<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CommType StructType
 * @subpackage Structs
 */
class CommType extends AbstractStructBase
{
    /**
     * The CommQualifier
     * Meta informations extracted from the WSDL
     * - documentation: [AL] : [Address/ Location (With Unknown Type)] [BN] : [Beeper Number] [CP] : [Cellular Phone Number] [EM] : [Email] [FX] : [Fax Number] [HA] : [Home Address] [HF] : [Home Facsimile Number] [HP] : [Home Phone Number] [IM] : [Instant
     * Messaging] [MA] : [Mailing Address] [NP] : [Evening Phone Number] [PC] : [Personal Cellular Number] [SA] : [Street Address] [TE] : [Telephone (With Unknown Type)] [UR] : [URL] [VM] : [Voice Mail] [WA] : [Work Address] [WC] : [Work Cellular Number]
     * [WF] : [Work Fax Number] [WP] : [Business Phone Number]
     * - maxLength: 80
     * - minLength: 1 | 1
     * - pattern: [\p{IsBasicLatin}]*
     * @var string
     */
    public $CommQualifier;
    /**
     * The CommPhone
     * Meta informations extracted from the WSDL
     * - pattern: ((\+\d{1,5}-\d{1,5}-)|(\d{1,5}-)){0,1}([a-zA-Z0-9]){3,8}(\+\d{1,10}){0,1} | [\p{IsBasicLatin}]*
     * - minLength: 1
     * @var string
     */
    public $CommPhone;
    /**
     * The CommEmail
     * Meta informations extracted from the WSDL
     * - minLength: 1 | 1
     * @var string
     */
    public $CommEmail;
    /**
     * The Address
     * @var \StructType\AddressType
     */
    public $Address;
    /**
     * Constructor method for CommType
     * @uses CommType::setCommQualifier()
     * @uses CommType::setCommPhone()
     * @uses CommType::setCommEmail()
     * @uses CommType::setAddress()
     * @param string $commQualifier
     * @param string $commPhone
     * @param string $commEmail
     * @param \StructType\AddressType $address
     */
    public function __construct($commQualifier = null, $commPhone = null, $commEmail = null, \StructType\AddressType $address = null)
    {
        $this
            ->setCommQualifier($commQualifier)
            ->setCommPhone($commPhone)
            ->setCommEmail($commEmail)
            ->setAddress($address);
    }
    /**
     * Get CommQualifier value
     * @return string|null
     */
    public function getCommQualifier()
    {
        return $this->CommQualifier;
    }
    /**
     * Set CommQualifier value
     * @param string $commQualifier
     * @return \StructType\CommType
     */
    public function setCommQualifier($commQualifier = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($commQualifier) && strlen($commQualifier) > 80) || (is_array($commQualifier) && count($commQualifier) > 80)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 80 element(s) or a scalar of 80 character(s) at most, "%d" length given', is_scalar($commQualifier) ? strlen($commQualifier) : count($commQualifier)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($commQualifier) && strlen($commQualifier) < 1) || (is_array($commQualifier) && count($commQualifier) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($commQualifier) && !preg_match('/[\\p{IsBasicLatin}]*/', $commQualifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\p{IsBasicLatin}]*", "%s" given', var_export($commQualifier, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($commQualifier) && !is_string($commQualifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($commQualifier)), __LINE__);
        }
        $this->CommQualifier = $commQualifier;
        return $this;
    }
    /**
     * Get CommPhone value
     * @return string|null
     */
    public function getCommPhone()
    {
        return $this->CommPhone;
    }
    /**
     * Set CommPhone value
     * @param string $commPhone
     * @return \StructType\CommType
     */
    public function setCommPhone($commPhone = null)
    {
        // validation for constraint: pattern
        if (is_scalar($commPhone) && !preg_match('//', $commPhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "Array", "%s" given', var_export($commPhone, true)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($commPhone) && strlen($commPhone) < 1) || (is_array($commPhone) && count($commPhone) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($commPhone) && !is_string($commPhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($commPhone)), __LINE__);
        }
        $this->CommPhone = $commPhone;
        return $this;
    }
    /**
     * Get CommEmail value
     * @return string|null
     */
    public function getCommEmail()
    {
        return $this->CommEmail;
    }
    /**
     * Set CommEmail value
     * @param string $commEmail
     * @return \StructType\CommType
     */
    public function setCommEmail($commEmail = null)
    {
        // validation for constraint: minLength
        if ((is_scalar($commEmail) && strlen($commEmail) < 1) || (is_array($commEmail) && count($commEmail) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($commEmail) && !is_string($commEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($commEmail)), __LINE__);
        }
        $this->CommEmail = $commEmail;
        return $this;
    }
    /**
     * Get Address value
     * @return \StructType\AddressType|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param \StructType\AddressType $address
     * @return \StructType\CommType
     */
    public function setAddress(\StructType\AddressType $address = null)
    {
        $this->Address = $address;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CommType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
