<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AvailabilityType StructType
 * @subpackage Structs
 */
class AvailabilityType extends AbstractStructBase
{
    /**
     * The Quantity
     * Meta informations extracted from the WSDL
     * - maxInclusive: 9999999999.99
     * - minInclusive: 0
     * - totalDigits: 15
     * @var float
     */
    public $Quantity;
    /**
     * The InventoryStatus
     * Meta informations extracted from the WSDL
     * - documentation: [Available] : [Available] [BackOrdered] : [Back Ordered] [Discontinued] : [Discontinued] [NotAvailable] : [Not Available]
     * - maxLength: 80
     * - minLength: 1 | 1
     * - pattern: [\p{IsBasicLatin}]*
     * @var string
     */
    public $InventoryStatus;
    /**
     * The AvailableShipDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $AvailableShipDate;
    /**
     * Constructor method for AvailabilityType
     * @uses AvailabilityType::setQuantity()
     * @uses AvailabilityType::setInventoryStatus()
     * @uses AvailabilityType::setAvailableShipDate()
     * @param float $quantity
     * @param string $inventoryStatus
     * @param string $availableShipDate
     */
    public function __construct($quantity = null, $inventoryStatus = null, $availableShipDate = null)
    {
        $this
            ->setQuantity($quantity)
            ->setInventoryStatus($inventoryStatus)
            ->setAvailableShipDate($availableShipDate);
    }
    /**
     * Get Quantity value
     * @return float|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param float $quantity
     * @return \StructType\AvailabilityType
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: maxInclusive
        if ($quantity > 9999999999) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 9999999999, "%s" given', $quantity), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($quantity < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 0, "%s" given', $quantity), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($quantity) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $quantity)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($quantity, strpos($quantity, '.')))), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get InventoryStatus value
     * @return string|null
     */
    public function getInventoryStatus()
    {
        return $this->InventoryStatus;
    }
    /**
     * Set InventoryStatus value
     * @param string $inventoryStatus
     * @return \StructType\AvailabilityType
     */
    public function setInventoryStatus($inventoryStatus = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($inventoryStatus) && strlen($inventoryStatus) > 80) || (is_array($inventoryStatus) && count($inventoryStatus) > 80)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 80 element(s) or a scalar of 80 character(s) at most, "%d" length given', is_scalar($inventoryStatus) ? strlen($inventoryStatus) : count($inventoryStatus)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($inventoryStatus) && strlen($inventoryStatus) < 1) || (is_array($inventoryStatus) && count($inventoryStatus) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($inventoryStatus) && !preg_match('/[\\p{IsBasicLatin}]*/', $inventoryStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\p{IsBasicLatin}]*", "%s" given', var_export($inventoryStatus, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($inventoryStatus) && !is_string($inventoryStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($inventoryStatus)), __LINE__);
        }
        $this->InventoryStatus = $inventoryStatus;
        return $this;
    }
    /**
     * Get AvailableShipDate value
     * @return string|null
     */
    public function getAvailableShipDate()
    {
        return $this->AvailableShipDate;
    }
    /**
     * Set AvailableShipDate value
     * @param string $availableShipDate
     * @return \StructType\AvailabilityType
     */
    public function setAvailableShipDate($availableShipDate = null)
    {
        // validation for constraint: string
        if (!is_null($availableShipDate) && !is_string($availableShipDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($availableShipDate)), __LINE__);
        }
        $this->AvailableShipDate = $availableShipDate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AvailabilityType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
