<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AdminInfoType StructType
 * @subpackage Structs
 */
class AdminInfoType extends AbstractStructBase
{
    /**
     * The Supplier
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\GenericPartyType[]
     */
    public $Supplier;
    /**
     * Constructor method for AdminInfoType
     * @uses AdminInfoType::setSupplier()
     * @param \StructType\GenericPartyType[] $supplier
     */
    public function __construct(array $supplier = array())
    {
        $this
            ->setSupplier($supplier);
    }
    /**
     * Get Supplier value
     * @return \StructType\GenericPartyType[]|null
     */
    public function getSupplier()
    {
        return $this->Supplier;
    }
    /**
     * Set Supplier value
     * @throws \InvalidArgumentException
     * @param \StructType\GenericPartyType[] $supplier
     * @return \StructType\AdminInfoType
     */
    public function setSupplier(array $supplier = array())
    {
        foreach ($supplier as $adminInfoTypeSupplierItem) {
            // validation for constraint: itemType
            if (!$adminInfoTypeSupplierItem instanceof \StructType\GenericPartyType) {
                throw new \InvalidArgumentException(sprintf('The Supplier property can only contain items of \StructType\GenericPartyType, "%s" given', is_object($adminInfoTypeSupplierItem) ? get_class($adminInfoTypeSupplierItem) : gettype($adminInfoTypeSupplierItem)), __LINE__);
            }
        }
        $this->Supplier = $supplier;
        return $this;
    }
    /**
     * Add item to Supplier value
     * @throws \InvalidArgumentException
     * @param \StructType\GenericPartyType $item
     * @return \StructType\AdminInfoType
     */
    public function addToSupplier(\StructType\GenericPartyType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\GenericPartyType) {
            throw new \InvalidArgumentException(sprintf('The Supplier property can only contain items of \StructType\GenericPartyType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Supplier[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AdminInfoType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
