<?php

namespace AcumaticaConfig\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Zones StructType
 * @subpackage Structs
 */
class Zones extends AbstractStructBase
{
    /**
     * The TaxZoneDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\TaxZoneDetail[]
     */
    public $TaxZoneDetail;
    /**
     * Constructor method for Zones
     * @uses Zones::setTaxZoneDetail()
     * @param \AcumaticaConfig\StructType\TaxZoneDetail[] $taxZoneDetail
     */
    public function __construct(array $taxZoneDetail = array())
    {
        $this
            ->setTaxZoneDetail($taxZoneDetail);
    }
    /**
     * Get TaxZoneDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\TaxZoneDetail[]|null
     */
    public function getTaxZoneDetail()
    {
        return isset($this->TaxZoneDetail) ? $this->TaxZoneDetail : null;
    }
    /**
     * Set TaxZoneDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\TaxZoneDetail[] $taxZoneDetail
     * @return \AcumaticaConfig\StructType\Zones
     */
    public function setTaxZoneDetail(array $taxZoneDetail = array())
    {
        foreach ($taxZoneDetail as $zonesTaxZoneDetailItem) {
            // validation for constraint: itemType
            if (!$zonesTaxZoneDetailItem instanceof \AcumaticaConfig\StructType\TaxZoneDetail) {
                throw new \InvalidArgumentException(sprintf('The TaxZoneDetail property can only contain items of \AcumaticaConfig\StructType\TaxZoneDetail, "%s" given', is_object($zonesTaxZoneDetailItem) ? get_class($zonesTaxZoneDetailItem) : gettype($zonesTaxZoneDetailItem)), __LINE__);
            }
        }
        if (is_null($taxZoneDetail) || (is_array($taxZoneDetail) && empty($taxZoneDetail))) {
            unset($this->TaxZoneDetail);
        } else {
            $this->TaxZoneDetail = $taxZoneDetail;
        }
        return $this;
    }
    /**
     * Add item to TaxZoneDetail value
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\TaxZoneDetail $item
     * @return \AcumaticaConfig\StructType\Zones
     */
    public function addToTaxZoneDetail(\AcumaticaConfig\StructType\TaxZoneDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AcumaticaConfig\StructType\TaxZoneDetail) {
            throw new \InvalidArgumentException(sprintf('The TaxZoneDetail property can only contain items of \AcumaticaConfig\StructType\TaxZoneDetail, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->TaxZoneDetail[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AcumaticaConfig\StructType\Zones
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
