<?php

namespace AcumaticaConfig\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Warehouse StructType
 * @subpackage Structs
 */
class Warehouse extends Entity
{
    /**
     * The Active
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\BooleanValue
     */
    public $Active;
    /**
     * The COGSExpenseAccount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $COGSExpenseAccount;
    /**
     * The COGSExpenseSubaccount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $COGSExpenseSubaccount;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $Description;
    /**
     * The DiscountAccount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $DiscountAccount;
    /**
     * The DiscountSubaccount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $DiscountSubaccount;
    /**
     * The DropShipLocationID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $DropShipLocationID;
    /**
     * The FreightChargeAccount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $FreightChargeAccount;
    /**
     * The FreightChargeSubaccount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $FreightChargeSubaccount;
    /**
     * The InventoryAccount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $InventoryAccount;
    /**
     * The InventorySubaccount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $InventorySubaccount;
    /**
     * The LandedCostVarianceAccount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $LandedCostVarianceAccount;
    /**
     * The LandedCostVarianceSubaccount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $LandedCostVarianceSubaccount;
    /**
     * The Locations
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\Locations
     */
    public $Locations;
    /**
     * The MiscChargeAccount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $MiscChargeAccount;
    /**
     * The MiscChargeSubaccount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $MiscChargeSubaccount;
    /**
     * The OverrideInventoryAccountSubaccount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\BooleanValue
     */
    public $OverrideInventoryAccountSubaccount;
    /**
     * The POAccrualAccount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $POAccrualAccount;
    /**
     * The POAccrualSubaccount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $POAccrualSubaccount;
    /**
     * The PurchasePriceVarianceAccount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $PurchasePriceVarianceAccount;
    /**
     * The PurchasePriceVarianceSubaccount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $PurchasePriceVarianceSubaccount;
    /**
     * The ReasonCodeSubaccount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $ReasonCodeSubaccount;
    /**
     * The ReceivingLocationID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $ReceivingLocationID;
    /**
     * The RMALocationID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $RMALocationID;
    /**
     * The SalesAccount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $SalesAccount;
    /**
     * The SalesSubaccount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $SalesSubaccount;
    /**
     * The ShippingLocationID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $ShippingLocationID;
    /**
     * The StandardCostRevaluationAccount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $StandardCostRevaluationAccount;
    /**
     * The StandardCostRevaluationSubaccount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $StandardCostRevaluationSubaccount;
    /**
     * The StandardCostVarianceAccount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $StandardCostVarianceAccount;
    /**
     * The StandardCostVarianceSubaccount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $StandardCostVarianceSubaccount;
    /**
     * The WarehouseID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $WarehouseID;
    /**
     * Constructor method for Warehouse
     * @uses Warehouse::setActive()
     * @uses Warehouse::setCOGSExpenseAccount()
     * @uses Warehouse::setCOGSExpenseSubaccount()
     * @uses Warehouse::setDescription()
     * @uses Warehouse::setDiscountAccount()
     * @uses Warehouse::setDiscountSubaccount()
     * @uses Warehouse::setDropShipLocationID()
     * @uses Warehouse::setFreightChargeAccount()
     * @uses Warehouse::setFreightChargeSubaccount()
     * @uses Warehouse::setInventoryAccount()
     * @uses Warehouse::setInventorySubaccount()
     * @uses Warehouse::setLandedCostVarianceAccount()
     * @uses Warehouse::setLandedCostVarianceSubaccount()
     * @uses Warehouse::setLocations()
     * @uses Warehouse::setMiscChargeAccount()
     * @uses Warehouse::setMiscChargeSubaccount()
     * @uses Warehouse::setOverrideInventoryAccountSubaccount()
     * @uses Warehouse::setPOAccrualAccount()
     * @uses Warehouse::setPOAccrualSubaccount()
     * @uses Warehouse::setPurchasePriceVarianceAccount()
     * @uses Warehouse::setPurchasePriceVarianceSubaccount()
     * @uses Warehouse::setReasonCodeSubaccount()
     * @uses Warehouse::setReceivingLocationID()
     * @uses Warehouse::setRMALocationID()
     * @uses Warehouse::setSalesAccount()
     * @uses Warehouse::setSalesSubaccount()
     * @uses Warehouse::setShippingLocationID()
     * @uses Warehouse::setStandardCostRevaluationAccount()
     * @uses Warehouse::setStandardCostRevaluationSubaccount()
     * @uses Warehouse::setStandardCostVarianceAccount()
     * @uses Warehouse::setStandardCostVarianceSubaccount()
     * @uses Warehouse::setWarehouseID()
     * @param \AcumaticaConfig\StructType\BooleanValue $active
     * @param \AcumaticaConfig\StructType\StringValue $cOGSExpenseAccount
     * @param \AcumaticaConfig\StructType\StringValue $cOGSExpenseSubaccount
     * @param \AcumaticaConfig\StructType\StringValue $description
     * @param \AcumaticaConfig\StructType\StringValue $discountAccount
     * @param \AcumaticaConfig\StructType\StringValue $discountSubaccount
     * @param \AcumaticaConfig\StructType\StringValue $dropShipLocationID
     * @param \AcumaticaConfig\StructType\StringValue $freightChargeAccount
     * @param \AcumaticaConfig\StructType\StringValue $freightChargeSubaccount
     * @param \AcumaticaConfig\StructType\StringValue $inventoryAccount
     * @param \AcumaticaConfig\StructType\StringValue $inventorySubaccount
     * @param \AcumaticaConfig\StructType\StringValue $landedCostVarianceAccount
     * @param \AcumaticaConfig\StructType\StringValue $landedCostVarianceSubaccount
     * @param \AcumaticaConfig\StructType\Locations $locations
     * @param \AcumaticaConfig\StructType\StringValue $miscChargeAccount
     * @param \AcumaticaConfig\StructType\StringValue $miscChargeSubaccount
     * @param \AcumaticaConfig\StructType\BooleanValue $overrideInventoryAccountSubaccount
     * @param \AcumaticaConfig\StructType\StringValue $pOAccrualAccount
     * @param \AcumaticaConfig\StructType\StringValue $pOAccrualSubaccount
     * @param \AcumaticaConfig\StructType\StringValue $purchasePriceVarianceAccount
     * @param \AcumaticaConfig\StructType\StringValue $purchasePriceVarianceSubaccount
     * @param \AcumaticaConfig\StructType\StringValue $reasonCodeSubaccount
     * @param \AcumaticaConfig\StructType\StringValue $receivingLocationID
     * @param \AcumaticaConfig\StructType\StringValue $rMALocationID
     * @param \AcumaticaConfig\StructType\StringValue $salesAccount
     * @param \AcumaticaConfig\StructType\StringValue $salesSubaccount
     * @param \AcumaticaConfig\StructType\StringValue $shippingLocationID
     * @param \AcumaticaConfig\StructType\StringValue $standardCostRevaluationAccount
     * @param \AcumaticaConfig\StructType\StringValue $standardCostRevaluationSubaccount
     * @param \AcumaticaConfig\StructType\StringValue $standardCostVarianceAccount
     * @param \AcumaticaConfig\StructType\StringValue $standardCostVarianceSubaccount
     * @param \AcumaticaConfig\StructType\StringValue $warehouseID
     */
    public function __construct(\AcumaticaConfig\StructType\BooleanValue $active = null, \AcumaticaConfig\StructType\StringValue $cOGSExpenseAccount = null, \AcumaticaConfig\StructType\StringValue $cOGSExpenseSubaccount = null, \AcumaticaConfig\StructType\StringValue $description = null, \AcumaticaConfig\StructType\StringValue $discountAccount = null, \AcumaticaConfig\StructType\StringValue $discountSubaccount = null, \AcumaticaConfig\StructType\StringValue $dropShipLocationID = null, \AcumaticaConfig\StructType\StringValue $freightChargeAccount = null, \AcumaticaConfig\StructType\StringValue $freightChargeSubaccount = null, \AcumaticaConfig\StructType\StringValue $inventoryAccount = null, \AcumaticaConfig\StructType\StringValue $inventorySubaccount = null, \AcumaticaConfig\StructType\StringValue $landedCostVarianceAccount = null, \AcumaticaConfig\StructType\StringValue $landedCostVarianceSubaccount = null, \AcumaticaConfig\StructType\Locations $locations = null, \AcumaticaConfig\StructType\StringValue $miscChargeAccount = null, \AcumaticaConfig\StructType\StringValue $miscChargeSubaccount = null, \AcumaticaConfig\StructType\BooleanValue $overrideInventoryAccountSubaccount = null, \AcumaticaConfig\StructType\StringValue $pOAccrualAccount = null, \AcumaticaConfig\StructType\StringValue $pOAccrualSubaccount = null, \AcumaticaConfig\StructType\StringValue $purchasePriceVarianceAccount = null, \AcumaticaConfig\StructType\StringValue $purchasePriceVarianceSubaccount = null, \AcumaticaConfig\StructType\StringValue $reasonCodeSubaccount = null, \AcumaticaConfig\StructType\StringValue $receivingLocationID = null, \AcumaticaConfig\StructType\StringValue $rMALocationID = null, \AcumaticaConfig\StructType\StringValue $salesAccount = null, \AcumaticaConfig\StructType\StringValue $salesSubaccount = null, \AcumaticaConfig\StructType\StringValue $shippingLocationID = null, \AcumaticaConfig\StructType\StringValue $standardCostRevaluationAccount = null, \AcumaticaConfig\StructType\StringValue $standardCostRevaluationSubaccount = null, \AcumaticaConfig\StructType\StringValue $standardCostVarianceAccount = null, \AcumaticaConfig\StructType\StringValue $standardCostVarianceSubaccount = null, \AcumaticaConfig\StructType\StringValue $warehouseID = null)
    {
        $this
            ->setActive($active)
            ->setCOGSExpenseAccount($cOGSExpenseAccount)
            ->setCOGSExpenseSubaccount($cOGSExpenseSubaccount)
            ->setDescription($description)
            ->setDiscountAccount($discountAccount)
            ->setDiscountSubaccount($discountSubaccount)
            ->setDropShipLocationID($dropShipLocationID)
            ->setFreightChargeAccount($freightChargeAccount)
            ->setFreightChargeSubaccount($freightChargeSubaccount)
            ->setInventoryAccount($inventoryAccount)
            ->setInventorySubaccount($inventorySubaccount)
            ->setLandedCostVarianceAccount($landedCostVarianceAccount)
            ->setLandedCostVarianceSubaccount($landedCostVarianceSubaccount)
            ->setLocations($locations)
            ->setMiscChargeAccount($miscChargeAccount)
            ->setMiscChargeSubaccount($miscChargeSubaccount)
            ->setOverrideInventoryAccountSubaccount($overrideInventoryAccountSubaccount)
            ->setPOAccrualAccount($pOAccrualAccount)
            ->setPOAccrualSubaccount($pOAccrualSubaccount)
            ->setPurchasePriceVarianceAccount($purchasePriceVarianceAccount)
            ->setPurchasePriceVarianceSubaccount($purchasePriceVarianceSubaccount)
            ->setReasonCodeSubaccount($reasonCodeSubaccount)
            ->setReceivingLocationID($receivingLocationID)
            ->setRMALocationID($rMALocationID)
            ->setSalesAccount($salesAccount)
            ->setSalesSubaccount($salesSubaccount)
            ->setShippingLocationID($shippingLocationID)
            ->setStandardCostRevaluationAccount($standardCostRevaluationAccount)
            ->setStandardCostRevaluationSubaccount($standardCostRevaluationSubaccount)
            ->setStandardCostVarianceAccount($standardCostVarianceAccount)
            ->setStandardCostVarianceSubaccount($standardCostVarianceSubaccount)
            ->setWarehouseID($warehouseID);
    }
    /**
     * Get Active value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\BooleanValue|null
     */
    public function getActive()
    {
        return isset($this->Active) ? $this->Active : null;
    }
    /**
     * Set Active value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\BooleanValue $active
     * @return \AcumaticaConfig\StructType\Warehouse
     */
    public function setActive(\AcumaticaConfig\StructType\BooleanValue $active = null)
    {
        if (is_null($active) || (is_array($active) && empty($active))) {
            unset($this->Active);
        } else {
            $this->Active = $active;
        }
        return $this;
    }
    /**
     * Get COGSExpenseAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getCOGSExpenseAccount()
    {
        return isset($this->COGSExpenseAccount) ? $this->COGSExpenseAccount : null;
    }
    /**
     * Set COGSExpenseAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $cOGSExpenseAccount
     * @return \AcumaticaConfig\StructType\Warehouse
     */
    public function setCOGSExpenseAccount(\AcumaticaConfig\StructType\StringValue $cOGSExpenseAccount = null)
    {
        if (is_null($cOGSExpenseAccount) || (is_array($cOGSExpenseAccount) && empty($cOGSExpenseAccount))) {
            unset($this->COGSExpenseAccount);
        } else {
            $this->COGSExpenseAccount = $cOGSExpenseAccount;
        }
        return $this;
    }
    /**
     * Get COGSExpenseSubaccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getCOGSExpenseSubaccount()
    {
        return isset($this->COGSExpenseSubaccount) ? $this->COGSExpenseSubaccount : null;
    }
    /**
     * Set COGSExpenseSubaccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $cOGSExpenseSubaccount
     * @return \AcumaticaConfig\StructType\Warehouse
     */
    public function setCOGSExpenseSubaccount(\AcumaticaConfig\StructType\StringValue $cOGSExpenseSubaccount = null)
    {
        if (is_null($cOGSExpenseSubaccount) || (is_array($cOGSExpenseSubaccount) && empty($cOGSExpenseSubaccount))) {
            unset($this->COGSExpenseSubaccount);
        } else {
            $this->COGSExpenseSubaccount = $cOGSExpenseSubaccount;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $description
     * @return \AcumaticaConfig\StructType\Warehouse
     */
    public function setDescription(\AcumaticaConfig\StructType\StringValue $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get DiscountAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getDiscountAccount()
    {
        return isset($this->DiscountAccount) ? $this->DiscountAccount : null;
    }
    /**
     * Set DiscountAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $discountAccount
     * @return \AcumaticaConfig\StructType\Warehouse
     */
    public function setDiscountAccount(\AcumaticaConfig\StructType\StringValue $discountAccount = null)
    {
        if (is_null($discountAccount) || (is_array($discountAccount) && empty($discountAccount))) {
            unset($this->DiscountAccount);
        } else {
            $this->DiscountAccount = $discountAccount;
        }
        return $this;
    }
    /**
     * Get DiscountSubaccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getDiscountSubaccount()
    {
        return isset($this->DiscountSubaccount) ? $this->DiscountSubaccount : null;
    }
    /**
     * Set DiscountSubaccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $discountSubaccount
     * @return \AcumaticaConfig\StructType\Warehouse
     */
    public function setDiscountSubaccount(\AcumaticaConfig\StructType\StringValue $discountSubaccount = null)
    {
        if (is_null($discountSubaccount) || (is_array($discountSubaccount) && empty($discountSubaccount))) {
            unset($this->DiscountSubaccount);
        } else {
            $this->DiscountSubaccount = $discountSubaccount;
        }
        return $this;
    }
    /**
     * Get DropShipLocationID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getDropShipLocationID()
    {
        return isset($this->DropShipLocationID) ? $this->DropShipLocationID : null;
    }
    /**
     * Set DropShipLocationID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $dropShipLocationID
     * @return \AcumaticaConfig\StructType\Warehouse
     */
    public function setDropShipLocationID(\AcumaticaConfig\StructType\StringValue $dropShipLocationID = null)
    {
        if (is_null($dropShipLocationID) || (is_array($dropShipLocationID) && empty($dropShipLocationID))) {
            unset($this->DropShipLocationID);
        } else {
            $this->DropShipLocationID = $dropShipLocationID;
        }
        return $this;
    }
    /**
     * Get FreightChargeAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getFreightChargeAccount()
    {
        return isset($this->FreightChargeAccount) ? $this->FreightChargeAccount : null;
    }
    /**
     * Set FreightChargeAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $freightChargeAccount
     * @return \AcumaticaConfig\StructType\Warehouse
     */
    public function setFreightChargeAccount(\AcumaticaConfig\StructType\StringValue $freightChargeAccount = null)
    {
        if (is_null($freightChargeAccount) || (is_array($freightChargeAccount) && empty($freightChargeAccount))) {
            unset($this->FreightChargeAccount);
        } else {
            $this->FreightChargeAccount = $freightChargeAccount;
        }
        return $this;
    }
    /**
     * Get FreightChargeSubaccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getFreightChargeSubaccount()
    {
        return isset($this->FreightChargeSubaccount) ? $this->FreightChargeSubaccount : null;
    }
    /**
     * Set FreightChargeSubaccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $freightChargeSubaccount
     * @return \AcumaticaConfig\StructType\Warehouse
     */
    public function setFreightChargeSubaccount(\AcumaticaConfig\StructType\StringValue $freightChargeSubaccount = null)
    {
        if (is_null($freightChargeSubaccount) || (is_array($freightChargeSubaccount) && empty($freightChargeSubaccount))) {
            unset($this->FreightChargeSubaccount);
        } else {
            $this->FreightChargeSubaccount = $freightChargeSubaccount;
        }
        return $this;
    }
    /**
     * Get InventoryAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getInventoryAccount()
    {
        return isset($this->InventoryAccount) ? $this->InventoryAccount : null;
    }
    /**
     * Set InventoryAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $inventoryAccount
     * @return \AcumaticaConfig\StructType\Warehouse
     */
    public function setInventoryAccount(\AcumaticaConfig\StructType\StringValue $inventoryAccount = null)
    {
        if (is_null($inventoryAccount) || (is_array($inventoryAccount) && empty($inventoryAccount))) {
            unset($this->InventoryAccount);
        } else {
            $this->InventoryAccount = $inventoryAccount;
        }
        return $this;
    }
    /**
     * Get InventorySubaccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getInventorySubaccount()
    {
        return isset($this->InventorySubaccount) ? $this->InventorySubaccount : null;
    }
    /**
     * Set InventorySubaccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $inventorySubaccount
     * @return \AcumaticaConfig\StructType\Warehouse
     */
    public function setInventorySubaccount(\AcumaticaConfig\StructType\StringValue $inventorySubaccount = null)
    {
        if (is_null($inventorySubaccount) || (is_array($inventorySubaccount) && empty($inventorySubaccount))) {
            unset($this->InventorySubaccount);
        } else {
            $this->InventorySubaccount = $inventorySubaccount;
        }
        return $this;
    }
    /**
     * Get LandedCostVarianceAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getLandedCostVarianceAccount()
    {
        return isset($this->LandedCostVarianceAccount) ? $this->LandedCostVarianceAccount : null;
    }
    /**
     * Set LandedCostVarianceAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $landedCostVarianceAccount
     * @return \AcumaticaConfig\StructType\Warehouse
     */
    public function setLandedCostVarianceAccount(\AcumaticaConfig\StructType\StringValue $landedCostVarianceAccount = null)
    {
        if (is_null($landedCostVarianceAccount) || (is_array($landedCostVarianceAccount) && empty($landedCostVarianceAccount))) {
            unset($this->LandedCostVarianceAccount);
        } else {
            $this->LandedCostVarianceAccount = $landedCostVarianceAccount;
        }
        return $this;
    }
    /**
     * Get LandedCostVarianceSubaccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getLandedCostVarianceSubaccount()
    {
        return isset($this->LandedCostVarianceSubaccount) ? $this->LandedCostVarianceSubaccount : null;
    }
    /**
     * Set LandedCostVarianceSubaccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $landedCostVarianceSubaccount
     * @return \AcumaticaConfig\StructType\Warehouse
     */
    public function setLandedCostVarianceSubaccount(\AcumaticaConfig\StructType\StringValue $landedCostVarianceSubaccount = null)
    {
        if (is_null($landedCostVarianceSubaccount) || (is_array($landedCostVarianceSubaccount) && empty($landedCostVarianceSubaccount))) {
            unset($this->LandedCostVarianceSubaccount);
        } else {
            $this->LandedCostVarianceSubaccount = $landedCostVarianceSubaccount;
        }
        return $this;
    }
    /**
     * Get Locations value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\Locations|null
     */
    public function getLocations()
    {
        return isset($this->Locations) ? $this->Locations : null;
    }
    /**
     * Set Locations value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\Locations $locations
     * @return \AcumaticaConfig\StructType\Warehouse
     */
    public function setLocations(\AcumaticaConfig\StructType\Locations $locations = null)
    {
        if (is_null($locations) || (is_array($locations) && empty($locations))) {
            unset($this->Locations);
        } else {
            $this->Locations = $locations;
        }
        return $this;
    }
    /**
     * Get MiscChargeAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getMiscChargeAccount()
    {
        return isset($this->MiscChargeAccount) ? $this->MiscChargeAccount : null;
    }
    /**
     * Set MiscChargeAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $miscChargeAccount
     * @return \AcumaticaConfig\StructType\Warehouse
     */
    public function setMiscChargeAccount(\AcumaticaConfig\StructType\StringValue $miscChargeAccount = null)
    {
        if (is_null($miscChargeAccount) || (is_array($miscChargeAccount) && empty($miscChargeAccount))) {
            unset($this->MiscChargeAccount);
        } else {
            $this->MiscChargeAccount = $miscChargeAccount;
        }
        return $this;
    }
    /**
     * Get MiscChargeSubaccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getMiscChargeSubaccount()
    {
        return isset($this->MiscChargeSubaccount) ? $this->MiscChargeSubaccount : null;
    }
    /**
     * Set MiscChargeSubaccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $miscChargeSubaccount
     * @return \AcumaticaConfig\StructType\Warehouse
     */
    public function setMiscChargeSubaccount(\AcumaticaConfig\StructType\StringValue $miscChargeSubaccount = null)
    {
        if (is_null($miscChargeSubaccount) || (is_array($miscChargeSubaccount) && empty($miscChargeSubaccount))) {
            unset($this->MiscChargeSubaccount);
        } else {
            $this->MiscChargeSubaccount = $miscChargeSubaccount;
        }
        return $this;
    }
    /**
     * Get OverrideInventoryAccountSubaccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\BooleanValue|null
     */
    public function getOverrideInventoryAccountSubaccount()
    {
        return isset($this->OverrideInventoryAccountSubaccount) ? $this->OverrideInventoryAccountSubaccount : null;
    }
    /**
     * Set OverrideInventoryAccountSubaccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\BooleanValue $overrideInventoryAccountSubaccount
     * @return \AcumaticaConfig\StructType\Warehouse
     */
    public function setOverrideInventoryAccountSubaccount(\AcumaticaConfig\StructType\BooleanValue $overrideInventoryAccountSubaccount = null)
    {
        if (is_null($overrideInventoryAccountSubaccount) || (is_array($overrideInventoryAccountSubaccount) && empty($overrideInventoryAccountSubaccount))) {
            unset($this->OverrideInventoryAccountSubaccount);
        } else {
            $this->OverrideInventoryAccountSubaccount = $overrideInventoryAccountSubaccount;
        }
        return $this;
    }
    /**
     * Get POAccrualAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getPOAccrualAccount()
    {
        return isset($this->POAccrualAccount) ? $this->POAccrualAccount : null;
    }
    /**
     * Set POAccrualAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $pOAccrualAccount
     * @return \AcumaticaConfig\StructType\Warehouse
     */
    public function setPOAccrualAccount(\AcumaticaConfig\StructType\StringValue $pOAccrualAccount = null)
    {
        if (is_null($pOAccrualAccount) || (is_array($pOAccrualAccount) && empty($pOAccrualAccount))) {
            unset($this->POAccrualAccount);
        } else {
            $this->POAccrualAccount = $pOAccrualAccount;
        }
        return $this;
    }
    /**
     * Get POAccrualSubaccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getPOAccrualSubaccount()
    {
        return isset($this->POAccrualSubaccount) ? $this->POAccrualSubaccount : null;
    }
    /**
     * Set POAccrualSubaccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $pOAccrualSubaccount
     * @return \AcumaticaConfig\StructType\Warehouse
     */
    public function setPOAccrualSubaccount(\AcumaticaConfig\StructType\StringValue $pOAccrualSubaccount = null)
    {
        if (is_null($pOAccrualSubaccount) || (is_array($pOAccrualSubaccount) && empty($pOAccrualSubaccount))) {
            unset($this->POAccrualSubaccount);
        } else {
            $this->POAccrualSubaccount = $pOAccrualSubaccount;
        }
        return $this;
    }
    /**
     * Get PurchasePriceVarianceAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getPurchasePriceVarianceAccount()
    {
        return isset($this->PurchasePriceVarianceAccount) ? $this->PurchasePriceVarianceAccount : null;
    }
    /**
     * Set PurchasePriceVarianceAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $purchasePriceVarianceAccount
     * @return \AcumaticaConfig\StructType\Warehouse
     */
    public function setPurchasePriceVarianceAccount(\AcumaticaConfig\StructType\StringValue $purchasePriceVarianceAccount = null)
    {
        if (is_null($purchasePriceVarianceAccount) || (is_array($purchasePriceVarianceAccount) && empty($purchasePriceVarianceAccount))) {
            unset($this->PurchasePriceVarianceAccount);
        } else {
            $this->PurchasePriceVarianceAccount = $purchasePriceVarianceAccount;
        }
        return $this;
    }
    /**
     * Get PurchasePriceVarianceSubaccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getPurchasePriceVarianceSubaccount()
    {
        return isset($this->PurchasePriceVarianceSubaccount) ? $this->PurchasePriceVarianceSubaccount : null;
    }
    /**
     * Set PurchasePriceVarianceSubaccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $purchasePriceVarianceSubaccount
     * @return \AcumaticaConfig\StructType\Warehouse
     */
    public function setPurchasePriceVarianceSubaccount(\AcumaticaConfig\StructType\StringValue $purchasePriceVarianceSubaccount = null)
    {
        if (is_null($purchasePriceVarianceSubaccount) || (is_array($purchasePriceVarianceSubaccount) && empty($purchasePriceVarianceSubaccount))) {
            unset($this->PurchasePriceVarianceSubaccount);
        } else {
            $this->PurchasePriceVarianceSubaccount = $purchasePriceVarianceSubaccount;
        }
        return $this;
    }
    /**
     * Get ReasonCodeSubaccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getReasonCodeSubaccount()
    {
        return isset($this->ReasonCodeSubaccount) ? $this->ReasonCodeSubaccount : null;
    }
    /**
     * Set ReasonCodeSubaccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $reasonCodeSubaccount
     * @return \AcumaticaConfig\StructType\Warehouse
     */
    public function setReasonCodeSubaccount(\AcumaticaConfig\StructType\StringValue $reasonCodeSubaccount = null)
    {
        if (is_null($reasonCodeSubaccount) || (is_array($reasonCodeSubaccount) && empty($reasonCodeSubaccount))) {
            unset($this->ReasonCodeSubaccount);
        } else {
            $this->ReasonCodeSubaccount = $reasonCodeSubaccount;
        }
        return $this;
    }
    /**
     * Get ReceivingLocationID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getReceivingLocationID()
    {
        return isset($this->ReceivingLocationID) ? $this->ReceivingLocationID : null;
    }
    /**
     * Set ReceivingLocationID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $receivingLocationID
     * @return \AcumaticaConfig\StructType\Warehouse
     */
    public function setReceivingLocationID(\AcumaticaConfig\StructType\StringValue $receivingLocationID = null)
    {
        if (is_null($receivingLocationID) || (is_array($receivingLocationID) && empty($receivingLocationID))) {
            unset($this->ReceivingLocationID);
        } else {
            $this->ReceivingLocationID = $receivingLocationID;
        }
        return $this;
    }
    /**
     * Get RMALocationID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getRMALocationID()
    {
        return isset($this->RMALocationID) ? $this->RMALocationID : null;
    }
    /**
     * Set RMALocationID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $rMALocationID
     * @return \AcumaticaConfig\StructType\Warehouse
     */
    public function setRMALocationID(\AcumaticaConfig\StructType\StringValue $rMALocationID = null)
    {
        if (is_null($rMALocationID) || (is_array($rMALocationID) && empty($rMALocationID))) {
            unset($this->RMALocationID);
        } else {
            $this->RMALocationID = $rMALocationID;
        }
        return $this;
    }
    /**
     * Get SalesAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getSalesAccount()
    {
        return isset($this->SalesAccount) ? $this->SalesAccount : null;
    }
    /**
     * Set SalesAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $salesAccount
     * @return \AcumaticaConfig\StructType\Warehouse
     */
    public function setSalesAccount(\AcumaticaConfig\StructType\StringValue $salesAccount = null)
    {
        if (is_null($salesAccount) || (is_array($salesAccount) && empty($salesAccount))) {
            unset($this->SalesAccount);
        } else {
            $this->SalesAccount = $salesAccount;
        }
        return $this;
    }
    /**
     * Get SalesSubaccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getSalesSubaccount()
    {
        return isset($this->SalesSubaccount) ? $this->SalesSubaccount : null;
    }
    /**
     * Set SalesSubaccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $salesSubaccount
     * @return \AcumaticaConfig\StructType\Warehouse
     */
    public function setSalesSubaccount(\AcumaticaConfig\StructType\StringValue $salesSubaccount = null)
    {
        if (is_null($salesSubaccount) || (is_array($salesSubaccount) && empty($salesSubaccount))) {
            unset($this->SalesSubaccount);
        } else {
            $this->SalesSubaccount = $salesSubaccount;
        }
        return $this;
    }
    /**
     * Get ShippingLocationID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getShippingLocationID()
    {
        return isset($this->ShippingLocationID) ? $this->ShippingLocationID : null;
    }
    /**
     * Set ShippingLocationID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $shippingLocationID
     * @return \AcumaticaConfig\StructType\Warehouse
     */
    public function setShippingLocationID(\AcumaticaConfig\StructType\StringValue $shippingLocationID = null)
    {
        if (is_null($shippingLocationID) || (is_array($shippingLocationID) && empty($shippingLocationID))) {
            unset($this->ShippingLocationID);
        } else {
            $this->ShippingLocationID = $shippingLocationID;
        }
        return $this;
    }
    /**
     * Get StandardCostRevaluationAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getStandardCostRevaluationAccount()
    {
        return isset($this->StandardCostRevaluationAccount) ? $this->StandardCostRevaluationAccount : null;
    }
    /**
     * Set StandardCostRevaluationAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $standardCostRevaluationAccount
     * @return \AcumaticaConfig\StructType\Warehouse
     */
    public function setStandardCostRevaluationAccount(\AcumaticaConfig\StructType\StringValue $standardCostRevaluationAccount = null)
    {
        if (is_null($standardCostRevaluationAccount) || (is_array($standardCostRevaluationAccount) && empty($standardCostRevaluationAccount))) {
            unset($this->StandardCostRevaluationAccount);
        } else {
            $this->StandardCostRevaluationAccount = $standardCostRevaluationAccount;
        }
        return $this;
    }
    /**
     * Get StandardCostRevaluationSubaccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getStandardCostRevaluationSubaccount()
    {
        return isset($this->StandardCostRevaluationSubaccount) ? $this->StandardCostRevaluationSubaccount : null;
    }
    /**
     * Set StandardCostRevaluationSubaccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $standardCostRevaluationSubaccount
     * @return \AcumaticaConfig\StructType\Warehouse
     */
    public function setStandardCostRevaluationSubaccount(\AcumaticaConfig\StructType\StringValue $standardCostRevaluationSubaccount = null)
    {
        if (is_null($standardCostRevaluationSubaccount) || (is_array($standardCostRevaluationSubaccount) && empty($standardCostRevaluationSubaccount))) {
            unset($this->StandardCostRevaluationSubaccount);
        } else {
            $this->StandardCostRevaluationSubaccount = $standardCostRevaluationSubaccount;
        }
        return $this;
    }
    /**
     * Get StandardCostVarianceAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getStandardCostVarianceAccount()
    {
        return isset($this->StandardCostVarianceAccount) ? $this->StandardCostVarianceAccount : null;
    }
    /**
     * Set StandardCostVarianceAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $standardCostVarianceAccount
     * @return \AcumaticaConfig\StructType\Warehouse
     */
    public function setStandardCostVarianceAccount(\AcumaticaConfig\StructType\StringValue $standardCostVarianceAccount = null)
    {
        if (is_null($standardCostVarianceAccount) || (is_array($standardCostVarianceAccount) && empty($standardCostVarianceAccount))) {
            unset($this->StandardCostVarianceAccount);
        } else {
            $this->StandardCostVarianceAccount = $standardCostVarianceAccount;
        }
        return $this;
    }
    /**
     * Get StandardCostVarianceSubaccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getStandardCostVarianceSubaccount()
    {
        return isset($this->StandardCostVarianceSubaccount) ? $this->StandardCostVarianceSubaccount : null;
    }
    /**
     * Set StandardCostVarianceSubaccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $standardCostVarianceSubaccount
     * @return \AcumaticaConfig\StructType\Warehouse
     */
    public function setStandardCostVarianceSubaccount(\AcumaticaConfig\StructType\StringValue $standardCostVarianceSubaccount = null)
    {
        if (is_null($standardCostVarianceSubaccount) || (is_array($standardCostVarianceSubaccount) && empty($standardCostVarianceSubaccount))) {
            unset($this->StandardCostVarianceSubaccount);
        } else {
            $this->StandardCostVarianceSubaccount = $standardCostVarianceSubaccount;
        }
        return $this;
    }
    /**
     * Get WarehouseID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getWarehouseID()
    {
        return isset($this->WarehouseID) ? $this->WarehouseID : null;
    }
    /**
     * Set WarehouseID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $warehouseID
     * @return \AcumaticaConfig\StructType\Warehouse
     */
    public function setWarehouseID(\AcumaticaConfig\StructType\StringValue $warehouseID = null)
    {
        if (is_null($warehouseID) || (is_array($warehouseID) && empty($warehouseID))) {
            unset($this->WarehouseID);
        } else {
            $this->WarehouseID = $warehouseID;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AcumaticaConfig\StructType\Warehouse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
