<?php

namespace AcumaticaConfig\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VendorDetails StructType
 * @subpackage Structs
 */
class VendorDetails extends AbstractStructBase
{
    /**
     * The StockItemVendorDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StockItemVendorDetail[]
     */
    public $StockItemVendorDetail;
    /**
     * The NonStockItemVendorDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\NonStockItemVendorDetail[]
     */
    public $NonStockItemVendorDetail;
    /**
     * Constructor method for VendorDetails
     * @uses VendorDetails::setStockItemVendorDetail()
     * @uses VendorDetails::setNonStockItemVendorDetail()
     * @param \AcumaticaConfig\StructType\StockItemVendorDetail[] $stockItemVendorDetail
     * @param \AcumaticaConfig\StructType\NonStockItemVendorDetail[] $nonStockItemVendorDetail
     */
    public function __construct(array $stockItemVendorDetail = array(), array $nonStockItemVendorDetail = array())
    {
        $this
            ->setStockItemVendorDetail($stockItemVendorDetail)
            ->setNonStockItemVendorDetail($nonStockItemVendorDetail);
    }
    /**
     * Get StockItemVendorDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StockItemVendorDetail[]|null
     */
    public function getStockItemVendorDetail()
    {
        return isset($this->StockItemVendorDetail) ? $this->StockItemVendorDetail : null;
    }
    /**
     * Set StockItemVendorDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\StockItemVendorDetail[] $stockItemVendorDetail
     * @return \AcumaticaConfig\StructType\VendorDetails
     */
    public function setStockItemVendorDetail(array $stockItemVendorDetail = array())
    {
        foreach ($stockItemVendorDetail as $vendorDetailsStockItemVendorDetailItem) {
            // validation for constraint: itemType
            if (!$vendorDetailsStockItemVendorDetailItem instanceof \AcumaticaConfig\StructType\StockItemVendorDetail) {
                throw new \InvalidArgumentException(sprintf('The StockItemVendorDetail property can only contain items of \AcumaticaConfig\StructType\StockItemVendorDetail, "%s" given', is_object($vendorDetailsStockItemVendorDetailItem) ? get_class($vendorDetailsStockItemVendorDetailItem) : gettype($vendorDetailsStockItemVendorDetailItem)), __LINE__);
            }
        }
        if (is_null($stockItemVendorDetail) || (is_array($stockItemVendorDetail) && empty($stockItemVendorDetail))) {
            unset($this->StockItemVendorDetail);
        } else {
            $this->StockItemVendorDetail = $stockItemVendorDetail;
        }
        return $this;
    }
    /**
     * Add item to StockItemVendorDetail value
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\StockItemVendorDetail $item
     * @return \AcumaticaConfig\StructType\VendorDetails
     */
    public function addToStockItemVendorDetail(\AcumaticaConfig\StructType\StockItemVendorDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AcumaticaConfig\StructType\StockItemVendorDetail) {
            throw new \InvalidArgumentException(sprintf('The StockItemVendorDetail property can only contain items of \AcumaticaConfig\StructType\StockItemVendorDetail, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->StockItemVendorDetail[] = $item;
        return $this;
    }
    /**
     * Get NonStockItemVendorDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\NonStockItemVendorDetail[]|null
     */
    public function getNonStockItemVendorDetail()
    {
        return isset($this->NonStockItemVendorDetail) ? $this->NonStockItemVendorDetail : null;
    }
    /**
     * Set NonStockItemVendorDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\NonStockItemVendorDetail[] $nonStockItemVendorDetail
     * @return \AcumaticaConfig\StructType\VendorDetails
     */
    public function setNonStockItemVendorDetail(array $nonStockItemVendorDetail = array())
    {
        foreach ($nonStockItemVendorDetail as $vendorDetailsNonStockItemVendorDetailItem) {
            // validation for constraint: itemType
            if (!$vendorDetailsNonStockItemVendorDetailItem instanceof \AcumaticaConfig\StructType\NonStockItemVendorDetail) {
                throw new \InvalidArgumentException(sprintf('The NonStockItemVendorDetail property can only contain items of \AcumaticaConfig\StructType\NonStockItemVendorDetail, "%s" given', is_object($vendorDetailsNonStockItemVendorDetailItem) ? get_class($vendorDetailsNonStockItemVendorDetailItem) : gettype($vendorDetailsNonStockItemVendorDetailItem)), __LINE__);
            }
        }
        if (is_null($nonStockItemVendorDetail) || (is_array($nonStockItemVendorDetail) && empty($nonStockItemVendorDetail))) {
            unset($this->NonStockItemVendorDetail);
        } else {
            $this->NonStockItemVendorDetail = $nonStockItemVendorDetail;
        }
        return $this;
    }
    /**
     * Add item to NonStockItemVendorDetail value
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\NonStockItemVendorDetail $item
     * @return \AcumaticaConfig\StructType\VendorDetails
     */
    public function addToNonStockItemVendorDetail(\AcumaticaConfig\StructType\NonStockItemVendorDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AcumaticaConfig\StructType\NonStockItemVendorDetail) {
            throw new \InvalidArgumentException(sprintf('The NonStockItemVendorDetail property can only contain items of \AcumaticaConfig\StructType\NonStockItemVendorDetail, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->NonStockItemVendorDetail[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AcumaticaConfig\StructType\VendorDetails
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
