<?php

namespace AcumaticaConfig\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Vendor StructType
 * @subpackage Structs
 */
class Vendor extends Entity
{
    /**
     * The AccountRef
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $AccountRef;
    /**
     * The APAccount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $APAccount;
    /**
     * The APSubaccount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $APSubaccount;
    /**
     * The Attributes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\Attributes
     */
    public $Attributes;
    /**
     * The CashAccount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $CashAccount;
    /**
     * The Contacts
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\Contacts
     */
    public $Contacts;
    /**
     * The CreatedDateTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DateTimeValue
     */
    public $CreatedDateTime;
    /**
     * The CurrencyID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $CurrencyID;
    /**
     * The CurrencyRateType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $CurrencyRateType;
    /**
     * The EnableCurrencyOverride
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\BooleanValue
     */
    public $EnableCurrencyOverride;
    /**
     * The EnableRateOverride
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\BooleanValue
     */
    public $EnableRateOverride;
    /**
     * The F1099Box
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $F1099Box;
    /**
     * The F1099Vendor
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\BooleanValue
     */
    public $F1099Vendor;
    /**
     * The FATCA
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\BooleanValue
     */
    public $FATCA;
    /**
     * The FOBPoint
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $FOBPoint;
    /**
     * The ForeignEntity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\BooleanValue
     */
    public $ForeignEntity;
    /**
     * The LandedCostVendor
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\BooleanValue
     */
    public $LandedCostVendor;
    /**
     * The LastModifiedDateTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DateTimeValue
     */
    public $LastModifiedDateTime;
    /**
     * The LeadTimedays
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\ShortValue
     */
    public $LeadTimedays;
    /**
     * The LocationName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $LocationName;
    /**
     * The MainContact
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\Contact
     */
    public $MainContact;
    /**
     * The MaxReceipt
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DecimalValue
     */
    public $MaxReceipt;
    /**
     * The MinReceipt
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DecimalValue
     */
    public $MinReceipt;
    /**
     * The ParentAccount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $ParentAccount;
    /**
     * The PaymentBy
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $PaymentBy;
    /**
     * The PaymentInstructions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\PaymentInstructions
     */
    public $PaymentInstructions;
    /**
     * The PaymentLeadTimedays
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\ShortValue
     */
    public $PaymentLeadTimedays;
    /**
     * The PaymentMethod
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $PaymentMethod;
    /**
     * The PaySeparately
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\BooleanValue
     */
    public $PaySeparately;
    /**
     * The PrintOrders
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\BooleanValue
     */
    public $PrintOrders;
    /**
     * The ReceiptAction
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $ReceiptAction;
    /**
     * The ReceivingBranch
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $ReceivingBranch;
    /**
     * The RemittanceAddressSameasMain
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\BooleanValue
     */
    public $RemittanceAddressSameasMain;
    /**
     * The RemittanceContact
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\Contact
     */
    public $RemittanceContact;
    /**
     * The RemittanceContactSameasMain
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\BooleanValue
     */
    public $RemittanceContactSameasMain;
    /**
     * The SendOrdersbyEmail
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\BooleanValue
     */
    public $SendOrdersbyEmail;
    /**
     * The ShippersContactSameasMain
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\BooleanValue
     */
    public $ShippersContactSameasMain;
    /**
     * The ShippingAddressSameasMain
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\BooleanValue
     */
    public $ShippingAddressSameasMain;
    /**
     * The ShippingContact
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\Contact
     */
    public $ShippingContact;
    /**
     * The ShippingTerms
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $ShippingTerms;
    /**
     * The ShipVia
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $ShipVia;
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $Status;
    /**
     * The TaxCalculationMode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $TaxCalculationMode;
    /**
     * The TaxRegistrationID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $TaxRegistrationID;
    /**
     * The TaxZone
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $TaxZone;
    /**
     * The Terms
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $Terms;
    /**
     * The ThresholdReceipt
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DecimalValue
     */
    public $ThresholdReceipt;
    /**
     * The VendorClass
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $VendorClass;
    /**
     * The VendorID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $VendorID;
    /**
     * The VendorIsLaborUnion
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\BooleanValue
     */
    public $VendorIsLaborUnion;
    /**
     * The VendorIsTaxAgency
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\BooleanValue
     */
    public $VendorIsTaxAgency;
    /**
     * The VendorName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $VendorName;
    /**
     * The Warehouse
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $Warehouse;
    /**
     * Constructor method for Vendor
     * @uses Vendor::setAccountRef()
     * @uses Vendor::setAPAccount()
     * @uses Vendor::setAPSubaccount()
     * @uses Vendor::setAttributes()
     * @uses Vendor::setCashAccount()
     * @uses Vendor::setContacts()
     * @uses Vendor::setCreatedDateTime()
     * @uses Vendor::setCurrencyID()
     * @uses Vendor::setCurrencyRateType()
     * @uses Vendor::setEnableCurrencyOverride()
     * @uses Vendor::setEnableRateOverride()
     * @uses Vendor::setF1099Box()
     * @uses Vendor::setF1099Vendor()
     * @uses Vendor::setFATCA()
     * @uses Vendor::setFOBPoint()
     * @uses Vendor::setForeignEntity()
     * @uses Vendor::setLandedCostVendor()
     * @uses Vendor::setLastModifiedDateTime()
     * @uses Vendor::setLeadTimedays()
     * @uses Vendor::setLocationName()
     * @uses Vendor::setMainContact()
     * @uses Vendor::setMaxReceipt()
     * @uses Vendor::setMinReceipt()
     * @uses Vendor::setParentAccount()
     * @uses Vendor::setPaymentBy()
     * @uses Vendor::setPaymentInstructions()
     * @uses Vendor::setPaymentLeadTimedays()
     * @uses Vendor::setPaymentMethod()
     * @uses Vendor::setPaySeparately()
     * @uses Vendor::setPrintOrders()
     * @uses Vendor::setReceiptAction()
     * @uses Vendor::setReceivingBranch()
     * @uses Vendor::setRemittanceAddressSameasMain()
     * @uses Vendor::setRemittanceContact()
     * @uses Vendor::setRemittanceContactSameasMain()
     * @uses Vendor::setSendOrdersbyEmail()
     * @uses Vendor::setShippersContactSameasMain()
     * @uses Vendor::setShippingAddressSameasMain()
     * @uses Vendor::setShippingContact()
     * @uses Vendor::setShippingTerms()
     * @uses Vendor::setShipVia()
     * @uses Vendor::setStatus()
     * @uses Vendor::setTaxCalculationMode()
     * @uses Vendor::setTaxRegistrationID()
     * @uses Vendor::setTaxZone()
     * @uses Vendor::setTerms()
     * @uses Vendor::setThresholdReceipt()
     * @uses Vendor::setVendorClass()
     * @uses Vendor::setVendorID()
     * @uses Vendor::setVendorIsLaborUnion()
     * @uses Vendor::setVendorIsTaxAgency()
     * @uses Vendor::setVendorName()
     * @uses Vendor::setWarehouse()
     * @param \AcumaticaConfig\StructType\StringValue $accountRef
     * @param \AcumaticaConfig\StructType\StringValue $aPAccount
     * @param \AcumaticaConfig\StructType\StringValue $aPSubaccount
     * @param \AcumaticaConfig\StructType\Attributes $attributes
     * @param \AcumaticaConfig\StructType\StringValue $cashAccount
     * @param \AcumaticaConfig\StructType\Contacts $contacts
     * @param \AcumaticaConfig\StructType\DateTimeValue $createdDateTime
     * @param \AcumaticaConfig\StructType\StringValue $currencyID
     * @param \AcumaticaConfig\StructType\StringValue $currencyRateType
     * @param \AcumaticaConfig\StructType\BooleanValue $enableCurrencyOverride
     * @param \AcumaticaConfig\StructType\BooleanValue $enableRateOverride
     * @param \AcumaticaConfig\StructType\StringValue $f1099Box
     * @param \AcumaticaConfig\StructType\BooleanValue $f1099Vendor
     * @param \AcumaticaConfig\StructType\BooleanValue $fATCA
     * @param \AcumaticaConfig\StructType\StringValue $fOBPoint
     * @param \AcumaticaConfig\StructType\BooleanValue $foreignEntity
     * @param \AcumaticaConfig\StructType\BooleanValue $landedCostVendor
     * @param \AcumaticaConfig\StructType\DateTimeValue $lastModifiedDateTime
     * @param \AcumaticaConfig\StructType\ShortValue $leadTimedays
     * @param \AcumaticaConfig\StructType\StringValue $locationName
     * @param \AcumaticaConfig\StructType\Contact $mainContact
     * @param \AcumaticaConfig\StructType\DecimalValue $maxReceipt
     * @param \AcumaticaConfig\StructType\DecimalValue $minReceipt
     * @param \AcumaticaConfig\StructType\StringValue $parentAccount
     * @param \AcumaticaConfig\StructType\StringValue $paymentBy
     * @param \AcumaticaConfig\StructType\PaymentInstructions $paymentInstructions
     * @param \AcumaticaConfig\StructType\ShortValue $paymentLeadTimedays
     * @param \AcumaticaConfig\StructType\StringValue $paymentMethod
     * @param \AcumaticaConfig\StructType\BooleanValue $paySeparately
     * @param \AcumaticaConfig\StructType\BooleanValue $printOrders
     * @param \AcumaticaConfig\StructType\StringValue $receiptAction
     * @param \AcumaticaConfig\StructType\StringValue $receivingBranch
     * @param \AcumaticaConfig\StructType\BooleanValue $remittanceAddressSameasMain
     * @param \AcumaticaConfig\StructType\Contact $remittanceContact
     * @param \AcumaticaConfig\StructType\BooleanValue $remittanceContactSameasMain
     * @param \AcumaticaConfig\StructType\BooleanValue $sendOrdersbyEmail
     * @param \AcumaticaConfig\StructType\BooleanValue $shippersContactSameasMain
     * @param \AcumaticaConfig\StructType\BooleanValue $shippingAddressSameasMain
     * @param \AcumaticaConfig\StructType\Contact $shippingContact
     * @param \AcumaticaConfig\StructType\StringValue $shippingTerms
     * @param \AcumaticaConfig\StructType\StringValue $shipVia
     * @param \AcumaticaConfig\StructType\StringValue $status
     * @param \AcumaticaConfig\StructType\StringValue $taxCalculationMode
     * @param \AcumaticaConfig\StructType\StringValue $taxRegistrationID
     * @param \AcumaticaConfig\StructType\StringValue $taxZone
     * @param \AcumaticaConfig\StructType\StringValue $terms
     * @param \AcumaticaConfig\StructType\DecimalValue $thresholdReceipt
     * @param \AcumaticaConfig\StructType\StringValue $vendorClass
     * @param \AcumaticaConfig\StructType\StringValue $vendorID
     * @param \AcumaticaConfig\StructType\BooleanValue $vendorIsLaborUnion
     * @param \AcumaticaConfig\StructType\BooleanValue $vendorIsTaxAgency
     * @param \AcumaticaConfig\StructType\StringValue $vendorName
     * @param \AcumaticaConfig\StructType\StringValue $warehouse
     */
    public function __construct(\AcumaticaConfig\StructType\StringValue $accountRef = null, \AcumaticaConfig\StructType\StringValue $aPAccount = null, \AcumaticaConfig\StructType\StringValue $aPSubaccount = null, \AcumaticaConfig\StructType\Attributes $attributes = null, \AcumaticaConfig\StructType\StringValue $cashAccount = null, \AcumaticaConfig\StructType\Contacts $contacts = null, \AcumaticaConfig\StructType\DateTimeValue $createdDateTime = null, \AcumaticaConfig\StructType\StringValue $currencyID = null, \AcumaticaConfig\StructType\StringValue $currencyRateType = null, \AcumaticaConfig\StructType\BooleanValue $enableCurrencyOverride = null, \AcumaticaConfig\StructType\BooleanValue $enableRateOverride = null, \AcumaticaConfig\StructType\StringValue $f1099Box = null, \AcumaticaConfig\StructType\BooleanValue $f1099Vendor = null, \AcumaticaConfig\StructType\BooleanValue $fATCA = null, \AcumaticaConfig\StructType\StringValue $fOBPoint = null, \AcumaticaConfig\StructType\BooleanValue $foreignEntity = null, \AcumaticaConfig\StructType\BooleanValue $landedCostVendor = null, \AcumaticaConfig\StructType\DateTimeValue $lastModifiedDateTime = null, \AcumaticaConfig\StructType\ShortValue $leadTimedays = null, \AcumaticaConfig\StructType\StringValue $locationName = null, \AcumaticaConfig\StructType\Contact $mainContact = null, \AcumaticaConfig\StructType\DecimalValue $maxReceipt = null, \AcumaticaConfig\StructType\DecimalValue $minReceipt = null, \AcumaticaConfig\StructType\StringValue $parentAccount = null, \AcumaticaConfig\StructType\StringValue $paymentBy = null, \AcumaticaConfig\StructType\PaymentInstructions $paymentInstructions = null, \AcumaticaConfig\StructType\ShortValue $paymentLeadTimedays = null, \AcumaticaConfig\StructType\StringValue $paymentMethod = null, \AcumaticaConfig\StructType\BooleanValue $paySeparately = null, \AcumaticaConfig\StructType\BooleanValue $printOrders = null, \AcumaticaConfig\StructType\StringValue $receiptAction = null, \AcumaticaConfig\StructType\StringValue $receivingBranch = null, \AcumaticaConfig\StructType\BooleanValue $remittanceAddressSameasMain = null, \AcumaticaConfig\StructType\Contact $remittanceContact = null, \AcumaticaConfig\StructType\BooleanValue $remittanceContactSameasMain = null, \AcumaticaConfig\StructType\BooleanValue $sendOrdersbyEmail = null, \AcumaticaConfig\StructType\BooleanValue $shippersContactSameasMain = null, \AcumaticaConfig\StructType\BooleanValue $shippingAddressSameasMain = null, \AcumaticaConfig\StructType\Contact $shippingContact = null, \AcumaticaConfig\StructType\StringValue $shippingTerms = null, \AcumaticaConfig\StructType\StringValue $shipVia = null, \AcumaticaConfig\StructType\StringValue $status = null, \AcumaticaConfig\StructType\StringValue $taxCalculationMode = null, \AcumaticaConfig\StructType\StringValue $taxRegistrationID = null, \AcumaticaConfig\StructType\StringValue $taxZone = null, \AcumaticaConfig\StructType\StringValue $terms = null, \AcumaticaConfig\StructType\DecimalValue $thresholdReceipt = null, \AcumaticaConfig\StructType\StringValue $vendorClass = null, \AcumaticaConfig\StructType\StringValue $vendorID = null, \AcumaticaConfig\StructType\BooleanValue $vendorIsLaborUnion = null, \AcumaticaConfig\StructType\BooleanValue $vendorIsTaxAgency = null, \AcumaticaConfig\StructType\StringValue $vendorName = null, \AcumaticaConfig\StructType\StringValue $warehouse = null)
    {
        $this
            ->setAccountRef($accountRef)
            ->setAPAccount($aPAccount)
            ->setAPSubaccount($aPSubaccount)
            ->setAttributes($attributes)
            ->setCashAccount($cashAccount)
            ->setContacts($contacts)
            ->setCreatedDateTime($createdDateTime)
            ->setCurrencyID($currencyID)
            ->setCurrencyRateType($currencyRateType)
            ->setEnableCurrencyOverride($enableCurrencyOverride)
            ->setEnableRateOverride($enableRateOverride)
            ->setF1099Box($f1099Box)
            ->setF1099Vendor($f1099Vendor)
            ->setFATCA($fATCA)
            ->setFOBPoint($fOBPoint)
            ->setForeignEntity($foreignEntity)
            ->setLandedCostVendor($landedCostVendor)
            ->setLastModifiedDateTime($lastModifiedDateTime)
            ->setLeadTimedays($leadTimedays)
            ->setLocationName($locationName)
            ->setMainContact($mainContact)
            ->setMaxReceipt($maxReceipt)
            ->setMinReceipt($minReceipt)
            ->setParentAccount($parentAccount)
            ->setPaymentBy($paymentBy)
            ->setPaymentInstructions($paymentInstructions)
            ->setPaymentLeadTimedays($paymentLeadTimedays)
            ->setPaymentMethod($paymentMethod)
            ->setPaySeparately($paySeparately)
            ->setPrintOrders($printOrders)
            ->setReceiptAction($receiptAction)
            ->setReceivingBranch($receivingBranch)
            ->setRemittanceAddressSameasMain($remittanceAddressSameasMain)
            ->setRemittanceContact($remittanceContact)
            ->setRemittanceContactSameasMain($remittanceContactSameasMain)
            ->setSendOrdersbyEmail($sendOrdersbyEmail)
            ->setShippersContactSameasMain($shippersContactSameasMain)
            ->setShippingAddressSameasMain($shippingAddressSameasMain)
            ->setShippingContact($shippingContact)
            ->setShippingTerms($shippingTerms)
            ->setShipVia($shipVia)
            ->setStatus($status)
            ->setTaxCalculationMode($taxCalculationMode)
            ->setTaxRegistrationID($taxRegistrationID)
            ->setTaxZone($taxZone)
            ->setTerms($terms)
            ->setThresholdReceipt($thresholdReceipt)
            ->setVendorClass($vendorClass)
            ->setVendorID($vendorID)
            ->setVendorIsLaborUnion($vendorIsLaborUnion)
            ->setVendorIsTaxAgency($vendorIsTaxAgency)
            ->setVendorName($vendorName)
            ->setWarehouse($warehouse);
    }
    /**
     * Get AccountRef value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getAccountRef()
    {
        return isset($this->AccountRef) ? $this->AccountRef : null;
    }
    /**
     * Set AccountRef value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $accountRef
     * @return \AcumaticaConfig\StructType\Vendor
     */
    public function setAccountRef(\AcumaticaConfig\StructType\StringValue $accountRef = null)
    {
        if (is_null($accountRef) || (is_array($accountRef) && empty($accountRef))) {
            unset($this->AccountRef);
        } else {
            $this->AccountRef = $accountRef;
        }
        return $this;
    }
    /**
     * Get APAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getAPAccount()
    {
        return isset($this->APAccount) ? $this->APAccount : null;
    }
    /**
     * Set APAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $aPAccount
     * @return \AcumaticaConfig\StructType\Vendor
     */
    public function setAPAccount(\AcumaticaConfig\StructType\StringValue $aPAccount = null)
    {
        if (is_null($aPAccount) || (is_array($aPAccount) && empty($aPAccount))) {
            unset($this->APAccount);
        } else {
            $this->APAccount = $aPAccount;
        }
        return $this;
    }
    /**
     * Get APSubaccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getAPSubaccount()
    {
        return isset($this->APSubaccount) ? $this->APSubaccount : null;
    }
    /**
     * Set APSubaccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $aPSubaccount
     * @return \AcumaticaConfig\StructType\Vendor
     */
    public function setAPSubaccount(\AcumaticaConfig\StructType\StringValue $aPSubaccount = null)
    {
        if (is_null($aPSubaccount) || (is_array($aPSubaccount) && empty($aPSubaccount))) {
            unset($this->APSubaccount);
        } else {
            $this->APSubaccount = $aPSubaccount;
        }
        return $this;
    }
    /**
     * Get Attributes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\Attributes|null
     */
    public function getAttributes()
    {
        return isset($this->Attributes) ? $this->Attributes : null;
    }
    /**
     * Set Attributes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\Attributes $attributes
     * @return \AcumaticaConfig\StructType\Vendor
     */
    public function setAttributes(\AcumaticaConfig\StructType\Attributes $attributes = null)
    {
        if (is_null($attributes) || (is_array($attributes) && empty($attributes))) {
            unset($this->Attributes);
        } else {
            $this->Attributes = $attributes;
        }
        return $this;
    }
    /**
     * Get CashAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getCashAccount()
    {
        return isset($this->CashAccount) ? $this->CashAccount : null;
    }
    /**
     * Set CashAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $cashAccount
     * @return \AcumaticaConfig\StructType\Vendor
     */
    public function setCashAccount(\AcumaticaConfig\StructType\StringValue $cashAccount = null)
    {
        if (is_null($cashAccount) || (is_array($cashAccount) && empty($cashAccount))) {
            unset($this->CashAccount);
        } else {
            $this->CashAccount = $cashAccount;
        }
        return $this;
    }
    /**
     * Get Contacts value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\Contacts|null
     */
    public function getContacts()
    {
        return isset($this->Contacts) ? $this->Contacts : null;
    }
    /**
     * Set Contacts value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\Contacts $contacts
     * @return \AcumaticaConfig\StructType\Vendor
     */
    public function setContacts(\AcumaticaConfig\StructType\Contacts $contacts = null)
    {
        if (is_null($contacts) || (is_array($contacts) && empty($contacts))) {
            unset($this->Contacts);
        } else {
            $this->Contacts = $contacts;
        }
        return $this;
    }
    /**
     * Get CreatedDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DateTimeValue|null
     */
    public function getCreatedDateTime()
    {
        return isset($this->CreatedDateTime) ? $this->CreatedDateTime : null;
    }
    /**
     * Set CreatedDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DateTimeValue $createdDateTime
     * @return \AcumaticaConfig\StructType\Vendor
     */
    public function setCreatedDateTime(\AcumaticaConfig\StructType\DateTimeValue $createdDateTime = null)
    {
        if (is_null($createdDateTime) || (is_array($createdDateTime) && empty($createdDateTime))) {
            unset($this->CreatedDateTime);
        } else {
            $this->CreatedDateTime = $createdDateTime;
        }
        return $this;
    }
    /**
     * Get CurrencyID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getCurrencyID()
    {
        return isset($this->CurrencyID) ? $this->CurrencyID : null;
    }
    /**
     * Set CurrencyID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $currencyID
     * @return \AcumaticaConfig\StructType\Vendor
     */
    public function setCurrencyID(\AcumaticaConfig\StructType\StringValue $currencyID = null)
    {
        if (is_null($currencyID) || (is_array($currencyID) && empty($currencyID))) {
            unset($this->CurrencyID);
        } else {
            $this->CurrencyID = $currencyID;
        }
        return $this;
    }
    /**
     * Get CurrencyRateType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getCurrencyRateType()
    {
        return isset($this->CurrencyRateType) ? $this->CurrencyRateType : null;
    }
    /**
     * Set CurrencyRateType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $currencyRateType
     * @return \AcumaticaConfig\StructType\Vendor
     */
    public function setCurrencyRateType(\AcumaticaConfig\StructType\StringValue $currencyRateType = null)
    {
        if (is_null($currencyRateType) || (is_array($currencyRateType) && empty($currencyRateType))) {
            unset($this->CurrencyRateType);
        } else {
            $this->CurrencyRateType = $currencyRateType;
        }
        return $this;
    }
    /**
     * Get EnableCurrencyOverride value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\BooleanValue|null
     */
    public function getEnableCurrencyOverride()
    {
        return isset($this->EnableCurrencyOverride) ? $this->EnableCurrencyOverride : null;
    }
    /**
     * Set EnableCurrencyOverride value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\BooleanValue $enableCurrencyOverride
     * @return \AcumaticaConfig\StructType\Vendor
     */
    public function setEnableCurrencyOverride(\AcumaticaConfig\StructType\BooleanValue $enableCurrencyOverride = null)
    {
        if (is_null($enableCurrencyOverride) || (is_array($enableCurrencyOverride) && empty($enableCurrencyOverride))) {
            unset($this->EnableCurrencyOverride);
        } else {
            $this->EnableCurrencyOverride = $enableCurrencyOverride;
        }
        return $this;
    }
    /**
     * Get EnableRateOverride value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\BooleanValue|null
     */
    public function getEnableRateOverride()
    {
        return isset($this->EnableRateOverride) ? $this->EnableRateOverride : null;
    }
    /**
     * Set EnableRateOverride value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\BooleanValue $enableRateOverride
     * @return \AcumaticaConfig\StructType\Vendor
     */
    public function setEnableRateOverride(\AcumaticaConfig\StructType\BooleanValue $enableRateOverride = null)
    {
        if (is_null($enableRateOverride) || (is_array($enableRateOverride) && empty($enableRateOverride))) {
            unset($this->EnableRateOverride);
        } else {
            $this->EnableRateOverride = $enableRateOverride;
        }
        return $this;
    }
    /**
     * Get F1099Box value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getF1099Box()
    {
        return isset($this->F1099Box) ? $this->F1099Box : null;
    }
    /**
     * Set F1099Box value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $f1099Box
     * @return \AcumaticaConfig\StructType\Vendor
     */
    public function setF1099Box(\AcumaticaConfig\StructType\StringValue $f1099Box = null)
    {
        if (is_null($f1099Box) || (is_array($f1099Box) && empty($f1099Box))) {
            unset($this->F1099Box);
        } else {
            $this->F1099Box = $f1099Box;
        }
        return $this;
    }
    /**
     * Get F1099Vendor value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\BooleanValue|null
     */
    public function getF1099Vendor()
    {
        return isset($this->F1099Vendor) ? $this->F1099Vendor : null;
    }
    /**
     * Set F1099Vendor value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\BooleanValue $f1099Vendor
     * @return \AcumaticaConfig\StructType\Vendor
     */
    public function setF1099Vendor(\AcumaticaConfig\StructType\BooleanValue $f1099Vendor = null)
    {
        if (is_null($f1099Vendor) || (is_array($f1099Vendor) && empty($f1099Vendor))) {
            unset($this->F1099Vendor);
        } else {
            $this->F1099Vendor = $f1099Vendor;
        }
        return $this;
    }
    /**
     * Get FATCA value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\BooleanValue|null
     */
    public function getFATCA()
    {
        return isset($this->FATCA) ? $this->FATCA : null;
    }
    /**
     * Set FATCA value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\BooleanValue $fATCA
     * @return \AcumaticaConfig\StructType\Vendor
     */
    public function setFATCA(\AcumaticaConfig\StructType\BooleanValue $fATCA = null)
    {
        if (is_null($fATCA) || (is_array($fATCA) && empty($fATCA))) {
            unset($this->FATCA);
        } else {
            $this->FATCA = $fATCA;
        }
        return $this;
    }
    /**
     * Get FOBPoint value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getFOBPoint()
    {
        return isset($this->FOBPoint) ? $this->FOBPoint : null;
    }
    /**
     * Set FOBPoint value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $fOBPoint
     * @return \AcumaticaConfig\StructType\Vendor
     */
    public function setFOBPoint(\AcumaticaConfig\StructType\StringValue $fOBPoint = null)
    {
        if (is_null($fOBPoint) || (is_array($fOBPoint) && empty($fOBPoint))) {
            unset($this->FOBPoint);
        } else {
            $this->FOBPoint = $fOBPoint;
        }
        return $this;
    }
    /**
     * Get ForeignEntity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\BooleanValue|null
     */
    public function getForeignEntity()
    {
        return isset($this->ForeignEntity) ? $this->ForeignEntity : null;
    }
    /**
     * Set ForeignEntity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\BooleanValue $foreignEntity
     * @return \AcumaticaConfig\StructType\Vendor
     */
    public function setForeignEntity(\AcumaticaConfig\StructType\BooleanValue $foreignEntity = null)
    {
        if (is_null($foreignEntity) || (is_array($foreignEntity) && empty($foreignEntity))) {
            unset($this->ForeignEntity);
        } else {
            $this->ForeignEntity = $foreignEntity;
        }
        return $this;
    }
    /**
     * Get LandedCostVendor value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\BooleanValue|null
     */
    public function getLandedCostVendor()
    {
        return isset($this->LandedCostVendor) ? $this->LandedCostVendor : null;
    }
    /**
     * Set LandedCostVendor value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\BooleanValue $landedCostVendor
     * @return \AcumaticaConfig\StructType\Vendor
     */
    public function setLandedCostVendor(\AcumaticaConfig\StructType\BooleanValue $landedCostVendor = null)
    {
        if (is_null($landedCostVendor) || (is_array($landedCostVendor) && empty($landedCostVendor))) {
            unset($this->LandedCostVendor);
        } else {
            $this->LandedCostVendor = $landedCostVendor;
        }
        return $this;
    }
    /**
     * Get LastModifiedDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DateTimeValue|null
     */
    public function getLastModifiedDateTime()
    {
        return isset($this->LastModifiedDateTime) ? $this->LastModifiedDateTime : null;
    }
    /**
     * Set LastModifiedDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DateTimeValue $lastModifiedDateTime
     * @return \AcumaticaConfig\StructType\Vendor
     */
    public function setLastModifiedDateTime(\AcumaticaConfig\StructType\DateTimeValue $lastModifiedDateTime = null)
    {
        if (is_null($lastModifiedDateTime) || (is_array($lastModifiedDateTime) && empty($lastModifiedDateTime))) {
            unset($this->LastModifiedDateTime);
        } else {
            $this->LastModifiedDateTime = $lastModifiedDateTime;
        }
        return $this;
    }
    /**
     * Get LeadTimedays value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\ShortValue|null
     */
    public function getLeadTimedays()
    {
        return isset($this->LeadTimedays) ? $this->LeadTimedays : null;
    }
    /**
     * Set LeadTimedays value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\ShortValue $leadTimedays
     * @return \AcumaticaConfig\StructType\Vendor
     */
    public function setLeadTimedays(\AcumaticaConfig\StructType\ShortValue $leadTimedays = null)
    {
        if (is_null($leadTimedays) || (is_array($leadTimedays) && empty($leadTimedays))) {
            unset($this->LeadTimedays);
        } else {
            $this->LeadTimedays = $leadTimedays;
        }
        return $this;
    }
    /**
     * Get LocationName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getLocationName()
    {
        return isset($this->LocationName) ? $this->LocationName : null;
    }
    /**
     * Set LocationName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $locationName
     * @return \AcumaticaConfig\StructType\Vendor
     */
    public function setLocationName(\AcumaticaConfig\StructType\StringValue $locationName = null)
    {
        if (is_null($locationName) || (is_array($locationName) && empty($locationName))) {
            unset($this->LocationName);
        } else {
            $this->LocationName = $locationName;
        }
        return $this;
    }
    /**
     * Get MainContact value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\Contact|null
     */
    public function getMainContact()
    {
        return isset($this->MainContact) ? $this->MainContact : null;
    }
    /**
     * Set MainContact value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\Contact $mainContact
     * @return \AcumaticaConfig\StructType\Vendor
     */
    public function setMainContact(\AcumaticaConfig\StructType\Contact $mainContact = null)
    {
        if (is_null($mainContact) || (is_array($mainContact) && empty($mainContact))) {
            unset($this->MainContact);
        } else {
            $this->MainContact = $mainContact;
        }
        return $this;
    }
    /**
     * Get MaxReceipt value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DecimalValue|null
     */
    public function getMaxReceipt()
    {
        return isset($this->MaxReceipt) ? $this->MaxReceipt : null;
    }
    /**
     * Set MaxReceipt value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DecimalValue $maxReceipt
     * @return \AcumaticaConfig\StructType\Vendor
     */
    public function setMaxReceipt(\AcumaticaConfig\StructType\DecimalValue $maxReceipt = null)
    {
        if (is_null($maxReceipt) || (is_array($maxReceipt) && empty($maxReceipt))) {
            unset($this->MaxReceipt);
        } else {
            $this->MaxReceipt = $maxReceipt;
        }
        return $this;
    }
    /**
     * Get MinReceipt value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DecimalValue|null
     */
    public function getMinReceipt()
    {
        return isset($this->MinReceipt) ? $this->MinReceipt : null;
    }
    /**
     * Set MinReceipt value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DecimalValue $minReceipt
     * @return \AcumaticaConfig\StructType\Vendor
     */
    public function setMinReceipt(\AcumaticaConfig\StructType\DecimalValue $minReceipt = null)
    {
        if (is_null($minReceipt) || (is_array($minReceipt) && empty($minReceipt))) {
            unset($this->MinReceipt);
        } else {
            $this->MinReceipt = $minReceipt;
        }
        return $this;
    }
    /**
     * Get ParentAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getParentAccount()
    {
        return isset($this->ParentAccount) ? $this->ParentAccount : null;
    }
    /**
     * Set ParentAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $parentAccount
     * @return \AcumaticaConfig\StructType\Vendor
     */
    public function setParentAccount(\AcumaticaConfig\StructType\StringValue $parentAccount = null)
    {
        if (is_null($parentAccount) || (is_array($parentAccount) && empty($parentAccount))) {
            unset($this->ParentAccount);
        } else {
            $this->ParentAccount = $parentAccount;
        }
        return $this;
    }
    /**
     * Get PaymentBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getPaymentBy()
    {
        return isset($this->PaymentBy) ? $this->PaymentBy : null;
    }
    /**
     * Set PaymentBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $paymentBy
     * @return \AcumaticaConfig\StructType\Vendor
     */
    public function setPaymentBy(\AcumaticaConfig\StructType\StringValue $paymentBy = null)
    {
        if (is_null($paymentBy) || (is_array($paymentBy) && empty($paymentBy))) {
            unset($this->PaymentBy);
        } else {
            $this->PaymentBy = $paymentBy;
        }
        return $this;
    }
    /**
     * Get PaymentInstructions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\PaymentInstructions|null
     */
    public function getPaymentInstructions()
    {
        return isset($this->PaymentInstructions) ? $this->PaymentInstructions : null;
    }
    /**
     * Set PaymentInstructions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\PaymentInstructions $paymentInstructions
     * @return \AcumaticaConfig\StructType\Vendor
     */
    public function setPaymentInstructions(\AcumaticaConfig\StructType\PaymentInstructions $paymentInstructions = null)
    {
        if (is_null($paymentInstructions) || (is_array($paymentInstructions) && empty($paymentInstructions))) {
            unset($this->PaymentInstructions);
        } else {
            $this->PaymentInstructions = $paymentInstructions;
        }
        return $this;
    }
    /**
     * Get PaymentLeadTimedays value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\ShortValue|null
     */
    public function getPaymentLeadTimedays()
    {
        return isset($this->PaymentLeadTimedays) ? $this->PaymentLeadTimedays : null;
    }
    /**
     * Set PaymentLeadTimedays value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\ShortValue $paymentLeadTimedays
     * @return \AcumaticaConfig\StructType\Vendor
     */
    public function setPaymentLeadTimedays(\AcumaticaConfig\StructType\ShortValue $paymentLeadTimedays = null)
    {
        if (is_null($paymentLeadTimedays) || (is_array($paymentLeadTimedays) && empty($paymentLeadTimedays))) {
            unset($this->PaymentLeadTimedays);
        } else {
            $this->PaymentLeadTimedays = $paymentLeadTimedays;
        }
        return $this;
    }
    /**
     * Get PaymentMethod value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getPaymentMethod()
    {
        return isset($this->PaymentMethod) ? $this->PaymentMethod : null;
    }
    /**
     * Set PaymentMethod value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $paymentMethod
     * @return \AcumaticaConfig\StructType\Vendor
     */
    public function setPaymentMethod(\AcumaticaConfig\StructType\StringValue $paymentMethod = null)
    {
        if (is_null($paymentMethod) || (is_array($paymentMethod) && empty($paymentMethod))) {
            unset($this->PaymentMethod);
        } else {
            $this->PaymentMethod = $paymentMethod;
        }
        return $this;
    }
    /**
     * Get PaySeparately value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\BooleanValue|null
     */
    public function getPaySeparately()
    {
        return isset($this->PaySeparately) ? $this->PaySeparately : null;
    }
    /**
     * Set PaySeparately value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\BooleanValue $paySeparately
     * @return \AcumaticaConfig\StructType\Vendor
     */
    public function setPaySeparately(\AcumaticaConfig\StructType\BooleanValue $paySeparately = null)
    {
        if (is_null($paySeparately) || (is_array($paySeparately) && empty($paySeparately))) {
            unset($this->PaySeparately);
        } else {
            $this->PaySeparately = $paySeparately;
        }
        return $this;
    }
    /**
     * Get PrintOrders value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\BooleanValue|null
     */
    public function getPrintOrders()
    {
        return isset($this->PrintOrders) ? $this->PrintOrders : null;
    }
    /**
     * Set PrintOrders value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\BooleanValue $printOrders
     * @return \AcumaticaConfig\StructType\Vendor
     */
    public function setPrintOrders(\AcumaticaConfig\StructType\BooleanValue $printOrders = null)
    {
        if (is_null($printOrders) || (is_array($printOrders) && empty($printOrders))) {
            unset($this->PrintOrders);
        } else {
            $this->PrintOrders = $printOrders;
        }
        return $this;
    }
    /**
     * Get ReceiptAction value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getReceiptAction()
    {
        return isset($this->ReceiptAction) ? $this->ReceiptAction : null;
    }
    /**
     * Set ReceiptAction value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $receiptAction
     * @return \AcumaticaConfig\StructType\Vendor
     */
    public function setReceiptAction(\AcumaticaConfig\StructType\StringValue $receiptAction = null)
    {
        if (is_null($receiptAction) || (is_array($receiptAction) && empty($receiptAction))) {
            unset($this->ReceiptAction);
        } else {
            $this->ReceiptAction = $receiptAction;
        }
        return $this;
    }
    /**
     * Get ReceivingBranch value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getReceivingBranch()
    {
        return isset($this->ReceivingBranch) ? $this->ReceivingBranch : null;
    }
    /**
     * Set ReceivingBranch value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $receivingBranch
     * @return \AcumaticaConfig\StructType\Vendor
     */
    public function setReceivingBranch(\AcumaticaConfig\StructType\StringValue $receivingBranch = null)
    {
        if (is_null($receivingBranch) || (is_array($receivingBranch) && empty($receivingBranch))) {
            unset($this->ReceivingBranch);
        } else {
            $this->ReceivingBranch = $receivingBranch;
        }
        return $this;
    }
    /**
     * Get RemittanceAddressSameasMain value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\BooleanValue|null
     */
    public function getRemittanceAddressSameasMain()
    {
        return isset($this->RemittanceAddressSameasMain) ? $this->RemittanceAddressSameasMain : null;
    }
    /**
     * Set RemittanceAddressSameasMain value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\BooleanValue $remittanceAddressSameasMain
     * @return \AcumaticaConfig\StructType\Vendor
     */
    public function setRemittanceAddressSameasMain(\AcumaticaConfig\StructType\BooleanValue $remittanceAddressSameasMain = null)
    {
        if (is_null($remittanceAddressSameasMain) || (is_array($remittanceAddressSameasMain) && empty($remittanceAddressSameasMain))) {
            unset($this->RemittanceAddressSameasMain);
        } else {
            $this->RemittanceAddressSameasMain = $remittanceAddressSameasMain;
        }
        return $this;
    }
    /**
     * Get RemittanceContact value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\Contact|null
     */
    public function getRemittanceContact()
    {
        return isset($this->RemittanceContact) ? $this->RemittanceContact : null;
    }
    /**
     * Set RemittanceContact value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\Contact $remittanceContact
     * @return \AcumaticaConfig\StructType\Vendor
     */
    public function setRemittanceContact(\AcumaticaConfig\StructType\Contact $remittanceContact = null)
    {
        if (is_null($remittanceContact) || (is_array($remittanceContact) && empty($remittanceContact))) {
            unset($this->RemittanceContact);
        } else {
            $this->RemittanceContact = $remittanceContact;
        }
        return $this;
    }
    /**
     * Get RemittanceContactSameasMain value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\BooleanValue|null
     */
    public function getRemittanceContactSameasMain()
    {
        return isset($this->RemittanceContactSameasMain) ? $this->RemittanceContactSameasMain : null;
    }
    /**
     * Set RemittanceContactSameasMain value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\BooleanValue $remittanceContactSameasMain
     * @return \AcumaticaConfig\StructType\Vendor
     */
    public function setRemittanceContactSameasMain(\AcumaticaConfig\StructType\BooleanValue $remittanceContactSameasMain = null)
    {
        if (is_null($remittanceContactSameasMain) || (is_array($remittanceContactSameasMain) && empty($remittanceContactSameasMain))) {
            unset($this->RemittanceContactSameasMain);
        } else {
            $this->RemittanceContactSameasMain = $remittanceContactSameasMain;
        }
        return $this;
    }
    /**
     * Get SendOrdersbyEmail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\BooleanValue|null
     */
    public function getSendOrdersbyEmail()
    {
        return isset($this->SendOrdersbyEmail) ? $this->SendOrdersbyEmail : null;
    }
    /**
     * Set SendOrdersbyEmail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\BooleanValue $sendOrdersbyEmail
     * @return \AcumaticaConfig\StructType\Vendor
     */
    public function setSendOrdersbyEmail(\AcumaticaConfig\StructType\BooleanValue $sendOrdersbyEmail = null)
    {
        if (is_null($sendOrdersbyEmail) || (is_array($sendOrdersbyEmail) && empty($sendOrdersbyEmail))) {
            unset($this->SendOrdersbyEmail);
        } else {
            $this->SendOrdersbyEmail = $sendOrdersbyEmail;
        }
        return $this;
    }
    /**
     * Get ShippersContactSameasMain value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\BooleanValue|null
     */
    public function getShippersContactSameasMain()
    {
        return isset($this->ShippersContactSameasMain) ? $this->ShippersContactSameasMain : null;
    }
    /**
     * Set ShippersContactSameasMain value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\BooleanValue $shippersContactSameasMain
     * @return \AcumaticaConfig\StructType\Vendor
     */
    public function setShippersContactSameasMain(\AcumaticaConfig\StructType\BooleanValue $shippersContactSameasMain = null)
    {
        if (is_null($shippersContactSameasMain) || (is_array($shippersContactSameasMain) && empty($shippersContactSameasMain))) {
            unset($this->ShippersContactSameasMain);
        } else {
            $this->ShippersContactSameasMain = $shippersContactSameasMain;
        }
        return $this;
    }
    /**
     * Get ShippingAddressSameasMain value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\BooleanValue|null
     */
    public function getShippingAddressSameasMain()
    {
        return isset($this->ShippingAddressSameasMain) ? $this->ShippingAddressSameasMain : null;
    }
    /**
     * Set ShippingAddressSameasMain value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\BooleanValue $shippingAddressSameasMain
     * @return \AcumaticaConfig\StructType\Vendor
     */
    public function setShippingAddressSameasMain(\AcumaticaConfig\StructType\BooleanValue $shippingAddressSameasMain = null)
    {
        if (is_null($shippingAddressSameasMain) || (is_array($shippingAddressSameasMain) && empty($shippingAddressSameasMain))) {
            unset($this->ShippingAddressSameasMain);
        } else {
            $this->ShippingAddressSameasMain = $shippingAddressSameasMain;
        }
        return $this;
    }
    /**
     * Get ShippingContact value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\Contact|null
     */
    public function getShippingContact()
    {
        return isset($this->ShippingContact) ? $this->ShippingContact : null;
    }
    /**
     * Set ShippingContact value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\Contact $shippingContact
     * @return \AcumaticaConfig\StructType\Vendor
     */
    public function setShippingContact(\AcumaticaConfig\StructType\Contact $shippingContact = null)
    {
        if (is_null($shippingContact) || (is_array($shippingContact) && empty($shippingContact))) {
            unset($this->ShippingContact);
        } else {
            $this->ShippingContact = $shippingContact;
        }
        return $this;
    }
    /**
     * Get ShippingTerms value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getShippingTerms()
    {
        return isset($this->ShippingTerms) ? $this->ShippingTerms : null;
    }
    /**
     * Set ShippingTerms value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $shippingTerms
     * @return \AcumaticaConfig\StructType\Vendor
     */
    public function setShippingTerms(\AcumaticaConfig\StructType\StringValue $shippingTerms = null)
    {
        if (is_null($shippingTerms) || (is_array($shippingTerms) && empty($shippingTerms))) {
            unset($this->ShippingTerms);
        } else {
            $this->ShippingTerms = $shippingTerms;
        }
        return $this;
    }
    /**
     * Get ShipVia value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getShipVia()
    {
        return isset($this->ShipVia) ? $this->ShipVia : null;
    }
    /**
     * Set ShipVia value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $shipVia
     * @return \AcumaticaConfig\StructType\Vendor
     */
    public function setShipVia(\AcumaticaConfig\StructType\StringValue $shipVia = null)
    {
        if (is_null($shipVia) || (is_array($shipVia) && empty($shipVia))) {
            unset($this->ShipVia);
        } else {
            $this->ShipVia = $shipVia;
        }
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $status
     * @return \AcumaticaConfig\StructType\Vendor
     */
    public function setStatus(\AcumaticaConfig\StructType\StringValue $status = null)
    {
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
    /**
     * Get TaxCalculationMode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getTaxCalculationMode()
    {
        return isset($this->TaxCalculationMode) ? $this->TaxCalculationMode : null;
    }
    /**
     * Set TaxCalculationMode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $taxCalculationMode
     * @return \AcumaticaConfig\StructType\Vendor
     */
    public function setTaxCalculationMode(\AcumaticaConfig\StructType\StringValue $taxCalculationMode = null)
    {
        if (is_null($taxCalculationMode) || (is_array($taxCalculationMode) && empty($taxCalculationMode))) {
            unset($this->TaxCalculationMode);
        } else {
            $this->TaxCalculationMode = $taxCalculationMode;
        }
        return $this;
    }
    /**
     * Get TaxRegistrationID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getTaxRegistrationID()
    {
        return isset($this->TaxRegistrationID) ? $this->TaxRegistrationID : null;
    }
    /**
     * Set TaxRegistrationID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $taxRegistrationID
     * @return \AcumaticaConfig\StructType\Vendor
     */
    public function setTaxRegistrationID(\AcumaticaConfig\StructType\StringValue $taxRegistrationID = null)
    {
        if (is_null($taxRegistrationID) || (is_array($taxRegistrationID) && empty($taxRegistrationID))) {
            unset($this->TaxRegistrationID);
        } else {
            $this->TaxRegistrationID = $taxRegistrationID;
        }
        return $this;
    }
    /**
     * Get TaxZone value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getTaxZone()
    {
        return isset($this->TaxZone) ? $this->TaxZone : null;
    }
    /**
     * Set TaxZone value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $taxZone
     * @return \AcumaticaConfig\StructType\Vendor
     */
    public function setTaxZone(\AcumaticaConfig\StructType\StringValue $taxZone = null)
    {
        if (is_null($taxZone) || (is_array($taxZone) && empty($taxZone))) {
            unset($this->TaxZone);
        } else {
            $this->TaxZone = $taxZone;
        }
        return $this;
    }
    /**
     * Get Terms value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getTerms()
    {
        return isset($this->Terms) ? $this->Terms : null;
    }
    /**
     * Set Terms value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $terms
     * @return \AcumaticaConfig\StructType\Vendor
     */
    public function setTerms(\AcumaticaConfig\StructType\StringValue $terms = null)
    {
        if (is_null($terms) || (is_array($terms) && empty($terms))) {
            unset($this->Terms);
        } else {
            $this->Terms = $terms;
        }
        return $this;
    }
    /**
     * Get ThresholdReceipt value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DecimalValue|null
     */
    public function getThresholdReceipt()
    {
        return isset($this->ThresholdReceipt) ? $this->ThresholdReceipt : null;
    }
    /**
     * Set ThresholdReceipt value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DecimalValue $thresholdReceipt
     * @return \AcumaticaConfig\StructType\Vendor
     */
    public function setThresholdReceipt(\AcumaticaConfig\StructType\DecimalValue $thresholdReceipt = null)
    {
        if (is_null($thresholdReceipt) || (is_array($thresholdReceipt) && empty($thresholdReceipt))) {
            unset($this->ThresholdReceipt);
        } else {
            $this->ThresholdReceipt = $thresholdReceipt;
        }
        return $this;
    }
    /**
     * Get VendorClass value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getVendorClass()
    {
        return isset($this->VendorClass) ? $this->VendorClass : null;
    }
    /**
     * Set VendorClass value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $vendorClass
     * @return \AcumaticaConfig\StructType\Vendor
     */
    public function setVendorClass(\AcumaticaConfig\StructType\StringValue $vendorClass = null)
    {
        if (is_null($vendorClass) || (is_array($vendorClass) && empty($vendorClass))) {
            unset($this->VendorClass);
        } else {
            $this->VendorClass = $vendorClass;
        }
        return $this;
    }
    /**
     * Get VendorID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getVendorID()
    {
        return isset($this->VendorID) ? $this->VendorID : null;
    }
    /**
     * Set VendorID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $vendorID
     * @return \AcumaticaConfig\StructType\Vendor
     */
    public function setVendorID(\AcumaticaConfig\StructType\StringValue $vendorID = null)
    {
        if (is_null($vendorID) || (is_array($vendorID) && empty($vendorID))) {
            unset($this->VendorID);
        } else {
            $this->VendorID = $vendorID;
        }
        return $this;
    }
    /**
     * Get VendorIsLaborUnion value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\BooleanValue|null
     */
    public function getVendorIsLaborUnion()
    {
        return isset($this->VendorIsLaborUnion) ? $this->VendorIsLaborUnion : null;
    }
    /**
     * Set VendorIsLaborUnion value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\BooleanValue $vendorIsLaborUnion
     * @return \AcumaticaConfig\StructType\Vendor
     */
    public function setVendorIsLaborUnion(\AcumaticaConfig\StructType\BooleanValue $vendorIsLaborUnion = null)
    {
        if (is_null($vendorIsLaborUnion) || (is_array($vendorIsLaborUnion) && empty($vendorIsLaborUnion))) {
            unset($this->VendorIsLaborUnion);
        } else {
            $this->VendorIsLaborUnion = $vendorIsLaborUnion;
        }
        return $this;
    }
    /**
     * Get VendorIsTaxAgency value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\BooleanValue|null
     */
    public function getVendorIsTaxAgency()
    {
        return isset($this->VendorIsTaxAgency) ? $this->VendorIsTaxAgency : null;
    }
    /**
     * Set VendorIsTaxAgency value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\BooleanValue $vendorIsTaxAgency
     * @return \AcumaticaConfig\StructType\Vendor
     */
    public function setVendorIsTaxAgency(\AcumaticaConfig\StructType\BooleanValue $vendorIsTaxAgency = null)
    {
        if (is_null($vendorIsTaxAgency) || (is_array($vendorIsTaxAgency) && empty($vendorIsTaxAgency))) {
            unset($this->VendorIsTaxAgency);
        } else {
            $this->VendorIsTaxAgency = $vendorIsTaxAgency;
        }
        return $this;
    }
    /**
     * Get VendorName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getVendorName()
    {
        return isset($this->VendorName) ? $this->VendorName : null;
    }
    /**
     * Set VendorName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $vendorName
     * @return \AcumaticaConfig\StructType\Vendor
     */
    public function setVendorName(\AcumaticaConfig\StructType\StringValue $vendorName = null)
    {
        if (is_null($vendorName) || (is_array($vendorName) && empty($vendorName))) {
            unset($this->VendorName);
        } else {
            $this->VendorName = $vendorName;
        }
        return $this;
    }
    /**
     * Get Warehouse value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getWarehouse()
    {
        return isset($this->Warehouse) ? $this->Warehouse : null;
    }
    /**
     * Set Warehouse value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $warehouse
     * @return \AcumaticaConfig\StructType\Vendor
     */
    public function setWarehouse(\AcumaticaConfig\StructType\StringValue $warehouse = null)
    {
        if (is_null($warehouse) || (is_array($warehouse) && empty($warehouse))) {
            unset($this->Warehouse);
        } else {
            $this->Warehouse = $warehouse;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AcumaticaConfig\StructType\Vendor
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
