<?php

namespace AcumaticaConfig\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UnitsOfMeasure StructType
 * @subpackage Structs
 */
class UnitsOfMeasure extends Entity
{
    /**
     * The ConversionFactor
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DecimalValue
     */
    public $ConversionFactor;
    /**
     * The CreatedDateTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DateTimeValue
     */
    public $CreatedDateTime;
    /**
     * The FromUOM
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $FromUOM;
    /**
     * The LastModifiedDateTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DateTimeValue
     */
    public $LastModifiedDateTime;
    /**
     * The MultiplyOrDivide
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $MultiplyOrDivide;
    /**
     * The ToUOM
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $ToUOM;
    /**
     * Constructor method for UnitsOfMeasure
     * @uses UnitsOfMeasure::setConversionFactor()
     * @uses UnitsOfMeasure::setCreatedDateTime()
     * @uses UnitsOfMeasure::setFromUOM()
     * @uses UnitsOfMeasure::setLastModifiedDateTime()
     * @uses UnitsOfMeasure::setMultiplyOrDivide()
     * @uses UnitsOfMeasure::setToUOM()
     * @param \AcumaticaConfig\StructType\DecimalValue $conversionFactor
     * @param \AcumaticaConfig\StructType\DateTimeValue $createdDateTime
     * @param \AcumaticaConfig\StructType\StringValue $fromUOM
     * @param \AcumaticaConfig\StructType\DateTimeValue $lastModifiedDateTime
     * @param \AcumaticaConfig\StructType\StringValue $multiplyOrDivide
     * @param \AcumaticaConfig\StructType\StringValue $toUOM
     */
    public function __construct(\AcumaticaConfig\StructType\DecimalValue $conversionFactor = null, \AcumaticaConfig\StructType\DateTimeValue $createdDateTime = null, \AcumaticaConfig\StructType\StringValue $fromUOM = null, \AcumaticaConfig\StructType\DateTimeValue $lastModifiedDateTime = null, \AcumaticaConfig\StructType\StringValue $multiplyOrDivide = null, \AcumaticaConfig\StructType\StringValue $toUOM = null)
    {
        $this
            ->setConversionFactor($conversionFactor)
            ->setCreatedDateTime($createdDateTime)
            ->setFromUOM($fromUOM)
            ->setLastModifiedDateTime($lastModifiedDateTime)
            ->setMultiplyOrDivide($multiplyOrDivide)
            ->setToUOM($toUOM);
    }
    /**
     * Get ConversionFactor value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DecimalValue|null
     */
    public function getConversionFactor()
    {
        return isset($this->ConversionFactor) ? $this->ConversionFactor : null;
    }
    /**
     * Set ConversionFactor value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DecimalValue $conversionFactor
     * @return \AcumaticaConfig\StructType\UnitsOfMeasure
     */
    public function setConversionFactor(\AcumaticaConfig\StructType\DecimalValue $conversionFactor = null)
    {
        if (is_null($conversionFactor) || (is_array($conversionFactor) && empty($conversionFactor))) {
            unset($this->ConversionFactor);
        } else {
            $this->ConversionFactor = $conversionFactor;
        }
        return $this;
    }
    /**
     * Get CreatedDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DateTimeValue|null
     */
    public function getCreatedDateTime()
    {
        return isset($this->CreatedDateTime) ? $this->CreatedDateTime : null;
    }
    /**
     * Set CreatedDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DateTimeValue $createdDateTime
     * @return \AcumaticaConfig\StructType\UnitsOfMeasure
     */
    public function setCreatedDateTime(\AcumaticaConfig\StructType\DateTimeValue $createdDateTime = null)
    {
        if (is_null($createdDateTime) || (is_array($createdDateTime) && empty($createdDateTime))) {
            unset($this->CreatedDateTime);
        } else {
            $this->CreatedDateTime = $createdDateTime;
        }
        return $this;
    }
    /**
     * Get FromUOM value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getFromUOM()
    {
        return isset($this->FromUOM) ? $this->FromUOM : null;
    }
    /**
     * Set FromUOM value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $fromUOM
     * @return \AcumaticaConfig\StructType\UnitsOfMeasure
     */
    public function setFromUOM(\AcumaticaConfig\StructType\StringValue $fromUOM = null)
    {
        if (is_null($fromUOM) || (is_array($fromUOM) && empty($fromUOM))) {
            unset($this->FromUOM);
        } else {
            $this->FromUOM = $fromUOM;
        }
        return $this;
    }
    /**
     * Get LastModifiedDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DateTimeValue|null
     */
    public function getLastModifiedDateTime()
    {
        return isset($this->LastModifiedDateTime) ? $this->LastModifiedDateTime : null;
    }
    /**
     * Set LastModifiedDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DateTimeValue $lastModifiedDateTime
     * @return \AcumaticaConfig\StructType\UnitsOfMeasure
     */
    public function setLastModifiedDateTime(\AcumaticaConfig\StructType\DateTimeValue $lastModifiedDateTime = null)
    {
        if (is_null($lastModifiedDateTime) || (is_array($lastModifiedDateTime) && empty($lastModifiedDateTime))) {
            unset($this->LastModifiedDateTime);
        } else {
            $this->LastModifiedDateTime = $lastModifiedDateTime;
        }
        return $this;
    }
    /**
     * Get MultiplyOrDivide value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getMultiplyOrDivide()
    {
        return isset($this->MultiplyOrDivide) ? $this->MultiplyOrDivide : null;
    }
    /**
     * Set MultiplyOrDivide value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $multiplyOrDivide
     * @return \AcumaticaConfig\StructType\UnitsOfMeasure
     */
    public function setMultiplyOrDivide(\AcumaticaConfig\StructType\StringValue $multiplyOrDivide = null)
    {
        if (is_null($multiplyOrDivide) || (is_array($multiplyOrDivide) && empty($multiplyOrDivide))) {
            unset($this->MultiplyOrDivide);
        } else {
            $this->MultiplyOrDivide = $multiplyOrDivide;
        }
        return $this;
    }
    /**
     * Get ToUOM value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getToUOM()
    {
        return isset($this->ToUOM) ? $this->ToUOM : null;
    }
    /**
     * Set ToUOM value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $toUOM
     * @return \AcumaticaConfig\StructType\UnitsOfMeasure
     */
    public function setToUOM(\AcumaticaConfig\StructType\StringValue $toUOM = null)
    {
        if (is_null($toUOM) || (is_array($toUOM) && empty($toUOM))) {
            unset($this->ToUOM);
        } else {
            $this->ToUOM = $toUOM;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AcumaticaConfig\StructType\UnitsOfMeasure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
