<?php

namespace AcumaticaConfig\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UnbilledTransactions StructType
 * @subpackage Structs
 */
class UnbilledTransactions extends AbstractStructBase
{
    /**
     * The ContractUsageTransactionDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\ContractUsageTransactionDetail[]
     */
    public $ContractUsageTransactionDetail;
    /**
     * Constructor method for UnbilledTransactions
     * @uses UnbilledTransactions::setContractUsageTransactionDetail()
     * @param \AcumaticaConfig\StructType\ContractUsageTransactionDetail[] $contractUsageTransactionDetail
     */
    public function __construct(array $contractUsageTransactionDetail = array())
    {
        $this
            ->setContractUsageTransactionDetail($contractUsageTransactionDetail);
    }
    /**
     * Get ContractUsageTransactionDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\ContractUsageTransactionDetail[]|null
     */
    public function getContractUsageTransactionDetail()
    {
        return isset($this->ContractUsageTransactionDetail) ? $this->ContractUsageTransactionDetail : null;
    }
    /**
     * Set ContractUsageTransactionDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\ContractUsageTransactionDetail[] $contractUsageTransactionDetail
     * @return \AcumaticaConfig\StructType\UnbilledTransactions
     */
    public function setContractUsageTransactionDetail(array $contractUsageTransactionDetail = array())
    {
        foreach ($contractUsageTransactionDetail as $unbilledTransactionsContractUsageTransactionDetailItem) {
            // validation for constraint: itemType
            if (!$unbilledTransactionsContractUsageTransactionDetailItem instanceof \AcumaticaConfig\StructType\ContractUsageTransactionDetail) {
                throw new \InvalidArgumentException(sprintf('The ContractUsageTransactionDetail property can only contain items of \AcumaticaConfig\StructType\ContractUsageTransactionDetail, "%s" given', is_object($unbilledTransactionsContractUsageTransactionDetailItem) ? get_class($unbilledTransactionsContractUsageTransactionDetailItem) : gettype($unbilledTransactionsContractUsageTransactionDetailItem)), __LINE__);
            }
        }
        if (is_null($contractUsageTransactionDetail) || (is_array($contractUsageTransactionDetail) && empty($contractUsageTransactionDetail))) {
            unset($this->ContractUsageTransactionDetail);
        } else {
            $this->ContractUsageTransactionDetail = $contractUsageTransactionDetail;
        }
        return $this;
    }
    /**
     * Add item to ContractUsageTransactionDetail value
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\ContractUsageTransactionDetail $item
     * @return \AcumaticaConfig\StructType\UnbilledTransactions
     */
    public function addToContractUsageTransactionDetail(\AcumaticaConfig\StructType\ContractUsageTransactionDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AcumaticaConfig\StructType\ContractUsageTransactionDetail) {
            throw new \InvalidArgumentException(sprintf('The ContractUsageTransactionDetail property can only contain items of \AcumaticaConfig\StructType\ContractUsageTransactionDetail, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ContractUsageTransactionDetail[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AcumaticaConfig\StructType\UnbilledTransactions
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
