<?php

namespace AcumaticaConfig\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TaxScheduleDetail StructType
 * @subpackage Structs
 */
class TaxScheduleDetail extends Entity
{
    /**
     * The DeductibleTaxRate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DecimalValue
     */
    public $DeductibleTaxRate;
    /**
     * The MaxTaxableAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DecimalValue
     */
    public $MaxTaxableAmount;
    /**
     * The MinTaxableAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DecimalValue
     */
    public $MinTaxableAmount;
    /**
     * The ReportingGroup
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $ReportingGroup;
    /**
     * The RevisionID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\IntValue
     */
    public $RevisionID;
    /**
     * The StartDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DateTimeValue
     */
    public $StartDate;
    /**
     * The TaxID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $TaxID;
    /**
     * The TaxRate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DecimalValue
     */
    public $TaxRate;
    /**
     * Constructor method for TaxScheduleDetail
     * @uses TaxScheduleDetail::setDeductibleTaxRate()
     * @uses TaxScheduleDetail::setMaxTaxableAmount()
     * @uses TaxScheduleDetail::setMinTaxableAmount()
     * @uses TaxScheduleDetail::setReportingGroup()
     * @uses TaxScheduleDetail::setRevisionID()
     * @uses TaxScheduleDetail::setStartDate()
     * @uses TaxScheduleDetail::setTaxID()
     * @uses TaxScheduleDetail::setTaxRate()
     * @param \AcumaticaConfig\StructType\DecimalValue $deductibleTaxRate
     * @param \AcumaticaConfig\StructType\DecimalValue $maxTaxableAmount
     * @param \AcumaticaConfig\StructType\DecimalValue $minTaxableAmount
     * @param \AcumaticaConfig\StructType\StringValue $reportingGroup
     * @param \AcumaticaConfig\StructType\IntValue $revisionID
     * @param \AcumaticaConfig\StructType\DateTimeValue $startDate
     * @param \AcumaticaConfig\StructType\StringValue $taxID
     * @param \AcumaticaConfig\StructType\DecimalValue $taxRate
     */
    public function __construct(\AcumaticaConfig\StructType\DecimalValue $deductibleTaxRate = null, \AcumaticaConfig\StructType\DecimalValue $maxTaxableAmount = null, \AcumaticaConfig\StructType\DecimalValue $minTaxableAmount = null, \AcumaticaConfig\StructType\StringValue $reportingGroup = null, \AcumaticaConfig\StructType\IntValue $revisionID = null, \AcumaticaConfig\StructType\DateTimeValue $startDate = null, \AcumaticaConfig\StructType\StringValue $taxID = null, \AcumaticaConfig\StructType\DecimalValue $taxRate = null)
    {
        $this
            ->setDeductibleTaxRate($deductibleTaxRate)
            ->setMaxTaxableAmount($maxTaxableAmount)
            ->setMinTaxableAmount($minTaxableAmount)
            ->setReportingGroup($reportingGroup)
            ->setRevisionID($revisionID)
            ->setStartDate($startDate)
            ->setTaxID($taxID)
            ->setTaxRate($taxRate);
    }
    /**
     * Get DeductibleTaxRate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DecimalValue|null
     */
    public function getDeductibleTaxRate()
    {
        return isset($this->DeductibleTaxRate) ? $this->DeductibleTaxRate : null;
    }
    /**
     * Set DeductibleTaxRate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DecimalValue $deductibleTaxRate
     * @return \AcumaticaConfig\StructType\TaxScheduleDetail
     */
    public function setDeductibleTaxRate(\AcumaticaConfig\StructType\DecimalValue $deductibleTaxRate = null)
    {
        if (is_null($deductibleTaxRate) || (is_array($deductibleTaxRate) && empty($deductibleTaxRate))) {
            unset($this->DeductibleTaxRate);
        } else {
            $this->DeductibleTaxRate = $deductibleTaxRate;
        }
        return $this;
    }
    /**
     * Get MaxTaxableAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DecimalValue|null
     */
    public function getMaxTaxableAmount()
    {
        return isset($this->MaxTaxableAmount) ? $this->MaxTaxableAmount : null;
    }
    /**
     * Set MaxTaxableAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DecimalValue $maxTaxableAmount
     * @return \AcumaticaConfig\StructType\TaxScheduleDetail
     */
    public function setMaxTaxableAmount(\AcumaticaConfig\StructType\DecimalValue $maxTaxableAmount = null)
    {
        if (is_null($maxTaxableAmount) || (is_array($maxTaxableAmount) && empty($maxTaxableAmount))) {
            unset($this->MaxTaxableAmount);
        } else {
            $this->MaxTaxableAmount = $maxTaxableAmount;
        }
        return $this;
    }
    /**
     * Get MinTaxableAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DecimalValue|null
     */
    public function getMinTaxableAmount()
    {
        return isset($this->MinTaxableAmount) ? $this->MinTaxableAmount : null;
    }
    /**
     * Set MinTaxableAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DecimalValue $minTaxableAmount
     * @return \AcumaticaConfig\StructType\TaxScheduleDetail
     */
    public function setMinTaxableAmount(\AcumaticaConfig\StructType\DecimalValue $minTaxableAmount = null)
    {
        if (is_null($minTaxableAmount) || (is_array($minTaxableAmount) && empty($minTaxableAmount))) {
            unset($this->MinTaxableAmount);
        } else {
            $this->MinTaxableAmount = $minTaxableAmount;
        }
        return $this;
    }
    /**
     * Get ReportingGroup value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getReportingGroup()
    {
        return isset($this->ReportingGroup) ? $this->ReportingGroup : null;
    }
    /**
     * Set ReportingGroup value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $reportingGroup
     * @return \AcumaticaConfig\StructType\TaxScheduleDetail
     */
    public function setReportingGroup(\AcumaticaConfig\StructType\StringValue $reportingGroup = null)
    {
        if (is_null($reportingGroup) || (is_array($reportingGroup) && empty($reportingGroup))) {
            unset($this->ReportingGroup);
        } else {
            $this->ReportingGroup = $reportingGroup;
        }
        return $this;
    }
    /**
     * Get RevisionID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\IntValue|null
     */
    public function getRevisionID()
    {
        return isset($this->RevisionID) ? $this->RevisionID : null;
    }
    /**
     * Set RevisionID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\IntValue $revisionID
     * @return \AcumaticaConfig\StructType\TaxScheduleDetail
     */
    public function setRevisionID(\AcumaticaConfig\StructType\IntValue $revisionID = null)
    {
        if (is_null($revisionID) || (is_array($revisionID) && empty($revisionID))) {
            unset($this->RevisionID);
        } else {
            $this->RevisionID = $revisionID;
        }
        return $this;
    }
    /**
     * Get StartDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DateTimeValue|null
     */
    public function getStartDate()
    {
        return isset($this->StartDate) ? $this->StartDate : null;
    }
    /**
     * Set StartDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DateTimeValue $startDate
     * @return \AcumaticaConfig\StructType\TaxScheduleDetail
     */
    public function setStartDate(\AcumaticaConfig\StructType\DateTimeValue $startDate = null)
    {
        if (is_null($startDate) || (is_array($startDate) && empty($startDate))) {
            unset($this->StartDate);
        } else {
            $this->StartDate = $startDate;
        }
        return $this;
    }
    /**
     * Get TaxID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getTaxID()
    {
        return isset($this->TaxID) ? $this->TaxID : null;
    }
    /**
     * Set TaxID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $taxID
     * @return \AcumaticaConfig\StructType\TaxScheduleDetail
     */
    public function setTaxID(\AcumaticaConfig\StructType\StringValue $taxID = null)
    {
        if (is_null($taxID) || (is_array($taxID) && empty($taxID))) {
            unset($this->TaxID);
        } else {
            $this->TaxID = $taxID;
        }
        return $this;
    }
    /**
     * Get TaxRate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DecimalValue|null
     */
    public function getTaxRate()
    {
        return isset($this->TaxRate) ? $this->TaxRate : null;
    }
    /**
     * Set TaxRate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DecimalValue $taxRate
     * @return \AcumaticaConfig\StructType\TaxScheduleDetail
     */
    public function setTaxRate(\AcumaticaConfig\StructType\DecimalValue $taxRate = null)
    {
        if (is_null($taxRate) || (is_array($taxRate) && empty($taxRate))) {
            unset($this->TaxRate);
        } else {
            $this->TaxRate = $taxRate;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AcumaticaConfig\StructType\TaxScheduleDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
