<?php

namespace AcumaticaConfig\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TaxSchedule StructType
 * @subpackage Structs
 */
class TaxSchedule extends AbstractStructBase
{
    /**
     * The TaxScheduleDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\TaxScheduleDetail[]
     */
    public $TaxScheduleDetail;
    /**
     * Constructor method for TaxSchedule
     * @uses TaxSchedule::setTaxScheduleDetail()
     * @param \AcumaticaConfig\StructType\TaxScheduleDetail[] $taxScheduleDetail
     */
    public function __construct(array $taxScheduleDetail = array())
    {
        $this
            ->setTaxScheduleDetail($taxScheduleDetail);
    }
    /**
     * Get TaxScheduleDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\TaxScheduleDetail[]|null
     */
    public function getTaxScheduleDetail()
    {
        return isset($this->TaxScheduleDetail) ? $this->TaxScheduleDetail : null;
    }
    /**
     * Set TaxScheduleDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\TaxScheduleDetail[] $taxScheduleDetail
     * @return \AcumaticaConfig\StructType\TaxSchedule
     */
    public function setTaxScheduleDetail(array $taxScheduleDetail = array())
    {
        foreach ($taxScheduleDetail as $taxScheduleTaxScheduleDetailItem) {
            // validation for constraint: itemType
            if (!$taxScheduleTaxScheduleDetailItem instanceof \AcumaticaConfig\StructType\TaxScheduleDetail) {
                throw new \InvalidArgumentException(sprintf('The TaxScheduleDetail property can only contain items of \AcumaticaConfig\StructType\TaxScheduleDetail, "%s" given', is_object($taxScheduleTaxScheduleDetailItem) ? get_class($taxScheduleTaxScheduleDetailItem) : gettype($taxScheduleTaxScheduleDetailItem)), __LINE__);
            }
        }
        if (is_null($taxScheduleDetail) || (is_array($taxScheduleDetail) && empty($taxScheduleDetail))) {
            unset($this->TaxScheduleDetail);
        } else {
            $this->TaxScheduleDetail = $taxScheduleDetail;
        }
        return $this;
    }
    /**
     * Add item to TaxScheduleDetail value
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\TaxScheduleDetail $item
     * @return \AcumaticaConfig\StructType\TaxSchedule
     */
    public function addToTaxScheduleDetail(\AcumaticaConfig\StructType\TaxScheduleDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AcumaticaConfig\StructType\TaxScheduleDetail) {
            throw new \InvalidArgumentException(sprintf('The TaxScheduleDetail property can only contain items of \AcumaticaConfig\StructType\TaxScheduleDetail, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->TaxScheduleDetail[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AcumaticaConfig\StructType\TaxSchedule
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
