<?php

namespace AcumaticaConfig\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TaxDetails StructType
 * @subpackage Structs
 */
class TaxDetails extends AbstractStructBase
{
    /**
     * The TaxDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\TaxDetail[]
     */
    public $TaxDetail;
    /**
     * The OpportunityTaxDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\OpportunityTaxDetail[]
     */
    public $OpportunityTaxDetail;
    /**
     * The InvoiceTaxDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\InvoiceTaxDetail[]
     */
    public $InvoiceTaxDetail;
    /**
     * The BillTaxDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\BillTaxDetail[]
     */
    public $BillTaxDetail;
    /**
     * Constructor method for TaxDetails
     * @uses TaxDetails::setTaxDetail()
     * @uses TaxDetails::setOpportunityTaxDetail()
     * @uses TaxDetails::setInvoiceTaxDetail()
     * @uses TaxDetails::setBillTaxDetail()
     * @param \AcumaticaConfig\StructType\TaxDetail[] $taxDetail
     * @param \AcumaticaConfig\StructType\OpportunityTaxDetail[] $opportunityTaxDetail
     * @param \AcumaticaConfig\StructType\InvoiceTaxDetail[] $invoiceTaxDetail
     * @param \AcumaticaConfig\StructType\BillTaxDetail[] $billTaxDetail
     */
    public function __construct(array $taxDetail = array(), array $opportunityTaxDetail = array(), array $invoiceTaxDetail = array(), array $billTaxDetail = array())
    {
        $this
            ->setTaxDetail($taxDetail)
            ->setOpportunityTaxDetail($opportunityTaxDetail)
            ->setInvoiceTaxDetail($invoiceTaxDetail)
            ->setBillTaxDetail($billTaxDetail);
    }
    /**
     * Get TaxDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\TaxDetail[]|null
     */
    public function getTaxDetail()
    {
        return isset($this->TaxDetail) ? $this->TaxDetail : null;
    }
    /**
     * Set TaxDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\TaxDetail[] $taxDetail
     * @return \AcumaticaConfig\StructType\TaxDetails
     */
    public function setTaxDetail(array $taxDetail = array())
    {
        foreach ($taxDetail as $taxDetailsTaxDetailItem) {
            // validation for constraint: itemType
            if (!$taxDetailsTaxDetailItem instanceof \AcumaticaConfig\StructType\TaxDetail) {
                throw new \InvalidArgumentException(sprintf('The TaxDetail property can only contain items of \AcumaticaConfig\StructType\TaxDetail, "%s" given', is_object($taxDetailsTaxDetailItem) ? get_class($taxDetailsTaxDetailItem) : gettype($taxDetailsTaxDetailItem)), __LINE__);
            }
        }
        if (is_null($taxDetail) || (is_array($taxDetail) && empty($taxDetail))) {
            unset($this->TaxDetail);
        } else {
            $this->TaxDetail = $taxDetail;
        }
        return $this;
    }
    /**
     * Add item to TaxDetail value
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\TaxDetail $item
     * @return \AcumaticaConfig\StructType\TaxDetails
     */
    public function addToTaxDetail(\AcumaticaConfig\StructType\TaxDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AcumaticaConfig\StructType\TaxDetail) {
            throw new \InvalidArgumentException(sprintf('The TaxDetail property can only contain items of \AcumaticaConfig\StructType\TaxDetail, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->TaxDetail[] = $item;
        return $this;
    }
    /**
     * Get OpportunityTaxDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\OpportunityTaxDetail[]|null
     */
    public function getOpportunityTaxDetail()
    {
        return isset($this->OpportunityTaxDetail) ? $this->OpportunityTaxDetail : null;
    }
    /**
     * Set OpportunityTaxDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\OpportunityTaxDetail[] $opportunityTaxDetail
     * @return \AcumaticaConfig\StructType\TaxDetails
     */
    public function setOpportunityTaxDetail(array $opportunityTaxDetail = array())
    {
        foreach ($opportunityTaxDetail as $taxDetailsOpportunityTaxDetailItem) {
            // validation for constraint: itemType
            if (!$taxDetailsOpportunityTaxDetailItem instanceof \AcumaticaConfig\StructType\OpportunityTaxDetail) {
                throw new \InvalidArgumentException(sprintf('The OpportunityTaxDetail property can only contain items of \AcumaticaConfig\StructType\OpportunityTaxDetail, "%s" given', is_object($taxDetailsOpportunityTaxDetailItem) ? get_class($taxDetailsOpportunityTaxDetailItem) : gettype($taxDetailsOpportunityTaxDetailItem)), __LINE__);
            }
        }
        if (is_null($opportunityTaxDetail) || (is_array($opportunityTaxDetail) && empty($opportunityTaxDetail))) {
            unset($this->OpportunityTaxDetail);
        } else {
            $this->OpportunityTaxDetail = $opportunityTaxDetail;
        }
        return $this;
    }
    /**
     * Add item to OpportunityTaxDetail value
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\OpportunityTaxDetail $item
     * @return \AcumaticaConfig\StructType\TaxDetails
     */
    public function addToOpportunityTaxDetail(\AcumaticaConfig\StructType\OpportunityTaxDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AcumaticaConfig\StructType\OpportunityTaxDetail) {
            throw new \InvalidArgumentException(sprintf('The OpportunityTaxDetail property can only contain items of \AcumaticaConfig\StructType\OpportunityTaxDetail, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->OpportunityTaxDetail[] = $item;
        return $this;
    }
    /**
     * Get InvoiceTaxDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\InvoiceTaxDetail[]|null
     */
    public function getInvoiceTaxDetail()
    {
        return isset($this->InvoiceTaxDetail) ? $this->InvoiceTaxDetail : null;
    }
    /**
     * Set InvoiceTaxDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\InvoiceTaxDetail[] $invoiceTaxDetail
     * @return \AcumaticaConfig\StructType\TaxDetails
     */
    public function setInvoiceTaxDetail(array $invoiceTaxDetail = array())
    {
        foreach ($invoiceTaxDetail as $taxDetailsInvoiceTaxDetailItem) {
            // validation for constraint: itemType
            if (!$taxDetailsInvoiceTaxDetailItem instanceof \AcumaticaConfig\StructType\InvoiceTaxDetail) {
                throw new \InvalidArgumentException(sprintf('The InvoiceTaxDetail property can only contain items of \AcumaticaConfig\StructType\InvoiceTaxDetail, "%s" given', is_object($taxDetailsInvoiceTaxDetailItem) ? get_class($taxDetailsInvoiceTaxDetailItem) : gettype($taxDetailsInvoiceTaxDetailItem)), __LINE__);
            }
        }
        if (is_null($invoiceTaxDetail) || (is_array($invoiceTaxDetail) && empty($invoiceTaxDetail))) {
            unset($this->InvoiceTaxDetail);
        } else {
            $this->InvoiceTaxDetail = $invoiceTaxDetail;
        }
        return $this;
    }
    /**
     * Add item to InvoiceTaxDetail value
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\InvoiceTaxDetail $item
     * @return \AcumaticaConfig\StructType\TaxDetails
     */
    public function addToInvoiceTaxDetail(\AcumaticaConfig\StructType\InvoiceTaxDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AcumaticaConfig\StructType\InvoiceTaxDetail) {
            throw new \InvalidArgumentException(sprintf('The InvoiceTaxDetail property can only contain items of \AcumaticaConfig\StructType\InvoiceTaxDetail, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->InvoiceTaxDetail[] = $item;
        return $this;
    }
    /**
     * Get BillTaxDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\BillTaxDetail[]|null
     */
    public function getBillTaxDetail()
    {
        return isset($this->BillTaxDetail) ? $this->BillTaxDetail : null;
    }
    /**
     * Set BillTaxDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\BillTaxDetail[] $billTaxDetail
     * @return \AcumaticaConfig\StructType\TaxDetails
     */
    public function setBillTaxDetail(array $billTaxDetail = array())
    {
        foreach ($billTaxDetail as $taxDetailsBillTaxDetailItem) {
            // validation for constraint: itemType
            if (!$taxDetailsBillTaxDetailItem instanceof \AcumaticaConfig\StructType\BillTaxDetail) {
                throw new \InvalidArgumentException(sprintf('The BillTaxDetail property can only contain items of \AcumaticaConfig\StructType\BillTaxDetail, "%s" given', is_object($taxDetailsBillTaxDetailItem) ? get_class($taxDetailsBillTaxDetailItem) : gettype($taxDetailsBillTaxDetailItem)), __LINE__);
            }
        }
        if (is_null($billTaxDetail) || (is_array($billTaxDetail) && empty($billTaxDetail))) {
            unset($this->BillTaxDetail);
        } else {
            $this->BillTaxDetail = $billTaxDetail;
        }
        return $this;
    }
    /**
     * Add item to BillTaxDetail value
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\BillTaxDetail $item
     * @return \AcumaticaConfig\StructType\TaxDetails
     */
    public function addToBillTaxDetail(\AcumaticaConfig\StructType\BillTaxDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AcumaticaConfig\StructType\BillTaxDetail) {
            throw new \InvalidArgumentException(sprintf('The BillTaxDetail property can only contain items of \AcumaticaConfig\StructType\BillTaxDetail, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->BillTaxDetail[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AcumaticaConfig\StructType\TaxDetails
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
