<?php

namespace AcumaticaConfig\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Tax StructType
 * @subpackage Structs
 */
class Tax extends Entity
{
    /**
     * The CalculateOn
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $CalculateOn;
    /**
     * The CashDiscount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $CashDiscount;
    /**
     * The CreatedDateTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DateTimeValue
     */
    public $CreatedDateTime;
    /**
     * The DeductibleVAT
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\BooleanValue
     */
    public $DeductibleVAT;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $Description;
    /**
     * The EnterFromTaxBill
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\BooleanValue
     */
    public $EnterFromTaxBill;
    /**
     * The ExcludeFromTaxonTaxCalculation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\BooleanValue
     */
    public $ExcludeFromTaxonTaxCalculation;
    /**
     * The IncludeInVATExemptTotal
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\BooleanValue
     */
    public $IncludeInVATExemptTotal;
    /**
     * The IncludeInVATTaxableTotal
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\BooleanValue
     */
    public $IncludeInVATTaxableTotal;
    /**
     * The LastModifiedDateTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DateTimeValue
     */
    public $LastModifiedDateTime;
    /**
     * The NotValidAfter
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DateTimeValue
     */
    public $NotValidAfter;
    /**
     * The PendingVAT
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\BooleanValue
     */
    public $PendingVAT;
    /**
     * The ReverseVAT
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\BooleanValue
     */
    public $ReverseVAT;
    /**
     * The StatisticalVAT
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\BooleanValue
     */
    public $StatisticalVAT;
    /**
     * The TaxAgency
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $TaxAgency;
    /**
     * The TaxClaimableAccount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $TaxClaimableAccount;
    /**
     * The TaxClaimableSubaccount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $TaxClaimableSubaccount;
    /**
     * The TaxExpenseAccount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $TaxExpenseAccount;
    /**
     * The TaxExpenseSubaccount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $TaxExpenseSubaccount;
    /**
     * The TaxID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $TaxID;
    /**
     * The TaxPayableAccount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $TaxPayableAccount;
    /**
     * The TaxPayableSubaccount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $TaxPayableSubaccount;
    /**
     * The TaxSchedule
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\TaxSchedule
     */
    public $TaxSchedule;
    /**
     * The TaxType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $TaxType;
    /**
     * The Zones
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\Zones
     */
    public $Zones;
    /**
     * Constructor method for Tax
     * @uses Tax::setCalculateOn()
     * @uses Tax::setCashDiscount()
     * @uses Tax::setCreatedDateTime()
     * @uses Tax::setDeductibleVAT()
     * @uses Tax::setDescription()
     * @uses Tax::setEnterFromTaxBill()
     * @uses Tax::setExcludeFromTaxonTaxCalculation()
     * @uses Tax::setIncludeInVATExemptTotal()
     * @uses Tax::setIncludeInVATTaxableTotal()
     * @uses Tax::setLastModifiedDateTime()
     * @uses Tax::setNotValidAfter()
     * @uses Tax::setPendingVAT()
     * @uses Tax::setReverseVAT()
     * @uses Tax::setStatisticalVAT()
     * @uses Tax::setTaxAgency()
     * @uses Tax::setTaxClaimableAccount()
     * @uses Tax::setTaxClaimableSubaccount()
     * @uses Tax::setTaxExpenseAccount()
     * @uses Tax::setTaxExpenseSubaccount()
     * @uses Tax::setTaxID()
     * @uses Tax::setTaxPayableAccount()
     * @uses Tax::setTaxPayableSubaccount()
     * @uses Tax::setTaxSchedule()
     * @uses Tax::setTaxType()
     * @uses Tax::setZones()
     * @param \AcumaticaConfig\StructType\StringValue $calculateOn
     * @param \AcumaticaConfig\StructType\StringValue $cashDiscount
     * @param \AcumaticaConfig\StructType\DateTimeValue $createdDateTime
     * @param \AcumaticaConfig\StructType\BooleanValue $deductibleVAT
     * @param \AcumaticaConfig\StructType\StringValue $description
     * @param \AcumaticaConfig\StructType\BooleanValue $enterFromTaxBill
     * @param \AcumaticaConfig\StructType\BooleanValue $excludeFromTaxonTaxCalculation
     * @param \AcumaticaConfig\StructType\BooleanValue $includeInVATExemptTotal
     * @param \AcumaticaConfig\StructType\BooleanValue $includeInVATTaxableTotal
     * @param \AcumaticaConfig\StructType\DateTimeValue $lastModifiedDateTime
     * @param \AcumaticaConfig\StructType\DateTimeValue $notValidAfter
     * @param \AcumaticaConfig\StructType\BooleanValue $pendingVAT
     * @param \AcumaticaConfig\StructType\BooleanValue $reverseVAT
     * @param \AcumaticaConfig\StructType\BooleanValue $statisticalVAT
     * @param \AcumaticaConfig\StructType\StringValue $taxAgency
     * @param \AcumaticaConfig\StructType\StringValue $taxClaimableAccount
     * @param \AcumaticaConfig\StructType\StringValue $taxClaimableSubaccount
     * @param \AcumaticaConfig\StructType\StringValue $taxExpenseAccount
     * @param \AcumaticaConfig\StructType\StringValue $taxExpenseSubaccount
     * @param \AcumaticaConfig\StructType\StringValue $taxID
     * @param \AcumaticaConfig\StructType\StringValue $taxPayableAccount
     * @param \AcumaticaConfig\StructType\StringValue $taxPayableSubaccount
     * @param \AcumaticaConfig\StructType\TaxSchedule $taxSchedule
     * @param \AcumaticaConfig\StructType\StringValue $taxType
     * @param \AcumaticaConfig\StructType\Zones $zones
     */
    public function __construct(\AcumaticaConfig\StructType\StringValue $calculateOn = null, \AcumaticaConfig\StructType\StringValue $cashDiscount = null, \AcumaticaConfig\StructType\DateTimeValue $createdDateTime = null, \AcumaticaConfig\StructType\BooleanValue $deductibleVAT = null, \AcumaticaConfig\StructType\StringValue $description = null, \AcumaticaConfig\StructType\BooleanValue $enterFromTaxBill = null, \AcumaticaConfig\StructType\BooleanValue $excludeFromTaxonTaxCalculation = null, \AcumaticaConfig\StructType\BooleanValue $includeInVATExemptTotal = null, \AcumaticaConfig\StructType\BooleanValue $includeInVATTaxableTotal = null, \AcumaticaConfig\StructType\DateTimeValue $lastModifiedDateTime = null, \AcumaticaConfig\StructType\DateTimeValue $notValidAfter = null, \AcumaticaConfig\StructType\BooleanValue $pendingVAT = null, \AcumaticaConfig\StructType\BooleanValue $reverseVAT = null, \AcumaticaConfig\StructType\BooleanValue $statisticalVAT = null, \AcumaticaConfig\StructType\StringValue $taxAgency = null, \AcumaticaConfig\StructType\StringValue $taxClaimableAccount = null, \AcumaticaConfig\StructType\StringValue $taxClaimableSubaccount = null, \AcumaticaConfig\StructType\StringValue $taxExpenseAccount = null, \AcumaticaConfig\StructType\StringValue $taxExpenseSubaccount = null, \AcumaticaConfig\StructType\StringValue $taxID = null, \AcumaticaConfig\StructType\StringValue $taxPayableAccount = null, \AcumaticaConfig\StructType\StringValue $taxPayableSubaccount = null, \AcumaticaConfig\StructType\TaxSchedule $taxSchedule = null, \AcumaticaConfig\StructType\StringValue $taxType = null, \AcumaticaConfig\StructType\Zones $zones = null)
    {
        $this
            ->setCalculateOn($calculateOn)
            ->setCashDiscount($cashDiscount)
            ->setCreatedDateTime($createdDateTime)
            ->setDeductibleVAT($deductibleVAT)
            ->setDescription($description)
            ->setEnterFromTaxBill($enterFromTaxBill)
            ->setExcludeFromTaxonTaxCalculation($excludeFromTaxonTaxCalculation)
            ->setIncludeInVATExemptTotal($includeInVATExemptTotal)
            ->setIncludeInVATTaxableTotal($includeInVATTaxableTotal)
            ->setLastModifiedDateTime($lastModifiedDateTime)
            ->setNotValidAfter($notValidAfter)
            ->setPendingVAT($pendingVAT)
            ->setReverseVAT($reverseVAT)
            ->setStatisticalVAT($statisticalVAT)
            ->setTaxAgency($taxAgency)
            ->setTaxClaimableAccount($taxClaimableAccount)
            ->setTaxClaimableSubaccount($taxClaimableSubaccount)
            ->setTaxExpenseAccount($taxExpenseAccount)
            ->setTaxExpenseSubaccount($taxExpenseSubaccount)
            ->setTaxID($taxID)
            ->setTaxPayableAccount($taxPayableAccount)
            ->setTaxPayableSubaccount($taxPayableSubaccount)
            ->setTaxSchedule($taxSchedule)
            ->setTaxType($taxType)
            ->setZones($zones);
    }
    /**
     * Get CalculateOn value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getCalculateOn()
    {
        return isset($this->CalculateOn) ? $this->CalculateOn : null;
    }
    /**
     * Set CalculateOn value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $calculateOn
     * @return \AcumaticaConfig\StructType\Tax
     */
    public function setCalculateOn(\AcumaticaConfig\StructType\StringValue $calculateOn = null)
    {
        if (is_null($calculateOn) || (is_array($calculateOn) && empty($calculateOn))) {
            unset($this->CalculateOn);
        } else {
            $this->CalculateOn = $calculateOn;
        }
        return $this;
    }
    /**
     * Get CashDiscount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getCashDiscount()
    {
        return isset($this->CashDiscount) ? $this->CashDiscount : null;
    }
    /**
     * Set CashDiscount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $cashDiscount
     * @return \AcumaticaConfig\StructType\Tax
     */
    public function setCashDiscount(\AcumaticaConfig\StructType\StringValue $cashDiscount = null)
    {
        if (is_null($cashDiscount) || (is_array($cashDiscount) && empty($cashDiscount))) {
            unset($this->CashDiscount);
        } else {
            $this->CashDiscount = $cashDiscount;
        }
        return $this;
    }
    /**
     * Get CreatedDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DateTimeValue|null
     */
    public function getCreatedDateTime()
    {
        return isset($this->CreatedDateTime) ? $this->CreatedDateTime : null;
    }
    /**
     * Set CreatedDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DateTimeValue $createdDateTime
     * @return \AcumaticaConfig\StructType\Tax
     */
    public function setCreatedDateTime(\AcumaticaConfig\StructType\DateTimeValue $createdDateTime = null)
    {
        if (is_null($createdDateTime) || (is_array($createdDateTime) && empty($createdDateTime))) {
            unset($this->CreatedDateTime);
        } else {
            $this->CreatedDateTime = $createdDateTime;
        }
        return $this;
    }
    /**
     * Get DeductibleVAT value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\BooleanValue|null
     */
    public function getDeductibleVAT()
    {
        return isset($this->DeductibleVAT) ? $this->DeductibleVAT : null;
    }
    /**
     * Set DeductibleVAT value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\BooleanValue $deductibleVAT
     * @return \AcumaticaConfig\StructType\Tax
     */
    public function setDeductibleVAT(\AcumaticaConfig\StructType\BooleanValue $deductibleVAT = null)
    {
        if (is_null($deductibleVAT) || (is_array($deductibleVAT) && empty($deductibleVAT))) {
            unset($this->DeductibleVAT);
        } else {
            $this->DeductibleVAT = $deductibleVAT;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $description
     * @return \AcumaticaConfig\StructType\Tax
     */
    public function setDescription(\AcumaticaConfig\StructType\StringValue $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get EnterFromTaxBill value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\BooleanValue|null
     */
    public function getEnterFromTaxBill()
    {
        return isset($this->EnterFromTaxBill) ? $this->EnterFromTaxBill : null;
    }
    /**
     * Set EnterFromTaxBill value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\BooleanValue $enterFromTaxBill
     * @return \AcumaticaConfig\StructType\Tax
     */
    public function setEnterFromTaxBill(\AcumaticaConfig\StructType\BooleanValue $enterFromTaxBill = null)
    {
        if (is_null($enterFromTaxBill) || (is_array($enterFromTaxBill) && empty($enterFromTaxBill))) {
            unset($this->EnterFromTaxBill);
        } else {
            $this->EnterFromTaxBill = $enterFromTaxBill;
        }
        return $this;
    }
    /**
     * Get ExcludeFromTaxonTaxCalculation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\BooleanValue|null
     */
    public function getExcludeFromTaxonTaxCalculation()
    {
        return isset($this->ExcludeFromTaxonTaxCalculation) ? $this->ExcludeFromTaxonTaxCalculation : null;
    }
    /**
     * Set ExcludeFromTaxonTaxCalculation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\BooleanValue $excludeFromTaxonTaxCalculation
     * @return \AcumaticaConfig\StructType\Tax
     */
    public function setExcludeFromTaxonTaxCalculation(\AcumaticaConfig\StructType\BooleanValue $excludeFromTaxonTaxCalculation = null)
    {
        if (is_null($excludeFromTaxonTaxCalculation) || (is_array($excludeFromTaxonTaxCalculation) && empty($excludeFromTaxonTaxCalculation))) {
            unset($this->ExcludeFromTaxonTaxCalculation);
        } else {
            $this->ExcludeFromTaxonTaxCalculation = $excludeFromTaxonTaxCalculation;
        }
        return $this;
    }
    /**
     * Get IncludeInVATExemptTotal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\BooleanValue|null
     */
    public function getIncludeInVATExemptTotal()
    {
        return isset($this->IncludeInVATExemptTotal) ? $this->IncludeInVATExemptTotal : null;
    }
    /**
     * Set IncludeInVATExemptTotal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\BooleanValue $includeInVATExemptTotal
     * @return \AcumaticaConfig\StructType\Tax
     */
    public function setIncludeInVATExemptTotal(\AcumaticaConfig\StructType\BooleanValue $includeInVATExemptTotal = null)
    {
        if (is_null($includeInVATExemptTotal) || (is_array($includeInVATExemptTotal) && empty($includeInVATExemptTotal))) {
            unset($this->IncludeInVATExemptTotal);
        } else {
            $this->IncludeInVATExemptTotal = $includeInVATExemptTotal;
        }
        return $this;
    }
    /**
     * Get IncludeInVATTaxableTotal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\BooleanValue|null
     */
    public function getIncludeInVATTaxableTotal()
    {
        return isset($this->IncludeInVATTaxableTotal) ? $this->IncludeInVATTaxableTotal : null;
    }
    /**
     * Set IncludeInVATTaxableTotal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\BooleanValue $includeInVATTaxableTotal
     * @return \AcumaticaConfig\StructType\Tax
     */
    public function setIncludeInVATTaxableTotal(\AcumaticaConfig\StructType\BooleanValue $includeInVATTaxableTotal = null)
    {
        if (is_null($includeInVATTaxableTotal) || (is_array($includeInVATTaxableTotal) && empty($includeInVATTaxableTotal))) {
            unset($this->IncludeInVATTaxableTotal);
        } else {
            $this->IncludeInVATTaxableTotal = $includeInVATTaxableTotal;
        }
        return $this;
    }
    /**
     * Get LastModifiedDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DateTimeValue|null
     */
    public function getLastModifiedDateTime()
    {
        return isset($this->LastModifiedDateTime) ? $this->LastModifiedDateTime : null;
    }
    /**
     * Set LastModifiedDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DateTimeValue $lastModifiedDateTime
     * @return \AcumaticaConfig\StructType\Tax
     */
    public function setLastModifiedDateTime(\AcumaticaConfig\StructType\DateTimeValue $lastModifiedDateTime = null)
    {
        if (is_null($lastModifiedDateTime) || (is_array($lastModifiedDateTime) && empty($lastModifiedDateTime))) {
            unset($this->LastModifiedDateTime);
        } else {
            $this->LastModifiedDateTime = $lastModifiedDateTime;
        }
        return $this;
    }
    /**
     * Get NotValidAfter value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DateTimeValue|null
     */
    public function getNotValidAfter()
    {
        return isset($this->NotValidAfter) ? $this->NotValidAfter : null;
    }
    /**
     * Set NotValidAfter value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DateTimeValue $notValidAfter
     * @return \AcumaticaConfig\StructType\Tax
     */
    public function setNotValidAfter(\AcumaticaConfig\StructType\DateTimeValue $notValidAfter = null)
    {
        if (is_null($notValidAfter) || (is_array($notValidAfter) && empty($notValidAfter))) {
            unset($this->NotValidAfter);
        } else {
            $this->NotValidAfter = $notValidAfter;
        }
        return $this;
    }
    /**
     * Get PendingVAT value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\BooleanValue|null
     */
    public function getPendingVAT()
    {
        return isset($this->PendingVAT) ? $this->PendingVAT : null;
    }
    /**
     * Set PendingVAT value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\BooleanValue $pendingVAT
     * @return \AcumaticaConfig\StructType\Tax
     */
    public function setPendingVAT(\AcumaticaConfig\StructType\BooleanValue $pendingVAT = null)
    {
        if (is_null($pendingVAT) || (is_array($pendingVAT) && empty($pendingVAT))) {
            unset($this->PendingVAT);
        } else {
            $this->PendingVAT = $pendingVAT;
        }
        return $this;
    }
    /**
     * Get ReverseVAT value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\BooleanValue|null
     */
    public function getReverseVAT()
    {
        return isset($this->ReverseVAT) ? $this->ReverseVAT : null;
    }
    /**
     * Set ReverseVAT value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\BooleanValue $reverseVAT
     * @return \AcumaticaConfig\StructType\Tax
     */
    public function setReverseVAT(\AcumaticaConfig\StructType\BooleanValue $reverseVAT = null)
    {
        if (is_null($reverseVAT) || (is_array($reverseVAT) && empty($reverseVAT))) {
            unset($this->ReverseVAT);
        } else {
            $this->ReverseVAT = $reverseVAT;
        }
        return $this;
    }
    /**
     * Get StatisticalVAT value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\BooleanValue|null
     */
    public function getStatisticalVAT()
    {
        return isset($this->StatisticalVAT) ? $this->StatisticalVAT : null;
    }
    /**
     * Set StatisticalVAT value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\BooleanValue $statisticalVAT
     * @return \AcumaticaConfig\StructType\Tax
     */
    public function setStatisticalVAT(\AcumaticaConfig\StructType\BooleanValue $statisticalVAT = null)
    {
        if (is_null($statisticalVAT) || (is_array($statisticalVAT) && empty($statisticalVAT))) {
            unset($this->StatisticalVAT);
        } else {
            $this->StatisticalVAT = $statisticalVAT;
        }
        return $this;
    }
    /**
     * Get TaxAgency value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getTaxAgency()
    {
        return isset($this->TaxAgency) ? $this->TaxAgency : null;
    }
    /**
     * Set TaxAgency value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $taxAgency
     * @return \AcumaticaConfig\StructType\Tax
     */
    public function setTaxAgency(\AcumaticaConfig\StructType\StringValue $taxAgency = null)
    {
        if (is_null($taxAgency) || (is_array($taxAgency) && empty($taxAgency))) {
            unset($this->TaxAgency);
        } else {
            $this->TaxAgency = $taxAgency;
        }
        return $this;
    }
    /**
     * Get TaxClaimableAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getTaxClaimableAccount()
    {
        return isset($this->TaxClaimableAccount) ? $this->TaxClaimableAccount : null;
    }
    /**
     * Set TaxClaimableAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $taxClaimableAccount
     * @return \AcumaticaConfig\StructType\Tax
     */
    public function setTaxClaimableAccount(\AcumaticaConfig\StructType\StringValue $taxClaimableAccount = null)
    {
        if (is_null($taxClaimableAccount) || (is_array($taxClaimableAccount) && empty($taxClaimableAccount))) {
            unset($this->TaxClaimableAccount);
        } else {
            $this->TaxClaimableAccount = $taxClaimableAccount;
        }
        return $this;
    }
    /**
     * Get TaxClaimableSubaccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getTaxClaimableSubaccount()
    {
        return isset($this->TaxClaimableSubaccount) ? $this->TaxClaimableSubaccount : null;
    }
    /**
     * Set TaxClaimableSubaccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $taxClaimableSubaccount
     * @return \AcumaticaConfig\StructType\Tax
     */
    public function setTaxClaimableSubaccount(\AcumaticaConfig\StructType\StringValue $taxClaimableSubaccount = null)
    {
        if (is_null($taxClaimableSubaccount) || (is_array($taxClaimableSubaccount) && empty($taxClaimableSubaccount))) {
            unset($this->TaxClaimableSubaccount);
        } else {
            $this->TaxClaimableSubaccount = $taxClaimableSubaccount;
        }
        return $this;
    }
    /**
     * Get TaxExpenseAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getTaxExpenseAccount()
    {
        return isset($this->TaxExpenseAccount) ? $this->TaxExpenseAccount : null;
    }
    /**
     * Set TaxExpenseAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $taxExpenseAccount
     * @return \AcumaticaConfig\StructType\Tax
     */
    public function setTaxExpenseAccount(\AcumaticaConfig\StructType\StringValue $taxExpenseAccount = null)
    {
        if (is_null($taxExpenseAccount) || (is_array($taxExpenseAccount) && empty($taxExpenseAccount))) {
            unset($this->TaxExpenseAccount);
        } else {
            $this->TaxExpenseAccount = $taxExpenseAccount;
        }
        return $this;
    }
    /**
     * Get TaxExpenseSubaccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getTaxExpenseSubaccount()
    {
        return isset($this->TaxExpenseSubaccount) ? $this->TaxExpenseSubaccount : null;
    }
    /**
     * Set TaxExpenseSubaccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $taxExpenseSubaccount
     * @return \AcumaticaConfig\StructType\Tax
     */
    public function setTaxExpenseSubaccount(\AcumaticaConfig\StructType\StringValue $taxExpenseSubaccount = null)
    {
        if (is_null($taxExpenseSubaccount) || (is_array($taxExpenseSubaccount) && empty($taxExpenseSubaccount))) {
            unset($this->TaxExpenseSubaccount);
        } else {
            $this->TaxExpenseSubaccount = $taxExpenseSubaccount;
        }
        return $this;
    }
    /**
     * Get TaxID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getTaxID()
    {
        return isset($this->TaxID) ? $this->TaxID : null;
    }
    /**
     * Set TaxID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $taxID
     * @return \AcumaticaConfig\StructType\Tax
     */
    public function setTaxID(\AcumaticaConfig\StructType\StringValue $taxID = null)
    {
        if (is_null($taxID) || (is_array($taxID) && empty($taxID))) {
            unset($this->TaxID);
        } else {
            $this->TaxID = $taxID;
        }
        return $this;
    }
    /**
     * Get TaxPayableAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getTaxPayableAccount()
    {
        return isset($this->TaxPayableAccount) ? $this->TaxPayableAccount : null;
    }
    /**
     * Set TaxPayableAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $taxPayableAccount
     * @return \AcumaticaConfig\StructType\Tax
     */
    public function setTaxPayableAccount(\AcumaticaConfig\StructType\StringValue $taxPayableAccount = null)
    {
        if (is_null($taxPayableAccount) || (is_array($taxPayableAccount) && empty($taxPayableAccount))) {
            unset($this->TaxPayableAccount);
        } else {
            $this->TaxPayableAccount = $taxPayableAccount;
        }
        return $this;
    }
    /**
     * Get TaxPayableSubaccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getTaxPayableSubaccount()
    {
        return isset($this->TaxPayableSubaccount) ? $this->TaxPayableSubaccount : null;
    }
    /**
     * Set TaxPayableSubaccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $taxPayableSubaccount
     * @return \AcumaticaConfig\StructType\Tax
     */
    public function setTaxPayableSubaccount(\AcumaticaConfig\StructType\StringValue $taxPayableSubaccount = null)
    {
        if (is_null($taxPayableSubaccount) || (is_array($taxPayableSubaccount) && empty($taxPayableSubaccount))) {
            unset($this->TaxPayableSubaccount);
        } else {
            $this->TaxPayableSubaccount = $taxPayableSubaccount;
        }
        return $this;
    }
    /**
     * Get TaxSchedule value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\TaxSchedule|null
     */
    public function getTaxSchedule()
    {
        return isset($this->TaxSchedule) ? $this->TaxSchedule : null;
    }
    /**
     * Set TaxSchedule value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\TaxSchedule $taxSchedule
     * @return \AcumaticaConfig\StructType\Tax
     */
    public function setTaxSchedule(\AcumaticaConfig\StructType\TaxSchedule $taxSchedule = null)
    {
        if (is_null($taxSchedule) || (is_array($taxSchedule) && empty($taxSchedule))) {
            unset($this->TaxSchedule);
        } else {
            $this->TaxSchedule = $taxSchedule;
        }
        return $this;
    }
    /**
     * Get TaxType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getTaxType()
    {
        return isset($this->TaxType) ? $this->TaxType : null;
    }
    /**
     * Set TaxType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $taxType
     * @return \AcumaticaConfig\StructType\Tax
     */
    public function setTaxType(\AcumaticaConfig\StructType\StringValue $taxType = null)
    {
        if (is_null($taxType) || (is_array($taxType) && empty($taxType))) {
            unset($this->TaxType);
        } else {
            $this->TaxType = $taxType;
        }
        return $this;
    }
    /**
     * Get Zones value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\Zones|null
     */
    public function getZones()
    {
        return isset($this->Zones) ? $this->Zones : null;
    }
    /**
     * Set Zones value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\Zones $zones
     * @return \AcumaticaConfig\StructType\Tax
     */
    public function setZones(\AcumaticaConfig\StructType\Zones $zones = null)
    {
        if (is_null($zones) || (is_array($zones) && empty($zones))) {
            unset($this->Zones);
        } else {
            $this->Zones = $zones;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AcumaticaConfig\StructType\Tax
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
