<?php

namespace AcumaticaConfig\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SubItems StructType
 * @subpackage Structs
 */
class SubItems extends AbstractStructBase
{
    /**
     * The SubItemStockItem
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\SubItemStockItem[]
     */
    public $SubItemStockItem;
    /**
     * Constructor method for SubItems
     * @uses SubItems::setSubItemStockItem()
     * @param \AcumaticaConfig\StructType\SubItemStockItem[] $subItemStockItem
     */
    public function __construct(array $subItemStockItem = array())
    {
        $this
            ->setSubItemStockItem($subItemStockItem);
    }
    /**
     * Get SubItemStockItem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\SubItemStockItem[]|null
     */
    public function getSubItemStockItem()
    {
        return isset($this->SubItemStockItem) ? $this->SubItemStockItem : null;
    }
    /**
     * Set SubItemStockItem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\SubItemStockItem[] $subItemStockItem
     * @return \AcumaticaConfig\StructType\SubItems
     */
    public function setSubItemStockItem(array $subItemStockItem = array())
    {
        foreach ($subItemStockItem as $subItemsSubItemStockItemItem) {
            // validation for constraint: itemType
            if (!$subItemsSubItemStockItemItem instanceof \AcumaticaConfig\StructType\SubItemStockItem) {
                throw new \InvalidArgumentException(sprintf('The SubItemStockItem property can only contain items of \AcumaticaConfig\StructType\SubItemStockItem, "%s" given', is_object($subItemsSubItemStockItemItem) ? get_class($subItemsSubItemStockItemItem) : gettype($subItemsSubItemStockItemItem)), __LINE__);
            }
        }
        if (is_null($subItemStockItem) || (is_array($subItemStockItem) && empty($subItemStockItem))) {
            unset($this->SubItemStockItem);
        } else {
            $this->SubItemStockItem = $subItemStockItem;
        }
        return $this;
    }
    /**
     * Add item to SubItemStockItem value
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\SubItemStockItem $item
     * @return \AcumaticaConfig\StructType\SubItems
     */
    public function addToSubItemStockItem(\AcumaticaConfig\StructType\SubItemStockItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AcumaticaConfig\StructType\SubItemStockItem) {
            throw new \InvalidArgumentException(sprintf('The SubItemStockItem property can only contain items of \AcumaticaConfig\StructType\SubItemStockItem, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->SubItemStockItem[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AcumaticaConfig\StructType\SubItems
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
