<?php

namespace AcumaticaConfig\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StokItemImageResults StructType
 * @subpackage Structs
 */
class StokItemImageResults extends Entity
{
    /**
     * The StokItemImageResults
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StokItemImageResults[]
     */
    public $StokItemImageResults;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $Description;
    /**
     * The InventoryID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $InventoryID;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $Name;
    /**
     * The NoteDoc_fileID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\GuidValue
     */
    public $NoteDoc_fileID;
    /**
     * Constructor method for StokItemImageResults
     * @uses StokItemImageResults::setStokItemImageResults()
     * @uses StokItemImageResults::setDescription()
     * @uses StokItemImageResults::setInventoryID()
     * @uses StokItemImageResults::setName()
     * @uses StokItemImageResults::setNoteDoc_fileID()
     * @param \AcumaticaConfig\StructType\StokItemImageResults[] $stokItemImageResults
     * @param \AcumaticaConfig\StructType\StringValue $description
     * @param \AcumaticaConfig\StructType\StringValue $inventoryID
     * @param \AcumaticaConfig\StructType\StringValue $name
     * @param \AcumaticaConfig\StructType\GuidValue $noteDoc_fileID
     */
    public function __construct(array $stokItemImageResults = array(), \AcumaticaConfig\StructType\StringValue $description = null, \AcumaticaConfig\StructType\StringValue $inventoryID = null, \AcumaticaConfig\StructType\StringValue $name = null, \AcumaticaConfig\StructType\GuidValue $noteDoc_fileID = null)
    {
        $this
            ->setStokItemImageResults($stokItemImageResults)
            ->setDescription($description)
            ->setInventoryID($inventoryID)
            ->setName($name)
            ->setNoteDoc_fileID($noteDoc_fileID);
    }
    /**
     * Get StokItemImageResults value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StokItemImageResults[]|null
     */
    public function getStokItemImageResults()
    {
        return isset($this->StokItemImageResults) ? $this->StokItemImageResults : null;
    }
    /**
     * Set StokItemImageResults value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\StokItemImageResults[] $stokItemImageResults
     * @return \AcumaticaConfig\StructType\StokItemImageResults
     */
    public function setStokItemImageResults(array $stokItemImageResults = array())
    {
        foreach ($stokItemImageResults as $stokItemImageResultsStokItemImageResultsItem) {
            // validation for constraint: itemType
            if (!$stokItemImageResultsStokItemImageResultsItem instanceof \AcumaticaConfig\StructType\StokItemImageResults) {
                throw new \InvalidArgumentException(sprintf('The StokItemImageResults property can only contain items of \AcumaticaConfig\StructType\StokItemImageResults, "%s" given', is_object($stokItemImageResultsStokItemImageResultsItem) ? get_class($stokItemImageResultsStokItemImageResultsItem) : gettype($stokItemImageResultsStokItemImageResultsItem)), __LINE__);
            }
        }
        if (is_null($stokItemImageResults) || (is_array($stokItemImageResults) && empty($stokItemImageResults))) {
            unset($this->StokItemImageResults);
        } else {
            $this->StokItemImageResults = $stokItemImageResults;
        }
        return $this;
    }
    /**
     * Add item to StokItemImageResults value
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\StokItemImageResults $item
     * @return \AcumaticaConfig\StructType\StokItemImageResults
     */
    public function addToStokItemImageResults(\AcumaticaConfig\StructType\StokItemImageResults $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AcumaticaConfig\StructType\StokItemImageResults) {
            throw new \InvalidArgumentException(sprintf('The StokItemImageResults property can only contain items of \AcumaticaConfig\StructType\StokItemImageResults, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->StokItemImageResults[] = $item;
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $description
     * @return \AcumaticaConfig\StructType\StokItemImageResults
     */
    public function setDescription(\AcumaticaConfig\StructType\StringValue $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get InventoryID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getInventoryID()
    {
        return isset($this->InventoryID) ? $this->InventoryID : null;
    }
    /**
     * Set InventoryID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $inventoryID
     * @return \AcumaticaConfig\StructType\StokItemImageResults
     */
    public function setInventoryID(\AcumaticaConfig\StructType\StringValue $inventoryID = null)
    {
        if (is_null($inventoryID) || (is_array($inventoryID) && empty($inventoryID))) {
            unset($this->InventoryID);
        } else {
            $this->InventoryID = $inventoryID;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $name
     * @return \AcumaticaConfig\StructType\StokItemImageResults
     */
    public function setName(\AcumaticaConfig\StructType\StringValue $name = null)
    {
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get NoteDoc_fileID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\GuidValue|null
     */
    public function getNoteDoc_fileID()
    {
        return isset($this->NoteDoc_fileID) ? $this->NoteDoc_fileID : null;
    }
    /**
     * Set NoteDoc_fileID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\GuidValue $noteDoc_fileID
     * @return \AcumaticaConfig\StructType\StokItemImageResults
     */
    public function setNoteDoc_fileID(\AcumaticaConfig\StructType\GuidValue $noteDoc_fileID = null)
    {
        if (is_null($noteDoc_fileID) || (is_array($noteDoc_fileID) && empty($noteDoc_fileID))) {
            unset($this->NoteDoc_fileID);
        } else {
            $this->NoteDoc_fileID = $noteDoc_fileID;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AcumaticaConfig\StructType\StokItemImageResults
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
