<?php

namespace AcumaticaConfig\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShipToSettings StructType
 * @subpackage Structs
 */
class ShipToSettings extends Entity
{
    /**
     * The ShipToAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\Address
     */
    public $ShipToAddress;
    /**
     * The ShipToAddressOverride
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\BooleanValue
     */
    public $ShipToAddressOverride;
    /**
     * The ShipToContact
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DocContact
     */
    public $ShipToContact;
    /**
     * The ShipToContactOverride
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\BooleanValue
     */
    public $ShipToContactOverride;
    /**
     * The Validated
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\BooleanValue
     */
    public $Validated;
    /**
     * Constructor method for ShipToSettings
     * @uses ShipToSettings::setShipToAddress()
     * @uses ShipToSettings::setShipToAddressOverride()
     * @uses ShipToSettings::setShipToContact()
     * @uses ShipToSettings::setShipToContactOverride()
     * @uses ShipToSettings::setValidated()
     * @param \AcumaticaConfig\StructType\Address $shipToAddress
     * @param \AcumaticaConfig\StructType\BooleanValue $shipToAddressOverride
     * @param \AcumaticaConfig\StructType\DocContact $shipToContact
     * @param \AcumaticaConfig\StructType\BooleanValue $shipToContactOverride
     * @param \AcumaticaConfig\StructType\BooleanValue $validated
     */
    public function __construct(\AcumaticaConfig\StructType\Address $shipToAddress = null, \AcumaticaConfig\StructType\BooleanValue $shipToAddressOverride = null, \AcumaticaConfig\StructType\DocContact $shipToContact = null, \AcumaticaConfig\StructType\BooleanValue $shipToContactOverride = null, \AcumaticaConfig\StructType\BooleanValue $validated = null)
    {
        $this
            ->setShipToAddress($shipToAddress)
            ->setShipToAddressOverride($shipToAddressOverride)
            ->setShipToContact($shipToContact)
            ->setShipToContactOverride($shipToContactOverride)
            ->setValidated($validated);
    }
    /**
     * Get ShipToAddress value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\Address|null
     */
    public function getShipToAddress()
    {
        return isset($this->ShipToAddress) ? $this->ShipToAddress : null;
    }
    /**
     * Set ShipToAddress value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\Address $shipToAddress
     * @return \AcumaticaConfig\StructType\ShipToSettings
     */
    public function setShipToAddress(\AcumaticaConfig\StructType\Address $shipToAddress = null)
    {
        if (is_null($shipToAddress) || (is_array($shipToAddress) && empty($shipToAddress))) {
            unset($this->ShipToAddress);
        } else {
            $this->ShipToAddress = $shipToAddress;
        }
        return $this;
    }
    /**
     * Get ShipToAddressOverride value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\BooleanValue|null
     */
    public function getShipToAddressOverride()
    {
        return isset($this->ShipToAddressOverride) ? $this->ShipToAddressOverride : null;
    }
    /**
     * Set ShipToAddressOverride value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\BooleanValue $shipToAddressOverride
     * @return \AcumaticaConfig\StructType\ShipToSettings
     */
    public function setShipToAddressOverride(\AcumaticaConfig\StructType\BooleanValue $shipToAddressOverride = null)
    {
        if (is_null($shipToAddressOverride) || (is_array($shipToAddressOverride) && empty($shipToAddressOverride))) {
            unset($this->ShipToAddressOverride);
        } else {
            $this->ShipToAddressOverride = $shipToAddressOverride;
        }
        return $this;
    }
    /**
     * Get ShipToContact value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DocContact|null
     */
    public function getShipToContact()
    {
        return isset($this->ShipToContact) ? $this->ShipToContact : null;
    }
    /**
     * Set ShipToContact value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DocContact $shipToContact
     * @return \AcumaticaConfig\StructType\ShipToSettings
     */
    public function setShipToContact(\AcumaticaConfig\StructType\DocContact $shipToContact = null)
    {
        if (is_null($shipToContact) || (is_array($shipToContact) && empty($shipToContact))) {
            unset($this->ShipToContact);
        } else {
            $this->ShipToContact = $shipToContact;
        }
        return $this;
    }
    /**
     * Get ShipToContactOverride value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\BooleanValue|null
     */
    public function getShipToContactOverride()
    {
        return isset($this->ShipToContactOverride) ? $this->ShipToContactOverride : null;
    }
    /**
     * Set ShipToContactOverride value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\BooleanValue $shipToContactOverride
     * @return \AcumaticaConfig\StructType\ShipToSettings
     */
    public function setShipToContactOverride(\AcumaticaConfig\StructType\BooleanValue $shipToContactOverride = null)
    {
        if (is_null($shipToContactOverride) || (is_array($shipToContactOverride) && empty($shipToContactOverride))) {
            unset($this->ShipToContactOverride);
        } else {
            $this->ShipToContactOverride = $shipToContactOverride;
        }
        return $this;
    }
    /**
     * Get Validated value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\BooleanValue|null
     */
    public function getValidated()
    {
        return isset($this->Validated) ? $this->Validated : null;
    }
    /**
     * Set Validated value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\BooleanValue $validated
     * @return \AcumaticaConfig\StructType\ShipToSettings
     */
    public function setValidated(\AcumaticaConfig\StructType\BooleanValue $validated = null)
    {
        if (is_null($validated) || (is_array($validated) && empty($validated))) {
            unset($this->Validated);
        } else {
            $this->Validated = $validated;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AcumaticaConfig\StructType\ShipToSettings
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
