<?php

namespace AcumaticaConfig\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Salespersons StructType
 * @subpackage Structs
 */
class Salespersons extends AbstractStructBase
{
    /**
     * The CustomerSalesPerson
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\CustomerSalesPerson[]
     */
    public $CustomerSalesPerson;
    /**
     * Constructor method for Salespersons
     * @uses Salespersons::setCustomerSalesPerson()
     * @param \AcumaticaConfig\StructType\CustomerSalesPerson[] $customerSalesPerson
     */
    public function __construct(array $customerSalesPerson = array())
    {
        $this
            ->setCustomerSalesPerson($customerSalesPerson);
    }
    /**
     * Get CustomerSalesPerson value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\CustomerSalesPerson[]|null
     */
    public function getCustomerSalesPerson()
    {
        return isset($this->CustomerSalesPerson) ? $this->CustomerSalesPerson : null;
    }
    /**
     * Set CustomerSalesPerson value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\CustomerSalesPerson[] $customerSalesPerson
     * @return \AcumaticaConfig\StructType\Salespersons
     */
    public function setCustomerSalesPerson(array $customerSalesPerson = array())
    {
        foreach ($customerSalesPerson as $salespersonsCustomerSalesPersonItem) {
            // validation for constraint: itemType
            if (!$salespersonsCustomerSalesPersonItem instanceof \AcumaticaConfig\StructType\CustomerSalesPerson) {
                throw new \InvalidArgumentException(sprintf('The CustomerSalesPerson property can only contain items of \AcumaticaConfig\StructType\CustomerSalesPerson, "%s" given', is_object($salespersonsCustomerSalesPersonItem) ? get_class($salespersonsCustomerSalesPersonItem) : gettype($salespersonsCustomerSalesPersonItem)), __LINE__);
            }
        }
        if (is_null($customerSalesPerson) || (is_array($customerSalesPerson) && empty($customerSalesPerson))) {
            unset($this->CustomerSalesPerson);
        } else {
            $this->CustomerSalesPerson = $customerSalesPerson;
        }
        return $this;
    }
    /**
     * Add item to CustomerSalesPerson value
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\CustomerSalesPerson $item
     * @return \AcumaticaConfig\StructType\Salespersons
     */
    public function addToCustomerSalesPerson(\AcumaticaConfig\StructType\CustomerSalesPerson $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AcumaticaConfig\StructType\CustomerSalesPerson) {
            throw new \InvalidArgumentException(sprintf('The CustomerSalesPerson property can only contain items of \AcumaticaConfig\StructType\CustomerSalesPerson, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->CustomerSalesPerson[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AcumaticaConfig\StructType\Salespersons
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
