<?php

namespace AcumaticaConfig\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SalesPersons StructType
 * @subpackage Structs
 */
class SalesPersons_1 extends AbstractStructBase
{
    /**
     * The SalesPersonDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\SalesPersonDetail[]
     */
    public $SalesPersonDetail;
    /**
     * Constructor method for SalesPersons
     * @uses SalesPersons_1::setSalesPersonDetail()
     * @param \AcumaticaConfig\StructType\SalesPersonDetail[] $salesPersonDetail
     */
    public function __construct(array $salesPersonDetail = array())
    {
        $this
            ->setSalesPersonDetail($salesPersonDetail);
    }
    /**
     * Get SalesPersonDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\SalesPersonDetail[]|null
     */
    public function getSalesPersonDetail()
    {
        return isset($this->SalesPersonDetail) ? $this->SalesPersonDetail : null;
    }
    /**
     * Set SalesPersonDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\SalesPersonDetail[] $salesPersonDetail
     * @return \AcumaticaConfig\StructType\SalesPersons_1
     */
    public function setSalesPersonDetail(array $salesPersonDetail = array())
    {
        foreach ($salesPersonDetail as $salesPersonsSalesPersonDetailItem) {
            // validation for constraint: itemType
            if (!$salesPersonsSalesPersonDetailItem instanceof \AcumaticaConfig\StructType\SalesPersonDetail) {
                throw new \InvalidArgumentException(sprintf('The SalesPersonDetail property can only contain items of \AcumaticaConfig\StructType\SalesPersonDetail, "%s" given', is_object($salesPersonsSalesPersonDetailItem) ? get_class($salesPersonsSalesPersonDetailItem) : gettype($salesPersonsSalesPersonDetailItem)), __LINE__);
            }
        }
        if (is_null($salesPersonDetail) || (is_array($salesPersonDetail) && empty($salesPersonDetail))) {
            unset($this->SalesPersonDetail);
        } else {
            $this->SalesPersonDetail = $salesPersonDetail;
        }
        return $this;
    }
    /**
     * Add item to SalesPersonDetail value
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\SalesPersonDetail $item
     * @return \AcumaticaConfig\StructType\SalesPersons_1
     */
    public function addToSalesPersonDetail(\AcumaticaConfig\StructType\SalesPersonDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AcumaticaConfig\StructType\SalesPersonDetail) {
            throw new \InvalidArgumentException(sprintf('The SalesPersonDetail property can only contain items of \AcumaticaConfig\StructType\SalesPersonDetail, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->SalesPersonDetail[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AcumaticaConfig\StructType\SalesPersons_1
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
