<?php

namespace AcumaticaConfig\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SalesPersonDetail StructType
 * @subpackage Structs
 */
class SalesPersonDetail extends Entity
{
    /**
     * The CommissionableAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DecimalValue
     */
    public $CommissionableAmount;
    /**
     * The CommissionAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DecimalValue
     */
    public $CommissionAmount;
    /**
     * The CommissionPercent
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DecimalValue
     */
    public $CommissionPercent;
    /**
     * The SalespersonID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $SalespersonID;
    /**
     * Constructor method for SalesPersonDetail
     * @uses SalesPersonDetail::setCommissionableAmount()
     * @uses SalesPersonDetail::setCommissionAmount()
     * @uses SalesPersonDetail::setCommissionPercent()
     * @uses SalesPersonDetail::setSalespersonID()
     * @param \AcumaticaConfig\StructType\DecimalValue $commissionableAmount
     * @param \AcumaticaConfig\StructType\DecimalValue $commissionAmount
     * @param \AcumaticaConfig\StructType\DecimalValue $commissionPercent
     * @param \AcumaticaConfig\StructType\StringValue $salespersonID
     */
    public function __construct(\AcumaticaConfig\StructType\DecimalValue $commissionableAmount = null, \AcumaticaConfig\StructType\DecimalValue $commissionAmount = null, \AcumaticaConfig\StructType\DecimalValue $commissionPercent = null, \AcumaticaConfig\StructType\StringValue $salespersonID = null)
    {
        $this
            ->setCommissionableAmount($commissionableAmount)
            ->setCommissionAmount($commissionAmount)
            ->setCommissionPercent($commissionPercent)
            ->setSalespersonID($salespersonID);
    }
    /**
     * Get CommissionableAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DecimalValue|null
     */
    public function getCommissionableAmount()
    {
        return isset($this->CommissionableAmount) ? $this->CommissionableAmount : null;
    }
    /**
     * Set CommissionableAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DecimalValue $commissionableAmount
     * @return \AcumaticaConfig\StructType\SalesPersonDetail
     */
    public function setCommissionableAmount(\AcumaticaConfig\StructType\DecimalValue $commissionableAmount = null)
    {
        if (is_null($commissionableAmount) || (is_array($commissionableAmount) && empty($commissionableAmount))) {
            unset($this->CommissionableAmount);
        } else {
            $this->CommissionableAmount = $commissionableAmount;
        }
        return $this;
    }
    /**
     * Get CommissionAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DecimalValue|null
     */
    public function getCommissionAmount()
    {
        return isset($this->CommissionAmount) ? $this->CommissionAmount : null;
    }
    /**
     * Set CommissionAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DecimalValue $commissionAmount
     * @return \AcumaticaConfig\StructType\SalesPersonDetail
     */
    public function setCommissionAmount(\AcumaticaConfig\StructType\DecimalValue $commissionAmount = null)
    {
        if (is_null($commissionAmount) || (is_array($commissionAmount) && empty($commissionAmount))) {
            unset($this->CommissionAmount);
        } else {
            $this->CommissionAmount = $commissionAmount;
        }
        return $this;
    }
    /**
     * Get CommissionPercent value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DecimalValue|null
     */
    public function getCommissionPercent()
    {
        return isset($this->CommissionPercent) ? $this->CommissionPercent : null;
    }
    /**
     * Set CommissionPercent value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DecimalValue $commissionPercent
     * @return \AcumaticaConfig\StructType\SalesPersonDetail
     */
    public function setCommissionPercent(\AcumaticaConfig\StructType\DecimalValue $commissionPercent = null)
    {
        if (is_null($commissionPercent) || (is_array($commissionPercent) && empty($commissionPercent))) {
            unset($this->CommissionPercent);
        } else {
            $this->CommissionPercent = $commissionPercent;
        }
        return $this;
    }
    /**
     * Get SalespersonID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getSalespersonID()
    {
        return isset($this->SalespersonID) ? $this->SalespersonID : null;
    }
    /**
     * Set SalespersonID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $salespersonID
     * @return \AcumaticaConfig\StructType\SalesPersonDetail
     */
    public function setSalespersonID(\AcumaticaConfig\StructType\StringValue $salespersonID = null)
    {
        if (is_null($salespersonID) || (is_array($salespersonID) && empty($salespersonID))) {
            unset($this->SalespersonID);
        } else {
            $this->SalespersonID = $salespersonID;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AcumaticaConfig\StructType\SalesPersonDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
