<?php

namespace AcumaticaConfig\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SalesOrderShipment StructType
 * @subpackage Structs
 */
class SalesOrderShipment extends Entity
{
    /**
     * The InventoryDocType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $InventoryDocType;
    /**
     * The InventoryRefNbr
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $InventoryRefNbr;
    /**
     * The InvoiceNbr
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $InvoiceNbr;
    /**
     * The InvoiceType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $InvoiceType;
    /**
     * The ShipmentDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DateTimeValue
     */
    public $ShipmentDate;
    /**
     * The ShipmentNbr
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $ShipmentNbr;
    /**
     * The ShipmentType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $ShipmentType;
    /**
     * The ShippedQty
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DecimalValue
     */
    public $ShippedQty;
    /**
     * The ShippedVolume
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DecimalValue
     */
    public $ShippedVolume;
    /**
     * The ShippedWeight
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DecimalValue
     */
    public $ShippedWeight;
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $Status;
    /**
     * Constructor method for SalesOrderShipment
     * @uses SalesOrderShipment::setInventoryDocType()
     * @uses SalesOrderShipment::setInventoryRefNbr()
     * @uses SalesOrderShipment::setInvoiceNbr()
     * @uses SalesOrderShipment::setInvoiceType()
     * @uses SalesOrderShipment::setShipmentDate()
     * @uses SalesOrderShipment::setShipmentNbr()
     * @uses SalesOrderShipment::setShipmentType()
     * @uses SalesOrderShipment::setShippedQty()
     * @uses SalesOrderShipment::setShippedVolume()
     * @uses SalesOrderShipment::setShippedWeight()
     * @uses SalesOrderShipment::setStatus()
     * @param \AcumaticaConfig\StructType\StringValue $inventoryDocType
     * @param \AcumaticaConfig\StructType\StringValue $inventoryRefNbr
     * @param \AcumaticaConfig\StructType\StringValue $invoiceNbr
     * @param \AcumaticaConfig\StructType\StringValue $invoiceType
     * @param \AcumaticaConfig\StructType\DateTimeValue $shipmentDate
     * @param \AcumaticaConfig\StructType\StringValue $shipmentNbr
     * @param \AcumaticaConfig\StructType\StringValue $shipmentType
     * @param \AcumaticaConfig\StructType\DecimalValue $shippedQty
     * @param \AcumaticaConfig\StructType\DecimalValue $shippedVolume
     * @param \AcumaticaConfig\StructType\DecimalValue $shippedWeight
     * @param \AcumaticaConfig\StructType\StringValue $status
     */
    public function __construct(\AcumaticaConfig\StructType\StringValue $inventoryDocType = null, \AcumaticaConfig\StructType\StringValue $inventoryRefNbr = null, \AcumaticaConfig\StructType\StringValue $invoiceNbr = null, \AcumaticaConfig\StructType\StringValue $invoiceType = null, \AcumaticaConfig\StructType\DateTimeValue $shipmentDate = null, \AcumaticaConfig\StructType\StringValue $shipmentNbr = null, \AcumaticaConfig\StructType\StringValue $shipmentType = null, \AcumaticaConfig\StructType\DecimalValue $shippedQty = null, \AcumaticaConfig\StructType\DecimalValue $shippedVolume = null, \AcumaticaConfig\StructType\DecimalValue $shippedWeight = null, \AcumaticaConfig\StructType\StringValue $status = null)
    {
        $this
            ->setInventoryDocType($inventoryDocType)
            ->setInventoryRefNbr($inventoryRefNbr)
            ->setInvoiceNbr($invoiceNbr)
            ->setInvoiceType($invoiceType)
            ->setShipmentDate($shipmentDate)
            ->setShipmentNbr($shipmentNbr)
            ->setShipmentType($shipmentType)
            ->setShippedQty($shippedQty)
            ->setShippedVolume($shippedVolume)
            ->setShippedWeight($shippedWeight)
            ->setStatus($status);
    }
    /**
     * Get InventoryDocType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getInventoryDocType()
    {
        return isset($this->InventoryDocType) ? $this->InventoryDocType : null;
    }
    /**
     * Set InventoryDocType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $inventoryDocType
     * @return \AcumaticaConfig\StructType\SalesOrderShipment
     */
    public function setInventoryDocType(\AcumaticaConfig\StructType\StringValue $inventoryDocType = null)
    {
        if (is_null($inventoryDocType) || (is_array($inventoryDocType) && empty($inventoryDocType))) {
            unset($this->InventoryDocType);
        } else {
            $this->InventoryDocType = $inventoryDocType;
        }
        return $this;
    }
    /**
     * Get InventoryRefNbr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getInventoryRefNbr()
    {
        return isset($this->InventoryRefNbr) ? $this->InventoryRefNbr : null;
    }
    /**
     * Set InventoryRefNbr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $inventoryRefNbr
     * @return \AcumaticaConfig\StructType\SalesOrderShipment
     */
    public function setInventoryRefNbr(\AcumaticaConfig\StructType\StringValue $inventoryRefNbr = null)
    {
        if (is_null($inventoryRefNbr) || (is_array($inventoryRefNbr) && empty($inventoryRefNbr))) {
            unset($this->InventoryRefNbr);
        } else {
            $this->InventoryRefNbr = $inventoryRefNbr;
        }
        return $this;
    }
    /**
     * Get InvoiceNbr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getInvoiceNbr()
    {
        return isset($this->InvoiceNbr) ? $this->InvoiceNbr : null;
    }
    /**
     * Set InvoiceNbr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $invoiceNbr
     * @return \AcumaticaConfig\StructType\SalesOrderShipment
     */
    public function setInvoiceNbr(\AcumaticaConfig\StructType\StringValue $invoiceNbr = null)
    {
        if (is_null($invoiceNbr) || (is_array($invoiceNbr) && empty($invoiceNbr))) {
            unset($this->InvoiceNbr);
        } else {
            $this->InvoiceNbr = $invoiceNbr;
        }
        return $this;
    }
    /**
     * Get InvoiceType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getInvoiceType()
    {
        return isset($this->InvoiceType) ? $this->InvoiceType : null;
    }
    /**
     * Set InvoiceType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $invoiceType
     * @return \AcumaticaConfig\StructType\SalesOrderShipment
     */
    public function setInvoiceType(\AcumaticaConfig\StructType\StringValue $invoiceType = null)
    {
        if (is_null($invoiceType) || (is_array($invoiceType) && empty($invoiceType))) {
            unset($this->InvoiceType);
        } else {
            $this->InvoiceType = $invoiceType;
        }
        return $this;
    }
    /**
     * Get ShipmentDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DateTimeValue|null
     */
    public function getShipmentDate()
    {
        return isset($this->ShipmentDate) ? $this->ShipmentDate : null;
    }
    /**
     * Set ShipmentDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DateTimeValue $shipmentDate
     * @return \AcumaticaConfig\StructType\SalesOrderShipment
     */
    public function setShipmentDate(\AcumaticaConfig\StructType\DateTimeValue $shipmentDate = null)
    {
        if (is_null($shipmentDate) || (is_array($shipmentDate) && empty($shipmentDate))) {
            unset($this->ShipmentDate);
        } else {
            $this->ShipmentDate = $shipmentDate;
        }
        return $this;
    }
    /**
     * Get ShipmentNbr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getShipmentNbr()
    {
        return isset($this->ShipmentNbr) ? $this->ShipmentNbr : null;
    }
    /**
     * Set ShipmentNbr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $shipmentNbr
     * @return \AcumaticaConfig\StructType\SalesOrderShipment
     */
    public function setShipmentNbr(\AcumaticaConfig\StructType\StringValue $shipmentNbr = null)
    {
        if (is_null($shipmentNbr) || (is_array($shipmentNbr) && empty($shipmentNbr))) {
            unset($this->ShipmentNbr);
        } else {
            $this->ShipmentNbr = $shipmentNbr;
        }
        return $this;
    }
    /**
     * Get ShipmentType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getShipmentType()
    {
        return isset($this->ShipmentType) ? $this->ShipmentType : null;
    }
    /**
     * Set ShipmentType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $shipmentType
     * @return \AcumaticaConfig\StructType\SalesOrderShipment
     */
    public function setShipmentType(\AcumaticaConfig\StructType\StringValue $shipmentType = null)
    {
        if (is_null($shipmentType) || (is_array($shipmentType) && empty($shipmentType))) {
            unset($this->ShipmentType);
        } else {
            $this->ShipmentType = $shipmentType;
        }
        return $this;
    }
    /**
     * Get ShippedQty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DecimalValue|null
     */
    public function getShippedQty()
    {
        return isset($this->ShippedQty) ? $this->ShippedQty : null;
    }
    /**
     * Set ShippedQty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DecimalValue $shippedQty
     * @return \AcumaticaConfig\StructType\SalesOrderShipment
     */
    public function setShippedQty(\AcumaticaConfig\StructType\DecimalValue $shippedQty = null)
    {
        if (is_null($shippedQty) || (is_array($shippedQty) && empty($shippedQty))) {
            unset($this->ShippedQty);
        } else {
            $this->ShippedQty = $shippedQty;
        }
        return $this;
    }
    /**
     * Get ShippedVolume value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DecimalValue|null
     */
    public function getShippedVolume()
    {
        return isset($this->ShippedVolume) ? $this->ShippedVolume : null;
    }
    /**
     * Set ShippedVolume value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DecimalValue $shippedVolume
     * @return \AcumaticaConfig\StructType\SalesOrderShipment
     */
    public function setShippedVolume(\AcumaticaConfig\StructType\DecimalValue $shippedVolume = null)
    {
        if (is_null($shippedVolume) || (is_array($shippedVolume) && empty($shippedVolume))) {
            unset($this->ShippedVolume);
        } else {
            $this->ShippedVolume = $shippedVolume;
        }
        return $this;
    }
    /**
     * Get ShippedWeight value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DecimalValue|null
     */
    public function getShippedWeight()
    {
        return isset($this->ShippedWeight) ? $this->ShippedWeight : null;
    }
    /**
     * Set ShippedWeight value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DecimalValue $shippedWeight
     * @return \AcumaticaConfig\StructType\SalesOrderShipment
     */
    public function setShippedWeight(\AcumaticaConfig\StructType\DecimalValue $shippedWeight = null)
    {
        if (is_null($shippedWeight) || (is_array($shippedWeight) && empty($shippedWeight))) {
            unset($this->ShippedWeight);
        } else {
            $this->ShippedWeight = $shippedWeight;
        }
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $status
     * @return \AcumaticaConfig\StructType\SalesOrderShipment
     */
    public function setStatus(\AcumaticaConfig\StructType\StringValue $status = null)
    {
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AcumaticaConfig\StructType\SalesOrderShipment
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
