<?php

namespace AcumaticaConfig\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SalesOrderDetail StructType
 * @subpackage Structs
 */
class SalesOrderDetail extends Entity
{
    /**
     * The Account
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $Account;
    /**
     * The Allocations
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\Allocations
     */
    public $Allocations;
    /**
     * The AlternateID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $AlternateID;
    /**
     * The AutoCreateIssue
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\BooleanValue
     */
    public $AutoCreateIssue;
    /**
     * The AverageCost
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DecimalValue
     */
    public $AverageCost;
    /**
     * The Branch
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $Branch;
    /**
     * The Commissionable
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\BooleanValue
     */
    public $Commissionable;
    /**
     * The Completed
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\BooleanValue
     */
    public $Completed;
    /**
     * The DiscountAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DecimalValue
     */
    public $DiscountAmount;
    /**
     * The DiscountCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $DiscountCode;
    /**
     * The DiscountedUnitPrice
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DecimalValue
     */
    public $DiscountedUnitPrice;
    /**
     * The DiscountPercent
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DecimalValue
     */
    public $DiscountPercent;
    /**
     * The ExtendedPrice
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DecimalValue
     */
    public $ExtendedPrice;
    /**
     * The FreeItem
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\BooleanValue
     */
    public $FreeItem;
    /**
     * The InventoryID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $InventoryID;
    /**
     * The LastModifiedDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $LastModifiedDate;
    /**
     * The LineDescription
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $LineDescription;
    /**
     * The LineNbr
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\IntValue
     */
    public $LineNbr;
    /**
     * The LineType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $LineType;
    /**
     * The Location
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $Location;
    /**
     * The ManualDiscount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\BooleanValue
     */
    public $ManualDiscount;
    /**
     * The MarkForPO
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\BooleanValue
     */
    public $MarkForPO;
    /**
     * The OpenQty
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DecimalValue
     */
    public $OpenQty;
    /**
     * The Operation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $Operation;
    /**
     * The OrderQty
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DecimalValue
     */
    public $OrderQty;
    /**
     * The OvershipThreshold
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DecimalValue
     */
    public $OvershipThreshold;
    /**
     * The POSource
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $POSource;
    /**
     * The ProjectTask
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $ProjectTask;
    /**
     * The PurchasingSettings
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\PurchaseSettings
     */
    public $PurchasingSettings;
    /**
     * The QtyOnShipments
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DecimalValue
     */
    public $QtyOnShipments;
    /**
     * The ReasonCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $ReasonCode;
    /**
     * The RequestedOn
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DateTimeValue
     */
    public $RequestedOn;
    /**
     * The SalespersonID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $SalespersonID;
    /**
     * The ShipOn
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DateTimeValue
     */
    public $ShipOn;
    /**
     * The ShippingRule
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $ShippingRule;
    /**
     * The Subitem
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $Subitem;
    /**
     * The TaxCategory
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $TaxCategory;
    /**
     * The UnbilledAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DecimalValue
     */
    public $UnbilledAmount;
    /**
     * The UndershipThreshold
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DecimalValue
     */
    public $UndershipThreshold;
    /**
     * The UnitCost
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DecimalValue
     */
    public $UnitCost;
    /**
     * The UnitPrice
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DecimalValue
     */
    public $UnitPrice;
    /**
     * The UOM
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $UOM;
    /**
     * The WarehouseID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $WarehouseID;
    /**
     * Constructor method for SalesOrderDetail
     * @uses SalesOrderDetail::setAccount()
     * @uses SalesOrderDetail::setAllocations()
     * @uses SalesOrderDetail::setAlternateID()
     * @uses SalesOrderDetail::setAutoCreateIssue()
     * @uses SalesOrderDetail::setAverageCost()
     * @uses SalesOrderDetail::setBranch()
     * @uses SalesOrderDetail::setCommissionable()
     * @uses SalesOrderDetail::setCompleted()
     * @uses SalesOrderDetail::setDiscountAmount()
     * @uses SalesOrderDetail::setDiscountCode()
     * @uses SalesOrderDetail::setDiscountedUnitPrice()
     * @uses SalesOrderDetail::setDiscountPercent()
     * @uses SalesOrderDetail::setExtendedPrice()
     * @uses SalesOrderDetail::setFreeItem()
     * @uses SalesOrderDetail::setInventoryID()
     * @uses SalesOrderDetail::setLastModifiedDate()
     * @uses SalesOrderDetail::setLineDescription()
     * @uses SalesOrderDetail::setLineNbr()
     * @uses SalesOrderDetail::setLineType()
     * @uses SalesOrderDetail::setLocation()
     * @uses SalesOrderDetail::setManualDiscount()
     * @uses SalesOrderDetail::setMarkForPO()
     * @uses SalesOrderDetail::setOpenQty()
     * @uses SalesOrderDetail::setOperation()
     * @uses SalesOrderDetail::setOrderQty()
     * @uses SalesOrderDetail::setOvershipThreshold()
     * @uses SalesOrderDetail::setPOSource()
     * @uses SalesOrderDetail::setProjectTask()
     * @uses SalesOrderDetail::setPurchasingSettings()
     * @uses SalesOrderDetail::setQtyOnShipments()
     * @uses SalesOrderDetail::setReasonCode()
     * @uses SalesOrderDetail::setRequestedOn()
     * @uses SalesOrderDetail::setSalespersonID()
     * @uses SalesOrderDetail::setShipOn()
     * @uses SalesOrderDetail::setShippingRule()
     * @uses SalesOrderDetail::setSubitem()
     * @uses SalesOrderDetail::setTaxCategory()
     * @uses SalesOrderDetail::setUnbilledAmount()
     * @uses SalesOrderDetail::setUndershipThreshold()
     * @uses SalesOrderDetail::setUnitCost()
     * @uses SalesOrderDetail::setUnitPrice()
     * @uses SalesOrderDetail::setUOM()
     * @uses SalesOrderDetail::setWarehouseID()
     * @param \AcumaticaConfig\StructType\StringValue $account
     * @param \AcumaticaConfig\StructType\Allocations $allocations
     * @param \AcumaticaConfig\StructType\StringValue $alternateID
     * @param \AcumaticaConfig\StructType\BooleanValue $autoCreateIssue
     * @param \AcumaticaConfig\StructType\DecimalValue $averageCost
     * @param \AcumaticaConfig\StructType\StringValue $branch
     * @param \AcumaticaConfig\StructType\BooleanValue $commissionable
     * @param \AcumaticaConfig\StructType\BooleanValue $completed
     * @param \AcumaticaConfig\StructType\DecimalValue $discountAmount
     * @param \AcumaticaConfig\StructType\StringValue $discountCode
     * @param \AcumaticaConfig\StructType\DecimalValue $discountedUnitPrice
     * @param \AcumaticaConfig\StructType\DecimalValue $discountPercent
     * @param \AcumaticaConfig\StructType\DecimalValue $extendedPrice
     * @param \AcumaticaConfig\StructType\BooleanValue $freeItem
     * @param \AcumaticaConfig\StructType\StringValue $inventoryID
     * @param \AcumaticaConfig\StructType\StringValue $lastModifiedDate
     * @param \AcumaticaConfig\StructType\StringValue $lineDescription
     * @param \AcumaticaConfig\StructType\IntValue $lineNbr
     * @param \AcumaticaConfig\StructType\StringValue $lineType
     * @param \AcumaticaConfig\StructType\StringValue $location
     * @param \AcumaticaConfig\StructType\BooleanValue $manualDiscount
     * @param \AcumaticaConfig\StructType\BooleanValue $markForPO
     * @param \AcumaticaConfig\StructType\DecimalValue $openQty
     * @param \AcumaticaConfig\StructType\StringValue $operation
     * @param \AcumaticaConfig\StructType\DecimalValue $orderQty
     * @param \AcumaticaConfig\StructType\DecimalValue $overshipThreshold
     * @param \AcumaticaConfig\StructType\StringValue $pOSource
     * @param \AcumaticaConfig\StructType\StringValue $projectTask
     * @param \AcumaticaConfig\StructType\PurchaseSettings $purchasingSettings
     * @param \AcumaticaConfig\StructType\DecimalValue $qtyOnShipments
     * @param \AcumaticaConfig\StructType\StringValue $reasonCode
     * @param \AcumaticaConfig\StructType\DateTimeValue $requestedOn
     * @param \AcumaticaConfig\StructType\StringValue $salespersonID
     * @param \AcumaticaConfig\StructType\DateTimeValue $shipOn
     * @param \AcumaticaConfig\StructType\StringValue $shippingRule
     * @param \AcumaticaConfig\StructType\StringValue $subitem
     * @param \AcumaticaConfig\StructType\StringValue $taxCategory
     * @param \AcumaticaConfig\StructType\DecimalValue $unbilledAmount
     * @param \AcumaticaConfig\StructType\DecimalValue $undershipThreshold
     * @param \AcumaticaConfig\StructType\DecimalValue $unitCost
     * @param \AcumaticaConfig\StructType\DecimalValue $unitPrice
     * @param \AcumaticaConfig\StructType\StringValue $uOM
     * @param \AcumaticaConfig\StructType\StringValue $warehouseID
     */
    public function __construct(\AcumaticaConfig\StructType\StringValue $account = null, \AcumaticaConfig\StructType\Allocations $allocations = null, \AcumaticaConfig\StructType\StringValue $alternateID = null, \AcumaticaConfig\StructType\BooleanValue $autoCreateIssue = null, \AcumaticaConfig\StructType\DecimalValue $averageCost = null, \AcumaticaConfig\StructType\StringValue $branch = null, \AcumaticaConfig\StructType\BooleanValue $commissionable = null, \AcumaticaConfig\StructType\BooleanValue $completed = null, \AcumaticaConfig\StructType\DecimalValue $discountAmount = null, \AcumaticaConfig\StructType\StringValue $discountCode = null, \AcumaticaConfig\StructType\DecimalValue $discountedUnitPrice = null, \AcumaticaConfig\StructType\DecimalValue $discountPercent = null, \AcumaticaConfig\StructType\DecimalValue $extendedPrice = null, \AcumaticaConfig\StructType\BooleanValue $freeItem = null, \AcumaticaConfig\StructType\StringValue $inventoryID = null, \AcumaticaConfig\StructType\StringValue $lastModifiedDate = null, \AcumaticaConfig\StructType\StringValue $lineDescription = null, \AcumaticaConfig\StructType\IntValue $lineNbr = null, \AcumaticaConfig\StructType\StringValue $lineType = null, \AcumaticaConfig\StructType\StringValue $location = null, \AcumaticaConfig\StructType\BooleanValue $manualDiscount = null, \AcumaticaConfig\StructType\BooleanValue $markForPO = null, \AcumaticaConfig\StructType\DecimalValue $openQty = null, \AcumaticaConfig\StructType\StringValue $operation = null, \AcumaticaConfig\StructType\DecimalValue $orderQty = null, \AcumaticaConfig\StructType\DecimalValue $overshipThreshold = null, \AcumaticaConfig\StructType\StringValue $pOSource = null, \AcumaticaConfig\StructType\StringValue $projectTask = null, \AcumaticaConfig\StructType\PurchaseSettings $purchasingSettings = null, \AcumaticaConfig\StructType\DecimalValue $qtyOnShipments = null, \AcumaticaConfig\StructType\StringValue $reasonCode = null, \AcumaticaConfig\StructType\DateTimeValue $requestedOn = null, \AcumaticaConfig\StructType\StringValue $salespersonID = null, \AcumaticaConfig\StructType\DateTimeValue $shipOn = null, \AcumaticaConfig\StructType\StringValue $shippingRule = null, \AcumaticaConfig\StructType\StringValue $subitem = null, \AcumaticaConfig\StructType\StringValue $taxCategory = null, \AcumaticaConfig\StructType\DecimalValue $unbilledAmount = null, \AcumaticaConfig\StructType\DecimalValue $undershipThreshold = null, \AcumaticaConfig\StructType\DecimalValue $unitCost = null, \AcumaticaConfig\StructType\DecimalValue $unitPrice = null, \AcumaticaConfig\StructType\StringValue $uOM = null, \AcumaticaConfig\StructType\StringValue $warehouseID = null)
    {
        $this
            ->setAccount($account)
            ->setAllocations($allocations)
            ->setAlternateID($alternateID)
            ->setAutoCreateIssue($autoCreateIssue)
            ->setAverageCost($averageCost)
            ->setBranch($branch)
            ->setCommissionable($commissionable)
            ->setCompleted($completed)
            ->setDiscountAmount($discountAmount)
            ->setDiscountCode($discountCode)
            ->setDiscountedUnitPrice($discountedUnitPrice)
            ->setDiscountPercent($discountPercent)
            ->setExtendedPrice($extendedPrice)
            ->setFreeItem($freeItem)
            ->setInventoryID($inventoryID)
            ->setLastModifiedDate($lastModifiedDate)
            ->setLineDescription($lineDescription)
            ->setLineNbr($lineNbr)
            ->setLineType($lineType)
            ->setLocation($location)
            ->setManualDiscount($manualDiscount)
            ->setMarkForPO($markForPO)
            ->setOpenQty($openQty)
            ->setOperation($operation)
            ->setOrderQty($orderQty)
            ->setOvershipThreshold($overshipThreshold)
            ->setPOSource($pOSource)
            ->setProjectTask($projectTask)
            ->setPurchasingSettings($purchasingSettings)
            ->setQtyOnShipments($qtyOnShipments)
            ->setReasonCode($reasonCode)
            ->setRequestedOn($requestedOn)
            ->setSalespersonID($salespersonID)
            ->setShipOn($shipOn)
            ->setShippingRule($shippingRule)
            ->setSubitem($subitem)
            ->setTaxCategory($taxCategory)
            ->setUnbilledAmount($unbilledAmount)
            ->setUndershipThreshold($undershipThreshold)
            ->setUnitCost($unitCost)
            ->setUnitPrice($unitPrice)
            ->setUOM($uOM)
            ->setWarehouseID($warehouseID);
    }
    /**
     * Get Account value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getAccount()
    {
        return isset($this->Account) ? $this->Account : null;
    }
    /**
     * Set Account value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $account
     * @return \AcumaticaConfig\StructType\SalesOrderDetail
     */
    public function setAccount(\AcumaticaConfig\StructType\StringValue $account = null)
    {
        if (is_null($account) || (is_array($account) && empty($account))) {
            unset($this->Account);
        } else {
            $this->Account = $account;
        }
        return $this;
    }
    /**
     * Get Allocations value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\Allocations|null
     */
    public function getAllocations()
    {
        return isset($this->Allocations) ? $this->Allocations : null;
    }
    /**
     * Set Allocations value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\Allocations $allocations
     * @return \AcumaticaConfig\StructType\SalesOrderDetail
     */
    public function setAllocations(\AcumaticaConfig\StructType\Allocations $allocations = null)
    {
        if (is_null($allocations) || (is_array($allocations) && empty($allocations))) {
            unset($this->Allocations);
        } else {
            $this->Allocations = $allocations;
        }
        return $this;
    }
    /**
     * Get AlternateID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getAlternateID()
    {
        return isset($this->AlternateID) ? $this->AlternateID : null;
    }
    /**
     * Set AlternateID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $alternateID
     * @return \AcumaticaConfig\StructType\SalesOrderDetail
     */
    public function setAlternateID(\AcumaticaConfig\StructType\StringValue $alternateID = null)
    {
        if (is_null($alternateID) || (is_array($alternateID) && empty($alternateID))) {
            unset($this->AlternateID);
        } else {
            $this->AlternateID = $alternateID;
        }
        return $this;
    }
    /**
     * Get AutoCreateIssue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\BooleanValue|null
     */
    public function getAutoCreateIssue()
    {
        return isset($this->AutoCreateIssue) ? $this->AutoCreateIssue : null;
    }
    /**
     * Set AutoCreateIssue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\BooleanValue $autoCreateIssue
     * @return \AcumaticaConfig\StructType\SalesOrderDetail
     */
    public function setAutoCreateIssue(\AcumaticaConfig\StructType\BooleanValue $autoCreateIssue = null)
    {
        if (is_null($autoCreateIssue) || (is_array($autoCreateIssue) && empty($autoCreateIssue))) {
            unset($this->AutoCreateIssue);
        } else {
            $this->AutoCreateIssue = $autoCreateIssue;
        }
        return $this;
    }
    /**
     * Get AverageCost value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DecimalValue|null
     */
    public function getAverageCost()
    {
        return isset($this->AverageCost) ? $this->AverageCost : null;
    }
    /**
     * Set AverageCost value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DecimalValue $averageCost
     * @return \AcumaticaConfig\StructType\SalesOrderDetail
     */
    public function setAverageCost(\AcumaticaConfig\StructType\DecimalValue $averageCost = null)
    {
        if (is_null($averageCost) || (is_array($averageCost) && empty($averageCost))) {
            unset($this->AverageCost);
        } else {
            $this->AverageCost = $averageCost;
        }
        return $this;
    }
    /**
     * Get Branch value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getBranch()
    {
        return isset($this->Branch) ? $this->Branch : null;
    }
    /**
     * Set Branch value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $branch
     * @return \AcumaticaConfig\StructType\SalesOrderDetail
     */
    public function setBranch(\AcumaticaConfig\StructType\StringValue $branch = null)
    {
        if (is_null($branch) || (is_array($branch) && empty($branch))) {
            unset($this->Branch);
        } else {
            $this->Branch = $branch;
        }
        return $this;
    }
    /**
     * Get Commissionable value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\BooleanValue|null
     */
    public function getCommissionable()
    {
        return isset($this->Commissionable) ? $this->Commissionable : null;
    }
    /**
     * Set Commissionable value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\BooleanValue $commissionable
     * @return \AcumaticaConfig\StructType\SalesOrderDetail
     */
    public function setCommissionable(\AcumaticaConfig\StructType\BooleanValue $commissionable = null)
    {
        if (is_null($commissionable) || (is_array($commissionable) && empty($commissionable))) {
            unset($this->Commissionable);
        } else {
            $this->Commissionable = $commissionable;
        }
        return $this;
    }
    /**
     * Get Completed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\BooleanValue|null
     */
    public function getCompleted()
    {
        return isset($this->Completed) ? $this->Completed : null;
    }
    /**
     * Set Completed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\BooleanValue $completed
     * @return \AcumaticaConfig\StructType\SalesOrderDetail
     */
    public function setCompleted(\AcumaticaConfig\StructType\BooleanValue $completed = null)
    {
        if (is_null($completed) || (is_array($completed) && empty($completed))) {
            unset($this->Completed);
        } else {
            $this->Completed = $completed;
        }
        return $this;
    }
    /**
     * Get DiscountAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DecimalValue|null
     */
    public function getDiscountAmount()
    {
        return isset($this->DiscountAmount) ? $this->DiscountAmount : null;
    }
    /**
     * Set DiscountAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DecimalValue $discountAmount
     * @return \AcumaticaConfig\StructType\SalesOrderDetail
     */
    public function setDiscountAmount(\AcumaticaConfig\StructType\DecimalValue $discountAmount = null)
    {
        if (is_null($discountAmount) || (is_array($discountAmount) && empty($discountAmount))) {
            unset($this->DiscountAmount);
        } else {
            $this->DiscountAmount = $discountAmount;
        }
        return $this;
    }
    /**
     * Get DiscountCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getDiscountCode()
    {
        return isset($this->DiscountCode) ? $this->DiscountCode : null;
    }
    /**
     * Set DiscountCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $discountCode
     * @return \AcumaticaConfig\StructType\SalesOrderDetail
     */
    public function setDiscountCode(\AcumaticaConfig\StructType\StringValue $discountCode = null)
    {
        if (is_null($discountCode) || (is_array($discountCode) && empty($discountCode))) {
            unset($this->DiscountCode);
        } else {
            $this->DiscountCode = $discountCode;
        }
        return $this;
    }
    /**
     * Get DiscountedUnitPrice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DecimalValue|null
     */
    public function getDiscountedUnitPrice()
    {
        return isset($this->DiscountedUnitPrice) ? $this->DiscountedUnitPrice : null;
    }
    /**
     * Set DiscountedUnitPrice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DecimalValue $discountedUnitPrice
     * @return \AcumaticaConfig\StructType\SalesOrderDetail
     */
    public function setDiscountedUnitPrice(\AcumaticaConfig\StructType\DecimalValue $discountedUnitPrice = null)
    {
        if (is_null($discountedUnitPrice) || (is_array($discountedUnitPrice) && empty($discountedUnitPrice))) {
            unset($this->DiscountedUnitPrice);
        } else {
            $this->DiscountedUnitPrice = $discountedUnitPrice;
        }
        return $this;
    }
    /**
     * Get DiscountPercent value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DecimalValue|null
     */
    public function getDiscountPercent()
    {
        return isset($this->DiscountPercent) ? $this->DiscountPercent : null;
    }
    /**
     * Set DiscountPercent value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DecimalValue $discountPercent
     * @return \AcumaticaConfig\StructType\SalesOrderDetail
     */
    public function setDiscountPercent(\AcumaticaConfig\StructType\DecimalValue $discountPercent = null)
    {
        if (is_null($discountPercent) || (is_array($discountPercent) && empty($discountPercent))) {
            unset($this->DiscountPercent);
        } else {
            $this->DiscountPercent = $discountPercent;
        }
        return $this;
    }
    /**
     * Get ExtendedPrice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DecimalValue|null
     */
    public function getExtendedPrice()
    {
        return isset($this->ExtendedPrice) ? $this->ExtendedPrice : null;
    }
    /**
     * Set ExtendedPrice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DecimalValue $extendedPrice
     * @return \AcumaticaConfig\StructType\SalesOrderDetail
     */
    public function setExtendedPrice(\AcumaticaConfig\StructType\DecimalValue $extendedPrice = null)
    {
        if (is_null($extendedPrice) || (is_array($extendedPrice) && empty($extendedPrice))) {
            unset($this->ExtendedPrice);
        } else {
            $this->ExtendedPrice = $extendedPrice;
        }
        return $this;
    }
    /**
     * Get FreeItem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\BooleanValue|null
     */
    public function getFreeItem()
    {
        return isset($this->FreeItem) ? $this->FreeItem : null;
    }
    /**
     * Set FreeItem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\BooleanValue $freeItem
     * @return \AcumaticaConfig\StructType\SalesOrderDetail
     */
    public function setFreeItem(\AcumaticaConfig\StructType\BooleanValue $freeItem = null)
    {
        if (is_null($freeItem) || (is_array($freeItem) && empty($freeItem))) {
            unset($this->FreeItem);
        } else {
            $this->FreeItem = $freeItem;
        }
        return $this;
    }
    /**
     * Get InventoryID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getInventoryID()
    {
        return isset($this->InventoryID) ? $this->InventoryID : null;
    }
    /**
     * Set InventoryID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $inventoryID
     * @return \AcumaticaConfig\StructType\SalesOrderDetail
     */
    public function setInventoryID(\AcumaticaConfig\StructType\StringValue $inventoryID = null)
    {
        if (is_null($inventoryID) || (is_array($inventoryID) && empty($inventoryID))) {
            unset($this->InventoryID);
        } else {
            $this->InventoryID = $inventoryID;
        }
        return $this;
    }
    /**
     * Get LastModifiedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getLastModifiedDate()
    {
        return isset($this->LastModifiedDate) ? $this->LastModifiedDate : null;
    }
    /**
     * Set LastModifiedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $lastModifiedDate
     * @return \AcumaticaConfig\StructType\SalesOrderDetail
     */
    public function setLastModifiedDate(\AcumaticaConfig\StructType\StringValue $lastModifiedDate = null)
    {
        if (is_null($lastModifiedDate) || (is_array($lastModifiedDate) && empty($lastModifiedDate))) {
            unset($this->LastModifiedDate);
        } else {
            $this->LastModifiedDate = $lastModifiedDate;
        }
        return $this;
    }
    /**
     * Get LineDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getLineDescription()
    {
        return isset($this->LineDescription) ? $this->LineDescription : null;
    }
    /**
     * Set LineDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $lineDescription
     * @return \AcumaticaConfig\StructType\SalesOrderDetail
     */
    public function setLineDescription(\AcumaticaConfig\StructType\StringValue $lineDescription = null)
    {
        if (is_null($lineDescription) || (is_array($lineDescription) && empty($lineDescription))) {
            unset($this->LineDescription);
        } else {
            $this->LineDescription = $lineDescription;
        }
        return $this;
    }
    /**
     * Get LineNbr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\IntValue|null
     */
    public function getLineNbr()
    {
        return isset($this->LineNbr) ? $this->LineNbr : null;
    }
    /**
     * Set LineNbr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\IntValue $lineNbr
     * @return \AcumaticaConfig\StructType\SalesOrderDetail
     */
    public function setLineNbr(\AcumaticaConfig\StructType\IntValue $lineNbr = null)
    {
        if (is_null($lineNbr) || (is_array($lineNbr) && empty($lineNbr))) {
            unset($this->LineNbr);
        } else {
            $this->LineNbr = $lineNbr;
        }
        return $this;
    }
    /**
     * Get LineType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getLineType()
    {
        return isset($this->LineType) ? $this->LineType : null;
    }
    /**
     * Set LineType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $lineType
     * @return \AcumaticaConfig\StructType\SalesOrderDetail
     */
    public function setLineType(\AcumaticaConfig\StructType\StringValue $lineType = null)
    {
        if (is_null($lineType) || (is_array($lineType) && empty($lineType))) {
            unset($this->LineType);
        } else {
            $this->LineType = $lineType;
        }
        return $this;
    }
    /**
     * Get Location value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getLocation()
    {
        return isset($this->Location) ? $this->Location : null;
    }
    /**
     * Set Location value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $location
     * @return \AcumaticaConfig\StructType\SalesOrderDetail
     */
    public function setLocation(\AcumaticaConfig\StructType\StringValue $location = null)
    {
        if (is_null($location) || (is_array($location) && empty($location))) {
            unset($this->Location);
        } else {
            $this->Location = $location;
        }
        return $this;
    }
    /**
     * Get ManualDiscount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\BooleanValue|null
     */
    public function getManualDiscount()
    {
        return isset($this->ManualDiscount) ? $this->ManualDiscount : null;
    }
    /**
     * Set ManualDiscount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\BooleanValue $manualDiscount
     * @return \AcumaticaConfig\StructType\SalesOrderDetail
     */
    public function setManualDiscount(\AcumaticaConfig\StructType\BooleanValue $manualDiscount = null)
    {
        if (is_null($manualDiscount) || (is_array($manualDiscount) && empty($manualDiscount))) {
            unset($this->ManualDiscount);
        } else {
            $this->ManualDiscount = $manualDiscount;
        }
        return $this;
    }
    /**
     * Get MarkForPO value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\BooleanValue|null
     */
    public function getMarkForPO()
    {
        return isset($this->MarkForPO) ? $this->MarkForPO : null;
    }
    /**
     * Set MarkForPO value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\BooleanValue $markForPO
     * @return \AcumaticaConfig\StructType\SalesOrderDetail
     */
    public function setMarkForPO(\AcumaticaConfig\StructType\BooleanValue $markForPO = null)
    {
        if (is_null($markForPO) || (is_array($markForPO) && empty($markForPO))) {
            unset($this->MarkForPO);
        } else {
            $this->MarkForPO = $markForPO;
        }
        return $this;
    }
    /**
     * Get OpenQty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DecimalValue|null
     */
    public function getOpenQty()
    {
        return isset($this->OpenQty) ? $this->OpenQty : null;
    }
    /**
     * Set OpenQty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DecimalValue $openQty
     * @return \AcumaticaConfig\StructType\SalesOrderDetail
     */
    public function setOpenQty(\AcumaticaConfig\StructType\DecimalValue $openQty = null)
    {
        if (is_null($openQty) || (is_array($openQty) && empty($openQty))) {
            unset($this->OpenQty);
        } else {
            $this->OpenQty = $openQty;
        }
        return $this;
    }
    /**
     * Get Operation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getOperation()
    {
        return isset($this->Operation) ? $this->Operation : null;
    }
    /**
     * Set Operation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $operation
     * @return \AcumaticaConfig\StructType\SalesOrderDetail
     */
    public function setOperation(\AcumaticaConfig\StructType\StringValue $operation = null)
    {
        if (is_null($operation) || (is_array($operation) && empty($operation))) {
            unset($this->Operation);
        } else {
            $this->Operation = $operation;
        }
        return $this;
    }
    /**
     * Get OrderQty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DecimalValue|null
     */
    public function getOrderQty()
    {
        return isset($this->OrderQty) ? $this->OrderQty : null;
    }
    /**
     * Set OrderQty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DecimalValue $orderQty
     * @return \AcumaticaConfig\StructType\SalesOrderDetail
     */
    public function setOrderQty(\AcumaticaConfig\StructType\DecimalValue $orderQty = null)
    {
        if (is_null($orderQty) || (is_array($orderQty) && empty($orderQty))) {
            unset($this->OrderQty);
        } else {
            $this->OrderQty = $orderQty;
        }
        return $this;
    }
    /**
     * Get OvershipThreshold value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DecimalValue|null
     */
    public function getOvershipThreshold()
    {
        return isset($this->OvershipThreshold) ? $this->OvershipThreshold : null;
    }
    /**
     * Set OvershipThreshold value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DecimalValue $overshipThreshold
     * @return \AcumaticaConfig\StructType\SalesOrderDetail
     */
    public function setOvershipThreshold(\AcumaticaConfig\StructType\DecimalValue $overshipThreshold = null)
    {
        if (is_null($overshipThreshold) || (is_array($overshipThreshold) && empty($overshipThreshold))) {
            unset($this->OvershipThreshold);
        } else {
            $this->OvershipThreshold = $overshipThreshold;
        }
        return $this;
    }
    /**
     * Get POSource value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getPOSource()
    {
        return isset($this->POSource) ? $this->POSource : null;
    }
    /**
     * Set POSource value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $pOSource
     * @return \AcumaticaConfig\StructType\SalesOrderDetail
     */
    public function setPOSource(\AcumaticaConfig\StructType\StringValue $pOSource = null)
    {
        if (is_null($pOSource) || (is_array($pOSource) && empty($pOSource))) {
            unset($this->POSource);
        } else {
            $this->POSource = $pOSource;
        }
        return $this;
    }
    /**
     * Get ProjectTask value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getProjectTask()
    {
        return isset($this->ProjectTask) ? $this->ProjectTask : null;
    }
    /**
     * Set ProjectTask value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $projectTask
     * @return \AcumaticaConfig\StructType\SalesOrderDetail
     */
    public function setProjectTask(\AcumaticaConfig\StructType\StringValue $projectTask = null)
    {
        if (is_null($projectTask) || (is_array($projectTask) && empty($projectTask))) {
            unset($this->ProjectTask);
        } else {
            $this->ProjectTask = $projectTask;
        }
        return $this;
    }
    /**
     * Get PurchasingSettings value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\PurchaseSettings|null
     */
    public function getPurchasingSettings()
    {
        return isset($this->PurchasingSettings) ? $this->PurchasingSettings : null;
    }
    /**
     * Set PurchasingSettings value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\PurchaseSettings $purchasingSettings
     * @return \AcumaticaConfig\StructType\SalesOrderDetail
     */
    public function setPurchasingSettings(\AcumaticaConfig\StructType\PurchaseSettings $purchasingSettings = null)
    {
        if (is_null($purchasingSettings) || (is_array($purchasingSettings) && empty($purchasingSettings))) {
            unset($this->PurchasingSettings);
        } else {
            $this->PurchasingSettings = $purchasingSettings;
        }
        return $this;
    }
    /**
     * Get QtyOnShipments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DecimalValue|null
     */
    public function getQtyOnShipments()
    {
        return isset($this->QtyOnShipments) ? $this->QtyOnShipments : null;
    }
    /**
     * Set QtyOnShipments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DecimalValue $qtyOnShipments
     * @return \AcumaticaConfig\StructType\SalesOrderDetail
     */
    public function setQtyOnShipments(\AcumaticaConfig\StructType\DecimalValue $qtyOnShipments = null)
    {
        if (is_null($qtyOnShipments) || (is_array($qtyOnShipments) && empty($qtyOnShipments))) {
            unset($this->QtyOnShipments);
        } else {
            $this->QtyOnShipments = $qtyOnShipments;
        }
        return $this;
    }
    /**
     * Get ReasonCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getReasonCode()
    {
        return isset($this->ReasonCode) ? $this->ReasonCode : null;
    }
    /**
     * Set ReasonCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $reasonCode
     * @return \AcumaticaConfig\StructType\SalesOrderDetail
     */
    public function setReasonCode(\AcumaticaConfig\StructType\StringValue $reasonCode = null)
    {
        if (is_null($reasonCode) || (is_array($reasonCode) && empty($reasonCode))) {
            unset($this->ReasonCode);
        } else {
            $this->ReasonCode = $reasonCode;
        }
        return $this;
    }
    /**
     * Get RequestedOn value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DateTimeValue|null
     */
    public function getRequestedOn()
    {
        return isset($this->RequestedOn) ? $this->RequestedOn : null;
    }
    /**
     * Set RequestedOn value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DateTimeValue $requestedOn
     * @return \AcumaticaConfig\StructType\SalesOrderDetail
     */
    public function setRequestedOn(\AcumaticaConfig\StructType\DateTimeValue $requestedOn = null)
    {
        if (is_null($requestedOn) || (is_array($requestedOn) && empty($requestedOn))) {
            unset($this->RequestedOn);
        } else {
            $this->RequestedOn = $requestedOn;
        }
        return $this;
    }
    /**
     * Get SalespersonID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getSalespersonID()
    {
        return isset($this->SalespersonID) ? $this->SalespersonID : null;
    }
    /**
     * Set SalespersonID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $salespersonID
     * @return \AcumaticaConfig\StructType\SalesOrderDetail
     */
    public function setSalespersonID(\AcumaticaConfig\StructType\StringValue $salespersonID = null)
    {
        if (is_null($salespersonID) || (is_array($salespersonID) && empty($salespersonID))) {
            unset($this->SalespersonID);
        } else {
            $this->SalespersonID = $salespersonID;
        }
        return $this;
    }
    /**
     * Get ShipOn value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DateTimeValue|null
     */
    public function getShipOn()
    {
        return isset($this->ShipOn) ? $this->ShipOn : null;
    }
    /**
     * Set ShipOn value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DateTimeValue $shipOn
     * @return \AcumaticaConfig\StructType\SalesOrderDetail
     */
    public function setShipOn(\AcumaticaConfig\StructType\DateTimeValue $shipOn = null)
    {
        if (is_null($shipOn) || (is_array($shipOn) && empty($shipOn))) {
            unset($this->ShipOn);
        } else {
            $this->ShipOn = $shipOn;
        }
        return $this;
    }
    /**
     * Get ShippingRule value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getShippingRule()
    {
        return isset($this->ShippingRule) ? $this->ShippingRule : null;
    }
    /**
     * Set ShippingRule value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $shippingRule
     * @return \AcumaticaConfig\StructType\SalesOrderDetail
     */
    public function setShippingRule(\AcumaticaConfig\StructType\StringValue $shippingRule = null)
    {
        if (is_null($shippingRule) || (is_array($shippingRule) && empty($shippingRule))) {
            unset($this->ShippingRule);
        } else {
            $this->ShippingRule = $shippingRule;
        }
        return $this;
    }
    /**
     * Get Subitem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getSubitem()
    {
        return isset($this->Subitem) ? $this->Subitem : null;
    }
    /**
     * Set Subitem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $subitem
     * @return \AcumaticaConfig\StructType\SalesOrderDetail
     */
    public function setSubitem(\AcumaticaConfig\StructType\StringValue $subitem = null)
    {
        if (is_null($subitem) || (is_array($subitem) && empty($subitem))) {
            unset($this->Subitem);
        } else {
            $this->Subitem = $subitem;
        }
        return $this;
    }
    /**
     * Get TaxCategory value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getTaxCategory()
    {
        return isset($this->TaxCategory) ? $this->TaxCategory : null;
    }
    /**
     * Set TaxCategory value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $taxCategory
     * @return \AcumaticaConfig\StructType\SalesOrderDetail
     */
    public function setTaxCategory(\AcumaticaConfig\StructType\StringValue $taxCategory = null)
    {
        if (is_null($taxCategory) || (is_array($taxCategory) && empty($taxCategory))) {
            unset($this->TaxCategory);
        } else {
            $this->TaxCategory = $taxCategory;
        }
        return $this;
    }
    /**
     * Get UnbilledAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DecimalValue|null
     */
    public function getUnbilledAmount()
    {
        return isset($this->UnbilledAmount) ? $this->UnbilledAmount : null;
    }
    /**
     * Set UnbilledAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DecimalValue $unbilledAmount
     * @return \AcumaticaConfig\StructType\SalesOrderDetail
     */
    public function setUnbilledAmount(\AcumaticaConfig\StructType\DecimalValue $unbilledAmount = null)
    {
        if (is_null($unbilledAmount) || (is_array($unbilledAmount) && empty($unbilledAmount))) {
            unset($this->UnbilledAmount);
        } else {
            $this->UnbilledAmount = $unbilledAmount;
        }
        return $this;
    }
    /**
     * Get UndershipThreshold value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DecimalValue|null
     */
    public function getUndershipThreshold()
    {
        return isset($this->UndershipThreshold) ? $this->UndershipThreshold : null;
    }
    /**
     * Set UndershipThreshold value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DecimalValue $undershipThreshold
     * @return \AcumaticaConfig\StructType\SalesOrderDetail
     */
    public function setUndershipThreshold(\AcumaticaConfig\StructType\DecimalValue $undershipThreshold = null)
    {
        if (is_null($undershipThreshold) || (is_array($undershipThreshold) && empty($undershipThreshold))) {
            unset($this->UndershipThreshold);
        } else {
            $this->UndershipThreshold = $undershipThreshold;
        }
        return $this;
    }
    /**
     * Get UnitCost value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DecimalValue|null
     */
    public function getUnitCost()
    {
        return isset($this->UnitCost) ? $this->UnitCost : null;
    }
    /**
     * Set UnitCost value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DecimalValue $unitCost
     * @return \AcumaticaConfig\StructType\SalesOrderDetail
     */
    public function setUnitCost(\AcumaticaConfig\StructType\DecimalValue $unitCost = null)
    {
        if (is_null($unitCost) || (is_array($unitCost) && empty($unitCost))) {
            unset($this->UnitCost);
        } else {
            $this->UnitCost = $unitCost;
        }
        return $this;
    }
    /**
     * Get UnitPrice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DecimalValue|null
     */
    public function getUnitPrice()
    {
        return isset($this->UnitPrice) ? $this->UnitPrice : null;
    }
    /**
     * Set UnitPrice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DecimalValue $unitPrice
     * @return \AcumaticaConfig\StructType\SalesOrderDetail
     */
    public function setUnitPrice(\AcumaticaConfig\StructType\DecimalValue $unitPrice = null)
    {
        if (is_null($unitPrice) || (is_array($unitPrice) && empty($unitPrice))) {
            unset($this->UnitPrice);
        } else {
            $this->UnitPrice = $unitPrice;
        }
        return $this;
    }
    /**
     * Get UOM value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getUOM()
    {
        return isset($this->UOM) ? $this->UOM : null;
    }
    /**
     * Set UOM value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $uOM
     * @return \AcumaticaConfig\StructType\SalesOrderDetail
     */
    public function setUOM(\AcumaticaConfig\StructType\StringValue $uOM = null)
    {
        if (is_null($uOM) || (is_array($uOM) && empty($uOM))) {
            unset($this->UOM);
        } else {
            $this->UOM = $uOM;
        }
        return $this;
    }
    /**
     * Get WarehouseID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getWarehouseID()
    {
        return isset($this->WarehouseID) ? $this->WarehouseID : null;
    }
    /**
     * Set WarehouseID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $warehouseID
     * @return \AcumaticaConfig\StructType\SalesOrderDetail
     */
    public function setWarehouseID(\AcumaticaConfig\StructType\StringValue $warehouseID = null)
    {
        if (is_null($warehouseID) || (is_array($warehouseID) && empty($warehouseID))) {
            unset($this->WarehouseID);
        } else {
            $this->WarehouseID = $warehouseID;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AcumaticaConfig\StructType\SalesOrderDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
