<?php

namespace AcumaticaConfig\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SalesInvoiceDetail StructType
 * @subpackage Structs
 */
class SalesInvoiceDetail extends Entity
{
    /**
     * The Amount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DecimalValue
     */
    public $Amount;
    /**
     * The BranchID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $BranchID;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $Description;
    /**
     * The InventoryID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $InventoryID;
    /**
     * The LineNbr
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\IntValue
     */
    public $LineNbr;
    /**
     * The OrderNbr
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $OrderNbr;
    /**
     * The OrderType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $OrderType;
    /**
     * The Qty
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DecimalValue
     */
    public $Qty;
    /**
     * The ShipmentNbr
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $ShipmentNbr;
    /**
     * The UnitPrice
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DecimalValue
     */
    public $UnitPrice;
    /**
     * The UOM
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $UOM;
    /**
     * Constructor method for SalesInvoiceDetail
     * @uses SalesInvoiceDetail::setAmount()
     * @uses SalesInvoiceDetail::setBranchID()
     * @uses SalesInvoiceDetail::setDescription()
     * @uses SalesInvoiceDetail::setInventoryID()
     * @uses SalesInvoiceDetail::setLineNbr()
     * @uses SalesInvoiceDetail::setOrderNbr()
     * @uses SalesInvoiceDetail::setOrderType()
     * @uses SalesInvoiceDetail::setQty()
     * @uses SalesInvoiceDetail::setShipmentNbr()
     * @uses SalesInvoiceDetail::setUnitPrice()
     * @uses SalesInvoiceDetail::setUOM()
     * @param \AcumaticaConfig\StructType\DecimalValue $amount
     * @param \AcumaticaConfig\StructType\StringValue $branchID
     * @param \AcumaticaConfig\StructType\StringValue $description
     * @param \AcumaticaConfig\StructType\StringValue $inventoryID
     * @param \AcumaticaConfig\StructType\IntValue $lineNbr
     * @param \AcumaticaConfig\StructType\StringValue $orderNbr
     * @param \AcumaticaConfig\StructType\StringValue $orderType
     * @param \AcumaticaConfig\StructType\DecimalValue $qty
     * @param \AcumaticaConfig\StructType\StringValue $shipmentNbr
     * @param \AcumaticaConfig\StructType\DecimalValue $unitPrice
     * @param \AcumaticaConfig\StructType\StringValue $uOM
     */
    public function __construct(\AcumaticaConfig\StructType\DecimalValue $amount = null, \AcumaticaConfig\StructType\StringValue $branchID = null, \AcumaticaConfig\StructType\StringValue $description = null, \AcumaticaConfig\StructType\StringValue $inventoryID = null, \AcumaticaConfig\StructType\IntValue $lineNbr = null, \AcumaticaConfig\StructType\StringValue $orderNbr = null, \AcumaticaConfig\StructType\StringValue $orderType = null, \AcumaticaConfig\StructType\DecimalValue $qty = null, \AcumaticaConfig\StructType\StringValue $shipmentNbr = null, \AcumaticaConfig\StructType\DecimalValue $unitPrice = null, \AcumaticaConfig\StructType\StringValue $uOM = null)
    {
        $this
            ->setAmount($amount)
            ->setBranchID($branchID)
            ->setDescription($description)
            ->setInventoryID($inventoryID)
            ->setLineNbr($lineNbr)
            ->setOrderNbr($orderNbr)
            ->setOrderType($orderType)
            ->setQty($qty)
            ->setShipmentNbr($shipmentNbr)
            ->setUnitPrice($unitPrice)
            ->setUOM($uOM);
    }
    /**
     * Get Amount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DecimalValue|null
     */
    public function getAmount()
    {
        return isset($this->Amount) ? $this->Amount : null;
    }
    /**
     * Set Amount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DecimalValue $amount
     * @return \AcumaticaConfig\StructType\SalesInvoiceDetail
     */
    public function setAmount(\AcumaticaConfig\StructType\DecimalValue $amount = null)
    {
        if (is_null($amount) || (is_array($amount) && empty($amount))) {
            unset($this->Amount);
        } else {
            $this->Amount = $amount;
        }
        return $this;
    }
    /**
     * Get BranchID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getBranchID()
    {
        return isset($this->BranchID) ? $this->BranchID : null;
    }
    /**
     * Set BranchID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $branchID
     * @return \AcumaticaConfig\StructType\SalesInvoiceDetail
     */
    public function setBranchID(\AcumaticaConfig\StructType\StringValue $branchID = null)
    {
        if (is_null($branchID) || (is_array($branchID) && empty($branchID))) {
            unset($this->BranchID);
        } else {
            $this->BranchID = $branchID;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $description
     * @return \AcumaticaConfig\StructType\SalesInvoiceDetail
     */
    public function setDescription(\AcumaticaConfig\StructType\StringValue $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get InventoryID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getInventoryID()
    {
        return isset($this->InventoryID) ? $this->InventoryID : null;
    }
    /**
     * Set InventoryID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $inventoryID
     * @return \AcumaticaConfig\StructType\SalesInvoiceDetail
     */
    public function setInventoryID(\AcumaticaConfig\StructType\StringValue $inventoryID = null)
    {
        if (is_null($inventoryID) || (is_array($inventoryID) && empty($inventoryID))) {
            unset($this->InventoryID);
        } else {
            $this->InventoryID = $inventoryID;
        }
        return $this;
    }
    /**
     * Get LineNbr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\IntValue|null
     */
    public function getLineNbr()
    {
        return isset($this->LineNbr) ? $this->LineNbr : null;
    }
    /**
     * Set LineNbr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\IntValue $lineNbr
     * @return \AcumaticaConfig\StructType\SalesInvoiceDetail
     */
    public function setLineNbr(\AcumaticaConfig\StructType\IntValue $lineNbr = null)
    {
        if (is_null($lineNbr) || (is_array($lineNbr) && empty($lineNbr))) {
            unset($this->LineNbr);
        } else {
            $this->LineNbr = $lineNbr;
        }
        return $this;
    }
    /**
     * Get OrderNbr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getOrderNbr()
    {
        return isset($this->OrderNbr) ? $this->OrderNbr : null;
    }
    /**
     * Set OrderNbr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $orderNbr
     * @return \AcumaticaConfig\StructType\SalesInvoiceDetail
     */
    public function setOrderNbr(\AcumaticaConfig\StructType\StringValue $orderNbr = null)
    {
        if (is_null($orderNbr) || (is_array($orderNbr) && empty($orderNbr))) {
            unset($this->OrderNbr);
        } else {
            $this->OrderNbr = $orderNbr;
        }
        return $this;
    }
    /**
     * Get OrderType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getOrderType()
    {
        return isset($this->OrderType) ? $this->OrderType : null;
    }
    /**
     * Set OrderType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $orderType
     * @return \AcumaticaConfig\StructType\SalesInvoiceDetail
     */
    public function setOrderType(\AcumaticaConfig\StructType\StringValue $orderType = null)
    {
        if (is_null($orderType) || (is_array($orderType) && empty($orderType))) {
            unset($this->OrderType);
        } else {
            $this->OrderType = $orderType;
        }
        return $this;
    }
    /**
     * Get Qty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DecimalValue|null
     */
    public function getQty()
    {
        return isset($this->Qty) ? $this->Qty : null;
    }
    /**
     * Set Qty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DecimalValue $qty
     * @return \AcumaticaConfig\StructType\SalesInvoiceDetail
     */
    public function setQty(\AcumaticaConfig\StructType\DecimalValue $qty = null)
    {
        if (is_null($qty) || (is_array($qty) && empty($qty))) {
            unset($this->Qty);
        } else {
            $this->Qty = $qty;
        }
        return $this;
    }
    /**
     * Get ShipmentNbr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getShipmentNbr()
    {
        return isset($this->ShipmentNbr) ? $this->ShipmentNbr : null;
    }
    /**
     * Set ShipmentNbr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $shipmentNbr
     * @return \AcumaticaConfig\StructType\SalesInvoiceDetail
     */
    public function setShipmentNbr(\AcumaticaConfig\StructType\StringValue $shipmentNbr = null)
    {
        if (is_null($shipmentNbr) || (is_array($shipmentNbr) && empty($shipmentNbr))) {
            unset($this->ShipmentNbr);
        } else {
            $this->ShipmentNbr = $shipmentNbr;
        }
        return $this;
    }
    /**
     * Get UnitPrice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DecimalValue|null
     */
    public function getUnitPrice()
    {
        return isset($this->UnitPrice) ? $this->UnitPrice : null;
    }
    /**
     * Set UnitPrice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DecimalValue $unitPrice
     * @return \AcumaticaConfig\StructType\SalesInvoiceDetail
     */
    public function setUnitPrice(\AcumaticaConfig\StructType\DecimalValue $unitPrice = null)
    {
        if (is_null($unitPrice) || (is_array($unitPrice) && empty($unitPrice))) {
            unset($this->UnitPrice);
        } else {
            $this->UnitPrice = $unitPrice;
        }
        return $this;
    }
    /**
     * Get UOM value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getUOM()
    {
        return isset($this->UOM) ? $this->UOM : null;
    }
    /**
     * Set UOM value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $uOM
     * @return \AcumaticaConfig\StructType\SalesInvoiceDetail
     */
    public function setUOM(\AcumaticaConfig\StructType\StringValue $uOM = null)
    {
        if (is_null($uOM) || (is_array($uOM) && empty($uOM))) {
            unset($this->UOM);
        } else {
            $this->UOM = $uOM;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AcumaticaConfig\StructType\SalesInvoiceDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
