<?php

namespace AcumaticaConfig\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Results StructType
 * @subpackage Structs
 */
class Results extends Entity
{
    /**
     * The Results
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\Results[]
     */
    public $Results;
    /**
     * The InventoryAllocationRow
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\InventoryAllocationRow[]
     */
    public $InventoryAllocationRow;
    /**
     * The AccountBySubaccountRow
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\AccountBySubaccountRow[]
     */
    public $AccountBySubaccountRow;
    /**
     * The AccountSummaryRow
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\AccountSummaryRow[]
     */
    public $AccountSummaryRow;
    /**
     * The InventoryIDINSiteStatus_InventoryID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $InventoryIDINSiteStatus_InventoryID;
    /**
     * The InventoryIDInventoryItem_inventoryCD
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $InventoryIDInventoryItem_inventoryCD;
    /**
     * The LineNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\IntValue
     */
    public $LineNumber;
    /**
     * The QtyAvailable
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DecimalValue
     */
    public $QtyAvailable;
    /**
     * The QtyOnHand
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DecimalValue
     */
    public $QtyOnHand;
    /**
     * The ReferenceNbr
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $ReferenceNbr;
    /**
     * The Selected
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\BooleanValue
     */
    public $Selected;
    /**
     * The Warehouse
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $Warehouse;
    /**
     * The WarehouseID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $WarehouseID;
    /**
     * The AccountByPeriodRow
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\AccountByPeriodRow[]
     */
    public $AccountByPeriodRow;
    /**
     * The AccountDetailsRow
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\AccountDetailsRow[]
     */
    public $AccountDetailsRow;
    /**
     * The InventorySummaryRow
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\InventorySummaryRow[]
     */
    public $InventorySummaryRow;
    /**
     * Constructor method for Results
     * @uses Results::setResults()
     * @uses Results::setInventoryAllocationRow()
     * @uses Results::setAccountBySubaccountRow()
     * @uses Results::setAccountSummaryRow()
     * @uses Results::setInventoryIDINSiteStatus_InventoryID()
     * @uses Results::setInventoryIDInventoryItem_inventoryCD()
     * @uses Results::setLineNumber()
     * @uses Results::setQtyAvailable()
     * @uses Results::setQtyOnHand()
     * @uses Results::setReferenceNbr()
     * @uses Results::setSelected()
     * @uses Results::setWarehouse()
     * @uses Results::setWarehouseID()
     * @uses Results::setAccountByPeriodRow()
     * @uses Results::setAccountDetailsRow()
     * @uses Results::setInventorySummaryRow()
     * @param \AcumaticaConfig\StructType\Results[] $results
     * @param \AcumaticaConfig\StructType\InventoryAllocationRow[] $inventoryAllocationRow
     * @param \AcumaticaConfig\StructType\AccountBySubaccountRow[] $accountBySubaccountRow
     * @param \AcumaticaConfig\StructType\AccountSummaryRow[] $accountSummaryRow
     * @param \AcumaticaConfig\StructType\StringValue $inventoryIDINSiteStatus_InventoryID
     * @param \AcumaticaConfig\StructType\StringValue $inventoryIDInventoryItem_inventoryCD
     * @param \AcumaticaConfig\StructType\IntValue $lineNumber
     * @param \AcumaticaConfig\StructType\DecimalValue $qtyAvailable
     * @param \AcumaticaConfig\StructType\DecimalValue $qtyOnHand
     * @param \AcumaticaConfig\StructType\StringValue $referenceNbr
     * @param \AcumaticaConfig\StructType\BooleanValue $selected
     * @param \AcumaticaConfig\StructType\StringValue $warehouse
     * @param \AcumaticaConfig\StructType\StringValue $warehouseID
     * @param \AcumaticaConfig\StructType\AccountByPeriodRow[] $accountByPeriodRow
     * @param \AcumaticaConfig\StructType\AccountDetailsRow[] $accountDetailsRow
     * @param \AcumaticaConfig\StructType\InventorySummaryRow[] $inventorySummaryRow
     */
    public function __construct(array $results = array(), array $inventoryAllocationRow = array(), array $accountBySubaccountRow = array(), array $accountSummaryRow = array(), \AcumaticaConfig\StructType\StringValue $inventoryIDINSiteStatus_InventoryID = null, \AcumaticaConfig\StructType\StringValue $inventoryIDInventoryItem_inventoryCD = null, \AcumaticaConfig\StructType\IntValue $lineNumber = null, \AcumaticaConfig\StructType\DecimalValue $qtyAvailable = null, \AcumaticaConfig\StructType\DecimalValue $qtyOnHand = null, \AcumaticaConfig\StructType\StringValue $referenceNbr = null, \AcumaticaConfig\StructType\BooleanValue $selected = null, \AcumaticaConfig\StructType\StringValue $warehouse = null, \AcumaticaConfig\StructType\StringValue $warehouseID = null, array $accountByPeriodRow = array(), array $accountDetailsRow = array(), array $inventorySummaryRow = array())
    {
        $this
            ->setResults($results)
            ->setInventoryAllocationRow($inventoryAllocationRow)
            ->setAccountBySubaccountRow($accountBySubaccountRow)
            ->setAccountSummaryRow($accountSummaryRow)
            ->setInventoryIDINSiteStatus_InventoryID($inventoryIDINSiteStatus_InventoryID)
            ->setInventoryIDInventoryItem_inventoryCD($inventoryIDInventoryItem_inventoryCD)
            ->setLineNumber($lineNumber)
            ->setQtyAvailable($qtyAvailable)
            ->setQtyOnHand($qtyOnHand)
            ->setReferenceNbr($referenceNbr)
            ->setSelected($selected)
            ->setWarehouse($warehouse)
            ->setWarehouseID($warehouseID)
            ->setAccountByPeriodRow($accountByPeriodRow)
            ->setAccountDetailsRow($accountDetailsRow)
            ->setInventorySummaryRow($inventorySummaryRow);
    }
    /**
     * Get Results value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\Results[]|null
     */
    public function getResults()
    {
        return isset($this->Results) ? $this->Results : null;
    }
    /**
     * Set Results value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\Results[] $results
     * @return \AcumaticaConfig\StructType\Results
     */
    public function setResults(array $results = array())
    {
        foreach ($results as $resultsResultsItem) {
            // validation for constraint: itemType
            if (!$resultsResultsItem instanceof \AcumaticaConfig\StructType\Results) {
                throw new \InvalidArgumentException(sprintf('The Results property can only contain items of \AcumaticaConfig\StructType\Results, "%s" given', is_object($resultsResultsItem) ? get_class($resultsResultsItem) : gettype($resultsResultsItem)), __LINE__);
            }
        }
        if (is_null($results) || (is_array($results) && empty($results))) {
            unset($this->Results);
        } else {
            $this->Results = $results;
        }
        return $this;
    }
    /**
     * Add item to Results value
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\Results $item
     * @return \AcumaticaConfig\StructType\Results
     */
    public function addToResults(\AcumaticaConfig\StructType\Results $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AcumaticaConfig\StructType\Results) {
            throw new \InvalidArgumentException(sprintf('The Results property can only contain items of \AcumaticaConfig\StructType\Results, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Results[] = $item;
        return $this;
    }
    /**
     * Get InventoryAllocationRow value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\InventoryAllocationRow[]|null
     */
    public function getInventoryAllocationRow()
    {
        return isset($this->InventoryAllocationRow) ? $this->InventoryAllocationRow : null;
    }
    /**
     * Set InventoryAllocationRow value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\InventoryAllocationRow[] $inventoryAllocationRow
     * @return \AcumaticaConfig\StructType\Results
     */
    public function setInventoryAllocationRow(array $inventoryAllocationRow = array())
    {
        foreach ($inventoryAllocationRow as $resultsInventoryAllocationRowItem) {
            // validation for constraint: itemType
            if (!$resultsInventoryAllocationRowItem instanceof \AcumaticaConfig\StructType\InventoryAllocationRow) {
                throw new \InvalidArgumentException(sprintf('The InventoryAllocationRow property can only contain items of \AcumaticaConfig\StructType\InventoryAllocationRow, "%s" given', is_object($resultsInventoryAllocationRowItem) ? get_class($resultsInventoryAllocationRowItem) : gettype($resultsInventoryAllocationRowItem)), __LINE__);
            }
        }
        if (is_null($inventoryAllocationRow) || (is_array($inventoryAllocationRow) && empty($inventoryAllocationRow))) {
            unset($this->InventoryAllocationRow);
        } else {
            $this->InventoryAllocationRow = $inventoryAllocationRow;
        }
        return $this;
    }
    /**
     * Add item to InventoryAllocationRow value
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\InventoryAllocationRow $item
     * @return \AcumaticaConfig\StructType\Results
     */
    public function addToInventoryAllocationRow(\AcumaticaConfig\StructType\InventoryAllocationRow $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AcumaticaConfig\StructType\InventoryAllocationRow) {
            throw new \InvalidArgumentException(sprintf('The InventoryAllocationRow property can only contain items of \AcumaticaConfig\StructType\InventoryAllocationRow, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->InventoryAllocationRow[] = $item;
        return $this;
    }
    /**
     * Get AccountBySubaccountRow value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\AccountBySubaccountRow[]|null
     */
    public function getAccountBySubaccountRow()
    {
        return isset($this->AccountBySubaccountRow) ? $this->AccountBySubaccountRow : null;
    }
    /**
     * Set AccountBySubaccountRow value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\AccountBySubaccountRow[] $accountBySubaccountRow
     * @return \AcumaticaConfig\StructType\Results
     */
    public function setAccountBySubaccountRow(array $accountBySubaccountRow = array())
    {
        foreach ($accountBySubaccountRow as $resultsAccountBySubaccountRowItem) {
            // validation for constraint: itemType
            if (!$resultsAccountBySubaccountRowItem instanceof \AcumaticaConfig\StructType\AccountBySubaccountRow) {
                throw new \InvalidArgumentException(sprintf('The AccountBySubaccountRow property can only contain items of \AcumaticaConfig\StructType\AccountBySubaccountRow, "%s" given', is_object($resultsAccountBySubaccountRowItem) ? get_class($resultsAccountBySubaccountRowItem) : gettype($resultsAccountBySubaccountRowItem)), __LINE__);
            }
        }
        if (is_null($accountBySubaccountRow) || (is_array($accountBySubaccountRow) && empty($accountBySubaccountRow))) {
            unset($this->AccountBySubaccountRow);
        } else {
            $this->AccountBySubaccountRow = $accountBySubaccountRow;
        }
        return $this;
    }
    /**
     * Add item to AccountBySubaccountRow value
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\AccountBySubaccountRow $item
     * @return \AcumaticaConfig\StructType\Results
     */
    public function addToAccountBySubaccountRow(\AcumaticaConfig\StructType\AccountBySubaccountRow $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AcumaticaConfig\StructType\AccountBySubaccountRow) {
            throw new \InvalidArgumentException(sprintf('The AccountBySubaccountRow property can only contain items of \AcumaticaConfig\StructType\AccountBySubaccountRow, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->AccountBySubaccountRow[] = $item;
        return $this;
    }
    /**
     * Get AccountSummaryRow value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\AccountSummaryRow[]|null
     */
    public function getAccountSummaryRow()
    {
        return isset($this->AccountSummaryRow) ? $this->AccountSummaryRow : null;
    }
    /**
     * Set AccountSummaryRow value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\AccountSummaryRow[] $accountSummaryRow
     * @return \AcumaticaConfig\StructType\Results
     */
    public function setAccountSummaryRow(array $accountSummaryRow = array())
    {
        foreach ($accountSummaryRow as $resultsAccountSummaryRowItem) {
            // validation for constraint: itemType
            if (!$resultsAccountSummaryRowItem instanceof \AcumaticaConfig\StructType\AccountSummaryRow) {
                throw new \InvalidArgumentException(sprintf('The AccountSummaryRow property can only contain items of \AcumaticaConfig\StructType\AccountSummaryRow, "%s" given', is_object($resultsAccountSummaryRowItem) ? get_class($resultsAccountSummaryRowItem) : gettype($resultsAccountSummaryRowItem)), __LINE__);
            }
        }
        if (is_null($accountSummaryRow) || (is_array($accountSummaryRow) && empty($accountSummaryRow))) {
            unset($this->AccountSummaryRow);
        } else {
            $this->AccountSummaryRow = $accountSummaryRow;
        }
        return $this;
    }
    /**
     * Add item to AccountSummaryRow value
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\AccountSummaryRow $item
     * @return \AcumaticaConfig\StructType\Results
     */
    public function addToAccountSummaryRow(\AcumaticaConfig\StructType\AccountSummaryRow $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AcumaticaConfig\StructType\AccountSummaryRow) {
            throw new \InvalidArgumentException(sprintf('The AccountSummaryRow property can only contain items of \AcumaticaConfig\StructType\AccountSummaryRow, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->AccountSummaryRow[] = $item;
        return $this;
    }
    /**
     * Get InventoryIDINSiteStatus_InventoryID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getInventoryIDINSiteStatus_InventoryID()
    {
        return isset($this->InventoryIDINSiteStatus_InventoryID) ? $this->InventoryIDINSiteStatus_InventoryID : null;
    }
    /**
     * Set InventoryIDINSiteStatus_InventoryID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $inventoryIDINSiteStatus_InventoryID
     * @return \AcumaticaConfig\StructType\Results
     */
    public function setInventoryIDINSiteStatus_InventoryID(\AcumaticaConfig\StructType\StringValue $inventoryIDINSiteStatus_InventoryID = null)
    {
        if (is_null($inventoryIDINSiteStatus_InventoryID) || (is_array($inventoryIDINSiteStatus_InventoryID) && empty($inventoryIDINSiteStatus_InventoryID))) {
            unset($this->InventoryIDINSiteStatus_InventoryID);
        } else {
            $this->InventoryIDINSiteStatus_InventoryID = $inventoryIDINSiteStatus_InventoryID;
        }
        return $this;
    }
    /**
     * Get InventoryIDInventoryItem_inventoryCD value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getInventoryIDInventoryItem_inventoryCD()
    {
        return isset($this->InventoryIDInventoryItem_inventoryCD) ? $this->InventoryIDInventoryItem_inventoryCD : null;
    }
    /**
     * Set InventoryIDInventoryItem_inventoryCD value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $inventoryIDInventoryItem_inventoryCD
     * @return \AcumaticaConfig\StructType\Results
     */
    public function setInventoryIDInventoryItem_inventoryCD(\AcumaticaConfig\StructType\StringValue $inventoryIDInventoryItem_inventoryCD = null)
    {
        if (is_null($inventoryIDInventoryItem_inventoryCD) || (is_array($inventoryIDInventoryItem_inventoryCD) && empty($inventoryIDInventoryItem_inventoryCD))) {
            unset($this->InventoryIDInventoryItem_inventoryCD);
        } else {
            $this->InventoryIDInventoryItem_inventoryCD = $inventoryIDInventoryItem_inventoryCD;
        }
        return $this;
    }
    /**
     * Get LineNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\IntValue|null
     */
    public function getLineNumber()
    {
        return isset($this->LineNumber) ? $this->LineNumber : null;
    }
    /**
     * Set LineNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\IntValue $lineNumber
     * @return \AcumaticaConfig\StructType\Results
     */
    public function setLineNumber(\AcumaticaConfig\StructType\IntValue $lineNumber = null)
    {
        if (is_null($lineNumber) || (is_array($lineNumber) && empty($lineNumber))) {
            unset($this->LineNumber);
        } else {
            $this->LineNumber = $lineNumber;
        }
        return $this;
    }
    /**
     * Get QtyAvailable value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DecimalValue|null
     */
    public function getQtyAvailable()
    {
        return isset($this->QtyAvailable) ? $this->QtyAvailable : null;
    }
    /**
     * Set QtyAvailable value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DecimalValue $qtyAvailable
     * @return \AcumaticaConfig\StructType\Results
     */
    public function setQtyAvailable(\AcumaticaConfig\StructType\DecimalValue $qtyAvailable = null)
    {
        if (is_null($qtyAvailable) || (is_array($qtyAvailable) && empty($qtyAvailable))) {
            unset($this->QtyAvailable);
        } else {
            $this->QtyAvailable = $qtyAvailable;
        }
        return $this;
    }
    /**
     * Get QtyOnHand value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DecimalValue|null
     */
    public function getQtyOnHand()
    {
        return isset($this->QtyOnHand) ? $this->QtyOnHand : null;
    }
    /**
     * Set QtyOnHand value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DecimalValue $qtyOnHand
     * @return \AcumaticaConfig\StructType\Results
     */
    public function setQtyOnHand(\AcumaticaConfig\StructType\DecimalValue $qtyOnHand = null)
    {
        if (is_null($qtyOnHand) || (is_array($qtyOnHand) && empty($qtyOnHand))) {
            unset($this->QtyOnHand);
        } else {
            $this->QtyOnHand = $qtyOnHand;
        }
        return $this;
    }
    /**
     * Get ReferenceNbr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getReferenceNbr()
    {
        return isset($this->ReferenceNbr) ? $this->ReferenceNbr : null;
    }
    /**
     * Set ReferenceNbr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $referenceNbr
     * @return \AcumaticaConfig\StructType\Results
     */
    public function setReferenceNbr(\AcumaticaConfig\StructType\StringValue $referenceNbr = null)
    {
        if (is_null($referenceNbr) || (is_array($referenceNbr) && empty($referenceNbr))) {
            unset($this->ReferenceNbr);
        } else {
            $this->ReferenceNbr = $referenceNbr;
        }
        return $this;
    }
    /**
     * Get Selected value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\BooleanValue|null
     */
    public function getSelected()
    {
        return isset($this->Selected) ? $this->Selected : null;
    }
    /**
     * Set Selected value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\BooleanValue $selected
     * @return \AcumaticaConfig\StructType\Results
     */
    public function setSelected(\AcumaticaConfig\StructType\BooleanValue $selected = null)
    {
        if (is_null($selected) || (is_array($selected) && empty($selected))) {
            unset($this->Selected);
        } else {
            $this->Selected = $selected;
        }
        return $this;
    }
    /**
     * Get Warehouse value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getWarehouse()
    {
        return isset($this->Warehouse) ? $this->Warehouse : null;
    }
    /**
     * Set Warehouse value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $warehouse
     * @return \AcumaticaConfig\StructType\Results
     */
    public function setWarehouse(\AcumaticaConfig\StructType\StringValue $warehouse = null)
    {
        if (is_null($warehouse) || (is_array($warehouse) && empty($warehouse))) {
            unset($this->Warehouse);
        } else {
            $this->Warehouse = $warehouse;
        }
        return $this;
    }
    /**
     * Get WarehouseID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getWarehouseID()
    {
        return isset($this->WarehouseID) ? $this->WarehouseID : null;
    }
    /**
     * Set WarehouseID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $warehouseID
     * @return \AcumaticaConfig\StructType\Results
     */
    public function setWarehouseID(\AcumaticaConfig\StructType\StringValue $warehouseID = null)
    {
        if (is_null($warehouseID) || (is_array($warehouseID) && empty($warehouseID))) {
            unset($this->WarehouseID);
        } else {
            $this->WarehouseID = $warehouseID;
        }
        return $this;
    }
    /**
     * Get AccountByPeriodRow value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\AccountByPeriodRow[]|null
     */
    public function getAccountByPeriodRow()
    {
        return isset($this->AccountByPeriodRow) ? $this->AccountByPeriodRow : null;
    }
    /**
     * Set AccountByPeriodRow value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\AccountByPeriodRow[] $accountByPeriodRow
     * @return \AcumaticaConfig\StructType\Results
     */
    public function setAccountByPeriodRow(array $accountByPeriodRow = array())
    {
        foreach ($accountByPeriodRow as $resultsAccountByPeriodRowItem) {
            // validation for constraint: itemType
            if (!$resultsAccountByPeriodRowItem instanceof \AcumaticaConfig\StructType\AccountByPeriodRow) {
                throw new \InvalidArgumentException(sprintf('The AccountByPeriodRow property can only contain items of \AcumaticaConfig\StructType\AccountByPeriodRow, "%s" given', is_object($resultsAccountByPeriodRowItem) ? get_class($resultsAccountByPeriodRowItem) : gettype($resultsAccountByPeriodRowItem)), __LINE__);
            }
        }
        if (is_null($accountByPeriodRow) || (is_array($accountByPeriodRow) && empty($accountByPeriodRow))) {
            unset($this->AccountByPeriodRow);
        } else {
            $this->AccountByPeriodRow = $accountByPeriodRow;
        }
        return $this;
    }
    /**
     * Add item to AccountByPeriodRow value
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\AccountByPeriodRow $item
     * @return \AcumaticaConfig\StructType\Results
     */
    public function addToAccountByPeriodRow(\AcumaticaConfig\StructType\AccountByPeriodRow $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AcumaticaConfig\StructType\AccountByPeriodRow) {
            throw new \InvalidArgumentException(sprintf('The AccountByPeriodRow property can only contain items of \AcumaticaConfig\StructType\AccountByPeriodRow, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->AccountByPeriodRow[] = $item;
        return $this;
    }
    /**
     * Get AccountDetailsRow value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\AccountDetailsRow[]|null
     */
    public function getAccountDetailsRow()
    {
        return isset($this->AccountDetailsRow) ? $this->AccountDetailsRow : null;
    }
    /**
     * Set AccountDetailsRow value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\AccountDetailsRow[] $accountDetailsRow
     * @return \AcumaticaConfig\StructType\Results
     */
    public function setAccountDetailsRow(array $accountDetailsRow = array())
    {
        foreach ($accountDetailsRow as $resultsAccountDetailsRowItem) {
            // validation for constraint: itemType
            if (!$resultsAccountDetailsRowItem instanceof \AcumaticaConfig\StructType\AccountDetailsRow) {
                throw new \InvalidArgumentException(sprintf('The AccountDetailsRow property can only contain items of \AcumaticaConfig\StructType\AccountDetailsRow, "%s" given', is_object($resultsAccountDetailsRowItem) ? get_class($resultsAccountDetailsRowItem) : gettype($resultsAccountDetailsRowItem)), __LINE__);
            }
        }
        if (is_null($accountDetailsRow) || (is_array($accountDetailsRow) && empty($accountDetailsRow))) {
            unset($this->AccountDetailsRow);
        } else {
            $this->AccountDetailsRow = $accountDetailsRow;
        }
        return $this;
    }
    /**
     * Add item to AccountDetailsRow value
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\AccountDetailsRow $item
     * @return \AcumaticaConfig\StructType\Results
     */
    public function addToAccountDetailsRow(\AcumaticaConfig\StructType\AccountDetailsRow $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AcumaticaConfig\StructType\AccountDetailsRow) {
            throw new \InvalidArgumentException(sprintf('The AccountDetailsRow property can only contain items of \AcumaticaConfig\StructType\AccountDetailsRow, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->AccountDetailsRow[] = $item;
        return $this;
    }
    /**
     * Get InventorySummaryRow value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\InventorySummaryRow[]|null
     */
    public function getInventorySummaryRow()
    {
        return isset($this->InventorySummaryRow) ? $this->InventorySummaryRow : null;
    }
    /**
     * Set InventorySummaryRow value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\InventorySummaryRow[] $inventorySummaryRow
     * @return \AcumaticaConfig\StructType\Results
     */
    public function setInventorySummaryRow(array $inventorySummaryRow = array())
    {
        foreach ($inventorySummaryRow as $resultsInventorySummaryRowItem) {
            // validation for constraint: itemType
            if (!$resultsInventorySummaryRowItem instanceof \AcumaticaConfig\StructType\InventorySummaryRow) {
                throw new \InvalidArgumentException(sprintf('The InventorySummaryRow property can only contain items of \AcumaticaConfig\StructType\InventorySummaryRow, "%s" given', is_object($resultsInventorySummaryRowItem) ? get_class($resultsInventorySummaryRowItem) : gettype($resultsInventorySummaryRowItem)), __LINE__);
            }
        }
        if (is_null($inventorySummaryRow) || (is_array($inventorySummaryRow) && empty($inventorySummaryRow))) {
            unset($this->InventorySummaryRow);
        } else {
            $this->InventorySummaryRow = $inventorySummaryRow;
        }
        return $this;
    }
    /**
     * Add item to InventorySummaryRow value
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\InventorySummaryRow $item
     * @return \AcumaticaConfig\StructType\Results
     */
    public function addToInventorySummaryRow(\AcumaticaConfig\StructType\InventorySummaryRow $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AcumaticaConfig\StructType\InventorySummaryRow) {
            throw new \InvalidArgumentException(sprintf('The InventorySummaryRow property can only contain items of \AcumaticaConfig\StructType\InventorySummaryRow, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->InventorySummaryRow[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AcumaticaConfig\StructType\Results
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
