<?php

namespace AcumaticaConfig\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Relations StructType
 * @subpackage Structs
 */
class Relations extends AbstractStructBase
{
    /**
     * The RelationDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\RelationDetail[]
     */
    public $RelationDetail;
    /**
     * Constructor method for Relations
     * @uses Relations::setRelationDetail()
     * @param \AcumaticaConfig\StructType\RelationDetail[] $relationDetail
     */
    public function __construct(array $relationDetail = array())
    {
        $this
            ->setRelationDetail($relationDetail);
    }
    /**
     * Get RelationDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\RelationDetail[]|null
     */
    public function getRelationDetail()
    {
        return isset($this->RelationDetail) ? $this->RelationDetail : null;
    }
    /**
     * Set RelationDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\RelationDetail[] $relationDetail
     * @return \AcumaticaConfig\StructType\Relations
     */
    public function setRelationDetail(array $relationDetail = array())
    {
        foreach ($relationDetail as $relationsRelationDetailItem) {
            // validation for constraint: itemType
            if (!$relationsRelationDetailItem instanceof \AcumaticaConfig\StructType\RelationDetail) {
                throw new \InvalidArgumentException(sprintf('The RelationDetail property can only contain items of \AcumaticaConfig\StructType\RelationDetail, "%s" given', is_object($relationsRelationDetailItem) ? get_class($relationsRelationDetailItem) : gettype($relationsRelationDetailItem)), __LINE__);
            }
        }
        if (is_null($relationDetail) || (is_array($relationDetail) && empty($relationDetail))) {
            unset($this->RelationDetail);
        } else {
            $this->RelationDetail = $relationDetail;
        }
        return $this;
    }
    /**
     * Add item to RelationDetail value
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\RelationDetail $item
     * @return \AcumaticaConfig\StructType\Relations
     */
    public function addToRelationDetail(\AcumaticaConfig\StructType\RelationDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AcumaticaConfig\StructType\RelationDetail) {
            throw new \InvalidArgumentException(sprintf('The RelationDetail property can only contain items of \AcumaticaConfig\StructType\RelationDetail, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->RelationDetail[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AcumaticaConfig\StructType\Relations
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
