<?php

namespace AcumaticaConfig\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RelatedActivities StructType
 * @subpackage Structs
 */
class RelatedActivities extends AbstractStructBase
{
    /**
     * The EventRelatedActivity
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\EventRelatedActivity[]
     */
    public $EventRelatedActivity;
    /**
     * The TaskRelatedActivity
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\TaskRelatedActivity[]
     */
    public $TaskRelatedActivity;
    /**
     * Constructor method for RelatedActivities
     * @uses RelatedActivities::setEventRelatedActivity()
     * @uses RelatedActivities::setTaskRelatedActivity()
     * @param \AcumaticaConfig\StructType\EventRelatedActivity[] $eventRelatedActivity
     * @param \AcumaticaConfig\StructType\TaskRelatedActivity[] $taskRelatedActivity
     */
    public function __construct(array $eventRelatedActivity = array(), array $taskRelatedActivity = array())
    {
        $this
            ->setEventRelatedActivity($eventRelatedActivity)
            ->setTaskRelatedActivity($taskRelatedActivity);
    }
    /**
     * Get EventRelatedActivity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\EventRelatedActivity[]|null
     */
    public function getEventRelatedActivity()
    {
        return isset($this->EventRelatedActivity) ? $this->EventRelatedActivity : null;
    }
    /**
     * Set EventRelatedActivity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\EventRelatedActivity[] $eventRelatedActivity
     * @return \AcumaticaConfig\StructType\RelatedActivities
     */
    public function setEventRelatedActivity(array $eventRelatedActivity = array())
    {
        foreach ($eventRelatedActivity as $relatedActivitiesEventRelatedActivityItem) {
            // validation for constraint: itemType
            if (!$relatedActivitiesEventRelatedActivityItem instanceof \AcumaticaConfig\StructType\EventRelatedActivity) {
                throw new \InvalidArgumentException(sprintf('The EventRelatedActivity property can only contain items of \AcumaticaConfig\StructType\EventRelatedActivity, "%s" given', is_object($relatedActivitiesEventRelatedActivityItem) ? get_class($relatedActivitiesEventRelatedActivityItem) : gettype($relatedActivitiesEventRelatedActivityItem)), __LINE__);
            }
        }
        if (is_null($eventRelatedActivity) || (is_array($eventRelatedActivity) && empty($eventRelatedActivity))) {
            unset($this->EventRelatedActivity);
        } else {
            $this->EventRelatedActivity = $eventRelatedActivity;
        }
        return $this;
    }
    /**
     * Add item to EventRelatedActivity value
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\EventRelatedActivity $item
     * @return \AcumaticaConfig\StructType\RelatedActivities
     */
    public function addToEventRelatedActivity(\AcumaticaConfig\StructType\EventRelatedActivity $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AcumaticaConfig\StructType\EventRelatedActivity) {
            throw new \InvalidArgumentException(sprintf('The EventRelatedActivity property can only contain items of \AcumaticaConfig\StructType\EventRelatedActivity, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->EventRelatedActivity[] = $item;
        return $this;
    }
    /**
     * Get TaskRelatedActivity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\TaskRelatedActivity[]|null
     */
    public function getTaskRelatedActivity()
    {
        return isset($this->TaskRelatedActivity) ? $this->TaskRelatedActivity : null;
    }
    /**
     * Set TaskRelatedActivity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\TaskRelatedActivity[] $taskRelatedActivity
     * @return \AcumaticaConfig\StructType\RelatedActivities
     */
    public function setTaskRelatedActivity(array $taskRelatedActivity = array())
    {
        foreach ($taskRelatedActivity as $relatedActivitiesTaskRelatedActivityItem) {
            // validation for constraint: itemType
            if (!$relatedActivitiesTaskRelatedActivityItem instanceof \AcumaticaConfig\StructType\TaskRelatedActivity) {
                throw new \InvalidArgumentException(sprintf('The TaskRelatedActivity property can only contain items of \AcumaticaConfig\StructType\TaskRelatedActivity, "%s" given', is_object($relatedActivitiesTaskRelatedActivityItem) ? get_class($relatedActivitiesTaskRelatedActivityItem) : gettype($relatedActivitiesTaskRelatedActivityItem)), __LINE__);
            }
        }
        if (is_null($taskRelatedActivity) || (is_array($taskRelatedActivity) && empty($taskRelatedActivity))) {
            unset($this->TaskRelatedActivity);
        } else {
            $this->TaskRelatedActivity = $taskRelatedActivity;
        }
        return $this;
    }
    /**
     * Add item to TaskRelatedActivity value
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\TaskRelatedActivity $item
     * @return \AcumaticaConfig\StructType\RelatedActivities
     */
    public function addToTaskRelatedActivity(\AcumaticaConfig\StructType\TaskRelatedActivity $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AcumaticaConfig\StructType\TaskRelatedActivity) {
            throw new \InvalidArgumentException(sprintf('The TaskRelatedActivity property can only contain items of \AcumaticaConfig\StructType\TaskRelatedActivity, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->TaskRelatedActivity[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AcumaticaConfig\StructType\RelatedActivities
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
