<?php

namespace AcumaticaConfig\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProjectTransactionDetail StructType
 * @subpackage Structs
 */
class ProjectTransactionDetail extends Entity
{
    /**
     * The AccountGroup
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $AccountGroup;
    /**
     * The AccountGroupDescription
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $AccountGroupDescription;
    /**
     * The Allocated
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\BooleanValue
     */
    public $Allocated;
    /**
     * The Amount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DecimalValue
     */
    public $Amount;
    /**
     * The BatchNbr
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $BatchNbr;
    /**
     * The Billable
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\BooleanValue
     */
    public $Billable;
    /**
     * The BillableQty
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DecimalValue
     */
    public $BillableQty;
    /**
     * The Branch
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $Branch;
    /**
     * The CreditAccount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $CreditAccount;
    /**
     * The CreditSubaccount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $CreditSubaccount;
    /**
     * The Date
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DateTimeValue
     */
    public $Date;
    /**
     * The DebitAccount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $DebitAccount;
    /**
     * The DebitSubaccount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $DebitSubaccount;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $Description;
    /**
     * The EarningType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $EarningType;
    /**
     * The Employee
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $Employee;
    /**
     * The EndDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DateTimeValue
     */
    public $EndDate;
    /**
     * The FinPeriod
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $FinPeriod;
    /**
     * The InventoryID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $InventoryID;
    /**
     * The Location
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $Location;
    /**
     * The Multiplier
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DecimalValue
     */
    public $Multiplier;
    /**
     * The Project
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $Project;
    /**
     * The ProjectTask
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $ProjectTask;
    /**
     * The Qty
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DecimalValue
     */
    public $Qty;
    /**
     * The Released
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\BooleanValue
     */
    public $Released;
    /**
     * The StartDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DateTimeValue
     */
    public $StartDate;
    /**
     * The TransactionID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\LongValue
     */
    public $TransactionID;
    /**
     * The UnitRate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DecimalValue
     */
    public $UnitRate;
    /**
     * The UOM
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $UOM;
    /**
     * The UseBillableQtyInAmountFormula
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\BooleanValue
     */
    public $UseBillableQtyInAmountFormula;
    /**
     * The VendorOrCustomer
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $VendorOrCustomer;
    /**
     * Constructor method for ProjectTransactionDetail
     * @uses ProjectTransactionDetail::setAccountGroup()
     * @uses ProjectTransactionDetail::setAccountGroupDescription()
     * @uses ProjectTransactionDetail::setAllocated()
     * @uses ProjectTransactionDetail::setAmount()
     * @uses ProjectTransactionDetail::setBatchNbr()
     * @uses ProjectTransactionDetail::setBillable()
     * @uses ProjectTransactionDetail::setBillableQty()
     * @uses ProjectTransactionDetail::setBranch()
     * @uses ProjectTransactionDetail::setCreditAccount()
     * @uses ProjectTransactionDetail::setCreditSubaccount()
     * @uses ProjectTransactionDetail::setDate()
     * @uses ProjectTransactionDetail::setDebitAccount()
     * @uses ProjectTransactionDetail::setDebitSubaccount()
     * @uses ProjectTransactionDetail::setDescription()
     * @uses ProjectTransactionDetail::setEarningType()
     * @uses ProjectTransactionDetail::setEmployee()
     * @uses ProjectTransactionDetail::setEndDate()
     * @uses ProjectTransactionDetail::setFinPeriod()
     * @uses ProjectTransactionDetail::setInventoryID()
     * @uses ProjectTransactionDetail::setLocation()
     * @uses ProjectTransactionDetail::setMultiplier()
     * @uses ProjectTransactionDetail::setProject()
     * @uses ProjectTransactionDetail::setProjectTask()
     * @uses ProjectTransactionDetail::setQty()
     * @uses ProjectTransactionDetail::setReleased()
     * @uses ProjectTransactionDetail::setStartDate()
     * @uses ProjectTransactionDetail::setTransactionID()
     * @uses ProjectTransactionDetail::setUnitRate()
     * @uses ProjectTransactionDetail::setUOM()
     * @uses ProjectTransactionDetail::setUseBillableQtyInAmountFormula()
     * @uses ProjectTransactionDetail::setVendorOrCustomer()
     * @param \AcumaticaConfig\StructType\StringValue $accountGroup
     * @param \AcumaticaConfig\StructType\StringValue $accountGroupDescription
     * @param \AcumaticaConfig\StructType\BooleanValue $allocated
     * @param \AcumaticaConfig\StructType\DecimalValue $amount
     * @param \AcumaticaConfig\StructType\StringValue $batchNbr
     * @param \AcumaticaConfig\StructType\BooleanValue $billable
     * @param \AcumaticaConfig\StructType\DecimalValue $billableQty
     * @param \AcumaticaConfig\StructType\StringValue $branch
     * @param \AcumaticaConfig\StructType\StringValue $creditAccount
     * @param \AcumaticaConfig\StructType\StringValue $creditSubaccount
     * @param \AcumaticaConfig\StructType\DateTimeValue $date
     * @param \AcumaticaConfig\StructType\StringValue $debitAccount
     * @param \AcumaticaConfig\StructType\StringValue $debitSubaccount
     * @param \AcumaticaConfig\StructType\StringValue $description
     * @param \AcumaticaConfig\StructType\StringValue $earningType
     * @param \AcumaticaConfig\StructType\StringValue $employee
     * @param \AcumaticaConfig\StructType\DateTimeValue $endDate
     * @param \AcumaticaConfig\StructType\StringValue $finPeriod
     * @param \AcumaticaConfig\StructType\StringValue $inventoryID
     * @param \AcumaticaConfig\StructType\StringValue $location
     * @param \AcumaticaConfig\StructType\DecimalValue $multiplier
     * @param \AcumaticaConfig\StructType\StringValue $project
     * @param \AcumaticaConfig\StructType\StringValue $projectTask
     * @param \AcumaticaConfig\StructType\DecimalValue $qty
     * @param \AcumaticaConfig\StructType\BooleanValue $released
     * @param \AcumaticaConfig\StructType\DateTimeValue $startDate
     * @param \AcumaticaConfig\StructType\LongValue $transactionID
     * @param \AcumaticaConfig\StructType\DecimalValue $unitRate
     * @param \AcumaticaConfig\StructType\StringValue $uOM
     * @param \AcumaticaConfig\StructType\BooleanValue $useBillableQtyInAmountFormula
     * @param \AcumaticaConfig\StructType\StringValue $vendorOrCustomer
     */
    public function __construct(\AcumaticaConfig\StructType\StringValue $accountGroup = null, \AcumaticaConfig\StructType\StringValue $accountGroupDescription = null, \AcumaticaConfig\StructType\BooleanValue $allocated = null, \AcumaticaConfig\StructType\DecimalValue $amount = null, \AcumaticaConfig\StructType\StringValue $batchNbr = null, \AcumaticaConfig\StructType\BooleanValue $billable = null, \AcumaticaConfig\StructType\DecimalValue $billableQty = null, \AcumaticaConfig\StructType\StringValue $branch = null, \AcumaticaConfig\StructType\StringValue $creditAccount = null, \AcumaticaConfig\StructType\StringValue $creditSubaccount = null, \AcumaticaConfig\StructType\DateTimeValue $date = null, \AcumaticaConfig\StructType\StringValue $debitAccount = null, \AcumaticaConfig\StructType\StringValue $debitSubaccount = null, \AcumaticaConfig\StructType\StringValue $description = null, \AcumaticaConfig\StructType\StringValue $earningType = null, \AcumaticaConfig\StructType\StringValue $employee = null, \AcumaticaConfig\StructType\DateTimeValue $endDate = null, \AcumaticaConfig\StructType\StringValue $finPeriod = null, \AcumaticaConfig\StructType\StringValue $inventoryID = null, \AcumaticaConfig\StructType\StringValue $location = null, \AcumaticaConfig\StructType\DecimalValue $multiplier = null, \AcumaticaConfig\StructType\StringValue $project = null, \AcumaticaConfig\StructType\StringValue $projectTask = null, \AcumaticaConfig\StructType\DecimalValue $qty = null, \AcumaticaConfig\StructType\BooleanValue $released = null, \AcumaticaConfig\StructType\DateTimeValue $startDate = null, \AcumaticaConfig\StructType\LongValue $transactionID = null, \AcumaticaConfig\StructType\DecimalValue $unitRate = null, \AcumaticaConfig\StructType\StringValue $uOM = null, \AcumaticaConfig\StructType\BooleanValue $useBillableQtyInAmountFormula = null, \AcumaticaConfig\StructType\StringValue $vendorOrCustomer = null)
    {
        $this
            ->setAccountGroup($accountGroup)
            ->setAccountGroupDescription($accountGroupDescription)
            ->setAllocated($allocated)
            ->setAmount($amount)
            ->setBatchNbr($batchNbr)
            ->setBillable($billable)
            ->setBillableQty($billableQty)
            ->setBranch($branch)
            ->setCreditAccount($creditAccount)
            ->setCreditSubaccount($creditSubaccount)
            ->setDate($date)
            ->setDebitAccount($debitAccount)
            ->setDebitSubaccount($debitSubaccount)
            ->setDescription($description)
            ->setEarningType($earningType)
            ->setEmployee($employee)
            ->setEndDate($endDate)
            ->setFinPeriod($finPeriod)
            ->setInventoryID($inventoryID)
            ->setLocation($location)
            ->setMultiplier($multiplier)
            ->setProject($project)
            ->setProjectTask($projectTask)
            ->setQty($qty)
            ->setReleased($released)
            ->setStartDate($startDate)
            ->setTransactionID($transactionID)
            ->setUnitRate($unitRate)
            ->setUOM($uOM)
            ->setUseBillableQtyInAmountFormula($useBillableQtyInAmountFormula)
            ->setVendorOrCustomer($vendorOrCustomer);
    }
    /**
     * Get AccountGroup value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getAccountGroup()
    {
        return isset($this->AccountGroup) ? $this->AccountGroup : null;
    }
    /**
     * Set AccountGroup value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $accountGroup
     * @return \AcumaticaConfig\StructType\ProjectTransactionDetail
     */
    public function setAccountGroup(\AcumaticaConfig\StructType\StringValue $accountGroup = null)
    {
        if (is_null($accountGroup) || (is_array($accountGroup) && empty($accountGroup))) {
            unset($this->AccountGroup);
        } else {
            $this->AccountGroup = $accountGroup;
        }
        return $this;
    }
    /**
     * Get AccountGroupDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getAccountGroupDescription()
    {
        return isset($this->AccountGroupDescription) ? $this->AccountGroupDescription : null;
    }
    /**
     * Set AccountGroupDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $accountGroupDescription
     * @return \AcumaticaConfig\StructType\ProjectTransactionDetail
     */
    public function setAccountGroupDescription(\AcumaticaConfig\StructType\StringValue $accountGroupDescription = null)
    {
        if (is_null($accountGroupDescription) || (is_array($accountGroupDescription) && empty($accountGroupDescription))) {
            unset($this->AccountGroupDescription);
        } else {
            $this->AccountGroupDescription = $accountGroupDescription;
        }
        return $this;
    }
    /**
     * Get Allocated value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\BooleanValue|null
     */
    public function getAllocated()
    {
        return isset($this->Allocated) ? $this->Allocated : null;
    }
    /**
     * Set Allocated value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\BooleanValue $allocated
     * @return \AcumaticaConfig\StructType\ProjectTransactionDetail
     */
    public function setAllocated(\AcumaticaConfig\StructType\BooleanValue $allocated = null)
    {
        if (is_null($allocated) || (is_array($allocated) && empty($allocated))) {
            unset($this->Allocated);
        } else {
            $this->Allocated = $allocated;
        }
        return $this;
    }
    /**
     * Get Amount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DecimalValue|null
     */
    public function getAmount()
    {
        return isset($this->Amount) ? $this->Amount : null;
    }
    /**
     * Set Amount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DecimalValue $amount
     * @return \AcumaticaConfig\StructType\ProjectTransactionDetail
     */
    public function setAmount(\AcumaticaConfig\StructType\DecimalValue $amount = null)
    {
        if (is_null($amount) || (is_array($amount) && empty($amount))) {
            unset($this->Amount);
        } else {
            $this->Amount = $amount;
        }
        return $this;
    }
    /**
     * Get BatchNbr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getBatchNbr()
    {
        return isset($this->BatchNbr) ? $this->BatchNbr : null;
    }
    /**
     * Set BatchNbr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $batchNbr
     * @return \AcumaticaConfig\StructType\ProjectTransactionDetail
     */
    public function setBatchNbr(\AcumaticaConfig\StructType\StringValue $batchNbr = null)
    {
        if (is_null($batchNbr) || (is_array($batchNbr) && empty($batchNbr))) {
            unset($this->BatchNbr);
        } else {
            $this->BatchNbr = $batchNbr;
        }
        return $this;
    }
    /**
     * Get Billable value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\BooleanValue|null
     */
    public function getBillable()
    {
        return isset($this->Billable) ? $this->Billable : null;
    }
    /**
     * Set Billable value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\BooleanValue $billable
     * @return \AcumaticaConfig\StructType\ProjectTransactionDetail
     */
    public function setBillable(\AcumaticaConfig\StructType\BooleanValue $billable = null)
    {
        if (is_null($billable) || (is_array($billable) && empty($billable))) {
            unset($this->Billable);
        } else {
            $this->Billable = $billable;
        }
        return $this;
    }
    /**
     * Get BillableQty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DecimalValue|null
     */
    public function getBillableQty()
    {
        return isset($this->BillableQty) ? $this->BillableQty : null;
    }
    /**
     * Set BillableQty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DecimalValue $billableQty
     * @return \AcumaticaConfig\StructType\ProjectTransactionDetail
     */
    public function setBillableQty(\AcumaticaConfig\StructType\DecimalValue $billableQty = null)
    {
        if (is_null($billableQty) || (is_array($billableQty) && empty($billableQty))) {
            unset($this->BillableQty);
        } else {
            $this->BillableQty = $billableQty;
        }
        return $this;
    }
    /**
     * Get Branch value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getBranch()
    {
        return isset($this->Branch) ? $this->Branch : null;
    }
    /**
     * Set Branch value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $branch
     * @return \AcumaticaConfig\StructType\ProjectTransactionDetail
     */
    public function setBranch(\AcumaticaConfig\StructType\StringValue $branch = null)
    {
        if (is_null($branch) || (is_array($branch) && empty($branch))) {
            unset($this->Branch);
        } else {
            $this->Branch = $branch;
        }
        return $this;
    }
    /**
     * Get CreditAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getCreditAccount()
    {
        return isset($this->CreditAccount) ? $this->CreditAccount : null;
    }
    /**
     * Set CreditAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $creditAccount
     * @return \AcumaticaConfig\StructType\ProjectTransactionDetail
     */
    public function setCreditAccount(\AcumaticaConfig\StructType\StringValue $creditAccount = null)
    {
        if (is_null($creditAccount) || (is_array($creditAccount) && empty($creditAccount))) {
            unset($this->CreditAccount);
        } else {
            $this->CreditAccount = $creditAccount;
        }
        return $this;
    }
    /**
     * Get CreditSubaccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getCreditSubaccount()
    {
        return isset($this->CreditSubaccount) ? $this->CreditSubaccount : null;
    }
    /**
     * Set CreditSubaccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $creditSubaccount
     * @return \AcumaticaConfig\StructType\ProjectTransactionDetail
     */
    public function setCreditSubaccount(\AcumaticaConfig\StructType\StringValue $creditSubaccount = null)
    {
        if (is_null($creditSubaccount) || (is_array($creditSubaccount) && empty($creditSubaccount))) {
            unset($this->CreditSubaccount);
        } else {
            $this->CreditSubaccount = $creditSubaccount;
        }
        return $this;
    }
    /**
     * Get Date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DateTimeValue|null
     */
    public function getDate()
    {
        return isset($this->Date) ? $this->Date : null;
    }
    /**
     * Set Date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DateTimeValue $date
     * @return \AcumaticaConfig\StructType\ProjectTransactionDetail
     */
    public function setDate(\AcumaticaConfig\StructType\DateTimeValue $date = null)
    {
        if (is_null($date) || (is_array($date) && empty($date))) {
            unset($this->Date);
        } else {
            $this->Date = $date;
        }
        return $this;
    }
    /**
     * Get DebitAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getDebitAccount()
    {
        return isset($this->DebitAccount) ? $this->DebitAccount : null;
    }
    /**
     * Set DebitAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $debitAccount
     * @return \AcumaticaConfig\StructType\ProjectTransactionDetail
     */
    public function setDebitAccount(\AcumaticaConfig\StructType\StringValue $debitAccount = null)
    {
        if (is_null($debitAccount) || (is_array($debitAccount) && empty($debitAccount))) {
            unset($this->DebitAccount);
        } else {
            $this->DebitAccount = $debitAccount;
        }
        return $this;
    }
    /**
     * Get DebitSubaccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getDebitSubaccount()
    {
        return isset($this->DebitSubaccount) ? $this->DebitSubaccount : null;
    }
    /**
     * Set DebitSubaccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $debitSubaccount
     * @return \AcumaticaConfig\StructType\ProjectTransactionDetail
     */
    public function setDebitSubaccount(\AcumaticaConfig\StructType\StringValue $debitSubaccount = null)
    {
        if (is_null($debitSubaccount) || (is_array($debitSubaccount) && empty($debitSubaccount))) {
            unset($this->DebitSubaccount);
        } else {
            $this->DebitSubaccount = $debitSubaccount;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $description
     * @return \AcumaticaConfig\StructType\ProjectTransactionDetail
     */
    public function setDescription(\AcumaticaConfig\StructType\StringValue $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get EarningType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getEarningType()
    {
        return isset($this->EarningType) ? $this->EarningType : null;
    }
    /**
     * Set EarningType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $earningType
     * @return \AcumaticaConfig\StructType\ProjectTransactionDetail
     */
    public function setEarningType(\AcumaticaConfig\StructType\StringValue $earningType = null)
    {
        if (is_null($earningType) || (is_array($earningType) && empty($earningType))) {
            unset($this->EarningType);
        } else {
            $this->EarningType = $earningType;
        }
        return $this;
    }
    /**
     * Get Employee value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getEmployee()
    {
        return isset($this->Employee) ? $this->Employee : null;
    }
    /**
     * Set Employee value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $employee
     * @return \AcumaticaConfig\StructType\ProjectTransactionDetail
     */
    public function setEmployee(\AcumaticaConfig\StructType\StringValue $employee = null)
    {
        if (is_null($employee) || (is_array($employee) && empty($employee))) {
            unset($this->Employee);
        } else {
            $this->Employee = $employee;
        }
        return $this;
    }
    /**
     * Get EndDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DateTimeValue|null
     */
    public function getEndDate()
    {
        return isset($this->EndDate) ? $this->EndDate : null;
    }
    /**
     * Set EndDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DateTimeValue $endDate
     * @return \AcumaticaConfig\StructType\ProjectTransactionDetail
     */
    public function setEndDate(\AcumaticaConfig\StructType\DateTimeValue $endDate = null)
    {
        if (is_null($endDate) || (is_array($endDate) && empty($endDate))) {
            unset($this->EndDate);
        } else {
            $this->EndDate = $endDate;
        }
        return $this;
    }
    /**
     * Get FinPeriod value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getFinPeriod()
    {
        return isset($this->FinPeriod) ? $this->FinPeriod : null;
    }
    /**
     * Set FinPeriod value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $finPeriod
     * @return \AcumaticaConfig\StructType\ProjectTransactionDetail
     */
    public function setFinPeriod(\AcumaticaConfig\StructType\StringValue $finPeriod = null)
    {
        if (is_null($finPeriod) || (is_array($finPeriod) && empty($finPeriod))) {
            unset($this->FinPeriod);
        } else {
            $this->FinPeriod = $finPeriod;
        }
        return $this;
    }
    /**
     * Get InventoryID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getInventoryID()
    {
        return isset($this->InventoryID) ? $this->InventoryID : null;
    }
    /**
     * Set InventoryID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $inventoryID
     * @return \AcumaticaConfig\StructType\ProjectTransactionDetail
     */
    public function setInventoryID(\AcumaticaConfig\StructType\StringValue $inventoryID = null)
    {
        if (is_null($inventoryID) || (is_array($inventoryID) && empty($inventoryID))) {
            unset($this->InventoryID);
        } else {
            $this->InventoryID = $inventoryID;
        }
        return $this;
    }
    /**
     * Get Location value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getLocation()
    {
        return isset($this->Location) ? $this->Location : null;
    }
    /**
     * Set Location value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $location
     * @return \AcumaticaConfig\StructType\ProjectTransactionDetail
     */
    public function setLocation(\AcumaticaConfig\StructType\StringValue $location = null)
    {
        if (is_null($location) || (is_array($location) && empty($location))) {
            unset($this->Location);
        } else {
            $this->Location = $location;
        }
        return $this;
    }
    /**
     * Get Multiplier value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DecimalValue|null
     */
    public function getMultiplier()
    {
        return isset($this->Multiplier) ? $this->Multiplier : null;
    }
    /**
     * Set Multiplier value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DecimalValue $multiplier
     * @return \AcumaticaConfig\StructType\ProjectTransactionDetail
     */
    public function setMultiplier(\AcumaticaConfig\StructType\DecimalValue $multiplier = null)
    {
        if (is_null($multiplier) || (is_array($multiplier) && empty($multiplier))) {
            unset($this->Multiplier);
        } else {
            $this->Multiplier = $multiplier;
        }
        return $this;
    }
    /**
     * Get Project value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getProject()
    {
        return isset($this->Project) ? $this->Project : null;
    }
    /**
     * Set Project value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $project
     * @return \AcumaticaConfig\StructType\ProjectTransactionDetail
     */
    public function setProject(\AcumaticaConfig\StructType\StringValue $project = null)
    {
        if (is_null($project) || (is_array($project) && empty($project))) {
            unset($this->Project);
        } else {
            $this->Project = $project;
        }
        return $this;
    }
    /**
     * Get ProjectTask value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getProjectTask()
    {
        return isset($this->ProjectTask) ? $this->ProjectTask : null;
    }
    /**
     * Set ProjectTask value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $projectTask
     * @return \AcumaticaConfig\StructType\ProjectTransactionDetail
     */
    public function setProjectTask(\AcumaticaConfig\StructType\StringValue $projectTask = null)
    {
        if (is_null($projectTask) || (is_array($projectTask) && empty($projectTask))) {
            unset($this->ProjectTask);
        } else {
            $this->ProjectTask = $projectTask;
        }
        return $this;
    }
    /**
     * Get Qty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DecimalValue|null
     */
    public function getQty()
    {
        return isset($this->Qty) ? $this->Qty : null;
    }
    /**
     * Set Qty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DecimalValue $qty
     * @return \AcumaticaConfig\StructType\ProjectTransactionDetail
     */
    public function setQty(\AcumaticaConfig\StructType\DecimalValue $qty = null)
    {
        if (is_null($qty) || (is_array($qty) && empty($qty))) {
            unset($this->Qty);
        } else {
            $this->Qty = $qty;
        }
        return $this;
    }
    /**
     * Get Released value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\BooleanValue|null
     */
    public function getReleased()
    {
        return isset($this->Released) ? $this->Released : null;
    }
    /**
     * Set Released value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\BooleanValue $released
     * @return \AcumaticaConfig\StructType\ProjectTransactionDetail
     */
    public function setReleased(\AcumaticaConfig\StructType\BooleanValue $released = null)
    {
        if (is_null($released) || (is_array($released) && empty($released))) {
            unset($this->Released);
        } else {
            $this->Released = $released;
        }
        return $this;
    }
    /**
     * Get StartDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DateTimeValue|null
     */
    public function getStartDate()
    {
        return isset($this->StartDate) ? $this->StartDate : null;
    }
    /**
     * Set StartDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DateTimeValue $startDate
     * @return \AcumaticaConfig\StructType\ProjectTransactionDetail
     */
    public function setStartDate(\AcumaticaConfig\StructType\DateTimeValue $startDate = null)
    {
        if (is_null($startDate) || (is_array($startDate) && empty($startDate))) {
            unset($this->StartDate);
        } else {
            $this->StartDate = $startDate;
        }
        return $this;
    }
    /**
     * Get TransactionID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\LongValue|null
     */
    public function getTransactionID()
    {
        return isset($this->TransactionID) ? $this->TransactionID : null;
    }
    /**
     * Set TransactionID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\LongValue $transactionID
     * @return \AcumaticaConfig\StructType\ProjectTransactionDetail
     */
    public function setTransactionID(\AcumaticaConfig\StructType\LongValue $transactionID = null)
    {
        if (is_null($transactionID) || (is_array($transactionID) && empty($transactionID))) {
            unset($this->TransactionID);
        } else {
            $this->TransactionID = $transactionID;
        }
        return $this;
    }
    /**
     * Get UnitRate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DecimalValue|null
     */
    public function getUnitRate()
    {
        return isset($this->UnitRate) ? $this->UnitRate : null;
    }
    /**
     * Set UnitRate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DecimalValue $unitRate
     * @return \AcumaticaConfig\StructType\ProjectTransactionDetail
     */
    public function setUnitRate(\AcumaticaConfig\StructType\DecimalValue $unitRate = null)
    {
        if (is_null($unitRate) || (is_array($unitRate) && empty($unitRate))) {
            unset($this->UnitRate);
        } else {
            $this->UnitRate = $unitRate;
        }
        return $this;
    }
    /**
     * Get UOM value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getUOM()
    {
        return isset($this->UOM) ? $this->UOM : null;
    }
    /**
     * Set UOM value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $uOM
     * @return \AcumaticaConfig\StructType\ProjectTransactionDetail
     */
    public function setUOM(\AcumaticaConfig\StructType\StringValue $uOM = null)
    {
        if (is_null($uOM) || (is_array($uOM) && empty($uOM))) {
            unset($this->UOM);
        } else {
            $this->UOM = $uOM;
        }
        return $this;
    }
    /**
     * Get UseBillableQtyInAmountFormula value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\BooleanValue|null
     */
    public function getUseBillableQtyInAmountFormula()
    {
        return isset($this->UseBillableQtyInAmountFormula) ? $this->UseBillableQtyInAmountFormula : null;
    }
    /**
     * Set UseBillableQtyInAmountFormula value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\BooleanValue $useBillableQtyInAmountFormula
     * @return \AcumaticaConfig\StructType\ProjectTransactionDetail
     */
    public function setUseBillableQtyInAmountFormula(\AcumaticaConfig\StructType\BooleanValue $useBillableQtyInAmountFormula = null)
    {
        if (is_null($useBillableQtyInAmountFormula) || (is_array($useBillableQtyInAmountFormula) && empty($useBillableQtyInAmountFormula))) {
            unset($this->UseBillableQtyInAmountFormula);
        } else {
            $this->UseBillableQtyInAmountFormula = $useBillableQtyInAmountFormula;
        }
        return $this;
    }
    /**
     * Get VendorOrCustomer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getVendorOrCustomer()
    {
        return isset($this->VendorOrCustomer) ? $this->VendorOrCustomer : null;
    }
    /**
     * Set VendorOrCustomer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $vendorOrCustomer
     * @return \AcumaticaConfig\StructType\ProjectTransactionDetail
     */
    public function setVendorOrCustomer(\AcumaticaConfig\StructType\StringValue $vendorOrCustomer = null)
    {
        if (is_null($vendorOrCustomer) || (is_array($vendorOrCustomer) && empty($vendorOrCustomer))) {
            unset($this->VendorOrCustomer);
        } else {
            $this->VendorOrCustomer = $vendorOrCustomer;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AcumaticaConfig\StructType\ProjectTransactionDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
