<?php

namespace AcumaticaConfig\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProjectTransaction StructType
 * @subpackage Structs
 */
class ProjectTransaction extends Entity
{
    /**
     * The CreatedDateTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DateTimeValue
     */
    public $CreatedDateTime;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $Description;
    /**
     * The Details
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\Details
     */
    public $Details;
    /**
     * The LastModifiedDateTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DateTimeValue
     */
    public $LastModifiedDateTime;
    /**
     * The Module
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $Module;
    /**
     * The OriginalDocNbr
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $OriginalDocNbr;
    /**
     * The OriginalDocType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $OriginalDocType;
    /**
     * The ReferenceNbr
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $ReferenceNbr;
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $Status;
    /**
     * The TotalAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DecimalValue
     */
    public $TotalAmount;
    /**
     * The TotalBillableQty
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DecimalValue
     */
    public $TotalBillableQty;
    /**
     * The TotalQty
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DecimalValue
     */
    public $TotalQty;
    /**
     * Constructor method for ProjectTransaction
     * @uses ProjectTransaction::setCreatedDateTime()
     * @uses ProjectTransaction::setDescription()
     * @uses ProjectTransaction::setDetails()
     * @uses ProjectTransaction::setLastModifiedDateTime()
     * @uses ProjectTransaction::setModule()
     * @uses ProjectTransaction::setOriginalDocNbr()
     * @uses ProjectTransaction::setOriginalDocType()
     * @uses ProjectTransaction::setReferenceNbr()
     * @uses ProjectTransaction::setStatus()
     * @uses ProjectTransaction::setTotalAmount()
     * @uses ProjectTransaction::setTotalBillableQty()
     * @uses ProjectTransaction::setTotalQty()
     * @param \AcumaticaConfig\StructType\DateTimeValue $createdDateTime
     * @param \AcumaticaConfig\StructType\StringValue $description
     * @param \AcumaticaConfig\StructType\Details $details
     * @param \AcumaticaConfig\StructType\DateTimeValue $lastModifiedDateTime
     * @param \AcumaticaConfig\StructType\StringValue $module
     * @param \AcumaticaConfig\StructType\StringValue $originalDocNbr
     * @param \AcumaticaConfig\StructType\StringValue $originalDocType
     * @param \AcumaticaConfig\StructType\StringValue $referenceNbr
     * @param \AcumaticaConfig\StructType\StringValue $status
     * @param \AcumaticaConfig\StructType\DecimalValue $totalAmount
     * @param \AcumaticaConfig\StructType\DecimalValue $totalBillableQty
     * @param \AcumaticaConfig\StructType\DecimalValue $totalQty
     */
    public function __construct(\AcumaticaConfig\StructType\DateTimeValue $createdDateTime = null, \AcumaticaConfig\StructType\StringValue $description = null, \AcumaticaConfig\StructType\Details $details = null, \AcumaticaConfig\StructType\DateTimeValue $lastModifiedDateTime = null, \AcumaticaConfig\StructType\StringValue $module = null, \AcumaticaConfig\StructType\StringValue $originalDocNbr = null, \AcumaticaConfig\StructType\StringValue $originalDocType = null, \AcumaticaConfig\StructType\StringValue $referenceNbr = null, \AcumaticaConfig\StructType\StringValue $status = null, \AcumaticaConfig\StructType\DecimalValue $totalAmount = null, \AcumaticaConfig\StructType\DecimalValue $totalBillableQty = null, \AcumaticaConfig\StructType\DecimalValue $totalQty = null)
    {
        $this
            ->setCreatedDateTime($createdDateTime)
            ->setDescription($description)
            ->setDetails($details)
            ->setLastModifiedDateTime($lastModifiedDateTime)
            ->setModule($module)
            ->setOriginalDocNbr($originalDocNbr)
            ->setOriginalDocType($originalDocType)
            ->setReferenceNbr($referenceNbr)
            ->setStatus($status)
            ->setTotalAmount($totalAmount)
            ->setTotalBillableQty($totalBillableQty)
            ->setTotalQty($totalQty);
    }
    /**
     * Get CreatedDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DateTimeValue|null
     */
    public function getCreatedDateTime()
    {
        return isset($this->CreatedDateTime) ? $this->CreatedDateTime : null;
    }
    /**
     * Set CreatedDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DateTimeValue $createdDateTime
     * @return \AcumaticaConfig\StructType\ProjectTransaction
     */
    public function setCreatedDateTime(\AcumaticaConfig\StructType\DateTimeValue $createdDateTime = null)
    {
        if (is_null($createdDateTime) || (is_array($createdDateTime) && empty($createdDateTime))) {
            unset($this->CreatedDateTime);
        } else {
            $this->CreatedDateTime = $createdDateTime;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $description
     * @return \AcumaticaConfig\StructType\ProjectTransaction
     */
    public function setDescription(\AcumaticaConfig\StructType\StringValue $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get Details value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\Details|null
     */
    public function getDetails()
    {
        return isset($this->Details) ? $this->Details : null;
    }
    /**
     * Set Details value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\Details $details
     * @return \AcumaticaConfig\StructType\ProjectTransaction
     */
    public function setDetails(\AcumaticaConfig\StructType\Details $details = null)
    {
        if (is_null($details) || (is_array($details) && empty($details))) {
            unset($this->Details);
        } else {
            $this->Details = $details;
        }
        return $this;
    }
    /**
     * Get LastModifiedDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DateTimeValue|null
     */
    public function getLastModifiedDateTime()
    {
        return isset($this->LastModifiedDateTime) ? $this->LastModifiedDateTime : null;
    }
    /**
     * Set LastModifiedDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DateTimeValue $lastModifiedDateTime
     * @return \AcumaticaConfig\StructType\ProjectTransaction
     */
    public function setLastModifiedDateTime(\AcumaticaConfig\StructType\DateTimeValue $lastModifiedDateTime = null)
    {
        if (is_null($lastModifiedDateTime) || (is_array($lastModifiedDateTime) && empty($lastModifiedDateTime))) {
            unset($this->LastModifiedDateTime);
        } else {
            $this->LastModifiedDateTime = $lastModifiedDateTime;
        }
        return $this;
    }
    /**
     * Get Module value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getModule()
    {
        return isset($this->Module) ? $this->Module : null;
    }
    /**
     * Set Module value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $module
     * @return \AcumaticaConfig\StructType\ProjectTransaction
     */
    public function setModule(\AcumaticaConfig\StructType\StringValue $module = null)
    {
        if (is_null($module) || (is_array($module) && empty($module))) {
            unset($this->Module);
        } else {
            $this->Module = $module;
        }
        return $this;
    }
    /**
     * Get OriginalDocNbr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getOriginalDocNbr()
    {
        return isset($this->OriginalDocNbr) ? $this->OriginalDocNbr : null;
    }
    /**
     * Set OriginalDocNbr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $originalDocNbr
     * @return \AcumaticaConfig\StructType\ProjectTransaction
     */
    public function setOriginalDocNbr(\AcumaticaConfig\StructType\StringValue $originalDocNbr = null)
    {
        if (is_null($originalDocNbr) || (is_array($originalDocNbr) && empty($originalDocNbr))) {
            unset($this->OriginalDocNbr);
        } else {
            $this->OriginalDocNbr = $originalDocNbr;
        }
        return $this;
    }
    /**
     * Get OriginalDocType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getOriginalDocType()
    {
        return isset($this->OriginalDocType) ? $this->OriginalDocType : null;
    }
    /**
     * Set OriginalDocType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $originalDocType
     * @return \AcumaticaConfig\StructType\ProjectTransaction
     */
    public function setOriginalDocType(\AcumaticaConfig\StructType\StringValue $originalDocType = null)
    {
        if (is_null($originalDocType) || (is_array($originalDocType) && empty($originalDocType))) {
            unset($this->OriginalDocType);
        } else {
            $this->OriginalDocType = $originalDocType;
        }
        return $this;
    }
    /**
     * Get ReferenceNbr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getReferenceNbr()
    {
        return isset($this->ReferenceNbr) ? $this->ReferenceNbr : null;
    }
    /**
     * Set ReferenceNbr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $referenceNbr
     * @return \AcumaticaConfig\StructType\ProjectTransaction
     */
    public function setReferenceNbr(\AcumaticaConfig\StructType\StringValue $referenceNbr = null)
    {
        if (is_null($referenceNbr) || (is_array($referenceNbr) && empty($referenceNbr))) {
            unset($this->ReferenceNbr);
        } else {
            $this->ReferenceNbr = $referenceNbr;
        }
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $status
     * @return \AcumaticaConfig\StructType\ProjectTransaction
     */
    public function setStatus(\AcumaticaConfig\StructType\StringValue $status = null)
    {
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
    /**
     * Get TotalAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DecimalValue|null
     */
    public function getTotalAmount()
    {
        return isset($this->TotalAmount) ? $this->TotalAmount : null;
    }
    /**
     * Set TotalAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DecimalValue $totalAmount
     * @return \AcumaticaConfig\StructType\ProjectTransaction
     */
    public function setTotalAmount(\AcumaticaConfig\StructType\DecimalValue $totalAmount = null)
    {
        if (is_null($totalAmount) || (is_array($totalAmount) && empty($totalAmount))) {
            unset($this->TotalAmount);
        } else {
            $this->TotalAmount = $totalAmount;
        }
        return $this;
    }
    /**
     * Get TotalBillableQty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DecimalValue|null
     */
    public function getTotalBillableQty()
    {
        return isset($this->TotalBillableQty) ? $this->TotalBillableQty : null;
    }
    /**
     * Set TotalBillableQty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DecimalValue $totalBillableQty
     * @return \AcumaticaConfig\StructType\ProjectTransaction
     */
    public function setTotalBillableQty(\AcumaticaConfig\StructType\DecimalValue $totalBillableQty = null)
    {
        if (is_null($totalBillableQty) || (is_array($totalBillableQty) && empty($totalBillableQty))) {
            unset($this->TotalBillableQty);
        } else {
            $this->TotalBillableQty = $totalBillableQty;
        }
        return $this;
    }
    /**
     * Get TotalQty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DecimalValue|null
     */
    public function getTotalQty()
    {
        return isset($this->TotalQty) ? $this->TotalQty : null;
    }
    /**
     * Set TotalQty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DecimalValue $totalQty
     * @return \AcumaticaConfig\StructType\ProjectTransaction
     */
    public function setTotalQty(\AcumaticaConfig\StructType\DecimalValue $totalQty = null)
    {
        if (is_null($totalQty) || (is_array($totalQty) && empty($totalQty))) {
            unset($this->TotalQty);
        } else {
            $this->TotalQty = $totalQty;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AcumaticaConfig\StructType\ProjectTransaction
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
