<?php

namespace AcumaticaConfig\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProductsDeletedResults StructType
 * @subpackage Structs
 */
class ProductsDeletedResults extends Entity
{
    /**
     * The InventoryCD
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $InventoryCD;
    /**
     * The LastModifiedDateTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DateTimeValue
     */
    public $LastModifiedDateTime;
    /**
     * The StkItem
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\BooleanValue
     */
    public $StkItem;
    /**
     * The ProductsDeletedResults
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\ProductsDeletedResults[]
     */
    public $ProductsDeletedResults;
    /**
     * Constructor method for ProductsDeletedResults
     * @uses ProductsDeletedResults::setInventoryCD()
     * @uses ProductsDeletedResults::setLastModifiedDateTime()
     * @uses ProductsDeletedResults::setStkItem()
     * @uses ProductsDeletedResults::setProductsDeletedResults()
     * @param \AcumaticaConfig\StructType\StringValue $inventoryCD
     * @param \AcumaticaConfig\StructType\DateTimeValue $lastModifiedDateTime
     * @param \AcumaticaConfig\StructType\BooleanValue $stkItem
     * @param \AcumaticaConfig\StructType\ProductsDeletedResults[] $productsDeletedResults
     */
    public function __construct(\AcumaticaConfig\StructType\StringValue $inventoryCD = null, \AcumaticaConfig\StructType\DateTimeValue $lastModifiedDateTime = null, \AcumaticaConfig\StructType\BooleanValue $stkItem = null, array $productsDeletedResults = array())
    {
        $this
            ->setInventoryCD($inventoryCD)
            ->setLastModifiedDateTime($lastModifiedDateTime)
            ->setStkItem($stkItem)
            ->setProductsDeletedResults($productsDeletedResults);
    }
    /**
     * Get InventoryCD value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getInventoryCD()
    {
        return isset($this->InventoryCD) ? $this->InventoryCD : null;
    }
    /**
     * Set InventoryCD value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $inventoryCD
     * @return \AcumaticaConfig\StructType\ProductsDeletedResults
     */
    public function setInventoryCD(\AcumaticaConfig\StructType\StringValue $inventoryCD = null)
    {
        if (is_null($inventoryCD) || (is_array($inventoryCD) && empty($inventoryCD))) {
            unset($this->InventoryCD);
        } else {
            $this->InventoryCD = $inventoryCD;
        }
        return $this;
    }
    /**
     * Get LastModifiedDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DateTimeValue|null
     */
    public function getLastModifiedDateTime()
    {
        return isset($this->LastModifiedDateTime) ? $this->LastModifiedDateTime : null;
    }
    /**
     * Set LastModifiedDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DateTimeValue $lastModifiedDateTime
     * @return \AcumaticaConfig\StructType\ProductsDeletedResults
     */
    public function setLastModifiedDateTime(\AcumaticaConfig\StructType\DateTimeValue $lastModifiedDateTime = null)
    {
        if (is_null($lastModifiedDateTime) || (is_array($lastModifiedDateTime) && empty($lastModifiedDateTime))) {
            unset($this->LastModifiedDateTime);
        } else {
            $this->LastModifiedDateTime = $lastModifiedDateTime;
        }
        return $this;
    }
    /**
     * Get StkItem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\BooleanValue|null
     */
    public function getStkItem()
    {
        return isset($this->StkItem) ? $this->StkItem : null;
    }
    /**
     * Set StkItem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\BooleanValue $stkItem
     * @return \AcumaticaConfig\StructType\ProductsDeletedResults
     */
    public function setStkItem(\AcumaticaConfig\StructType\BooleanValue $stkItem = null)
    {
        if (is_null($stkItem) || (is_array($stkItem) && empty($stkItem))) {
            unset($this->StkItem);
        } else {
            $this->StkItem = $stkItem;
        }
        return $this;
    }
    /**
     * Get ProductsDeletedResults value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\ProductsDeletedResults[]|null
     */
    public function getProductsDeletedResults()
    {
        return isset($this->ProductsDeletedResults) ? $this->ProductsDeletedResults : null;
    }
    /**
     * Set ProductsDeletedResults value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\ProductsDeletedResults[] $productsDeletedResults
     * @return \AcumaticaConfig\StructType\ProductsDeletedResults
     */
    public function setProductsDeletedResults(array $productsDeletedResults = array())
    {
        foreach ($productsDeletedResults as $productsDeletedResultsProductsDeletedResultsItem) {
            // validation for constraint: itemType
            if (!$productsDeletedResultsProductsDeletedResultsItem instanceof \AcumaticaConfig\StructType\ProductsDeletedResults) {
                throw new \InvalidArgumentException(sprintf('The ProductsDeletedResults property can only contain items of \AcumaticaConfig\StructType\ProductsDeletedResults, "%s" given', is_object($productsDeletedResultsProductsDeletedResultsItem) ? get_class($productsDeletedResultsProductsDeletedResultsItem) : gettype($productsDeletedResultsProductsDeletedResultsItem)), __LINE__);
            }
        }
        if (is_null($productsDeletedResults) || (is_array($productsDeletedResults) && empty($productsDeletedResults))) {
            unset($this->ProductsDeletedResults);
        } else {
            $this->ProductsDeletedResults = $productsDeletedResults;
        }
        return $this;
    }
    /**
     * Add item to ProductsDeletedResults value
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\ProductsDeletedResults $item
     * @return \AcumaticaConfig\StructType\ProductsDeletedResults
     */
    public function addToProductsDeletedResults(\AcumaticaConfig\StructType\ProductsDeletedResults $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AcumaticaConfig\StructType\ProductsDeletedResults) {
            throw new \InvalidArgumentException(sprintf('The ProductsDeletedResults property can only contain items of \AcumaticaConfig\StructType\ProductsDeletedResults, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ProductsDeletedResults[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AcumaticaConfig\StructType\ProductsDeletedResults
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
