<?php

namespace AcumaticaConfig\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Products StructType
 * @subpackage Structs
 */
class Products extends AbstractStructBase
{
    /**
     * The OpportunityProduct
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\OpportunityProduct[]
     */
    public $OpportunityProduct;
    /**
     * Constructor method for Products
     * @uses Products::setOpportunityProduct()
     * @param \AcumaticaConfig\StructType\OpportunityProduct[] $opportunityProduct
     */
    public function __construct(array $opportunityProduct = array())
    {
        $this
            ->setOpportunityProduct($opportunityProduct);
    }
    /**
     * Get OpportunityProduct value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\OpportunityProduct[]|null
     */
    public function getOpportunityProduct()
    {
        return isset($this->OpportunityProduct) ? $this->OpportunityProduct : null;
    }
    /**
     * Set OpportunityProduct value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\OpportunityProduct[] $opportunityProduct
     * @return \AcumaticaConfig\StructType\Products
     */
    public function setOpportunityProduct(array $opportunityProduct = array())
    {
        foreach ($opportunityProduct as $productsOpportunityProductItem) {
            // validation for constraint: itemType
            if (!$productsOpportunityProductItem instanceof \AcumaticaConfig\StructType\OpportunityProduct) {
                throw new \InvalidArgumentException(sprintf('The OpportunityProduct property can only contain items of \AcumaticaConfig\StructType\OpportunityProduct, "%s" given', is_object($productsOpportunityProductItem) ? get_class($productsOpportunityProductItem) : gettype($productsOpportunityProductItem)), __LINE__);
            }
        }
        if (is_null($opportunityProduct) || (is_array($opportunityProduct) && empty($opportunityProduct))) {
            unset($this->OpportunityProduct);
        } else {
            $this->OpportunityProduct = $opportunityProduct;
        }
        return $this;
    }
    /**
     * Add item to OpportunityProduct value
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\OpportunityProduct $item
     * @return \AcumaticaConfig\StructType\Products
     */
    public function addToOpportunityProduct(\AcumaticaConfig\StructType\OpportunityProduct $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AcumaticaConfig\StructType\OpportunityProduct) {
            throw new \InvalidArgumentException(sprintf('The OpportunityProduct property can only contain items of \AcumaticaConfig\StructType\OpportunityProduct, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->OpportunityProduct[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AcumaticaConfig\StructType\Products
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
