<?php

namespace AcumaticaConfig\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProductInventory StructType
 * @subpackage Structs
 */
class ProductInventory extends Entity
{
    /**
     * The InventoryID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $InventoryID;
    /**
     * The WarehouseDetails
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\WarehouseDetails
     */
    public $WarehouseDetails;
    /**
     * Constructor method for ProductInventory
     * @uses ProductInventory::setInventoryID()
     * @uses ProductInventory::setWarehouseDetails()
     * @param \AcumaticaConfig\StructType\StringValue $inventoryID
     * @param \AcumaticaConfig\StructType\WarehouseDetails $warehouseDetails
     */
    public function __construct(\AcumaticaConfig\StructType\StringValue $inventoryID = null, \AcumaticaConfig\StructType\WarehouseDetails $warehouseDetails = null)
    {
        $this
            ->setInventoryID($inventoryID)
            ->setWarehouseDetails($warehouseDetails);
    }
    /**
     * Get InventoryID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getInventoryID()
    {
        return isset($this->InventoryID) ? $this->InventoryID : null;
    }
    /**
     * Set InventoryID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $inventoryID
     * @return \AcumaticaConfig\StructType\ProductInventory
     */
    public function setInventoryID(\AcumaticaConfig\StructType\StringValue $inventoryID = null)
    {
        if (is_null($inventoryID) || (is_array($inventoryID) && empty($inventoryID))) {
            unset($this->InventoryID);
        } else {
            $this->InventoryID = $inventoryID;
        }
        return $this;
    }
    /**
     * Get WarehouseDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\WarehouseDetails|null
     */
    public function getWarehouseDetails()
    {
        return isset($this->WarehouseDetails) ? $this->WarehouseDetails : null;
    }
    /**
     * Set WarehouseDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\WarehouseDetails $warehouseDetails
     * @return \AcumaticaConfig\StructType\ProductInventory
     */
    public function setWarehouseDetails(\AcumaticaConfig\StructType\WarehouseDetails $warehouseDetails = null)
    {
        if (is_null($warehouseDetails) || (is_array($warehouseDetails) && empty($warehouseDetails))) {
            unset($this->WarehouseDetails);
        } else {
            $this->WarehouseDetails = $warehouseDetails;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AcumaticaConfig\StructType\ProductInventory
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
