<?php

namespace AcumaticaConfig\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProductByItemClass StructType
 * @subpackage Structs
 */
class ProductByItemClass extends Entity
{
    /**
     * The ItemClass
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\IntValue
     */
    public $ItemClass;
    /**
     * The ProductDetails
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\ProductDetails
     */
    public $ProductDetails;
    /**
     * Constructor method for ProductByItemClass
     * @uses ProductByItemClass::setItemClass()
     * @uses ProductByItemClass::setProductDetails()
     * @param \AcumaticaConfig\StructType\IntValue $itemClass
     * @param \AcumaticaConfig\StructType\ProductDetails $productDetails
     */
    public function __construct(\AcumaticaConfig\StructType\IntValue $itemClass = null, \AcumaticaConfig\StructType\ProductDetails $productDetails = null)
    {
        $this
            ->setItemClass($itemClass)
            ->setProductDetails($productDetails);
    }
    /**
     * Get ItemClass value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\IntValue|null
     */
    public function getItemClass()
    {
        return isset($this->ItemClass) ? $this->ItemClass : null;
    }
    /**
     * Set ItemClass value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\IntValue $itemClass
     * @return \AcumaticaConfig\StructType\ProductByItemClass
     */
    public function setItemClass(\AcumaticaConfig\StructType\IntValue $itemClass = null)
    {
        if (is_null($itemClass) || (is_array($itemClass) && empty($itemClass))) {
            unset($this->ItemClass);
        } else {
            $this->ItemClass = $itemClass;
        }
        return $this;
    }
    /**
     * Get ProductDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\ProductDetails|null
     */
    public function getProductDetails()
    {
        return isset($this->ProductDetails) ? $this->ProductDetails : null;
    }
    /**
     * Set ProductDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\ProductDetails $productDetails
     * @return \AcumaticaConfig\StructType\ProductByItemClass
     */
    public function setProductDetails(\AcumaticaConfig\StructType\ProductDetails $productDetails = null)
    {
        if (is_null($productDetails) || (is_array($productDetails) && empty($productDetails))) {
            unset($this->ProductDetails);
        } else {
            $this->ProductDetails = $productDetails;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AcumaticaConfig\StructType\ProductByItemClass
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
