<?php

namespace AcumaticaConfig\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentDetail StructType
 * @subpackage Structs
 */
class PaymentDetail extends Entity
{
    /**
     * The AmountPaid
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DecimalValue
     */
    public $AmountPaid;
    /**
     * The BalanceWriteOff
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DecimalValue
     */
    public $BalanceWriteOff;
    /**
     * The CustomerOrder
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $CustomerOrder;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $Description;
    /**
     * The DocType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $DocType;
    /**
     * The ReferenceNbr
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $ReferenceNbr;
    /**
     * The WriteOffReasonCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $WriteOffReasonCode;
    /**
     * Constructor method for PaymentDetail
     * @uses PaymentDetail::setAmountPaid()
     * @uses PaymentDetail::setBalanceWriteOff()
     * @uses PaymentDetail::setCustomerOrder()
     * @uses PaymentDetail::setDescription()
     * @uses PaymentDetail::setDocType()
     * @uses PaymentDetail::setReferenceNbr()
     * @uses PaymentDetail::setWriteOffReasonCode()
     * @param \AcumaticaConfig\StructType\DecimalValue $amountPaid
     * @param \AcumaticaConfig\StructType\DecimalValue $balanceWriteOff
     * @param \AcumaticaConfig\StructType\StringValue $customerOrder
     * @param \AcumaticaConfig\StructType\StringValue $description
     * @param \AcumaticaConfig\StructType\StringValue $docType
     * @param \AcumaticaConfig\StructType\StringValue $referenceNbr
     * @param \AcumaticaConfig\StructType\StringValue $writeOffReasonCode
     */
    public function __construct(\AcumaticaConfig\StructType\DecimalValue $amountPaid = null, \AcumaticaConfig\StructType\DecimalValue $balanceWriteOff = null, \AcumaticaConfig\StructType\StringValue $customerOrder = null, \AcumaticaConfig\StructType\StringValue $description = null, \AcumaticaConfig\StructType\StringValue $docType = null, \AcumaticaConfig\StructType\StringValue $referenceNbr = null, \AcumaticaConfig\StructType\StringValue $writeOffReasonCode = null)
    {
        $this
            ->setAmountPaid($amountPaid)
            ->setBalanceWriteOff($balanceWriteOff)
            ->setCustomerOrder($customerOrder)
            ->setDescription($description)
            ->setDocType($docType)
            ->setReferenceNbr($referenceNbr)
            ->setWriteOffReasonCode($writeOffReasonCode);
    }
    /**
     * Get AmountPaid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DecimalValue|null
     */
    public function getAmountPaid()
    {
        return isset($this->AmountPaid) ? $this->AmountPaid : null;
    }
    /**
     * Set AmountPaid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DecimalValue $amountPaid
     * @return \AcumaticaConfig\StructType\PaymentDetail
     */
    public function setAmountPaid(\AcumaticaConfig\StructType\DecimalValue $amountPaid = null)
    {
        if (is_null($amountPaid) || (is_array($amountPaid) && empty($amountPaid))) {
            unset($this->AmountPaid);
        } else {
            $this->AmountPaid = $amountPaid;
        }
        return $this;
    }
    /**
     * Get BalanceWriteOff value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DecimalValue|null
     */
    public function getBalanceWriteOff()
    {
        return isset($this->BalanceWriteOff) ? $this->BalanceWriteOff : null;
    }
    /**
     * Set BalanceWriteOff value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DecimalValue $balanceWriteOff
     * @return \AcumaticaConfig\StructType\PaymentDetail
     */
    public function setBalanceWriteOff(\AcumaticaConfig\StructType\DecimalValue $balanceWriteOff = null)
    {
        if (is_null($balanceWriteOff) || (is_array($balanceWriteOff) && empty($balanceWriteOff))) {
            unset($this->BalanceWriteOff);
        } else {
            $this->BalanceWriteOff = $balanceWriteOff;
        }
        return $this;
    }
    /**
     * Get CustomerOrder value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getCustomerOrder()
    {
        return isset($this->CustomerOrder) ? $this->CustomerOrder : null;
    }
    /**
     * Set CustomerOrder value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $customerOrder
     * @return \AcumaticaConfig\StructType\PaymentDetail
     */
    public function setCustomerOrder(\AcumaticaConfig\StructType\StringValue $customerOrder = null)
    {
        if (is_null($customerOrder) || (is_array($customerOrder) && empty($customerOrder))) {
            unset($this->CustomerOrder);
        } else {
            $this->CustomerOrder = $customerOrder;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $description
     * @return \AcumaticaConfig\StructType\PaymentDetail
     */
    public function setDescription(\AcumaticaConfig\StructType\StringValue $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get DocType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getDocType()
    {
        return isset($this->DocType) ? $this->DocType : null;
    }
    /**
     * Set DocType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $docType
     * @return \AcumaticaConfig\StructType\PaymentDetail
     */
    public function setDocType(\AcumaticaConfig\StructType\StringValue $docType = null)
    {
        if (is_null($docType) || (is_array($docType) && empty($docType))) {
            unset($this->DocType);
        } else {
            $this->DocType = $docType;
        }
        return $this;
    }
    /**
     * Get ReferenceNbr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getReferenceNbr()
    {
        return isset($this->ReferenceNbr) ? $this->ReferenceNbr : null;
    }
    /**
     * Set ReferenceNbr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $referenceNbr
     * @return \AcumaticaConfig\StructType\PaymentDetail
     */
    public function setReferenceNbr(\AcumaticaConfig\StructType\StringValue $referenceNbr = null)
    {
        if (is_null($referenceNbr) || (is_array($referenceNbr) && empty($referenceNbr))) {
            unset($this->ReferenceNbr);
        } else {
            $this->ReferenceNbr = $referenceNbr;
        }
        return $this;
    }
    /**
     * Get WriteOffReasonCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getWriteOffReasonCode()
    {
        return isset($this->WriteOffReasonCode) ? $this->WriteOffReasonCode : null;
    }
    /**
     * Set WriteOffReasonCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $writeOffReasonCode
     * @return \AcumaticaConfig\StructType\PaymentDetail
     */
    public function setWriteOffReasonCode(\AcumaticaConfig\StructType\StringValue $writeOffReasonCode = null)
    {
        if (is_null($writeOffReasonCode) || (is_array($writeOffReasonCode) && empty($writeOffReasonCode))) {
            unset($this->WriteOffReasonCode);
        } else {
            $this->WriteOffReasonCode = $writeOffReasonCode;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AcumaticaConfig\StructType\PaymentDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
