<?php

namespace AcumaticaConfig\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Packages StructType
 * @subpackage Structs
 */
class Packages extends AbstractStructBase
{
    /**
     * The ShipmentPackage
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\ShipmentPackage[]
     */
    public $ShipmentPackage;
    /**
     * The ShippingBox
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\ShippingBox[]
     */
    public $ShippingBox;
    /**
     * Constructor method for Packages
     * @uses Packages::setShipmentPackage()
     * @uses Packages::setShippingBox()
     * @param \AcumaticaConfig\StructType\ShipmentPackage[] $shipmentPackage
     * @param \AcumaticaConfig\StructType\ShippingBox[] $shippingBox
     */
    public function __construct(array $shipmentPackage = array(), array $shippingBox = array())
    {
        $this
            ->setShipmentPackage($shipmentPackage)
            ->setShippingBox($shippingBox);
    }
    /**
     * Get ShipmentPackage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\ShipmentPackage[]|null
     */
    public function getShipmentPackage()
    {
        return isset($this->ShipmentPackage) ? $this->ShipmentPackage : null;
    }
    /**
     * Set ShipmentPackage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\ShipmentPackage[] $shipmentPackage
     * @return \AcumaticaConfig\StructType\Packages
     */
    public function setShipmentPackage(array $shipmentPackage = array())
    {
        foreach ($shipmentPackage as $packagesShipmentPackageItem) {
            // validation for constraint: itemType
            if (!$packagesShipmentPackageItem instanceof \AcumaticaConfig\StructType\ShipmentPackage) {
                throw new \InvalidArgumentException(sprintf('The ShipmentPackage property can only contain items of \AcumaticaConfig\StructType\ShipmentPackage, "%s" given', is_object($packagesShipmentPackageItem) ? get_class($packagesShipmentPackageItem) : gettype($packagesShipmentPackageItem)), __LINE__);
            }
        }
        if (is_null($shipmentPackage) || (is_array($shipmentPackage) && empty($shipmentPackage))) {
            unset($this->ShipmentPackage);
        } else {
            $this->ShipmentPackage = $shipmentPackage;
        }
        return $this;
    }
    /**
     * Add item to ShipmentPackage value
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\ShipmentPackage $item
     * @return \AcumaticaConfig\StructType\Packages
     */
    public function addToShipmentPackage(\AcumaticaConfig\StructType\ShipmentPackage $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AcumaticaConfig\StructType\ShipmentPackage) {
            throw new \InvalidArgumentException(sprintf('The ShipmentPackage property can only contain items of \AcumaticaConfig\StructType\ShipmentPackage, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ShipmentPackage[] = $item;
        return $this;
    }
    /**
     * Get ShippingBox value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\ShippingBox[]|null
     */
    public function getShippingBox()
    {
        return isset($this->ShippingBox) ? $this->ShippingBox : null;
    }
    /**
     * Set ShippingBox value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\ShippingBox[] $shippingBox
     * @return \AcumaticaConfig\StructType\Packages
     */
    public function setShippingBox(array $shippingBox = array())
    {
        foreach ($shippingBox as $packagesShippingBoxItem) {
            // validation for constraint: itemType
            if (!$packagesShippingBoxItem instanceof \AcumaticaConfig\StructType\ShippingBox) {
                throw new \InvalidArgumentException(sprintf('The ShippingBox property can only contain items of \AcumaticaConfig\StructType\ShippingBox, "%s" given', is_object($packagesShippingBoxItem) ? get_class($packagesShippingBoxItem) : gettype($packagesShippingBoxItem)), __LINE__);
            }
        }
        if (is_null($shippingBox) || (is_array($shippingBox) && empty($shippingBox))) {
            unset($this->ShippingBox);
        } else {
            $this->ShippingBox = $shippingBox;
        }
        return $this;
    }
    /**
     * Add item to ShippingBox value
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\ShippingBox $item
     * @return \AcumaticaConfig\StructType\Packages
     */
    public function addToShippingBox(\AcumaticaConfig\StructType\ShippingBox $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AcumaticaConfig\StructType\ShippingBox) {
            throw new \InvalidArgumentException(sprintf('The ShippingBox property can only contain items of \AcumaticaConfig\StructType\ShippingBox, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ShippingBox[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AcumaticaConfig\StructType\Packages
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
