<?php

namespace AcumaticaConfig\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrdersToApply StructType
 * @subpackage Structs
 */
class OrdersToApply extends AbstractStructBase
{
    /**
     * The PaymentOrderDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\PaymentOrderDetail[]
     */
    public $PaymentOrderDetail;
    /**
     * Constructor method for OrdersToApply
     * @uses OrdersToApply::setPaymentOrderDetail()
     * @param \AcumaticaConfig\StructType\PaymentOrderDetail[] $paymentOrderDetail
     */
    public function __construct(array $paymentOrderDetail = array())
    {
        $this
            ->setPaymentOrderDetail($paymentOrderDetail);
    }
    /**
     * Get PaymentOrderDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\PaymentOrderDetail[]|null
     */
    public function getPaymentOrderDetail()
    {
        return isset($this->PaymentOrderDetail) ? $this->PaymentOrderDetail : null;
    }
    /**
     * Set PaymentOrderDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\PaymentOrderDetail[] $paymentOrderDetail
     * @return \AcumaticaConfig\StructType\OrdersToApply
     */
    public function setPaymentOrderDetail(array $paymentOrderDetail = array())
    {
        foreach ($paymentOrderDetail as $ordersToApplyPaymentOrderDetailItem) {
            // validation for constraint: itemType
            if (!$ordersToApplyPaymentOrderDetailItem instanceof \AcumaticaConfig\StructType\PaymentOrderDetail) {
                throw new \InvalidArgumentException(sprintf('The PaymentOrderDetail property can only contain items of \AcumaticaConfig\StructType\PaymentOrderDetail, "%s" given', is_object($ordersToApplyPaymentOrderDetailItem) ? get_class($ordersToApplyPaymentOrderDetailItem) : gettype($ordersToApplyPaymentOrderDetailItem)), __LINE__);
            }
        }
        if (is_null($paymentOrderDetail) || (is_array($paymentOrderDetail) && empty($paymentOrderDetail))) {
            unset($this->PaymentOrderDetail);
        } else {
            $this->PaymentOrderDetail = $paymentOrderDetail;
        }
        return $this;
    }
    /**
     * Add item to PaymentOrderDetail value
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\PaymentOrderDetail $item
     * @return \AcumaticaConfig\StructType\OrdersToApply
     */
    public function addToPaymentOrderDetail(\AcumaticaConfig\StructType\PaymentOrderDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AcumaticaConfig\StructType\PaymentOrderDetail) {
            throw new \InvalidArgumentException(sprintf('The PaymentOrderDetail property can only contain items of \AcumaticaConfig\StructType\PaymentOrderDetail, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PaymentOrderDetail[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AcumaticaConfig\StructType\OrdersToApply
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
