<?php

namespace AcumaticaConfig\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrdersResult StructType
 * @subpackage Structs
 */
class OrdersResult extends Entity
{
    /**
     * The OrdersResult
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\OrdersResult[]
     */
    public $OrdersResult;
    /**
     * The Count
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\IntValue
     */
    public $Count;
    /**
     * The OrderNbr
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $OrderNbr;
    /**
     * The OrderType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $OrderType;
    /**
     * Constructor method for OrdersResult
     * @uses OrdersResult::setOrdersResult()
     * @uses OrdersResult::setCount()
     * @uses OrdersResult::setOrderNbr()
     * @uses OrdersResult::setOrderType()
     * @param \AcumaticaConfig\StructType\OrdersResult[] $ordersResult
     * @param \AcumaticaConfig\StructType\IntValue $count
     * @param \AcumaticaConfig\StructType\StringValue $orderNbr
     * @param \AcumaticaConfig\StructType\StringValue $orderType
     */
    public function __construct(array $ordersResult = array(), \AcumaticaConfig\StructType\IntValue $count = null, \AcumaticaConfig\StructType\StringValue $orderNbr = null, \AcumaticaConfig\StructType\StringValue $orderType = null)
    {
        $this
            ->setOrdersResult($ordersResult)
            ->setCount($count)
            ->setOrderNbr($orderNbr)
            ->setOrderType($orderType);
    }
    /**
     * Get OrdersResult value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\OrdersResult[]|null
     */
    public function getOrdersResult()
    {
        return isset($this->OrdersResult) ? $this->OrdersResult : null;
    }
    /**
     * Set OrdersResult value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\OrdersResult[] $ordersResult
     * @return \AcumaticaConfig\StructType\OrdersResult
     */
    public function setOrdersResult(array $ordersResult = array())
    {
        foreach ($ordersResult as $ordersResultOrdersResultItem) {
            // validation for constraint: itemType
            if (!$ordersResultOrdersResultItem instanceof \AcumaticaConfig\StructType\OrdersResult) {
                throw new \InvalidArgumentException(sprintf('The OrdersResult property can only contain items of \AcumaticaConfig\StructType\OrdersResult, "%s" given', is_object($ordersResultOrdersResultItem) ? get_class($ordersResultOrdersResultItem) : gettype($ordersResultOrdersResultItem)), __LINE__);
            }
        }
        if (is_null($ordersResult) || (is_array($ordersResult) && empty($ordersResult))) {
            unset($this->OrdersResult);
        } else {
            $this->OrdersResult = $ordersResult;
        }
        return $this;
    }
    /**
     * Add item to OrdersResult value
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\OrdersResult $item
     * @return \AcumaticaConfig\StructType\OrdersResult
     */
    public function addToOrdersResult(\AcumaticaConfig\StructType\OrdersResult $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AcumaticaConfig\StructType\OrdersResult) {
            throw new \InvalidArgumentException(sprintf('The OrdersResult property can only contain items of \AcumaticaConfig\StructType\OrdersResult, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->OrdersResult[] = $item;
        return $this;
    }
    /**
     * Get Count value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\IntValue|null
     */
    public function getCount()
    {
        return isset($this->Count) ? $this->Count : null;
    }
    /**
     * Set Count value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\IntValue $count
     * @return \AcumaticaConfig\StructType\OrdersResult
     */
    public function setCount(\AcumaticaConfig\StructType\IntValue $count = null)
    {
        if (is_null($count) || (is_array($count) && empty($count))) {
            unset($this->Count);
        } else {
            $this->Count = $count;
        }
        return $this;
    }
    /**
     * Get OrderNbr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getOrderNbr()
    {
        return isset($this->OrderNbr) ? $this->OrderNbr : null;
    }
    /**
     * Set OrderNbr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $orderNbr
     * @return \AcumaticaConfig\StructType\OrdersResult
     */
    public function setOrderNbr(\AcumaticaConfig\StructType\StringValue $orderNbr = null)
    {
        if (is_null($orderNbr) || (is_array($orderNbr) && empty($orderNbr))) {
            unset($this->OrderNbr);
        } else {
            $this->OrderNbr = $orderNbr;
        }
        return $this;
    }
    /**
     * Get OrderType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getOrderType()
    {
        return isset($this->OrderType) ? $this->OrderType : null;
    }
    /**
     * Set OrderType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $orderType
     * @return \AcumaticaConfig\StructType\OrdersResult
     */
    public function setOrderType(\AcumaticaConfig\StructType\StringValue $orderType = null)
    {
        if (is_null($orderType) || (is_array($orderType) && empty($orderType))) {
            unset($this->OrderType);
        } else {
            $this->OrderType = $orderType;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AcumaticaConfig\StructType\OrdersResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
