<?php

namespace AcumaticaConfig\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OpportunityProduct StructType
 * @subpackage Structs
 */
class OpportunityProduct extends Entity
{
    /**
     * The Amount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DecimalValue
     */
    public $Amount;
    /**
     * The Discount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DecimalValue
     */
    public $Discount;
    /**
     * The DiscountAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DecimalValue
     */
    public $DiscountAmount;
    /**
     * The DiscountCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $DiscountCode;
    /**
     * The DiscountSequence
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $DiscountSequence;
    /**
     * The ExternalPrice
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DecimalValue
     */
    public $ExternalPrice;
    /**
     * The FreeItem
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\BooleanValue
     */
    public $FreeItem;
    /**
     * The InventoryID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $InventoryID;
    /**
     * The ManualDiscount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\BooleanValue
     */
    public $ManualDiscount;
    /**
     * The OpportunityProductID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\IntValue
     */
    public $OpportunityProductID;
    /**
     * The ProjectTask
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $ProjectTask;
    /**
     * The Qty
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DecimalValue
     */
    public $Qty;
    /**
     * The Subitem
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $Subitem;
    /**
     * The TaxCategory
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $TaxCategory;
    /**
     * The TransactionDescription
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $TransactionDescription;
    /**
     * The UnitPrice
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DecimalValue
     */
    public $UnitPrice;
    /**
     * The UOM
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $UOM;
    /**
     * The Warehouse
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $Warehouse;
    /**
     * Constructor method for OpportunityProduct
     * @uses OpportunityProduct::setAmount()
     * @uses OpportunityProduct::setDiscount()
     * @uses OpportunityProduct::setDiscountAmount()
     * @uses OpportunityProduct::setDiscountCode()
     * @uses OpportunityProduct::setDiscountSequence()
     * @uses OpportunityProduct::setExternalPrice()
     * @uses OpportunityProduct::setFreeItem()
     * @uses OpportunityProduct::setInventoryID()
     * @uses OpportunityProduct::setManualDiscount()
     * @uses OpportunityProduct::setOpportunityProductID()
     * @uses OpportunityProduct::setProjectTask()
     * @uses OpportunityProduct::setQty()
     * @uses OpportunityProduct::setSubitem()
     * @uses OpportunityProduct::setTaxCategory()
     * @uses OpportunityProduct::setTransactionDescription()
     * @uses OpportunityProduct::setUnitPrice()
     * @uses OpportunityProduct::setUOM()
     * @uses OpportunityProduct::setWarehouse()
     * @param \AcumaticaConfig\StructType\DecimalValue $amount
     * @param \AcumaticaConfig\StructType\DecimalValue $discount
     * @param \AcumaticaConfig\StructType\DecimalValue $discountAmount
     * @param \AcumaticaConfig\StructType\StringValue $discountCode
     * @param \AcumaticaConfig\StructType\StringValue $discountSequence
     * @param \AcumaticaConfig\StructType\DecimalValue $externalPrice
     * @param \AcumaticaConfig\StructType\BooleanValue $freeItem
     * @param \AcumaticaConfig\StructType\StringValue $inventoryID
     * @param \AcumaticaConfig\StructType\BooleanValue $manualDiscount
     * @param \AcumaticaConfig\StructType\IntValue $opportunityProductID
     * @param \AcumaticaConfig\StructType\StringValue $projectTask
     * @param \AcumaticaConfig\StructType\DecimalValue $qty
     * @param \AcumaticaConfig\StructType\StringValue $subitem
     * @param \AcumaticaConfig\StructType\StringValue $taxCategory
     * @param \AcumaticaConfig\StructType\StringValue $transactionDescription
     * @param \AcumaticaConfig\StructType\DecimalValue $unitPrice
     * @param \AcumaticaConfig\StructType\StringValue $uOM
     * @param \AcumaticaConfig\StructType\StringValue $warehouse
     */
    public function __construct(\AcumaticaConfig\StructType\DecimalValue $amount = null, \AcumaticaConfig\StructType\DecimalValue $discount = null, \AcumaticaConfig\StructType\DecimalValue $discountAmount = null, \AcumaticaConfig\StructType\StringValue $discountCode = null, \AcumaticaConfig\StructType\StringValue $discountSequence = null, \AcumaticaConfig\StructType\DecimalValue $externalPrice = null, \AcumaticaConfig\StructType\BooleanValue $freeItem = null, \AcumaticaConfig\StructType\StringValue $inventoryID = null, \AcumaticaConfig\StructType\BooleanValue $manualDiscount = null, \AcumaticaConfig\StructType\IntValue $opportunityProductID = null, \AcumaticaConfig\StructType\StringValue $projectTask = null, \AcumaticaConfig\StructType\DecimalValue $qty = null, \AcumaticaConfig\StructType\StringValue $subitem = null, \AcumaticaConfig\StructType\StringValue $taxCategory = null, \AcumaticaConfig\StructType\StringValue $transactionDescription = null, \AcumaticaConfig\StructType\DecimalValue $unitPrice = null, \AcumaticaConfig\StructType\StringValue $uOM = null, \AcumaticaConfig\StructType\StringValue $warehouse = null)
    {
        $this
            ->setAmount($amount)
            ->setDiscount($discount)
            ->setDiscountAmount($discountAmount)
            ->setDiscountCode($discountCode)
            ->setDiscountSequence($discountSequence)
            ->setExternalPrice($externalPrice)
            ->setFreeItem($freeItem)
            ->setInventoryID($inventoryID)
            ->setManualDiscount($manualDiscount)
            ->setOpportunityProductID($opportunityProductID)
            ->setProjectTask($projectTask)
            ->setQty($qty)
            ->setSubitem($subitem)
            ->setTaxCategory($taxCategory)
            ->setTransactionDescription($transactionDescription)
            ->setUnitPrice($unitPrice)
            ->setUOM($uOM)
            ->setWarehouse($warehouse);
    }
    /**
     * Get Amount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DecimalValue|null
     */
    public function getAmount()
    {
        return isset($this->Amount) ? $this->Amount : null;
    }
    /**
     * Set Amount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DecimalValue $amount
     * @return \AcumaticaConfig\StructType\OpportunityProduct
     */
    public function setAmount(\AcumaticaConfig\StructType\DecimalValue $amount = null)
    {
        if (is_null($amount) || (is_array($amount) && empty($amount))) {
            unset($this->Amount);
        } else {
            $this->Amount = $amount;
        }
        return $this;
    }
    /**
     * Get Discount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DecimalValue|null
     */
    public function getDiscount()
    {
        return isset($this->Discount) ? $this->Discount : null;
    }
    /**
     * Set Discount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DecimalValue $discount
     * @return \AcumaticaConfig\StructType\OpportunityProduct
     */
    public function setDiscount(\AcumaticaConfig\StructType\DecimalValue $discount = null)
    {
        if (is_null($discount) || (is_array($discount) && empty($discount))) {
            unset($this->Discount);
        } else {
            $this->Discount = $discount;
        }
        return $this;
    }
    /**
     * Get DiscountAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DecimalValue|null
     */
    public function getDiscountAmount()
    {
        return isset($this->DiscountAmount) ? $this->DiscountAmount : null;
    }
    /**
     * Set DiscountAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DecimalValue $discountAmount
     * @return \AcumaticaConfig\StructType\OpportunityProduct
     */
    public function setDiscountAmount(\AcumaticaConfig\StructType\DecimalValue $discountAmount = null)
    {
        if (is_null($discountAmount) || (is_array($discountAmount) && empty($discountAmount))) {
            unset($this->DiscountAmount);
        } else {
            $this->DiscountAmount = $discountAmount;
        }
        return $this;
    }
    /**
     * Get DiscountCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getDiscountCode()
    {
        return isset($this->DiscountCode) ? $this->DiscountCode : null;
    }
    /**
     * Set DiscountCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $discountCode
     * @return \AcumaticaConfig\StructType\OpportunityProduct
     */
    public function setDiscountCode(\AcumaticaConfig\StructType\StringValue $discountCode = null)
    {
        if (is_null($discountCode) || (is_array($discountCode) && empty($discountCode))) {
            unset($this->DiscountCode);
        } else {
            $this->DiscountCode = $discountCode;
        }
        return $this;
    }
    /**
     * Get DiscountSequence value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getDiscountSequence()
    {
        return isset($this->DiscountSequence) ? $this->DiscountSequence : null;
    }
    /**
     * Set DiscountSequence value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $discountSequence
     * @return \AcumaticaConfig\StructType\OpportunityProduct
     */
    public function setDiscountSequence(\AcumaticaConfig\StructType\StringValue $discountSequence = null)
    {
        if (is_null($discountSequence) || (is_array($discountSequence) && empty($discountSequence))) {
            unset($this->DiscountSequence);
        } else {
            $this->DiscountSequence = $discountSequence;
        }
        return $this;
    }
    /**
     * Get ExternalPrice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DecimalValue|null
     */
    public function getExternalPrice()
    {
        return isset($this->ExternalPrice) ? $this->ExternalPrice : null;
    }
    /**
     * Set ExternalPrice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DecimalValue $externalPrice
     * @return \AcumaticaConfig\StructType\OpportunityProduct
     */
    public function setExternalPrice(\AcumaticaConfig\StructType\DecimalValue $externalPrice = null)
    {
        if (is_null($externalPrice) || (is_array($externalPrice) && empty($externalPrice))) {
            unset($this->ExternalPrice);
        } else {
            $this->ExternalPrice = $externalPrice;
        }
        return $this;
    }
    /**
     * Get FreeItem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\BooleanValue|null
     */
    public function getFreeItem()
    {
        return isset($this->FreeItem) ? $this->FreeItem : null;
    }
    /**
     * Set FreeItem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\BooleanValue $freeItem
     * @return \AcumaticaConfig\StructType\OpportunityProduct
     */
    public function setFreeItem(\AcumaticaConfig\StructType\BooleanValue $freeItem = null)
    {
        if (is_null($freeItem) || (is_array($freeItem) && empty($freeItem))) {
            unset($this->FreeItem);
        } else {
            $this->FreeItem = $freeItem;
        }
        return $this;
    }
    /**
     * Get InventoryID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getInventoryID()
    {
        return isset($this->InventoryID) ? $this->InventoryID : null;
    }
    /**
     * Set InventoryID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $inventoryID
     * @return \AcumaticaConfig\StructType\OpportunityProduct
     */
    public function setInventoryID(\AcumaticaConfig\StructType\StringValue $inventoryID = null)
    {
        if (is_null($inventoryID) || (is_array($inventoryID) && empty($inventoryID))) {
            unset($this->InventoryID);
        } else {
            $this->InventoryID = $inventoryID;
        }
        return $this;
    }
    /**
     * Get ManualDiscount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\BooleanValue|null
     */
    public function getManualDiscount()
    {
        return isset($this->ManualDiscount) ? $this->ManualDiscount : null;
    }
    /**
     * Set ManualDiscount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\BooleanValue $manualDiscount
     * @return \AcumaticaConfig\StructType\OpportunityProduct
     */
    public function setManualDiscount(\AcumaticaConfig\StructType\BooleanValue $manualDiscount = null)
    {
        if (is_null($manualDiscount) || (is_array($manualDiscount) && empty($manualDiscount))) {
            unset($this->ManualDiscount);
        } else {
            $this->ManualDiscount = $manualDiscount;
        }
        return $this;
    }
    /**
     * Get OpportunityProductID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\IntValue|null
     */
    public function getOpportunityProductID()
    {
        return isset($this->OpportunityProductID) ? $this->OpportunityProductID : null;
    }
    /**
     * Set OpportunityProductID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\IntValue $opportunityProductID
     * @return \AcumaticaConfig\StructType\OpportunityProduct
     */
    public function setOpportunityProductID(\AcumaticaConfig\StructType\IntValue $opportunityProductID = null)
    {
        if (is_null($opportunityProductID) || (is_array($opportunityProductID) && empty($opportunityProductID))) {
            unset($this->OpportunityProductID);
        } else {
            $this->OpportunityProductID = $opportunityProductID;
        }
        return $this;
    }
    /**
     * Get ProjectTask value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getProjectTask()
    {
        return isset($this->ProjectTask) ? $this->ProjectTask : null;
    }
    /**
     * Set ProjectTask value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $projectTask
     * @return \AcumaticaConfig\StructType\OpportunityProduct
     */
    public function setProjectTask(\AcumaticaConfig\StructType\StringValue $projectTask = null)
    {
        if (is_null($projectTask) || (is_array($projectTask) && empty($projectTask))) {
            unset($this->ProjectTask);
        } else {
            $this->ProjectTask = $projectTask;
        }
        return $this;
    }
    /**
     * Get Qty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DecimalValue|null
     */
    public function getQty()
    {
        return isset($this->Qty) ? $this->Qty : null;
    }
    /**
     * Set Qty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DecimalValue $qty
     * @return \AcumaticaConfig\StructType\OpportunityProduct
     */
    public function setQty(\AcumaticaConfig\StructType\DecimalValue $qty = null)
    {
        if (is_null($qty) || (is_array($qty) && empty($qty))) {
            unset($this->Qty);
        } else {
            $this->Qty = $qty;
        }
        return $this;
    }
    /**
     * Get Subitem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getSubitem()
    {
        return isset($this->Subitem) ? $this->Subitem : null;
    }
    /**
     * Set Subitem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $subitem
     * @return \AcumaticaConfig\StructType\OpportunityProduct
     */
    public function setSubitem(\AcumaticaConfig\StructType\StringValue $subitem = null)
    {
        if (is_null($subitem) || (is_array($subitem) && empty($subitem))) {
            unset($this->Subitem);
        } else {
            $this->Subitem = $subitem;
        }
        return $this;
    }
    /**
     * Get TaxCategory value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getTaxCategory()
    {
        return isset($this->TaxCategory) ? $this->TaxCategory : null;
    }
    /**
     * Set TaxCategory value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $taxCategory
     * @return \AcumaticaConfig\StructType\OpportunityProduct
     */
    public function setTaxCategory(\AcumaticaConfig\StructType\StringValue $taxCategory = null)
    {
        if (is_null($taxCategory) || (is_array($taxCategory) && empty($taxCategory))) {
            unset($this->TaxCategory);
        } else {
            $this->TaxCategory = $taxCategory;
        }
        return $this;
    }
    /**
     * Get TransactionDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getTransactionDescription()
    {
        return isset($this->TransactionDescription) ? $this->TransactionDescription : null;
    }
    /**
     * Set TransactionDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $transactionDescription
     * @return \AcumaticaConfig\StructType\OpportunityProduct
     */
    public function setTransactionDescription(\AcumaticaConfig\StructType\StringValue $transactionDescription = null)
    {
        if (is_null($transactionDescription) || (is_array($transactionDescription) && empty($transactionDescription))) {
            unset($this->TransactionDescription);
        } else {
            $this->TransactionDescription = $transactionDescription;
        }
        return $this;
    }
    /**
     * Get UnitPrice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DecimalValue|null
     */
    public function getUnitPrice()
    {
        return isset($this->UnitPrice) ? $this->UnitPrice : null;
    }
    /**
     * Set UnitPrice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DecimalValue $unitPrice
     * @return \AcumaticaConfig\StructType\OpportunityProduct
     */
    public function setUnitPrice(\AcumaticaConfig\StructType\DecimalValue $unitPrice = null)
    {
        if (is_null($unitPrice) || (is_array($unitPrice) && empty($unitPrice))) {
            unset($this->UnitPrice);
        } else {
            $this->UnitPrice = $unitPrice;
        }
        return $this;
    }
    /**
     * Get UOM value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getUOM()
    {
        return isset($this->UOM) ? $this->UOM : null;
    }
    /**
     * Set UOM value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $uOM
     * @return \AcumaticaConfig\StructType\OpportunityProduct
     */
    public function setUOM(\AcumaticaConfig\StructType\StringValue $uOM = null)
    {
        if (is_null($uOM) || (is_array($uOM) && empty($uOM))) {
            unset($this->UOM);
        } else {
            $this->UOM = $uOM;
        }
        return $this;
    }
    /**
     * Get Warehouse value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getWarehouse()
    {
        return isset($this->Warehouse) ? $this->Warehouse : null;
    }
    /**
     * Set Warehouse value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $warehouse
     * @return \AcumaticaConfig\StructType\OpportunityProduct
     */
    public function setWarehouse(\AcumaticaConfig\StructType\StringValue $warehouse = null)
    {
        if (is_null($warehouse) || (is_array($warehouse) && empty($warehouse))) {
            unset($this->Warehouse);
        } else {
            $this->Warehouse = $warehouse;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AcumaticaConfig\StructType\OpportunityProduct
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
