<?php

namespace AcumaticaConfig\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Opportunities StructType
 * @subpackage Structs
 */
class Opportunities extends AbstractStructBase
{
    /**
     * The OpportunityDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\OpportunityDetail[]
     */
    public $OpportunityDetail;
    /**
     * The BusinessAccountOpportunityDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\BusinessAccountOpportunityDetail[]
     */
    public $BusinessAccountOpportunityDetail;
    /**
     * Constructor method for Opportunities
     * @uses Opportunities::setOpportunityDetail()
     * @uses Opportunities::setBusinessAccountOpportunityDetail()
     * @param \AcumaticaConfig\StructType\OpportunityDetail[] $opportunityDetail
     * @param \AcumaticaConfig\StructType\BusinessAccountOpportunityDetail[] $businessAccountOpportunityDetail
     */
    public function __construct(array $opportunityDetail = array(), array $businessAccountOpportunityDetail = array())
    {
        $this
            ->setOpportunityDetail($opportunityDetail)
            ->setBusinessAccountOpportunityDetail($businessAccountOpportunityDetail);
    }
    /**
     * Get OpportunityDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\OpportunityDetail[]|null
     */
    public function getOpportunityDetail()
    {
        return isset($this->OpportunityDetail) ? $this->OpportunityDetail : null;
    }
    /**
     * Set OpportunityDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\OpportunityDetail[] $opportunityDetail
     * @return \AcumaticaConfig\StructType\Opportunities
     */
    public function setOpportunityDetail(array $opportunityDetail = array())
    {
        foreach ($opportunityDetail as $opportunitiesOpportunityDetailItem) {
            // validation for constraint: itemType
            if (!$opportunitiesOpportunityDetailItem instanceof \AcumaticaConfig\StructType\OpportunityDetail) {
                throw new \InvalidArgumentException(sprintf('The OpportunityDetail property can only contain items of \AcumaticaConfig\StructType\OpportunityDetail, "%s" given', is_object($opportunitiesOpportunityDetailItem) ? get_class($opportunitiesOpportunityDetailItem) : gettype($opportunitiesOpportunityDetailItem)), __LINE__);
            }
        }
        if (is_null($opportunityDetail) || (is_array($opportunityDetail) && empty($opportunityDetail))) {
            unset($this->OpportunityDetail);
        } else {
            $this->OpportunityDetail = $opportunityDetail;
        }
        return $this;
    }
    /**
     * Add item to OpportunityDetail value
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\OpportunityDetail $item
     * @return \AcumaticaConfig\StructType\Opportunities
     */
    public function addToOpportunityDetail(\AcumaticaConfig\StructType\OpportunityDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AcumaticaConfig\StructType\OpportunityDetail) {
            throw new \InvalidArgumentException(sprintf('The OpportunityDetail property can only contain items of \AcumaticaConfig\StructType\OpportunityDetail, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->OpportunityDetail[] = $item;
        return $this;
    }
    /**
     * Get BusinessAccountOpportunityDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\BusinessAccountOpportunityDetail[]|null
     */
    public function getBusinessAccountOpportunityDetail()
    {
        return isset($this->BusinessAccountOpportunityDetail) ? $this->BusinessAccountOpportunityDetail : null;
    }
    /**
     * Set BusinessAccountOpportunityDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\BusinessAccountOpportunityDetail[] $businessAccountOpportunityDetail
     * @return \AcumaticaConfig\StructType\Opportunities
     */
    public function setBusinessAccountOpportunityDetail(array $businessAccountOpportunityDetail = array())
    {
        foreach ($businessAccountOpportunityDetail as $opportunitiesBusinessAccountOpportunityDetailItem) {
            // validation for constraint: itemType
            if (!$opportunitiesBusinessAccountOpportunityDetailItem instanceof \AcumaticaConfig\StructType\BusinessAccountOpportunityDetail) {
                throw new \InvalidArgumentException(sprintf('The BusinessAccountOpportunityDetail property can only contain items of \AcumaticaConfig\StructType\BusinessAccountOpportunityDetail, "%s" given', is_object($opportunitiesBusinessAccountOpportunityDetailItem) ? get_class($opportunitiesBusinessAccountOpportunityDetailItem) : gettype($opportunitiesBusinessAccountOpportunityDetailItem)), __LINE__);
            }
        }
        if (is_null($businessAccountOpportunityDetail) || (is_array($businessAccountOpportunityDetail) && empty($businessAccountOpportunityDetail))) {
            unset($this->BusinessAccountOpportunityDetail);
        } else {
            $this->BusinessAccountOpportunityDetail = $businessAccountOpportunityDetail;
        }
        return $this;
    }
    /**
     * Add item to BusinessAccountOpportunityDetail value
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\BusinessAccountOpportunityDetail $item
     * @return \AcumaticaConfig\StructType\Opportunities
     */
    public function addToBusinessAccountOpportunityDetail(\AcumaticaConfig\StructType\BusinessAccountOpportunityDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AcumaticaConfig\StructType\BusinessAccountOpportunityDetail) {
            throw new \InvalidArgumentException(sprintf('The BusinessAccountOpportunityDetail property can only contain items of \AcumaticaConfig\StructType\BusinessAccountOpportunityDetail, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->BusinessAccountOpportunityDetail[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AcumaticaConfig\StructType\Opportunities
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
