<?php

namespace AcumaticaConfig\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Notifications StructType
 * @subpackage Structs
 */
class Notifications extends AbstractStructBase
{
    /**
     * The ContactNotification
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\ContactNotification[]
     */
    public $ContactNotification;
    /**
     * Constructor method for Notifications
     * @uses Notifications::setContactNotification()
     * @param \AcumaticaConfig\StructType\ContactNotification[] $contactNotification
     */
    public function __construct(array $contactNotification = array())
    {
        $this
            ->setContactNotification($contactNotification);
    }
    /**
     * Get ContactNotification value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\ContactNotification[]|null
     */
    public function getContactNotification()
    {
        return isset($this->ContactNotification) ? $this->ContactNotification : null;
    }
    /**
     * Set ContactNotification value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\ContactNotification[] $contactNotification
     * @return \AcumaticaConfig\StructType\Notifications
     */
    public function setContactNotification(array $contactNotification = array())
    {
        foreach ($contactNotification as $notificationsContactNotificationItem) {
            // validation for constraint: itemType
            if (!$notificationsContactNotificationItem instanceof \AcumaticaConfig\StructType\ContactNotification) {
                throw new \InvalidArgumentException(sprintf('The ContactNotification property can only contain items of \AcumaticaConfig\StructType\ContactNotification, "%s" given', is_object($notificationsContactNotificationItem) ? get_class($notificationsContactNotificationItem) : gettype($notificationsContactNotificationItem)), __LINE__);
            }
        }
        if (is_null($contactNotification) || (is_array($contactNotification) && empty($contactNotification))) {
            unset($this->ContactNotification);
        } else {
            $this->ContactNotification = $contactNotification;
        }
        return $this;
    }
    /**
     * Add item to ContactNotification value
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\ContactNotification $item
     * @return \AcumaticaConfig\StructType\Notifications
     */
    public function addToContactNotification(\AcumaticaConfig\StructType\ContactNotification $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AcumaticaConfig\StructType\ContactNotification) {
            throw new \InvalidArgumentException(sprintf('The ContactNotification property can only contain items of \AcumaticaConfig\StructType\ContactNotification, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ContactNotification[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AcumaticaConfig\StructType\Notifications
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
