<?php

namespace AcumaticaConfig\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NonStockItem StructType
 * @subpackage Structs
 */
class NonStockItem extends Entity
{
    /**
     * The Active
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\BooleanValue
     */
    public $Active;
    /**
     * The AlternateSearchKeywords
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $AlternateSearchKeywords;
    /**
     * The Attributes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\Attributes
     */
    public $Attributes;
    /**
     * The BaseUnit
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $BaseUnit;
    /**
     * The BestSeller
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\BooleanValue
     */
    public $BestSeller;
    /**
     * The CategoryID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $CategoryID;
    /**
     * The CrossReferences
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\CrossReferences
     */
    public $CrossReferences;
    /**
     * The CrossSellID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $CrossSellID;
    /**
     * The CurrentCost
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DecimalValue
     */
    public $CurrentCost;
    /**
     * The DefaultPrice
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DecimalValue
     */
    public $DefaultPrice;
    /**
     * The DefaultWarehouse
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $DefaultWarehouse;
    /**
     * The DeferralAccount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $DeferralAccount;
    /**
     * The DeferralSubaccount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $DeferralSubaccount;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $Description;
    /**
     * The DescriptionLong
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $DescriptionLong;
    /**
     * The DescriptionShort
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $DescriptionShort;
    /**
     * The EffectiveDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DateTimeValue
     */
    public $EffectiveDate;
    /**
     * The ExpenseAccount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $ExpenseAccount;
    /**
     * The ExpenseAccrualAccount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $ExpenseAccrualAccount;
    /**
     * The ExpenseAccrualSubaccount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $ExpenseAccrualSubaccount;
    /**
     * The ExpenseSubaccount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $ExpenseSubaccount;
    /**
     * The HomePage
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\BooleanValue
     */
    public $HomePage;
    /**
     * The InventoryID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $InventoryID;
    /**
     * The IsKit
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\BooleanValue
     */
    public $IsKit;
    /**
     * The ItemClass
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $ItemClass;
    /**
     * The ItemStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $ItemStatus;
    /**
     * The ItemType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $ItemType;
    /**
     * The LastCost
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DecimalValue
     */
    public $LastCost;
    /**
     * The LastModifiedDateTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DateTimeValue
     */
    public $LastModifiedDateTime;
    /**
     * The MetaDescription
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $MetaDescription;
    /**
     * The MetaKeywords
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $MetaKeywords;
    /**
     * The MetaTitle
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $MetaTitle;
    /**
     * The PendingCost
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DecimalValue
     */
    public $PendingCost;
    /**
     * The PendingCostDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DateTimeValue
     */
    public $PendingCostDate;
    /**
     * The POAccrualAccount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $POAccrualAccount;
    /**
     * The POAccrualSubaccount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $POAccrualSubaccount;
    /**
     * The PostingClass
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $PostingClass;
    /**
     * The PriceClass
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $PriceClass;
    /**
     * The PurchasePriceVarianceAccount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $PurchasePriceVarianceAccount;
    /**
     * The PurchasePriceVarianceSubaccount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $PurchasePriceVarianceSubaccount;
    /**
     * The PurchaseUnit
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $PurchaseUnit;
    /**
     * The ReasonCodeSubaccount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $ReasonCodeSubaccount;
    /**
     * The RequireReceipt
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\BooleanValue
     */
    public $RequireReceipt;
    /**
     * The RequireShipment
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\BooleanValue
     */
    public $RequireShipment;
    /**
     * The SalesAccount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $SalesAccount;
    /**
     * The SalesCategories
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\SalesCategories
     */
    public $SalesCategories;
    /**
     * The SalesSubaccount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $SalesSubaccount;
    /**
     * The SalesUnit
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $SalesUnit;
    /**
     * The TaxCategory
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $TaxCategory;
    /**
     * The UpSellID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $UpSellID;
    /**
     * The URLKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $URLKey;
    /**
     * The VendorDetails
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\VendorDetails
     */
    public $VendorDetails;
    /**
     * The Visibility
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $Visibility;
    /**
     * The Volume
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DecimalValue
     */
    public $Volume;
    /**
     * The VolumeUOM
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $VolumeUOM;
    /**
     * The Weight
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DecimalValue
     */
    public $Weight;
    /**
     * The WeightUOM
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $WeightUOM;
    /**
     * Constructor method for NonStockItem
     * @uses NonStockItem::setActive()
     * @uses NonStockItem::setAlternateSearchKeywords()
     * @uses NonStockItem::setAttributes()
     * @uses NonStockItem::setBaseUnit()
     * @uses NonStockItem::setBestSeller()
     * @uses NonStockItem::setCategoryID()
     * @uses NonStockItem::setCrossReferences()
     * @uses NonStockItem::setCrossSellID()
     * @uses NonStockItem::setCurrentCost()
     * @uses NonStockItem::setDefaultPrice()
     * @uses NonStockItem::setDefaultWarehouse()
     * @uses NonStockItem::setDeferralAccount()
     * @uses NonStockItem::setDeferralSubaccount()
     * @uses NonStockItem::setDescription()
     * @uses NonStockItem::setDescriptionLong()
     * @uses NonStockItem::setDescriptionShort()
     * @uses NonStockItem::setEffectiveDate()
     * @uses NonStockItem::setExpenseAccount()
     * @uses NonStockItem::setExpenseAccrualAccount()
     * @uses NonStockItem::setExpenseAccrualSubaccount()
     * @uses NonStockItem::setExpenseSubaccount()
     * @uses NonStockItem::setHomePage()
     * @uses NonStockItem::setInventoryID()
     * @uses NonStockItem::setIsKit()
     * @uses NonStockItem::setItemClass()
     * @uses NonStockItem::setItemStatus()
     * @uses NonStockItem::setItemType()
     * @uses NonStockItem::setLastCost()
     * @uses NonStockItem::setLastModifiedDateTime()
     * @uses NonStockItem::setMetaDescription()
     * @uses NonStockItem::setMetaKeywords()
     * @uses NonStockItem::setMetaTitle()
     * @uses NonStockItem::setPendingCost()
     * @uses NonStockItem::setPendingCostDate()
     * @uses NonStockItem::setPOAccrualAccount()
     * @uses NonStockItem::setPOAccrualSubaccount()
     * @uses NonStockItem::setPostingClass()
     * @uses NonStockItem::setPriceClass()
     * @uses NonStockItem::setPurchasePriceVarianceAccount()
     * @uses NonStockItem::setPurchasePriceVarianceSubaccount()
     * @uses NonStockItem::setPurchaseUnit()
     * @uses NonStockItem::setReasonCodeSubaccount()
     * @uses NonStockItem::setRequireReceipt()
     * @uses NonStockItem::setRequireShipment()
     * @uses NonStockItem::setSalesAccount()
     * @uses NonStockItem::setSalesCategories()
     * @uses NonStockItem::setSalesSubaccount()
     * @uses NonStockItem::setSalesUnit()
     * @uses NonStockItem::setTaxCategory()
     * @uses NonStockItem::setUpSellID()
     * @uses NonStockItem::setURLKey()
     * @uses NonStockItem::setVendorDetails()
     * @uses NonStockItem::setVisibility()
     * @uses NonStockItem::setVolume()
     * @uses NonStockItem::setVolumeUOM()
     * @uses NonStockItem::setWeight()
     * @uses NonStockItem::setWeightUOM()
     * @param \AcumaticaConfig\StructType\BooleanValue $active
     * @param \AcumaticaConfig\StructType\StringValue $alternateSearchKeywords
     * @param \AcumaticaConfig\StructType\Attributes $attributes
     * @param \AcumaticaConfig\StructType\StringValue $baseUnit
     * @param \AcumaticaConfig\StructType\BooleanValue $bestSeller
     * @param \AcumaticaConfig\StructType\StringValue $categoryID
     * @param \AcumaticaConfig\StructType\CrossReferences $crossReferences
     * @param \AcumaticaConfig\StructType\StringValue $crossSellID
     * @param \AcumaticaConfig\StructType\DecimalValue $currentCost
     * @param \AcumaticaConfig\StructType\DecimalValue $defaultPrice
     * @param \AcumaticaConfig\StructType\StringValue $defaultWarehouse
     * @param \AcumaticaConfig\StructType\StringValue $deferralAccount
     * @param \AcumaticaConfig\StructType\StringValue $deferralSubaccount
     * @param \AcumaticaConfig\StructType\StringValue $description
     * @param \AcumaticaConfig\StructType\StringValue $descriptionLong
     * @param \AcumaticaConfig\StructType\StringValue $descriptionShort
     * @param \AcumaticaConfig\StructType\DateTimeValue $effectiveDate
     * @param \AcumaticaConfig\StructType\StringValue $expenseAccount
     * @param \AcumaticaConfig\StructType\StringValue $expenseAccrualAccount
     * @param \AcumaticaConfig\StructType\StringValue $expenseAccrualSubaccount
     * @param \AcumaticaConfig\StructType\StringValue $expenseSubaccount
     * @param \AcumaticaConfig\StructType\BooleanValue $homePage
     * @param \AcumaticaConfig\StructType\StringValue $inventoryID
     * @param \AcumaticaConfig\StructType\BooleanValue $isKit
     * @param \AcumaticaConfig\StructType\StringValue $itemClass
     * @param \AcumaticaConfig\StructType\StringValue $itemStatus
     * @param \AcumaticaConfig\StructType\StringValue $itemType
     * @param \AcumaticaConfig\StructType\DecimalValue $lastCost
     * @param \AcumaticaConfig\StructType\DateTimeValue $lastModifiedDateTime
     * @param \AcumaticaConfig\StructType\StringValue $metaDescription
     * @param \AcumaticaConfig\StructType\StringValue $metaKeywords
     * @param \AcumaticaConfig\StructType\StringValue $metaTitle
     * @param \AcumaticaConfig\StructType\DecimalValue $pendingCost
     * @param \AcumaticaConfig\StructType\DateTimeValue $pendingCostDate
     * @param \AcumaticaConfig\StructType\StringValue $pOAccrualAccount
     * @param \AcumaticaConfig\StructType\StringValue $pOAccrualSubaccount
     * @param \AcumaticaConfig\StructType\StringValue $postingClass
     * @param \AcumaticaConfig\StructType\StringValue $priceClass
     * @param \AcumaticaConfig\StructType\StringValue $purchasePriceVarianceAccount
     * @param \AcumaticaConfig\StructType\StringValue $purchasePriceVarianceSubaccount
     * @param \AcumaticaConfig\StructType\StringValue $purchaseUnit
     * @param \AcumaticaConfig\StructType\StringValue $reasonCodeSubaccount
     * @param \AcumaticaConfig\StructType\BooleanValue $requireReceipt
     * @param \AcumaticaConfig\StructType\BooleanValue $requireShipment
     * @param \AcumaticaConfig\StructType\StringValue $salesAccount
     * @param \AcumaticaConfig\StructType\SalesCategories $salesCategories
     * @param \AcumaticaConfig\StructType\StringValue $salesSubaccount
     * @param \AcumaticaConfig\StructType\StringValue $salesUnit
     * @param \AcumaticaConfig\StructType\StringValue $taxCategory
     * @param \AcumaticaConfig\StructType\StringValue $upSellID
     * @param \AcumaticaConfig\StructType\StringValue $uRLKey
     * @param \AcumaticaConfig\StructType\VendorDetails $vendorDetails
     * @param \AcumaticaConfig\StructType\StringValue $visibility
     * @param \AcumaticaConfig\StructType\DecimalValue $volume
     * @param \AcumaticaConfig\StructType\StringValue $volumeUOM
     * @param \AcumaticaConfig\StructType\DecimalValue $weight
     * @param \AcumaticaConfig\StructType\StringValue $weightUOM
     */
    public function __construct(\AcumaticaConfig\StructType\BooleanValue $active = null, \AcumaticaConfig\StructType\StringValue $alternateSearchKeywords = null, \AcumaticaConfig\StructType\Attributes $attributes = null, \AcumaticaConfig\StructType\StringValue $baseUnit = null, \AcumaticaConfig\StructType\BooleanValue $bestSeller = null, \AcumaticaConfig\StructType\StringValue $categoryID = null, \AcumaticaConfig\StructType\CrossReferences $crossReferences = null, \AcumaticaConfig\StructType\StringValue $crossSellID = null, \AcumaticaConfig\StructType\DecimalValue $currentCost = null, \AcumaticaConfig\StructType\DecimalValue $defaultPrice = null, \AcumaticaConfig\StructType\StringValue $defaultWarehouse = null, \AcumaticaConfig\StructType\StringValue $deferralAccount = null, \AcumaticaConfig\StructType\StringValue $deferralSubaccount = null, \AcumaticaConfig\StructType\StringValue $description = null, \AcumaticaConfig\StructType\StringValue $descriptionLong = null, \AcumaticaConfig\StructType\StringValue $descriptionShort = null, \AcumaticaConfig\StructType\DateTimeValue $effectiveDate = null, \AcumaticaConfig\StructType\StringValue $expenseAccount = null, \AcumaticaConfig\StructType\StringValue $expenseAccrualAccount = null, \AcumaticaConfig\StructType\StringValue $expenseAccrualSubaccount = null, \AcumaticaConfig\StructType\StringValue $expenseSubaccount = null, \AcumaticaConfig\StructType\BooleanValue $homePage = null, \AcumaticaConfig\StructType\StringValue $inventoryID = null, \AcumaticaConfig\StructType\BooleanValue $isKit = null, \AcumaticaConfig\StructType\StringValue $itemClass = null, \AcumaticaConfig\StructType\StringValue $itemStatus = null, \AcumaticaConfig\StructType\StringValue $itemType = null, \AcumaticaConfig\StructType\DecimalValue $lastCost = null, \AcumaticaConfig\StructType\DateTimeValue $lastModifiedDateTime = null, \AcumaticaConfig\StructType\StringValue $metaDescription = null, \AcumaticaConfig\StructType\StringValue $metaKeywords = null, \AcumaticaConfig\StructType\StringValue $metaTitle = null, \AcumaticaConfig\StructType\DecimalValue $pendingCost = null, \AcumaticaConfig\StructType\DateTimeValue $pendingCostDate = null, \AcumaticaConfig\StructType\StringValue $pOAccrualAccount = null, \AcumaticaConfig\StructType\StringValue $pOAccrualSubaccount = null, \AcumaticaConfig\StructType\StringValue $postingClass = null, \AcumaticaConfig\StructType\StringValue $priceClass = null, \AcumaticaConfig\StructType\StringValue $purchasePriceVarianceAccount = null, \AcumaticaConfig\StructType\StringValue $purchasePriceVarianceSubaccount = null, \AcumaticaConfig\StructType\StringValue $purchaseUnit = null, \AcumaticaConfig\StructType\StringValue $reasonCodeSubaccount = null, \AcumaticaConfig\StructType\BooleanValue $requireReceipt = null, \AcumaticaConfig\StructType\BooleanValue $requireShipment = null, \AcumaticaConfig\StructType\StringValue $salesAccount = null, \AcumaticaConfig\StructType\SalesCategories $salesCategories = null, \AcumaticaConfig\StructType\StringValue $salesSubaccount = null, \AcumaticaConfig\StructType\StringValue $salesUnit = null, \AcumaticaConfig\StructType\StringValue $taxCategory = null, \AcumaticaConfig\StructType\StringValue $upSellID = null, \AcumaticaConfig\StructType\StringValue $uRLKey = null, \AcumaticaConfig\StructType\VendorDetails $vendorDetails = null, \AcumaticaConfig\StructType\StringValue $visibility = null, \AcumaticaConfig\StructType\DecimalValue $volume = null, \AcumaticaConfig\StructType\StringValue $volumeUOM = null, \AcumaticaConfig\StructType\DecimalValue $weight = null, \AcumaticaConfig\StructType\StringValue $weightUOM = null)
    {
        $this
            ->setActive($active)
            ->setAlternateSearchKeywords($alternateSearchKeywords)
            ->setAttributes($attributes)
            ->setBaseUnit($baseUnit)
            ->setBestSeller($bestSeller)
            ->setCategoryID($categoryID)
            ->setCrossReferences($crossReferences)
            ->setCrossSellID($crossSellID)
            ->setCurrentCost($currentCost)
            ->setDefaultPrice($defaultPrice)
            ->setDefaultWarehouse($defaultWarehouse)
            ->setDeferralAccount($deferralAccount)
            ->setDeferralSubaccount($deferralSubaccount)
            ->setDescription($description)
            ->setDescriptionLong($descriptionLong)
            ->setDescriptionShort($descriptionShort)
            ->setEffectiveDate($effectiveDate)
            ->setExpenseAccount($expenseAccount)
            ->setExpenseAccrualAccount($expenseAccrualAccount)
            ->setExpenseAccrualSubaccount($expenseAccrualSubaccount)
            ->setExpenseSubaccount($expenseSubaccount)
            ->setHomePage($homePage)
            ->setInventoryID($inventoryID)
            ->setIsKit($isKit)
            ->setItemClass($itemClass)
            ->setItemStatus($itemStatus)
            ->setItemType($itemType)
            ->setLastCost($lastCost)
            ->setLastModifiedDateTime($lastModifiedDateTime)
            ->setMetaDescription($metaDescription)
            ->setMetaKeywords($metaKeywords)
            ->setMetaTitle($metaTitle)
            ->setPendingCost($pendingCost)
            ->setPendingCostDate($pendingCostDate)
            ->setPOAccrualAccount($pOAccrualAccount)
            ->setPOAccrualSubaccount($pOAccrualSubaccount)
            ->setPostingClass($postingClass)
            ->setPriceClass($priceClass)
            ->setPurchasePriceVarianceAccount($purchasePriceVarianceAccount)
            ->setPurchasePriceVarianceSubaccount($purchasePriceVarianceSubaccount)
            ->setPurchaseUnit($purchaseUnit)
            ->setReasonCodeSubaccount($reasonCodeSubaccount)
            ->setRequireReceipt($requireReceipt)
            ->setRequireShipment($requireShipment)
            ->setSalesAccount($salesAccount)
            ->setSalesCategories($salesCategories)
            ->setSalesSubaccount($salesSubaccount)
            ->setSalesUnit($salesUnit)
            ->setTaxCategory($taxCategory)
            ->setUpSellID($upSellID)
            ->setURLKey($uRLKey)
            ->setVendorDetails($vendorDetails)
            ->setVisibility($visibility)
            ->setVolume($volume)
            ->setVolumeUOM($volumeUOM)
            ->setWeight($weight)
            ->setWeightUOM($weightUOM);
    }
    /**
     * Get Active value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\BooleanValue|null
     */
    public function getActive()
    {
        return isset($this->Active) ? $this->Active : null;
    }
    /**
     * Set Active value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\BooleanValue $active
     * @return \AcumaticaConfig\StructType\NonStockItem
     */
    public function setActive(\AcumaticaConfig\StructType\BooleanValue $active = null)
    {
        if (is_null($active) || (is_array($active) && empty($active))) {
            unset($this->Active);
        } else {
            $this->Active = $active;
        }
        return $this;
    }
    /**
     * Get AlternateSearchKeywords value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getAlternateSearchKeywords()
    {
        return isset($this->AlternateSearchKeywords) ? $this->AlternateSearchKeywords : null;
    }
    /**
     * Set AlternateSearchKeywords value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $alternateSearchKeywords
     * @return \AcumaticaConfig\StructType\NonStockItem
     */
    public function setAlternateSearchKeywords(\AcumaticaConfig\StructType\StringValue $alternateSearchKeywords = null)
    {
        if (is_null($alternateSearchKeywords) || (is_array($alternateSearchKeywords) && empty($alternateSearchKeywords))) {
            unset($this->AlternateSearchKeywords);
        } else {
            $this->AlternateSearchKeywords = $alternateSearchKeywords;
        }
        return $this;
    }
    /**
     * Get Attributes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\Attributes|null
     */
    public function getAttributes()
    {
        return isset($this->Attributes) ? $this->Attributes : null;
    }
    /**
     * Set Attributes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\Attributes $attributes
     * @return \AcumaticaConfig\StructType\NonStockItem
     */
    public function setAttributes(\AcumaticaConfig\StructType\Attributes $attributes = null)
    {
        if (is_null($attributes) || (is_array($attributes) && empty($attributes))) {
            unset($this->Attributes);
        } else {
            $this->Attributes = $attributes;
        }
        return $this;
    }
    /**
     * Get BaseUnit value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getBaseUnit()
    {
        return isset($this->BaseUnit) ? $this->BaseUnit : null;
    }
    /**
     * Set BaseUnit value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $baseUnit
     * @return \AcumaticaConfig\StructType\NonStockItem
     */
    public function setBaseUnit(\AcumaticaConfig\StructType\StringValue $baseUnit = null)
    {
        if (is_null($baseUnit) || (is_array($baseUnit) && empty($baseUnit))) {
            unset($this->BaseUnit);
        } else {
            $this->BaseUnit = $baseUnit;
        }
        return $this;
    }
    /**
     * Get BestSeller value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\BooleanValue|null
     */
    public function getBestSeller()
    {
        return isset($this->BestSeller) ? $this->BestSeller : null;
    }
    /**
     * Set BestSeller value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\BooleanValue $bestSeller
     * @return \AcumaticaConfig\StructType\NonStockItem
     */
    public function setBestSeller(\AcumaticaConfig\StructType\BooleanValue $bestSeller = null)
    {
        if (is_null($bestSeller) || (is_array($bestSeller) && empty($bestSeller))) {
            unset($this->BestSeller);
        } else {
            $this->BestSeller = $bestSeller;
        }
        return $this;
    }
    /**
     * Get CategoryID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getCategoryID()
    {
        return isset($this->CategoryID) ? $this->CategoryID : null;
    }
    /**
     * Set CategoryID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $categoryID
     * @return \AcumaticaConfig\StructType\NonStockItem
     */
    public function setCategoryID(\AcumaticaConfig\StructType\StringValue $categoryID = null)
    {
        if (is_null($categoryID) || (is_array($categoryID) && empty($categoryID))) {
            unset($this->CategoryID);
        } else {
            $this->CategoryID = $categoryID;
        }
        return $this;
    }
    /**
     * Get CrossReferences value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\CrossReferences|null
     */
    public function getCrossReferences()
    {
        return isset($this->CrossReferences) ? $this->CrossReferences : null;
    }
    /**
     * Set CrossReferences value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\CrossReferences $crossReferences
     * @return \AcumaticaConfig\StructType\NonStockItem
     */
    public function setCrossReferences(\AcumaticaConfig\StructType\CrossReferences $crossReferences = null)
    {
        if (is_null($crossReferences) || (is_array($crossReferences) && empty($crossReferences))) {
            unset($this->CrossReferences);
        } else {
            $this->CrossReferences = $crossReferences;
        }
        return $this;
    }
    /**
     * Get CrossSellID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getCrossSellID()
    {
        return isset($this->CrossSellID) ? $this->CrossSellID : null;
    }
    /**
     * Set CrossSellID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $crossSellID
     * @return \AcumaticaConfig\StructType\NonStockItem
     */
    public function setCrossSellID(\AcumaticaConfig\StructType\StringValue $crossSellID = null)
    {
        if (is_null($crossSellID) || (is_array($crossSellID) && empty($crossSellID))) {
            unset($this->CrossSellID);
        } else {
            $this->CrossSellID = $crossSellID;
        }
        return $this;
    }
    /**
     * Get CurrentCost value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DecimalValue|null
     */
    public function getCurrentCost()
    {
        return isset($this->CurrentCost) ? $this->CurrentCost : null;
    }
    /**
     * Set CurrentCost value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DecimalValue $currentCost
     * @return \AcumaticaConfig\StructType\NonStockItem
     */
    public function setCurrentCost(\AcumaticaConfig\StructType\DecimalValue $currentCost = null)
    {
        if (is_null($currentCost) || (is_array($currentCost) && empty($currentCost))) {
            unset($this->CurrentCost);
        } else {
            $this->CurrentCost = $currentCost;
        }
        return $this;
    }
    /**
     * Get DefaultPrice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DecimalValue|null
     */
    public function getDefaultPrice()
    {
        return isset($this->DefaultPrice) ? $this->DefaultPrice : null;
    }
    /**
     * Set DefaultPrice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DecimalValue $defaultPrice
     * @return \AcumaticaConfig\StructType\NonStockItem
     */
    public function setDefaultPrice(\AcumaticaConfig\StructType\DecimalValue $defaultPrice = null)
    {
        if (is_null($defaultPrice) || (is_array($defaultPrice) && empty($defaultPrice))) {
            unset($this->DefaultPrice);
        } else {
            $this->DefaultPrice = $defaultPrice;
        }
        return $this;
    }
    /**
     * Get DefaultWarehouse value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getDefaultWarehouse()
    {
        return isset($this->DefaultWarehouse) ? $this->DefaultWarehouse : null;
    }
    /**
     * Set DefaultWarehouse value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $defaultWarehouse
     * @return \AcumaticaConfig\StructType\NonStockItem
     */
    public function setDefaultWarehouse(\AcumaticaConfig\StructType\StringValue $defaultWarehouse = null)
    {
        if (is_null($defaultWarehouse) || (is_array($defaultWarehouse) && empty($defaultWarehouse))) {
            unset($this->DefaultWarehouse);
        } else {
            $this->DefaultWarehouse = $defaultWarehouse;
        }
        return $this;
    }
    /**
     * Get DeferralAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getDeferralAccount()
    {
        return isset($this->DeferralAccount) ? $this->DeferralAccount : null;
    }
    /**
     * Set DeferralAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $deferralAccount
     * @return \AcumaticaConfig\StructType\NonStockItem
     */
    public function setDeferralAccount(\AcumaticaConfig\StructType\StringValue $deferralAccount = null)
    {
        if (is_null($deferralAccount) || (is_array($deferralAccount) && empty($deferralAccount))) {
            unset($this->DeferralAccount);
        } else {
            $this->DeferralAccount = $deferralAccount;
        }
        return $this;
    }
    /**
     * Get DeferralSubaccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getDeferralSubaccount()
    {
        return isset($this->DeferralSubaccount) ? $this->DeferralSubaccount : null;
    }
    /**
     * Set DeferralSubaccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $deferralSubaccount
     * @return \AcumaticaConfig\StructType\NonStockItem
     */
    public function setDeferralSubaccount(\AcumaticaConfig\StructType\StringValue $deferralSubaccount = null)
    {
        if (is_null($deferralSubaccount) || (is_array($deferralSubaccount) && empty($deferralSubaccount))) {
            unset($this->DeferralSubaccount);
        } else {
            $this->DeferralSubaccount = $deferralSubaccount;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $description
     * @return \AcumaticaConfig\StructType\NonStockItem
     */
    public function setDescription(\AcumaticaConfig\StructType\StringValue $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get DescriptionLong value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getDescriptionLong()
    {
        return isset($this->DescriptionLong) ? $this->DescriptionLong : null;
    }
    /**
     * Set DescriptionLong value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $descriptionLong
     * @return \AcumaticaConfig\StructType\NonStockItem
     */
    public function setDescriptionLong(\AcumaticaConfig\StructType\StringValue $descriptionLong = null)
    {
        if (is_null($descriptionLong) || (is_array($descriptionLong) && empty($descriptionLong))) {
            unset($this->DescriptionLong);
        } else {
            $this->DescriptionLong = $descriptionLong;
        }
        return $this;
    }
    /**
     * Get DescriptionShort value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getDescriptionShort()
    {
        return isset($this->DescriptionShort) ? $this->DescriptionShort : null;
    }
    /**
     * Set DescriptionShort value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $descriptionShort
     * @return \AcumaticaConfig\StructType\NonStockItem
     */
    public function setDescriptionShort(\AcumaticaConfig\StructType\StringValue $descriptionShort = null)
    {
        if (is_null($descriptionShort) || (is_array($descriptionShort) && empty($descriptionShort))) {
            unset($this->DescriptionShort);
        } else {
            $this->DescriptionShort = $descriptionShort;
        }
        return $this;
    }
    /**
     * Get EffectiveDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DateTimeValue|null
     */
    public function getEffectiveDate()
    {
        return isset($this->EffectiveDate) ? $this->EffectiveDate : null;
    }
    /**
     * Set EffectiveDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DateTimeValue $effectiveDate
     * @return \AcumaticaConfig\StructType\NonStockItem
     */
    public function setEffectiveDate(\AcumaticaConfig\StructType\DateTimeValue $effectiveDate = null)
    {
        if (is_null($effectiveDate) || (is_array($effectiveDate) && empty($effectiveDate))) {
            unset($this->EffectiveDate);
        } else {
            $this->EffectiveDate = $effectiveDate;
        }
        return $this;
    }
    /**
     * Get ExpenseAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getExpenseAccount()
    {
        return isset($this->ExpenseAccount) ? $this->ExpenseAccount : null;
    }
    /**
     * Set ExpenseAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $expenseAccount
     * @return \AcumaticaConfig\StructType\NonStockItem
     */
    public function setExpenseAccount(\AcumaticaConfig\StructType\StringValue $expenseAccount = null)
    {
        if (is_null($expenseAccount) || (is_array($expenseAccount) && empty($expenseAccount))) {
            unset($this->ExpenseAccount);
        } else {
            $this->ExpenseAccount = $expenseAccount;
        }
        return $this;
    }
    /**
     * Get ExpenseAccrualAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getExpenseAccrualAccount()
    {
        return isset($this->ExpenseAccrualAccount) ? $this->ExpenseAccrualAccount : null;
    }
    /**
     * Set ExpenseAccrualAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $expenseAccrualAccount
     * @return \AcumaticaConfig\StructType\NonStockItem
     */
    public function setExpenseAccrualAccount(\AcumaticaConfig\StructType\StringValue $expenseAccrualAccount = null)
    {
        if (is_null($expenseAccrualAccount) || (is_array($expenseAccrualAccount) && empty($expenseAccrualAccount))) {
            unset($this->ExpenseAccrualAccount);
        } else {
            $this->ExpenseAccrualAccount = $expenseAccrualAccount;
        }
        return $this;
    }
    /**
     * Get ExpenseAccrualSubaccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getExpenseAccrualSubaccount()
    {
        return isset($this->ExpenseAccrualSubaccount) ? $this->ExpenseAccrualSubaccount : null;
    }
    /**
     * Set ExpenseAccrualSubaccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $expenseAccrualSubaccount
     * @return \AcumaticaConfig\StructType\NonStockItem
     */
    public function setExpenseAccrualSubaccount(\AcumaticaConfig\StructType\StringValue $expenseAccrualSubaccount = null)
    {
        if (is_null($expenseAccrualSubaccount) || (is_array($expenseAccrualSubaccount) && empty($expenseAccrualSubaccount))) {
            unset($this->ExpenseAccrualSubaccount);
        } else {
            $this->ExpenseAccrualSubaccount = $expenseAccrualSubaccount;
        }
        return $this;
    }
    /**
     * Get ExpenseSubaccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getExpenseSubaccount()
    {
        return isset($this->ExpenseSubaccount) ? $this->ExpenseSubaccount : null;
    }
    /**
     * Set ExpenseSubaccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $expenseSubaccount
     * @return \AcumaticaConfig\StructType\NonStockItem
     */
    public function setExpenseSubaccount(\AcumaticaConfig\StructType\StringValue $expenseSubaccount = null)
    {
        if (is_null($expenseSubaccount) || (is_array($expenseSubaccount) && empty($expenseSubaccount))) {
            unset($this->ExpenseSubaccount);
        } else {
            $this->ExpenseSubaccount = $expenseSubaccount;
        }
        return $this;
    }
    /**
     * Get HomePage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\BooleanValue|null
     */
    public function getHomePage()
    {
        return isset($this->HomePage) ? $this->HomePage : null;
    }
    /**
     * Set HomePage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\BooleanValue $homePage
     * @return \AcumaticaConfig\StructType\NonStockItem
     */
    public function setHomePage(\AcumaticaConfig\StructType\BooleanValue $homePage = null)
    {
        if (is_null($homePage) || (is_array($homePage) && empty($homePage))) {
            unset($this->HomePage);
        } else {
            $this->HomePage = $homePage;
        }
        return $this;
    }
    /**
     * Get InventoryID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getInventoryID()
    {
        return isset($this->InventoryID) ? $this->InventoryID : null;
    }
    /**
     * Set InventoryID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $inventoryID
     * @return \AcumaticaConfig\StructType\NonStockItem
     */
    public function setInventoryID(\AcumaticaConfig\StructType\StringValue $inventoryID = null)
    {
        if (is_null($inventoryID) || (is_array($inventoryID) && empty($inventoryID))) {
            unset($this->InventoryID);
        } else {
            $this->InventoryID = $inventoryID;
        }
        return $this;
    }
    /**
     * Get IsKit value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\BooleanValue|null
     */
    public function getIsKit()
    {
        return isset($this->IsKit) ? $this->IsKit : null;
    }
    /**
     * Set IsKit value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\BooleanValue $isKit
     * @return \AcumaticaConfig\StructType\NonStockItem
     */
    public function setIsKit(\AcumaticaConfig\StructType\BooleanValue $isKit = null)
    {
        if (is_null($isKit) || (is_array($isKit) && empty($isKit))) {
            unset($this->IsKit);
        } else {
            $this->IsKit = $isKit;
        }
        return $this;
    }
    /**
     * Get ItemClass value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getItemClass()
    {
        return isset($this->ItemClass) ? $this->ItemClass : null;
    }
    /**
     * Set ItemClass value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $itemClass
     * @return \AcumaticaConfig\StructType\NonStockItem
     */
    public function setItemClass(\AcumaticaConfig\StructType\StringValue $itemClass = null)
    {
        if (is_null($itemClass) || (is_array($itemClass) && empty($itemClass))) {
            unset($this->ItemClass);
        } else {
            $this->ItemClass = $itemClass;
        }
        return $this;
    }
    /**
     * Get ItemStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getItemStatus()
    {
        return isset($this->ItemStatus) ? $this->ItemStatus : null;
    }
    /**
     * Set ItemStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $itemStatus
     * @return \AcumaticaConfig\StructType\NonStockItem
     */
    public function setItemStatus(\AcumaticaConfig\StructType\StringValue $itemStatus = null)
    {
        if (is_null($itemStatus) || (is_array($itemStatus) && empty($itemStatus))) {
            unset($this->ItemStatus);
        } else {
            $this->ItemStatus = $itemStatus;
        }
        return $this;
    }
    /**
     * Get ItemType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getItemType()
    {
        return isset($this->ItemType) ? $this->ItemType : null;
    }
    /**
     * Set ItemType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $itemType
     * @return \AcumaticaConfig\StructType\NonStockItem
     */
    public function setItemType(\AcumaticaConfig\StructType\StringValue $itemType = null)
    {
        if (is_null($itemType) || (is_array($itemType) && empty($itemType))) {
            unset($this->ItemType);
        } else {
            $this->ItemType = $itemType;
        }
        return $this;
    }
    /**
     * Get LastCost value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DecimalValue|null
     */
    public function getLastCost()
    {
        return isset($this->LastCost) ? $this->LastCost : null;
    }
    /**
     * Set LastCost value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DecimalValue $lastCost
     * @return \AcumaticaConfig\StructType\NonStockItem
     */
    public function setLastCost(\AcumaticaConfig\StructType\DecimalValue $lastCost = null)
    {
        if (is_null($lastCost) || (is_array($lastCost) && empty($lastCost))) {
            unset($this->LastCost);
        } else {
            $this->LastCost = $lastCost;
        }
        return $this;
    }
    /**
     * Get LastModifiedDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DateTimeValue|null
     */
    public function getLastModifiedDateTime()
    {
        return isset($this->LastModifiedDateTime) ? $this->LastModifiedDateTime : null;
    }
    /**
     * Set LastModifiedDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DateTimeValue $lastModifiedDateTime
     * @return \AcumaticaConfig\StructType\NonStockItem
     */
    public function setLastModifiedDateTime(\AcumaticaConfig\StructType\DateTimeValue $lastModifiedDateTime = null)
    {
        if (is_null($lastModifiedDateTime) || (is_array($lastModifiedDateTime) && empty($lastModifiedDateTime))) {
            unset($this->LastModifiedDateTime);
        } else {
            $this->LastModifiedDateTime = $lastModifiedDateTime;
        }
        return $this;
    }
    /**
     * Get MetaDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getMetaDescription()
    {
        return isset($this->MetaDescription) ? $this->MetaDescription : null;
    }
    /**
     * Set MetaDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $metaDescription
     * @return \AcumaticaConfig\StructType\NonStockItem
     */
    public function setMetaDescription(\AcumaticaConfig\StructType\StringValue $metaDescription = null)
    {
        if (is_null($metaDescription) || (is_array($metaDescription) && empty($metaDescription))) {
            unset($this->MetaDescription);
        } else {
            $this->MetaDescription = $metaDescription;
        }
        return $this;
    }
    /**
     * Get MetaKeywords value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getMetaKeywords()
    {
        return isset($this->MetaKeywords) ? $this->MetaKeywords : null;
    }
    /**
     * Set MetaKeywords value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $metaKeywords
     * @return \AcumaticaConfig\StructType\NonStockItem
     */
    public function setMetaKeywords(\AcumaticaConfig\StructType\StringValue $metaKeywords = null)
    {
        if (is_null($metaKeywords) || (is_array($metaKeywords) && empty($metaKeywords))) {
            unset($this->MetaKeywords);
        } else {
            $this->MetaKeywords = $metaKeywords;
        }
        return $this;
    }
    /**
     * Get MetaTitle value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getMetaTitle()
    {
        return isset($this->MetaTitle) ? $this->MetaTitle : null;
    }
    /**
     * Set MetaTitle value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $metaTitle
     * @return \AcumaticaConfig\StructType\NonStockItem
     */
    public function setMetaTitle(\AcumaticaConfig\StructType\StringValue $metaTitle = null)
    {
        if (is_null($metaTitle) || (is_array($metaTitle) && empty($metaTitle))) {
            unset($this->MetaTitle);
        } else {
            $this->MetaTitle = $metaTitle;
        }
        return $this;
    }
    /**
     * Get PendingCost value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DecimalValue|null
     */
    public function getPendingCost()
    {
        return isset($this->PendingCost) ? $this->PendingCost : null;
    }
    /**
     * Set PendingCost value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DecimalValue $pendingCost
     * @return \AcumaticaConfig\StructType\NonStockItem
     */
    public function setPendingCost(\AcumaticaConfig\StructType\DecimalValue $pendingCost = null)
    {
        if (is_null($pendingCost) || (is_array($pendingCost) && empty($pendingCost))) {
            unset($this->PendingCost);
        } else {
            $this->PendingCost = $pendingCost;
        }
        return $this;
    }
    /**
     * Get PendingCostDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DateTimeValue|null
     */
    public function getPendingCostDate()
    {
        return isset($this->PendingCostDate) ? $this->PendingCostDate : null;
    }
    /**
     * Set PendingCostDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DateTimeValue $pendingCostDate
     * @return \AcumaticaConfig\StructType\NonStockItem
     */
    public function setPendingCostDate(\AcumaticaConfig\StructType\DateTimeValue $pendingCostDate = null)
    {
        if (is_null($pendingCostDate) || (is_array($pendingCostDate) && empty($pendingCostDate))) {
            unset($this->PendingCostDate);
        } else {
            $this->PendingCostDate = $pendingCostDate;
        }
        return $this;
    }
    /**
     * Get POAccrualAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getPOAccrualAccount()
    {
        return isset($this->POAccrualAccount) ? $this->POAccrualAccount : null;
    }
    /**
     * Set POAccrualAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $pOAccrualAccount
     * @return \AcumaticaConfig\StructType\NonStockItem
     */
    public function setPOAccrualAccount(\AcumaticaConfig\StructType\StringValue $pOAccrualAccount = null)
    {
        if (is_null($pOAccrualAccount) || (is_array($pOAccrualAccount) && empty($pOAccrualAccount))) {
            unset($this->POAccrualAccount);
        } else {
            $this->POAccrualAccount = $pOAccrualAccount;
        }
        return $this;
    }
    /**
     * Get POAccrualSubaccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getPOAccrualSubaccount()
    {
        return isset($this->POAccrualSubaccount) ? $this->POAccrualSubaccount : null;
    }
    /**
     * Set POAccrualSubaccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $pOAccrualSubaccount
     * @return \AcumaticaConfig\StructType\NonStockItem
     */
    public function setPOAccrualSubaccount(\AcumaticaConfig\StructType\StringValue $pOAccrualSubaccount = null)
    {
        if (is_null($pOAccrualSubaccount) || (is_array($pOAccrualSubaccount) && empty($pOAccrualSubaccount))) {
            unset($this->POAccrualSubaccount);
        } else {
            $this->POAccrualSubaccount = $pOAccrualSubaccount;
        }
        return $this;
    }
    /**
     * Get PostingClass value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getPostingClass()
    {
        return isset($this->PostingClass) ? $this->PostingClass : null;
    }
    /**
     * Set PostingClass value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $postingClass
     * @return \AcumaticaConfig\StructType\NonStockItem
     */
    public function setPostingClass(\AcumaticaConfig\StructType\StringValue $postingClass = null)
    {
        if (is_null($postingClass) || (is_array($postingClass) && empty($postingClass))) {
            unset($this->PostingClass);
        } else {
            $this->PostingClass = $postingClass;
        }
        return $this;
    }
    /**
     * Get PriceClass value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getPriceClass()
    {
        return isset($this->PriceClass) ? $this->PriceClass : null;
    }
    /**
     * Set PriceClass value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $priceClass
     * @return \AcumaticaConfig\StructType\NonStockItem
     */
    public function setPriceClass(\AcumaticaConfig\StructType\StringValue $priceClass = null)
    {
        if (is_null($priceClass) || (is_array($priceClass) && empty($priceClass))) {
            unset($this->PriceClass);
        } else {
            $this->PriceClass = $priceClass;
        }
        return $this;
    }
    /**
     * Get PurchasePriceVarianceAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getPurchasePriceVarianceAccount()
    {
        return isset($this->PurchasePriceVarianceAccount) ? $this->PurchasePriceVarianceAccount : null;
    }
    /**
     * Set PurchasePriceVarianceAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $purchasePriceVarianceAccount
     * @return \AcumaticaConfig\StructType\NonStockItem
     */
    public function setPurchasePriceVarianceAccount(\AcumaticaConfig\StructType\StringValue $purchasePriceVarianceAccount = null)
    {
        if (is_null($purchasePriceVarianceAccount) || (is_array($purchasePriceVarianceAccount) && empty($purchasePriceVarianceAccount))) {
            unset($this->PurchasePriceVarianceAccount);
        } else {
            $this->PurchasePriceVarianceAccount = $purchasePriceVarianceAccount;
        }
        return $this;
    }
    /**
     * Get PurchasePriceVarianceSubaccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getPurchasePriceVarianceSubaccount()
    {
        return isset($this->PurchasePriceVarianceSubaccount) ? $this->PurchasePriceVarianceSubaccount : null;
    }
    /**
     * Set PurchasePriceVarianceSubaccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $purchasePriceVarianceSubaccount
     * @return \AcumaticaConfig\StructType\NonStockItem
     */
    public function setPurchasePriceVarianceSubaccount(\AcumaticaConfig\StructType\StringValue $purchasePriceVarianceSubaccount = null)
    {
        if (is_null($purchasePriceVarianceSubaccount) || (is_array($purchasePriceVarianceSubaccount) && empty($purchasePriceVarianceSubaccount))) {
            unset($this->PurchasePriceVarianceSubaccount);
        } else {
            $this->PurchasePriceVarianceSubaccount = $purchasePriceVarianceSubaccount;
        }
        return $this;
    }
    /**
     * Get PurchaseUnit value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getPurchaseUnit()
    {
        return isset($this->PurchaseUnit) ? $this->PurchaseUnit : null;
    }
    /**
     * Set PurchaseUnit value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $purchaseUnit
     * @return \AcumaticaConfig\StructType\NonStockItem
     */
    public function setPurchaseUnit(\AcumaticaConfig\StructType\StringValue $purchaseUnit = null)
    {
        if (is_null($purchaseUnit) || (is_array($purchaseUnit) && empty($purchaseUnit))) {
            unset($this->PurchaseUnit);
        } else {
            $this->PurchaseUnit = $purchaseUnit;
        }
        return $this;
    }
    /**
     * Get ReasonCodeSubaccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getReasonCodeSubaccount()
    {
        return isset($this->ReasonCodeSubaccount) ? $this->ReasonCodeSubaccount : null;
    }
    /**
     * Set ReasonCodeSubaccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $reasonCodeSubaccount
     * @return \AcumaticaConfig\StructType\NonStockItem
     */
    public function setReasonCodeSubaccount(\AcumaticaConfig\StructType\StringValue $reasonCodeSubaccount = null)
    {
        if (is_null($reasonCodeSubaccount) || (is_array($reasonCodeSubaccount) && empty($reasonCodeSubaccount))) {
            unset($this->ReasonCodeSubaccount);
        } else {
            $this->ReasonCodeSubaccount = $reasonCodeSubaccount;
        }
        return $this;
    }
    /**
     * Get RequireReceipt value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\BooleanValue|null
     */
    public function getRequireReceipt()
    {
        return isset($this->RequireReceipt) ? $this->RequireReceipt : null;
    }
    /**
     * Set RequireReceipt value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\BooleanValue $requireReceipt
     * @return \AcumaticaConfig\StructType\NonStockItem
     */
    public function setRequireReceipt(\AcumaticaConfig\StructType\BooleanValue $requireReceipt = null)
    {
        if (is_null($requireReceipt) || (is_array($requireReceipt) && empty($requireReceipt))) {
            unset($this->RequireReceipt);
        } else {
            $this->RequireReceipt = $requireReceipt;
        }
        return $this;
    }
    /**
     * Get RequireShipment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\BooleanValue|null
     */
    public function getRequireShipment()
    {
        return isset($this->RequireShipment) ? $this->RequireShipment : null;
    }
    /**
     * Set RequireShipment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\BooleanValue $requireShipment
     * @return \AcumaticaConfig\StructType\NonStockItem
     */
    public function setRequireShipment(\AcumaticaConfig\StructType\BooleanValue $requireShipment = null)
    {
        if (is_null($requireShipment) || (is_array($requireShipment) && empty($requireShipment))) {
            unset($this->RequireShipment);
        } else {
            $this->RequireShipment = $requireShipment;
        }
        return $this;
    }
    /**
     * Get SalesAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getSalesAccount()
    {
        return isset($this->SalesAccount) ? $this->SalesAccount : null;
    }
    /**
     * Set SalesAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $salesAccount
     * @return \AcumaticaConfig\StructType\NonStockItem
     */
    public function setSalesAccount(\AcumaticaConfig\StructType\StringValue $salesAccount = null)
    {
        if (is_null($salesAccount) || (is_array($salesAccount) && empty($salesAccount))) {
            unset($this->SalesAccount);
        } else {
            $this->SalesAccount = $salesAccount;
        }
        return $this;
    }
    /**
     * Get SalesCategories value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\SalesCategories|null
     */
    public function getSalesCategories()
    {
        return isset($this->SalesCategories) ? $this->SalesCategories : null;
    }
    /**
     * Set SalesCategories value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\SalesCategories $salesCategories
     * @return \AcumaticaConfig\StructType\NonStockItem
     */
    public function setSalesCategories(\AcumaticaConfig\StructType\SalesCategories $salesCategories = null)
    {
        if (is_null($salesCategories) || (is_array($salesCategories) && empty($salesCategories))) {
            unset($this->SalesCategories);
        } else {
            $this->SalesCategories = $salesCategories;
        }
        return $this;
    }
    /**
     * Get SalesSubaccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getSalesSubaccount()
    {
        return isset($this->SalesSubaccount) ? $this->SalesSubaccount : null;
    }
    /**
     * Set SalesSubaccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $salesSubaccount
     * @return \AcumaticaConfig\StructType\NonStockItem
     */
    public function setSalesSubaccount(\AcumaticaConfig\StructType\StringValue $salesSubaccount = null)
    {
        if (is_null($salesSubaccount) || (is_array($salesSubaccount) && empty($salesSubaccount))) {
            unset($this->SalesSubaccount);
        } else {
            $this->SalesSubaccount = $salesSubaccount;
        }
        return $this;
    }
    /**
     * Get SalesUnit value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getSalesUnit()
    {
        return isset($this->SalesUnit) ? $this->SalesUnit : null;
    }
    /**
     * Set SalesUnit value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $salesUnit
     * @return \AcumaticaConfig\StructType\NonStockItem
     */
    public function setSalesUnit(\AcumaticaConfig\StructType\StringValue $salesUnit = null)
    {
        if (is_null($salesUnit) || (is_array($salesUnit) && empty($salesUnit))) {
            unset($this->SalesUnit);
        } else {
            $this->SalesUnit = $salesUnit;
        }
        return $this;
    }
    /**
     * Get TaxCategory value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getTaxCategory()
    {
        return isset($this->TaxCategory) ? $this->TaxCategory : null;
    }
    /**
     * Set TaxCategory value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $taxCategory
     * @return \AcumaticaConfig\StructType\NonStockItem
     */
    public function setTaxCategory(\AcumaticaConfig\StructType\StringValue $taxCategory = null)
    {
        if (is_null($taxCategory) || (is_array($taxCategory) && empty($taxCategory))) {
            unset($this->TaxCategory);
        } else {
            $this->TaxCategory = $taxCategory;
        }
        return $this;
    }
    /**
     * Get UpSellID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getUpSellID()
    {
        return isset($this->UpSellID) ? $this->UpSellID : null;
    }
    /**
     * Set UpSellID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $upSellID
     * @return \AcumaticaConfig\StructType\NonStockItem
     */
    public function setUpSellID(\AcumaticaConfig\StructType\StringValue $upSellID = null)
    {
        if (is_null($upSellID) || (is_array($upSellID) && empty($upSellID))) {
            unset($this->UpSellID);
        } else {
            $this->UpSellID = $upSellID;
        }
        return $this;
    }
    /**
     * Get URLKey value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getURLKey()
    {
        return isset($this->URLKey) ? $this->URLKey : null;
    }
    /**
     * Set URLKey value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $uRLKey
     * @return \AcumaticaConfig\StructType\NonStockItem
     */
    public function setURLKey(\AcumaticaConfig\StructType\StringValue $uRLKey = null)
    {
        if (is_null($uRLKey) || (is_array($uRLKey) && empty($uRLKey))) {
            unset($this->URLKey);
        } else {
            $this->URLKey = $uRLKey;
        }
        return $this;
    }
    /**
     * Get VendorDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\VendorDetails|null
     */
    public function getVendorDetails()
    {
        return isset($this->VendorDetails) ? $this->VendorDetails : null;
    }
    /**
     * Set VendorDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\VendorDetails $vendorDetails
     * @return \AcumaticaConfig\StructType\NonStockItem
     */
    public function setVendorDetails(\AcumaticaConfig\StructType\VendorDetails $vendorDetails = null)
    {
        if (is_null($vendorDetails) || (is_array($vendorDetails) && empty($vendorDetails))) {
            unset($this->VendorDetails);
        } else {
            $this->VendorDetails = $vendorDetails;
        }
        return $this;
    }
    /**
     * Get Visibility value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getVisibility()
    {
        return isset($this->Visibility) ? $this->Visibility : null;
    }
    /**
     * Set Visibility value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $visibility
     * @return \AcumaticaConfig\StructType\NonStockItem
     */
    public function setVisibility(\AcumaticaConfig\StructType\StringValue $visibility = null)
    {
        if (is_null($visibility) || (is_array($visibility) && empty($visibility))) {
            unset($this->Visibility);
        } else {
            $this->Visibility = $visibility;
        }
        return $this;
    }
    /**
     * Get Volume value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DecimalValue|null
     */
    public function getVolume()
    {
        return isset($this->Volume) ? $this->Volume : null;
    }
    /**
     * Set Volume value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DecimalValue $volume
     * @return \AcumaticaConfig\StructType\NonStockItem
     */
    public function setVolume(\AcumaticaConfig\StructType\DecimalValue $volume = null)
    {
        if (is_null($volume) || (is_array($volume) && empty($volume))) {
            unset($this->Volume);
        } else {
            $this->Volume = $volume;
        }
        return $this;
    }
    /**
     * Get VolumeUOM value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getVolumeUOM()
    {
        return isset($this->VolumeUOM) ? $this->VolumeUOM : null;
    }
    /**
     * Set VolumeUOM value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $volumeUOM
     * @return \AcumaticaConfig\StructType\NonStockItem
     */
    public function setVolumeUOM(\AcumaticaConfig\StructType\StringValue $volumeUOM = null)
    {
        if (is_null($volumeUOM) || (is_array($volumeUOM) && empty($volumeUOM))) {
            unset($this->VolumeUOM);
        } else {
            $this->VolumeUOM = $volumeUOM;
        }
        return $this;
    }
    /**
     * Get Weight value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DecimalValue|null
     */
    public function getWeight()
    {
        return isset($this->Weight) ? $this->Weight : null;
    }
    /**
     * Set Weight value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DecimalValue $weight
     * @return \AcumaticaConfig\StructType\NonStockItem
     */
    public function setWeight(\AcumaticaConfig\StructType\DecimalValue $weight = null)
    {
        if (is_null($weight) || (is_array($weight) && empty($weight))) {
            unset($this->Weight);
        } else {
            $this->Weight = $weight;
        }
        return $this;
    }
    /**
     * Get WeightUOM value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getWeightUOM()
    {
        return isset($this->WeightUOM) ? $this->WeightUOM : null;
    }
    /**
     * Set WeightUOM value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $weightUOM
     * @return \AcumaticaConfig\StructType\NonStockItem
     */
    public function setWeightUOM(\AcumaticaConfig\StructType\StringValue $weightUOM = null)
    {
        if (is_null($weightUOM) || (is_array($weightUOM) && empty($weightUOM))) {
            unset($this->WeightUOM);
        } else {
            $this->WeightUOM = $weightUOM;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AcumaticaConfig\StructType\NonStockItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
