<?php

namespace AcumaticaConfig\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NonProductResults StructType
 * @subpackage Structs
 */
class NonProductResults extends Entity
{
    /**
     * The NonProductResults
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\NonProductResults[]
     */
    public $NonProductResults;
    /**
     * The DefaultPrice
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DecimalValue
     */
    public $DefaultPrice;
    /**
     * The InventoryID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $InventoryID;
    /**
     * The Selected
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\BooleanValue
     */
    public $Selected;
    /**
     * Constructor method for NonProductResults
     * @uses NonProductResults::setNonProductResults()
     * @uses NonProductResults::setDefaultPrice()
     * @uses NonProductResults::setInventoryID()
     * @uses NonProductResults::setSelected()
     * @param \AcumaticaConfig\StructType\NonProductResults[] $nonProductResults
     * @param \AcumaticaConfig\StructType\DecimalValue $defaultPrice
     * @param \AcumaticaConfig\StructType\StringValue $inventoryID
     * @param \AcumaticaConfig\StructType\BooleanValue $selected
     */
    public function __construct(array $nonProductResults = array(), \AcumaticaConfig\StructType\DecimalValue $defaultPrice = null, \AcumaticaConfig\StructType\StringValue $inventoryID = null, \AcumaticaConfig\StructType\BooleanValue $selected = null)
    {
        $this
            ->setNonProductResults($nonProductResults)
            ->setDefaultPrice($defaultPrice)
            ->setInventoryID($inventoryID)
            ->setSelected($selected);
    }
    /**
     * Get NonProductResults value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\NonProductResults[]|null
     */
    public function getNonProductResults()
    {
        return isset($this->NonProductResults) ? $this->NonProductResults : null;
    }
    /**
     * Set NonProductResults value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\NonProductResults[] $nonProductResults
     * @return \AcumaticaConfig\StructType\NonProductResults
     */
    public function setNonProductResults(array $nonProductResults = array())
    {
        foreach ($nonProductResults as $nonProductResultsNonProductResultsItem) {
            // validation for constraint: itemType
            if (!$nonProductResultsNonProductResultsItem instanceof \AcumaticaConfig\StructType\NonProductResults) {
                throw new \InvalidArgumentException(sprintf('The NonProductResults property can only contain items of \AcumaticaConfig\StructType\NonProductResults, "%s" given', is_object($nonProductResultsNonProductResultsItem) ? get_class($nonProductResultsNonProductResultsItem) : gettype($nonProductResultsNonProductResultsItem)), __LINE__);
            }
        }
        if (is_null($nonProductResults) || (is_array($nonProductResults) && empty($nonProductResults))) {
            unset($this->NonProductResults);
        } else {
            $this->NonProductResults = $nonProductResults;
        }
        return $this;
    }
    /**
     * Add item to NonProductResults value
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\NonProductResults $item
     * @return \AcumaticaConfig\StructType\NonProductResults
     */
    public function addToNonProductResults(\AcumaticaConfig\StructType\NonProductResults $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AcumaticaConfig\StructType\NonProductResults) {
            throw new \InvalidArgumentException(sprintf('The NonProductResults property can only contain items of \AcumaticaConfig\StructType\NonProductResults, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->NonProductResults[] = $item;
        return $this;
    }
    /**
     * Get DefaultPrice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DecimalValue|null
     */
    public function getDefaultPrice()
    {
        return isset($this->DefaultPrice) ? $this->DefaultPrice : null;
    }
    /**
     * Set DefaultPrice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DecimalValue $defaultPrice
     * @return \AcumaticaConfig\StructType\NonProductResults
     */
    public function setDefaultPrice(\AcumaticaConfig\StructType\DecimalValue $defaultPrice = null)
    {
        if (is_null($defaultPrice) || (is_array($defaultPrice) && empty($defaultPrice))) {
            unset($this->DefaultPrice);
        } else {
            $this->DefaultPrice = $defaultPrice;
        }
        return $this;
    }
    /**
     * Get InventoryID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getInventoryID()
    {
        return isset($this->InventoryID) ? $this->InventoryID : null;
    }
    /**
     * Set InventoryID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $inventoryID
     * @return \AcumaticaConfig\StructType\NonProductResults
     */
    public function setInventoryID(\AcumaticaConfig\StructType\StringValue $inventoryID = null)
    {
        if (is_null($inventoryID) || (is_array($inventoryID) && empty($inventoryID))) {
            unset($this->InventoryID);
        } else {
            $this->InventoryID = $inventoryID;
        }
        return $this;
    }
    /**
     * Get Selected value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\BooleanValue|null
     */
    public function getSelected()
    {
        return isset($this->Selected) ? $this->Selected : null;
    }
    /**
     * Set Selected value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\BooleanValue $selected
     * @return \AcumaticaConfig\StructType\NonProductResults
     */
    public function setSelected(\AcumaticaConfig\StructType\BooleanValue $selected = null)
    {
        if (is_null($selected) || (is_array($selected) && empty($selected))) {
            unset($this->Selected);
        } else {
            $this->Selected = $selected;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AcumaticaConfig\StructType\NonProductResults
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
