<?php

namespace AcumaticaConfig\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Members StructType
 * @subpackage Structs
 */
class Members extends Entity
{
    /**
     * The InventoryID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $InventoryID;
    /**
     * The ItemSalesCategoryMember
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\ItemSalesCategoryMember[]
     */
    public $ItemSalesCategoryMember;
    /**
     * Constructor method for Members
     * @uses Members::setInventoryID()
     * @uses Members::setItemSalesCategoryMember()
     * @param \AcumaticaConfig\StructType\StringValue $inventoryID
     * @param \AcumaticaConfig\StructType\ItemSalesCategoryMember[] $itemSalesCategoryMember
     */
    public function __construct(\AcumaticaConfig\StructType\StringValue $inventoryID = null, array $itemSalesCategoryMember = array())
    {
        $this
            ->setInventoryID($inventoryID)
            ->setItemSalesCategoryMember($itemSalesCategoryMember);
    }
    /**
     * Get InventoryID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getInventoryID()
    {
        return isset($this->InventoryID) ? $this->InventoryID : null;
    }
    /**
     * Set InventoryID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $inventoryID
     * @return \AcumaticaConfig\StructType\Members
     */
    public function setInventoryID(\AcumaticaConfig\StructType\StringValue $inventoryID = null)
    {
        if (is_null($inventoryID) || (is_array($inventoryID) && empty($inventoryID))) {
            unset($this->InventoryID);
        } else {
            $this->InventoryID = $inventoryID;
        }
        return $this;
    }
    /**
     * Get ItemSalesCategoryMember value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\ItemSalesCategoryMember[]|null
     */
    public function getItemSalesCategoryMember()
    {
        return isset($this->ItemSalesCategoryMember) ? $this->ItemSalesCategoryMember : null;
    }
    /**
     * Set ItemSalesCategoryMember value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\ItemSalesCategoryMember[] $itemSalesCategoryMember
     * @return \AcumaticaConfig\StructType\Members
     */
    public function setItemSalesCategoryMember(array $itemSalesCategoryMember = array())
    {
        foreach ($itemSalesCategoryMember as $membersItemSalesCategoryMemberItem) {
            // validation for constraint: itemType
            if (!$membersItemSalesCategoryMemberItem instanceof \AcumaticaConfig\StructType\ItemSalesCategoryMember) {
                throw new \InvalidArgumentException(sprintf('The ItemSalesCategoryMember property can only contain items of \AcumaticaConfig\StructType\ItemSalesCategoryMember, "%s" given', is_object($membersItemSalesCategoryMemberItem) ? get_class($membersItemSalesCategoryMemberItem) : gettype($membersItemSalesCategoryMemberItem)), __LINE__);
            }
        }
        if (is_null($itemSalesCategoryMember) || (is_array($itemSalesCategoryMember) && empty($itemSalesCategoryMember))) {
            unset($this->ItemSalesCategoryMember);
        } else {
            $this->ItemSalesCategoryMember = $itemSalesCategoryMember;
        }
        return $this;
    }
    /**
     * Add item to ItemSalesCategoryMember value
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\ItemSalesCategoryMember $item
     * @return \AcumaticaConfig\StructType\Members
     */
    public function addToItemSalesCategoryMember(\AcumaticaConfig\StructType\ItemSalesCategoryMember $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AcumaticaConfig\StructType\ItemSalesCategoryMember) {
            throw new \InvalidArgumentException(sprintf('The ItemSalesCategoryMember property can only contain items of \AcumaticaConfig\StructType\ItemSalesCategoryMember, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ItemSalesCategoryMember[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AcumaticaConfig\StructType\Members
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
