<?php

namespace AcumaticaConfig\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Locations StructType
 * @subpackage Structs
 */
class Locations extends AbstractStructBase
{
    /**
     * The BusinessAccountLocation
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\BusinessAccountLocation[]
     */
    public $BusinessAccountLocation;
    /**
     * The WarehouseLocation
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\WarehouseLocation[]
     */
    public $WarehouseLocation;
    /**
     * Constructor method for Locations
     * @uses Locations::setBusinessAccountLocation()
     * @uses Locations::setWarehouseLocation()
     * @param \AcumaticaConfig\StructType\BusinessAccountLocation[] $businessAccountLocation
     * @param \AcumaticaConfig\StructType\WarehouseLocation[] $warehouseLocation
     */
    public function __construct(array $businessAccountLocation = array(), array $warehouseLocation = array())
    {
        $this
            ->setBusinessAccountLocation($businessAccountLocation)
            ->setWarehouseLocation($warehouseLocation);
    }
    /**
     * Get BusinessAccountLocation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\BusinessAccountLocation[]|null
     */
    public function getBusinessAccountLocation()
    {
        return isset($this->BusinessAccountLocation) ? $this->BusinessAccountLocation : null;
    }
    /**
     * Set BusinessAccountLocation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\BusinessAccountLocation[] $businessAccountLocation
     * @return \AcumaticaConfig\StructType\Locations
     */
    public function setBusinessAccountLocation(array $businessAccountLocation = array())
    {
        foreach ($businessAccountLocation as $locationsBusinessAccountLocationItem) {
            // validation for constraint: itemType
            if (!$locationsBusinessAccountLocationItem instanceof \AcumaticaConfig\StructType\BusinessAccountLocation) {
                throw new \InvalidArgumentException(sprintf('The BusinessAccountLocation property can only contain items of \AcumaticaConfig\StructType\BusinessAccountLocation, "%s" given', is_object($locationsBusinessAccountLocationItem) ? get_class($locationsBusinessAccountLocationItem) : gettype($locationsBusinessAccountLocationItem)), __LINE__);
            }
        }
        if (is_null($businessAccountLocation) || (is_array($businessAccountLocation) && empty($businessAccountLocation))) {
            unset($this->BusinessAccountLocation);
        } else {
            $this->BusinessAccountLocation = $businessAccountLocation;
        }
        return $this;
    }
    /**
     * Add item to BusinessAccountLocation value
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\BusinessAccountLocation $item
     * @return \AcumaticaConfig\StructType\Locations
     */
    public function addToBusinessAccountLocation(\AcumaticaConfig\StructType\BusinessAccountLocation $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AcumaticaConfig\StructType\BusinessAccountLocation) {
            throw new \InvalidArgumentException(sprintf('The BusinessAccountLocation property can only contain items of \AcumaticaConfig\StructType\BusinessAccountLocation, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->BusinessAccountLocation[] = $item;
        return $this;
    }
    /**
     * Get WarehouseLocation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\WarehouseLocation[]|null
     */
    public function getWarehouseLocation()
    {
        return isset($this->WarehouseLocation) ? $this->WarehouseLocation : null;
    }
    /**
     * Set WarehouseLocation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\WarehouseLocation[] $warehouseLocation
     * @return \AcumaticaConfig\StructType\Locations
     */
    public function setWarehouseLocation(array $warehouseLocation = array())
    {
        foreach ($warehouseLocation as $locationsWarehouseLocationItem) {
            // validation for constraint: itemType
            if (!$locationsWarehouseLocationItem instanceof \AcumaticaConfig\StructType\WarehouseLocation) {
                throw new \InvalidArgumentException(sprintf('The WarehouseLocation property can only contain items of \AcumaticaConfig\StructType\WarehouseLocation, "%s" given', is_object($locationsWarehouseLocationItem) ? get_class($locationsWarehouseLocationItem) : gettype($locationsWarehouseLocationItem)), __LINE__);
            }
        }
        if (is_null($warehouseLocation) || (is_array($warehouseLocation) && empty($warehouseLocation))) {
            unset($this->WarehouseLocation);
        } else {
            $this->WarehouseLocation = $warehouseLocation;
        }
        return $this;
    }
    /**
     * Add item to WarehouseLocation value
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\WarehouseLocation $item
     * @return \AcumaticaConfig\StructType\Locations
     */
    public function addToWarehouseLocation(\AcumaticaConfig\StructType\WarehouseLocation $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AcumaticaConfig\StructType\WarehouseLocation) {
            throw new \InvalidArgumentException(sprintf('The WarehouseLocation property can only contain items of \AcumaticaConfig\StructType\WarehouseLocation, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->WarehouseLocation[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AcumaticaConfig\StructType\Locations
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
