<?php

namespace AcumaticaConfig\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for KitSpecification StructType
 * @subpackage Structs
 */
class KitSpecification extends Entity
{
    /**
     * The Active
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\BooleanValue
     */
    public $Active;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $Description;
    /**
     * The IsNonStock
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\BooleanValue
     */
    public $IsNonStock;
    /**
     * The KitInventoryID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $KitInventoryID;
    /**
     * The NonStockComponents
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\NonStockComponents
     */
    public $NonStockComponents;
    /**
     * The RevisionID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $RevisionID;
    /**
     * The StockComponents
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StockComponents
     */
    public $StockComponents;
    /**
     * Constructor method for KitSpecification
     * @uses KitSpecification::setActive()
     * @uses KitSpecification::setDescription()
     * @uses KitSpecification::setIsNonStock()
     * @uses KitSpecification::setKitInventoryID()
     * @uses KitSpecification::setNonStockComponents()
     * @uses KitSpecification::setRevisionID()
     * @uses KitSpecification::setStockComponents()
     * @param \AcumaticaConfig\StructType\BooleanValue $active
     * @param \AcumaticaConfig\StructType\StringValue $description
     * @param \AcumaticaConfig\StructType\BooleanValue $isNonStock
     * @param \AcumaticaConfig\StructType\StringValue $kitInventoryID
     * @param \AcumaticaConfig\StructType\NonStockComponents $nonStockComponents
     * @param \AcumaticaConfig\StructType\StringValue $revisionID
     * @param \AcumaticaConfig\StructType\StockComponents $stockComponents
     */
    public function __construct(\AcumaticaConfig\StructType\BooleanValue $active = null, \AcumaticaConfig\StructType\StringValue $description = null, \AcumaticaConfig\StructType\BooleanValue $isNonStock = null, \AcumaticaConfig\StructType\StringValue $kitInventoryID = null, \AcumaticaConfig\StructType\NonStockComponents $nonStockComponents = null, \AcumaticaConfig\StructType\StringValue $revisionID = null, \AcumaticaConfig\StructType\StockComponents $stockComponents = null)
    {
        $this
            ->setActive($active)
            ->setDescription($description)
            ->setIsNonStock($isNonStock)
            ->setKitInventoryID($kitInventoryID)
            ->setNonStockComponents($nonStockComponents)
            ->setRevisionID($revisionID)
            ->setStockComponents($stockComponents);
    }
    /**
     * Get Active value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\BooleanValue|null
     */
    public function getActive()
    {
        return isset($this->Active) ? $this->Active : null;
    }
    /**
     * Set Active value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\BooleanValue $active
     * @return \AcumaticaConfig\StructType\KitSpecification
     */
    public function setActive(\AcumaticaConfig\StructType\BooleanValue $active = null)
    {
        if (is_null($active) || (is_array($active) && empty($active))) {
            unset($this->Active);
        } else {
            $this->Active = $active;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $description
     * @return \AcumaticaConfig\StructType\KitSpecification
     */
    public function setDescription(\AcumaticaConfig\StructType\StringValue $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get IsNonStock value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\BooleanValue|null
     */
    public function getIsNonStock()
    {
        return isset($this->IsNonStock) ? $this->IsNonStock : null;
    }
    /**
     * Set IsNonStock value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\BooleanValue $isNonStock
     * @return \AcumaticaConfig\StructType\KitSpecification
     */
    public function setIsNonStock(\AcumaticaConfig\StructType\BooleanValue $isNonStock = null)
    {
        if (is_null($isNonStock) || (is_array($isNonStock) && empty($isNonStock))) {
            unset($this->IsNonStock);
        } else {
            $this->IsNonStock = $isNonStock;
        }
        return $this;
    }
    /**
     * Get KitInventoryID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getKitInventoryID()
    {
        return isset($this->KitInventoryID) ? $this->KitInventoryID : null;
    }
    /**
     * Set KitInventoryID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $kitInventoryID
     * @return \AcumaticaConfig\StructType\KitSpecification
     */
    public function setKitInventoryID(\AcumaticaConfig\StructType\StringValue $kitInventoryID = null)
    {
        if (is_null($kitInventoryID) || (is_array($kitInventoryID) && empty($kitInventoryID))) {
            unset($this->KitInventoryID);
        } else {
            $this->KitInventoryID = $kitInventoryID;
        }
        return $this;
    }
    /**
     * Get NonStockComponents value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\NonStockComponents|null
     */
    public function getNonStockComponents()
    {
        return isset($this->NonStockComponents) ? $this->NonStockComponents : null;
    }
    /**
     * Set NonStockComponents value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\NonStockComponents $nonStockComponents
     * @return \AcumaticaConfig\StructType\KitSpecification
     */
    public function setNonStockComponents(\AcumaticaConfig\StructType\NonStockComponents $nonStockComponents = null)
    {
        if (is_null($nonStockComponents) || (is_array($nonStockComponents) && empty($nonStockComponents))) {
            unset($this->NonStockComponents);
        } else {
            $this->NonStockComponents = $nonStockComponents;
        }
        return $this;
    }
    /**
     * Get RevisionID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getRevisionID()
    {
        return isset($this->RevisionID) ? $this->RevisionID : null;
    }
    /**
     * Set RevisionID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $revisionID
     * @return \AcumaticaConfig\StructType\KitSpecification
     */
    public function setRevisionID(\AcumaticaConfig\StructType\StringValue $revisionID = null)
    {
        if (is_null($revisionID) || (is_array($revisionID) && empty($revisionID))) {
            unset($this->RevisionID);
        } else {
            $this->RevisionID = $revisionID;
        }
        return $this;
    }
    /**
     * Get StockComponents value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StockComponents|null
     */
    public function getStockComponents()
    {
        return isset($this->StockComponents) ? $this->StockComponents : null;
    }
    /**
     * Set StockComponents value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StockComponents $stockComponents
     * @return \AcumaticaConfig\StructType\KitSpecification
     */
    public function setStockComponents(\AcumaticaConfig\StructType\StockComponents $stockComponents = null)
    {
        if (is_null($stockComponents) || (is_array($stockComponents) && empty($stockComponents))) {
            unset($this->StockComponents);
        } else {
            $this->StockComponents = $stockComponents;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AcumaticaConfig\StructType\KitSpecification
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
