<?php

namespace AcumaticaConfig\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Items StructType
 * @subpackage Structs
 */
class Items extends AbstractStructBase
{
    /**
     * The DiscountItemDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DiscountItemDetail[]
     */
    public $DiscountItemDetail;
    /**
     * Constructor method for Items
     * @uses Items::setDiscountItemDetail()
     * @param \AcumaticaConfig\StructType\DiscountItemDetail[] $discountItemDetail
     */
    public function __construct(array $discountItemDetail = array())
    {
        $this
            ->setDiscountItemDetail($discountItemDetail);
    }
    /**
     * Get DiscountItemDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DiscountItemDetail[]|null
     */
    public function getDiscountItemDetail()
    {
        return isset($this->DiscountItemDetail) ? $this->DiscountItemDetail : null;
    }
    /**
     * Set DiscountItemDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\DiscountItemDetail[] $discountItemDetail
     * @return \AcumaticaConfig\StructType\Items
     */
    public function setDiscountItemDetail(array $discountItemDetail = array())
    {
        foreach ($discountItemDetail as $itemsDiscountItemDetailItem) {
            // validation for constraint: itemType
            if (!$itemsDiscountItemDetailItem instanceof \AcumaticaConfig\StructType\DiscountItemDetail) {
                throw new \InvalidArgumentException(sprintf('The DiscountItemDetail property can only contain items of \AcumaticaConfig\StructType\DiscountItemDetail, "%s" given', is_object($itemsDiscountItemDetailItem) ? get_class($itemsDiscountItemDetailItem) : gettype($itemsDiscountItemDetailItem)), __LINE__);
            }
        }
        if (is_null($discountItemDetail) || (is_array($discountItemDetail) && empty($discountItemDetail))) {
            unset($this->DiscountItemDetail);
        } else {
            $this->DiscountItemDetail = $discountItemDetail;
        }
        return $this;
    }
    /**
     * Add item to DiscountItemDetail value
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\DiscountItemDetail $item
     * @return \AcumaticaConfig\StructType\Items
     */
    public function addToDiscountItemDetail(\AcumaticaConfig\StructType\DiscountItemDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AcumaticaConfig\StructType\DiscountItemDetail) {
            throw new \InvalidArgumentException(sprintf('The DiscountItemDetail property can only contain items of \AcumaticaConfig\StructType\DiscountItemDetail, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->DiscountItemDetail[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AcumaticaConfig\StructType\Items
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
