<?php

namespace AcumaticaConfig\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ItemWarehouse StructType
 * @subpackage Structs
 */
class ItemWarehouse extends Entity
{
    /**
     * The CreatedDateTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DateTimeValue
     */
    public $CreatedDateTime;
    /**
     * The DefaultIssueFrom
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $DefaultIssueFrom;
    /**
     * The DefaultReceiptTo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $DefaultReceiptTo;
    /**
     * The DefaultSubitem
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $DefaultSubitem;
    /**
     * The InventoryAccount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $InventoryAccount;
    /**
     * The InventoryID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $InventoryID;
    /**
     * The InventorySubaccount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $InventorySubaccount;
    /**
     * The LastModifiedDateTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DateTimeValue
     */
    public $LastModifiedDateTime;
    /**
     * The MSRP
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DecimalValue
     */
    public $MSRP;
    /**
     * The OverrideInventoryAccountSubaccount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\BooleanValue
     */
    public $OverrideInventoryAccountSubaccount;
    /**
     * The OverridePreferredVendor
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\BooleanValue
     */
    public $OverridePreferredVendor;
    /**
     * The OverridePrice
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\BooleanValue
     */
    public $OverridePrice;
    /**
     * The OverrideReplenishmentSettings
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\BooleanValue
     */
    public $OverrideReplenishmentSettings;
    /**
     * The OverrideServiceLevelOverride
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\BooleanValue
     */
    public $OverrideServiceLevelOverride;
    /**
     * The OverrideStandardCost
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\BooleanValue
     */
    public $OverrideStandardCost;
    /**
     * The PreferredLocation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $PreferredLocation;
    /**
     * The PreferredVendor
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $PreferredVendor;
    /**
     * The ProductManager
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $ProductManager;
    /**
     * The ProductWorkgroup
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $ProductWorkgroup;
    /**
     * The ReplenishmentClass
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $ReplenishmentClass;
    /**
     * The ReplenishmentMethod
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $ReplenishmentMethod;
    /**
     * The ReplenishmentSource
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $ReplenishmentSource;
    /**
     * The ReplenishmentWarehouse
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $ReplenishmentWarehouse;
    /**
     * The Seasonality
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $Seasonality;
    /**
     * The ServiceLevel
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DecimalValue
     */
    public $ServiceLevel;
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $Status;
    /**
     * The WarehouseID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $WarehouseID;
    /**
     * Constructor method for ItemWarehouse
     * @uses ItemWarehouse::setCreatedDateTime()
     * @uses ItemWarehouse::setDefaultIssueFrom()
     * @uses ItemWarehouse::setDefaultReceiptTo()
     * @uses ItemWarehouse::setDefaultSubitem()
     * @uses ItemWarehouse::setInventoryAccount()
     * @uses ItemWarehouse::setInventoryID()
     * @uses ItemWarehouse::setInventorySubaccount()
     * @uses ItemWarehouse::setLastModifiedDateTime()
     * @uses ItemWarehouse::setMSRP()
     * @uses ItemWarehouse::setOverrideInventoryAccountSubaccount()
     * @uses ItemWarehouse::setOverridePreferredVendor()
     * @uses ItemWarehouse::setOverridePrice()
     * @uses ItemWarehouse::setOverrideReplenishmentSettings()
     * @uses ItemWarehouse::setOverrideServiceLevelOverride()
     * @uses ItemWarehouse::setOverrideStandardCost()
     * @uses ItemWarehouse::setPreferredLocation()
     * @uses ItemWarehouse::setPreferredVendor()
     * @uses ItemWarehouse::setProductManager()
     * @uses ItemWarehouse::setProductWorkgroup()
     * @uses ItemWarehouse::setReplenishmentClass()
     * @uses ItemWarehouse::setReplenishmentMethod()
     * @uses ItemWarehouse::setReplenishmentSource()
     * @uses ItemWarehouse::setReplenishmentWarehouse()
     * @uses ItemWarehouse::setSeasonality()
     * @uses ItemWarehouse::setServiceLevel()
     * @uses ItemWarehouse::setStatus()
     * @uses ItemWarehouse::setWarehouseID()
     * @param \AcumaticaConfig\StructType\DateTimeValue $createdDateTime
     * @param \AcumaticaConfig\StructType\StringValue $defaultIssueFrom
     * @param \AcumaticaConfig\StructType\StringValue $defaultReceiptTo
     * @param \AcumaticaConfig\StructType\StringValue $defaultSubitem
     * @param \AcumaticaConfig\StructType\StringValue $inventoryAccount
     * @param \AcumaticaConfig\StructType\StringValue $inventoryID
     * @param \AcumaticaConfig\StructType\StringValue $inventorySubaccount
     * @param \AcumaticaConfig\StructType\DateTimeValue $lastModifiedDateTime
     * @param \AcumaticaConfig\StructType\DecimalValue $mSRP
     * @param \AcumaticaConfig\StructType\BooleanValue $overrideInventoryAccountSubaccount
     * @param \AcumaticaConfig\StructType\BooleanValue $overridePreferredVendor
     * @param \AcumaticaConfig\StructType\BooleanValue $overridePrice
     * @param \AcumaticaConfig\StructType\BooleanValue $overrideReplenishmentSettings
     * @param \AcumaticaConfig\StructType\BooleanValue $overrideServiceLevelOverride
     * @param \AcumaticaConfig\StructType\BooleanValue $overrideStandardCost
     * @param \AcumaticaConfig\StructType\StringValue $preferredLocation
     * @param \AcumaticaConfig\StructType\StringValue $preferredVendor
     * @param \AcumaticaConfig\StructType\StringValue $productManager
     * @param \AcumaticaConfig\StructType\StringValue $productWorkgroup
     * @param \AcumaticaConfig\StructType\StringValue $replenishmentClass
     * @param \AcumaticaConfig\StructType\StringValue $replenishmentMethod
     * @param \AcumaticaConfig\StructType\StringValue $replenishmentSource
     * @param \AcumaticaConfig\StructType\StringValue $replenishmentWarehouse
     * @param \AcumaticaConfig\StructType\StringValue $seasonality
     * @param \AcumaticaConfig\StructType\DecimalValue $serviceLevel
     * @param \AcumaticaConfig\StructType\StringValue $status
     * @param \AcumaticaConfig\StructType\StringValue $warehouseID
     */
    public function __construct(\AcumaticaConfig\StructType\DateTimeValue $createdDateTime = null, \AcumaticaConfig\StructType\StringValue $defaultIssueFrom = null, \AcumaticaConfig\StructType\StringValue $defaultReceiptTo = null, \AcumaticaConfig\StructType\StringValue $defaultSubitem = null, \AcumaticaConfig\StructType\StringValue $inventoryAccount = null, \AcumaticaConfig\StructType\StringValue $inventoryID = null, \AcumaticaConfig\StructType\StringValue $inventorySubaccount = null, \AcumaticaConfig\StructType\DateTimeValue $lastModifiedDateTime = null, \AcumaticaConfig\StructType\DecimalValue $mSRP = null, \AcumaticaConfig\StructType\BooleanValue $overrideInventoryAccountSubaccount = null, \AcumaticaConfig\StructType\BooleanValue $overridePreferredVendor = null, \AcumaticaConfig\StructType\BooleanValue $overridePrice = null, \AcumaticaConfig\StructType\BooleanValue $overrideReplenishmentSettings = null, \AcumaticaConfig\StructType\BooleanValue $overrideServiceLevelOverride = null, \AcumaticaConfig\StructType\BooleanValue $overrideStandardCost = null, \AcumaticaConfig\StructType\StringValue $preferredLocation = null, \AcumaticaConfig\StructType\StringValue $preferredVendor = null, \AcumaticaConfig\StructType\StringValue $productManager = null, \AcumaticaConfig\StructType\StringValue $productWorkgroup = null, \AcumaticaConfig\StructType\StringValue $replenishmentClass = null, \AcumaticaConfig\StructType\StringValue $replenishmentMethod = null, \AcumaticaConfig\StructType\StringValue $replenishmentSource = null, \AcumaticaConfig\StructType\StringValue $replenishmentWarehouse = null, \AcumaticaConfig\StructType\StringValue $seasonality = null, \AcumaticaConfig\StructType\DecimalValue $serviceLevel = null, \AcumaticaConfig\StructType\StringValue $status = null, \AcumaticaConfig\StructType\StringValue $warehouseID = null)
    {
        $this
            ->setCreatedDateTime($createdDateTime)
            ->setDefaultIssueFrom($defaultIssueFrom)
            ->setDefaultReceiptTo($defaultReceiptTo)
            ->setDefaultSubitem($defaultSubitem)
            ->setInventoryAccount($inventoryAccount)
            ->setInventoryID($inventoryID)
            ->setInventorySubaccount($inventorySubaccount)
            ->setLastModifiedDateTime($lastModifiedDateTime)
            ->setMSRP($mSRP)
            ->setOverrideInventoryAccountSubaccount($overrideInventoryAccountSubaccount)
            ->setOverridePreferredVendor($overridePreferredVendor)
            ->setOverridePrice($overridePrice)
            ->setOverrideReplenishmentSettings($overrideReplenishmentSettings)
            ->setOverrideServiceLevelOverride($overrideServiceLevelOverride)
            ->setOverrideStandardCost($overrideStandardCost)
            ->setPreferredLocation($preferredLocation)
            ->setPreferredVendor($preferredVendor)
            ->setProductManager($productManager)
            ->setProductWorkgroup($productWorkgroup)
            ->setReplenishmentClass($replenishmentClass)
            ->setReplenishmentMethod($replenishmentMethod)
            ->setReplenishmentSource($replenishmentSource)
            ->setReplenishmentWarehouse($replenishmentWarehouse)
            ->setSeasonality($seasonality)
            ->setServiceLevel($serviceLevel)
            ->setStatus($status)
            ->setWarehouseID($warehouseID);
    }
    /**
     * Get CreatedDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DateTimeValue|null
     */
    public function getCreatedDateTime()
    {
        return isset($this->CreatedDateTime) ? $this->CreatedDateTime : null;
    }
    /**
     * Set CreatedDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DateTimeValue $createdDateTime
     * @return \AcumaticaConfig\StructType\ItemWarehouse
     */
    public function setCreatedDateTime(\AcumaticaConfig\StructType\DateTimeValue $createdDateTime = null)
    {
        if (is_null($createdDateTime) || (is_array($createdDateTime) && empty($createdDateTime))) {
            unset($this->CreatedDateTime);
        } else {
            $this->CreatedDateTime = $createdDateTime;
        }
        return $this;
    }
    /**
     * Get DefaultIssueFrom value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getDefaultIssueFrom()
    {
        return isset($this->DefaultIssueFrom) ? $this->DefaultIssueFrom : null;
    }
    /**
     * Set DefaultIssueFrom value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $defaultIssueFrom
     * @return \AcumaticaConfig\StructType\ItemWarehouse
     */
    public function setDefaultIssueFrom(\AcumaticaConfig\StructType\StringValue $defaultIssueFrom = null)
    {
        if (is_null($defaultIssueFrom) || (is_array($defaultIssueFrom) && empty($defaultIssueFrom))) {
            unset($this->DefaultIssueFrom);
        } else {
            $this->DefaultIssueFrom = $defaultIssueFrom;
        }
        return $this;
    }
    /**
     * Get DefaultReceiptTo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getDefaultReceiptTo()
    {
        return isset($this->DefaultReceiptTo) ? $this->DefaultReceiptTo : null;
    }
    /**
     * Set DefaultReceiptTo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $defaultReceiptTo
     * @return \AcumaticaConfig\StructType\ItemWarehouse
     */
    public function setDefaultReceiptTo(\AcumaticaConfig\StructType\StringValue $defaultReceiptTo = null)
    {
        if (is_null($defaultReceiptTo) || (is_array($defaultReceiptTo) && empty($defaultReceiptTo))) {
            unset($this->DefaultReceiptTo);
        } else {
            $this->DefaultReceiptTo = $defaultReceiptTo;
        }
        return $this;
    }
    /**
     * Get DefaultSubitem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getDefaultSubitem()
    {
        return isset($this->DefaultSubitem) ? $this->DefaultSubitem : null;
    }
    /**
     * Set DefaultSubitem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $defaultSubitem
     * @return \AcumaticaConfig\StructType\ItemWarehouse
     */
    public function setDefaultSubitem(\AcumaticaConfig\StructType\StringValue $defaultSubitem = null)
    {
        if (is_null($defaultSubitem) || (is_array($defaultSubitem) && empty($defaultSubitem))) {
            unset($this->DefaultSubitem);
        } else {
            $this->DefaultSubitem = $defaultSubitem;
        }
        return $this;
    }
    /**
     * Get InventoryAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getInventoryAccount()
    {
        return isset($this->InventoryAccount) ? $this->InventoryAccount : null;
    }
    /**
     * Set InventoryAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $inventoryAccount
     * @return \AcumaticaConfig\StructType\ItemWarehouse
     */
    public function setInventoryAccount(\AcumaticaConfig\StructType\StringValue $inventoryAccount = null)
    {
        if (is_null($inventoryAccount) || (is_array($inventoryAccount) && empty($inventoryAccount))) {
            unset($this->InventoryAccount);
        } else {
            $this->InventoryAccount = $inventoryAccount;
        }
        return $this;
    }
    /**
     * Get InventoryID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getInventoryID()
    {
        return isset($this->InventoryID) ? $this->InventoryID : null;
    }
    /**
     * Set InventoryID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $inventoryID
     * @return \AcumaticaConfig\StructType\ItemWarehouse
     */
    public function setInventoryID(\AcumaticaConfig\StructType\StringValue $inventoryID = null)
    {
        if (is_null($inventoryID) || (is_array($inventoryID) && empty($inventoryID))) {
            unset($this->InventoryID);
        } else {
            $this->InventoryID = $inventoryID;
        }
        return $this;
    }
    /**
     * Get InventorySubaccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getInventorySubaccount()
    {
        return isset($this->InventorySubaccount) ? $this->InventorySubaccount : null;
    }
    /**
     * Set InventorySubaccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $inventorySubaccount
     * @return \AcumaticaConfig\StructType\ItemWarehouse
     */
    public function setInventorySubaccount(\AcumaticaConfig\StructType\StringValue $inventorySubaccount = null)
    {
        if (is_null($inventorySubaccount) || (is_array($inventorySubaccount) && empty($inventorySubaccount))) {
            unset($this->InventorySubaccount);
        } else {
            $this->InventorySubaccount = $inventorySubaccount;
        }
        return $this;
    }
    /**
     * Get LastModifiedDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DateTimeValue|null
     */
    public function getLastModifiedDateTime()
    {
        return isset($this->LastModifiedDateTime) ? $this->LastModifiedDateTime : null;
    }
    /**
     * Set LastModifiedDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DateTimeValue $lastModifiedDateTime
     * @return \AcumaticaConfig\StructType\ItemWarehouse
     */
    public function setLastModifiedDateTime(\AcumaticaConfig\StructType\DateTimeValue $lastModifiedDateTime = null)
    {
        if (is_null($lastModifiedDateTime) || (is_array($lastModifiedDateTime) && empty($lastModifiedDateTime))) {
            unset($this->LastModifiedDateTime);
        } else {
            $this->LastModifiedDateTime = $lastModifiedDateTime;
        }
        return $this;
    }
    /**
     * Get MSRP value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DecimalValue|null
     */
    public function getMSRP()
    {
        return isset($this->MSRP) ? $this->MSRP : null;
    }
    /**
     * Set MSRP value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DecimalValue $mSRP
     * @return \AcumaticaConfig\StructType\ItemWarehouse
     */
    public function setMSRP(\AcumaticaConfig\StructType\DecimalValue $mSRP = null)
    {
        if (is_null($mSRP) || (is_array($mSRP) && empty($mSRP))) {
            unset($this->MSRP);
        } else {
            $this->MSRP = $mSRP;
        }
        return $this;
    }
    /**
     * Get OverrideInventoryAccountSubaccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\BooleanValue|null
     */
    public function getOverrideInventoryAccountSubaccount()
    {
        return isset($this->OverrideInventoryAccountSubaccount) ? $this->OverrideInventoryAccountSubaccount : null;
    }
    /**
     * Set OverrideInventoryAccountSubaccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\BooleanValue $overrideInventoryAccountSubaccount
     * @return \AcumaticaConfig\StructType\ItemWarehouse
     */
    public function setOverrideInventoryAccountSubaccount(\AcumaticaConfig\StructType\BooleanValue $overrideInventoryAccountSubaccount = null)
    {
        if (is_null($overrideInventoryAccountSubaccount) || (is_array($overrideInventoryAccountSubaccount) && empty($overrideInventoryAccountSubaccount))) {
            unset($this->OverrideInventoryAccountSubaccount);
        } else {
            $this->OverrideInventoryAccountSubaccount = $overrideInventoryAccountSubaccount;
        }
        return $this;
    }
    /**
     * Get OverridePreferredVendor value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\BooleanValue|null
     */
    public function getOverridePreferredVendor()
    {
        return isset($this->OverridePreferredVendor) ? $this->OverridePreferredVendor : null;
    }
    /**
     * Set OverridePreferredVendor value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\BooleanValue $overridePreferredVendor
     * @return \AcumaticaConfig\StructType\ItemWarehouse
     */
    public function setOverridePreferredVendor(\AcumaticaConfig\StructType\BooleanValue $overridePreferredVendor = null)
    {
        if (is_null($overridePreferredVendor) || (is_array($overridePreferredVendor) && empty($overridePreferredVendor))) {
            unset($this->OverridePreferredVendor);
        } else {
            $this->OverridePreferredVendor = $overridePreferredVendor;
        }
        return $this;
    }
    /**
     * Get OverridePrice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\BooleanValue|null
     */
    public function getOverridePrice()
    {
        return isset($this->OverridePrice) ? $this->OverridePrice : null;
    }
    /**
     * Set OverridePrice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\BooleanValue $overridePrice
     * @return \AcumaticaConfig\StructType\ItemWarehouse
     */
    public function setOverridePrice(\AcumaticaConfig\StructType\BooleanValue $overridePrice = null)
    {
        if (is_null($overridePrice) || (is_array($overridePrice) && empty($overridePrice))) {
            unset($this->OverridePrice);
        } else {
            $this->OverridePrice = $overridePrice;
        }
        return $this;
    }
    /**
     * Get OverrideReplenishmentSettings value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\BooleanValue|null
     */
    public function getOverrideReplenishmentSettings()
    {
        return isset($this->OverrideReplenishmentSettings) ? $this->OverrideReplenishmentSettings : null;
    }
    /**
     * Set OverrideReplenishmentSettings value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\BooleanValue $overrideReplenishmentSettings
     * @return \AcumaticaConfig\StructType\ItemWarehouse
     */
    public function setOverrideReplenishmentSettings(\AcumaticaConfig\StructType\BooleanValue $overrideReplenishmentSettings = null)
    {
        if (is_null($overrideReplenishmentSettings) || (is_array($overrideReplenishmentSettings) && empty($overrideReplenishmentSettings))) {
            unset($this->OverrideReplenishmentSettings);
        } else {
            $this->OverrideReplenishmentSettings = $overrideReplenishmentSettings;
        }
        return $this;
    }
    /**
     * Get OverrideServiceLevelOverride value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\BooleanValue|null
     */
    public function getOverrideServiceLevelOverride()
    {
        return isset($this->OverrideServiceLevelOverride) ? $this->OverrideServiceLevelOverride : null;
    }
    /**
     * Set OverrideServiceLevelOverride value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\BooleanValue $overrideServiceLevelOverride
     * @return \AcumaticaConfig\StructType\ItemWarehouse
     */
    public function setOverrideServiceLevelOverride(\AcumaticaConfig\StructType\BooleanValue $overrideServiceLevelOverride = null)
    {
        if (is_null($overrideServiceLevelOverride) || (is_array($overrideServiceLevelOverride) && empty($overrideServiceLevelOverride))) {
            unset($this->OverrideServiceLevelOverride);
        } else {
            $this->OverrideServiceLevelOverride = $overrideServiceLevelOverride;
        }
        return $this;
    }
    /**
     * Get OverrideStandardCost value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\BooleanValue|null
     */
    public function getOverrideStandardCost()
    {
        return isset($this->OverrideStandardCost) ? $this->OverrideStandardCost : null;
    }
    /**
     * Set OverrideStandardCost value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\BooleanValue $overrideStandardCost
     * @return \AcumaticaConfig\StructType\ItemWarehouse
     */
    public function setOverrideStandardCost(\AcumaticaConfig\StructType\BooleanValue $overrideStandardCost = null)
    {
        if (is_null($overrideStandardCost) || (is_array($overrideStandardCost) && empty($overrideStandardCost))) {
            unset($this->OverrideStandardCost);
        } else {
            $this->OverrideStandardCost = $overrideStandardCost;
        }
        return $this;
    }
    /**
     * Get PreferredLocation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getPreferredLocation()
    {
        return isset($this->PreferredLocation) ? $this->PreferredLocation : null;
    }
    /**
     * Set PreferredLocation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $preferredLocation
     * @return \AcumaticaConfig\StructType\ItemWarehouse
     */
    public function setPreferredLocation(\AcumaticaConfig\StructType\StringValue $preferredLocation = null)
    {
        if (is_null($preferredLocation) || (is_array($preferredLocation) && empty($preferredLocation))) {
            unset($this->PreferredLocation);
        } else {
            $this->PreferredLocation = $preferredLocation;
        }
        return $this;
    }
    /**
     * Get PreferredVendor value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getPreferredVendor()
    {
        return isset($this->PreferredVendor) ? $this->PreferredVendor : null;
    }
    /**
     * Set PreferredVendor value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $preferredVendor
     * @return \AcumaticaConfig\StructType\ItemWarehouse
     */
    public function setPreferredVendor(\AcumaticaConfig\StructType\StringValue $preferredVendor = null)
    {
        if (is_null($preferredVendor) || (is_array($preferredVendor) && empty($preferredVendor))) {
            unset($this->PreferredVendor);
        } else {
            $this->PreferredVendor = $preferredVendor;
        }
        return $this;
    }
    /**
     * Get ProductManager value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getProductManager()
    {
        return isset($this->ProductManager) ? $this->ProductManager : null;
    }
    /**
     * Set ProductManager value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $productManager
     * @return \AcumaticaConfig\StructType\ItemWarehouse
     */
    public function setProductManager(\AcumaticaConfig\StructType\StringValue $productManager = null)
    {
        if (is_null($productManager) || (is_array($productManager) && empty($productManager))) {
            unset($this->ProductManager);
        } else {
            $this->ProductManager = $productManager;
        }
        return $this;
    }
    /**
     * Get ProductWorkgroup value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getProductWorkgroup()
    {
        return isset($this->ProductWorkgroup) ? $this->ProductWorkgroup : null;
    }
    /**
     * Set ProductWorkgroup value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $productWorkgroup
     * @return \AcumaticaConfig\StructType\ItemWarehouse
     */
    public function setProductWorkgroup(\AcumaticaConfig\StructType\StringValue $productWorkgroup = null)
    {
        if (is_null($productWorkgroup) || (is_array($productWorkgroup) && empty($productWorkgroup))) {
            unset($this->ProductWorkgroup);
        } else {
            $this->ProductWorkgroup = $productWorkgroup;
        }
        return $this;
    }
    /**
     * Get ReplenishmentClass value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getReplenishmentClass()
    {
        return isset($this->ReplenishmentClass) ? $this->ReplenishmentClass : null;
    }
    /**
     * Set ReplenishmentClass value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $replenishmentClass
     * @return \AcumaticaConfig\StructType\ItemWarehouse
     */
    public function setReplenishmentClass(\AcumaticaConfig\StructType\StringValue $replenishmentClass = null)
    {
        if (is_null($replenishmentClass) || (is_array($replenishmentClass) && empty($replenishmentClass))) {
            unset($this->ReplenishmentClass);
        } else {
            $this->ReplenishmentClass = $replenishmentClass;
        }
        return $this;
    }
    /**
     * Get ReplenishmentMethod value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getReplenishmentMethod()
    {
        return isset($this->ReplenishmentMethod) ? $this->ReplenishmentMethod : null;
    }
    /**
     * Set ReplenishmentMethod value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $replenishmentMethod
     * @return \AcumaticaConfig\StructType\ItemWarehouse
     */
    public function setReplenishmentMethod(\AcumaticaConfig\StructType\StringValue $replenishmentMethod = null)
    {
        if (is_null($replenishmentMethod) || (is_array($replenishmentMethod) && empty($replenishmentMethod))) {
            unset($this->ReplenishmentMethod);
        } else {
            $this->ReplenishmentMethod = $replenishmentMethod;
        }
        return $this;
    }
    /**
     * Get ReplenishmentSource value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getReplenishmentSource()
    {
        return isset($this->ReplenishmentSource) ? $this->ReplenishmentSource : null;
    }
    /**
     * Set ReplenishmentSource value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $replenishmentSource
     * @return \AcumaticaConfig\StructType\ItemWarehouse
     */
    public function setReplenishmentSource(\AcumaticaConfig\StructType\StringValue $replenishmentSource = null)
    {
        if (is_null($replenishmentSource) || (is_array($replenishmentSource) && empty($replenishmentSource))) {
            unset($this->ReplenishmentSource);
        } else {
            $this->ReplenishmentSource = $replenishmentSource;
        }
        return $this;
    }
    /**
     * Get ReplenishmentWarehouse value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getReplenishmentWarehouse()
    {
        return isset($this->ReplenishmentWarehouse) ? $this->ReplenishmentWarehouse : null;
    }
    /**
     * Set ReplenishmentWarehouse value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $replenishmentWarehouse
     * @return \AcumaticaConfig\StructType\ItemWarehouse
     */
    public function setReplenishmentWarehouse(\AcumaticaConfig\StructType\StringValue $replenishmentWarehouse = null)
    {
        if (is_null($replenishmentWarehouse) || (is_array($replenishmentWarehouse) && empty($replenishmentWarehouse))) {
            unset($this->ReplenishmentWarehouse);
        } else {
            $this->ReplenishmentWarehouse = $replenishmentWarehouse;
        }
        return $this;
    }
    /**
     * Get Seasonality value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getSeasonality()
    {
        return isset($this->Seasonality) ? $this->Seasonality : null;
    }
    /**
     * Set Seasonality value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $seasonality
     * @return \AcumaticaConfig\StructType\ItemWarehouse
     */
    public function setSeasonality(\AcumaticaConfig\StructType\StringValue $seasonality = null)
    {
        if (is_null($seasonality) || (is_array($seasonality) && empty($seasonality))) {
            unset($this->Seasonality);
        } else {
            $this->Seasonality = $seasonality;
        }
        return $this;
    }
    /**
     * Get ServiceLevel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DecimalValue|null
     */
    public function getServiceLevel()
    {
        return isset($this->ServiceLevel) ? $this->ServiceLevel : null;
    }
    /**
     * Set ServiceLevel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DecimalValue $serviceLevel
     * @return \AcumaticaConfig\StructType\ItemWarehouse
     */
    public function setServiceLevel(\AcumaticaConfig\StructType\DecimalValue $serviceLevel = null)
    {
        if (is_null($serviceLevel) || (is_array($serviceLevel) && empty($serviceLevel))) {
            unset($this->ServiceLevel);
        } else {
            $this->ServiceLevel = $serviceLevel;
        }
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $status
     * @return \AcumaticaConfig\StructType\ItemWarehouse
     */
    public function setStatus(\AcumaticaConfig\StructType\StringValue $status = null)
    {
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
    /**
     * Get WarehouseID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getWarehouseID()
    {
        return isset($this->WarehouseID) ? $this->WarehouseID : null;
    }
    /**
     * Set WarehouseID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $warehouseID
     * @return \AcumaticaConfig\StructType\ItemWarehouse
     */
    public function setWarehouseID(\AcumaticaConfig\StructType\StringValue $warehouseID = null)
    {
        if (is_null($warehouseID) || (is_array($warehouseID) && empty($warehouseID))) {
            unset($this->WarehouseID);
        } else {
            $this->WarehouseID = $warehouseID;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AcumaticaConfig\StructType\ItemWarehouse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
