<?php

namespace AcumaticaConfig\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InventoryResults StructType
 * @subpackage Structs
 */
class InventoryResults extends Entity
{
    /**
     * The InventoryID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $InventoryID;
    /**
     * The Selected
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\BooleanValue
     */
    public $Selected;
    /**
     * The InventoryResults
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\InventoryResults[]
     */
    public $InventoryResults;
    /**
     * Constructor method for InventoryResults
     * @uses InventoryResults::setInventoryID()
     * @uses InventoryResults::setSelected()
     * @uses InventoryResults::setInventoryResults()
     * @param \AcumaticaConfig\StructType\StringValue $inventoryID
     * @param \AcumaticaConfig\StructType\BooleanValue $selected
     * @param \AcumaticaConfig\StructType\InventoryResults[] $inventoryResults
     */
    public function __construct(\AcumaticaConfig\StructType\StringValue $inventoryID = null, \AcumaticaConfig\StructType\BooleanValue $selected = null, array $inventoryResults = array())
    {
        $this
            ->setInventoryID($inventoryID)
            ->setSelected($selected)
            ->setInventoryResults($inventoryResults);
    }
    /**
     * Get InventoryID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getInventoryID()
    {
        return isset($this->InventoryID) ? $this->InventoryID : null;
    }
    /**
     * Set InventoryID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $inventoryID
     * @return \AcumaticaConfig\StructType\InventoryResults
     */
    public function setInventoryID(\AcumaticaConfig\StructType\StringValue $inventoryID = null)
    {
        if (is_null($inventoryID) || (is_array($inventoryID) && empty($inventoryID))) {
            unset($this->InventoryID);
        } else {
            $this->InventoryID = $inventoryID;
        }
        return $this;
    }
    /**
     * Get Selected value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\BooleanValue|null
     */
    public function getSelected()
    {
        return isset($this->Selected) ? $this->Selected : null;
    }
    /**
     * Set Selected value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\BooleanValue $selected
     * @return \AcumaticaConfig\StructType\InventoryResults
     */
    public function setSelected(\AcumaticaConfig\StructType\BooleanValue $selected = null)
    {
        if (is_null($selected) || (is_array($selected) && empty($selected))) {
            unset($this->Selected);
        } else {
            $this->Selected = $selected;
        }
        return $this;
    }
    /**
     * Get InventoryResults value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\InventoryResults[]|null
     */
    public function getInventoryResults()
    {
        return isset($this->InventoryResults) ? $this->InventoryResults : null;
    }
    /**
     * Set InventoryResults value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\InventoryResults[] $inventoryResults
     * @return \AcumaticaConfig\StructType\InventoryResults
     */
    public function setInventoryResults(array $inventoryResults = array())
    {
        foreach ($inventoryResults as $inventoryResultsInventoryResultsItem) {
            // validation for constraint: itemType
            if (!$inventoryResultsInventoryResultsItem instanceof \AcumaticaConfig\StructType\InventoryResults) {
                throw new \InvalidArgumentException(sprintf('The InventoryResults property can only contain items of \AcumaticaConfig\StructType\InventoryResults, "%s" given', is_object($inventoryResultsInventoryResultsItem) ? get_class($inventoryResultsInventoryResultsItem) : gettype($inventoryResultsInventoryResultsItem)), __LINE__);
            }
        }
        if (is_null($inventoryResults) || (is_array($inventoryResults) && empty($inventoryResults))) {
            unset($this->InventoryResults);
        } else {
            $this->InventoryResults = $inventoryResults;
        }
        return $this;
    }
    /**
     * Add item to InventoryResults value
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\InventoryResults $item
     * @return \AcumaticaConfig\StructType\InventoryResults
     */
    public function addToInventoryResults(\AcumaticaConfig\StructType\InventoryResults $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AcumaticaConfig\StructType\InventoryResults) {
            throw new \InvalidArgumentException(sprintf('The InventoryResults property can only contain items of \AcumaticaConfig\StructType\InventoryResults, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->InventoryResults[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AcumaticaConfig\StructType\InventoryResults
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
