<?php

namespace AcumaticaConfig\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FreightRates StructType
 * @subpackage Structs
 */
class FreightRates extends AbstractStructBase
{
    /**
     * The ShipViaFreightRate
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\ShipViaFreightRate[]
     */
    public $ShipViaFreightRate;
    /**
     * Constructor method for FreightRates
     * @uses FreightRates::setShipViaFreightRate()
     * @param \AcumaticaConfig\StructType\ShipViaFreightRate[] $shipViaFreightRate
     */
    public function __construct(array $shipViaFreightRate = array())
    {
        $this
            ->setShipViaFreightRate($shipViaFreightRate);
    }
    /**
     * Get ShipViaFreightRate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\ShipViaFreightRate[]|null
     */
    public function getShipViaFreightRate()
    {
        return isset($this->ShipViaFreightRate) ? $this->ShipViaFreightRate : null;
    }
    /**
     * Set ShipViaFreightRate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\ShipViaFreightRate[] $shipViaFreightRate
     * @return \AcumaticaConfig\StructType\FreightRates
     */
    public function setShipViaFreightRate(array $shipViaFreightRate = array())
    {
        foreach ($shipViaFreightRate as $freightRatesShipViaFreightRateItem) {
            // validation for constraint: itemType
            if (!$freightRatesShipViaFreightRateItem instanceof \AcumaticaConfig\StructType\ShipViaFreightRate) {
                throw new \InvalidArgumentException(sprintf('The ShipViaFreightRate property can only contain items of \AcumaticaConfig\StructType\ShipViaFreightRate, "%s" given', is_object($freightRatesShipViaFreightRateItem) ? get_class($freightRatesShipViaFreightRateItem) : gettype($freightRatesShipViaFreightRateItem)), __LINE__);
            }
        }
        if (is_null($shipViaFreightRate) || (is_array($shipViaFreightRate) && empty($shipViaFreightRate))) {
            unset($this->ShipViaFreightRate);
        } else {
            $this->ShipViaFreightRate = $shipViaFreightRate;
        }
        return $this;
    }
    /**
     * Add item to ShipViaFreightRate value
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\ShipViaFreightRate $item
     * @return \AcumaticaConfig\StructType\FreightRates
     */
    public function addToShipViaFreightRate(\AcumaticaConfig\StructType\ShipViaFreightRate $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AcumaticaConfig\StructType\ShipViaFreightRate) {
            throw new \InvalidArgumentException(sprintf('The ShipViaFreightRate property can only contain items of \AcumaticaConfig\StructType\ShipViaFreightRate, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ShipViaFreightRate[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AcumaticaConfig\StructType\FreightRates
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
