<?php

namespace AcumaticaConfig\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FreightDetails StructType
 * @subpackage Structs
 */
class FreightDetails extends AbstractStructBase
{
    /**
     * The SalesInvoiceFreightDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\SalesInvoiceFreightDetail[]
     */
    public $SalesInvoiceFreightDetail;
    /**
     * Constructor method for FreightDetails
     * @uses FreightDetails::setSalesInvoiceFreightDetail()
     * @param \AcumaticaConfig\StructType\SalesInvoiceFreightDetail[] $salesInvoiceFreightDetail
     */
    public function __construct(array $salesInvoiceFreightDetail = array())
    {
        $this
            ->setSalesInvoiceFreightDetail($salesInvoiceFreightDetail);
    }
    /**
     * Get SalesInvoiceFreightDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\SalesInvoiceFreightDetail[]|null
     */
    public function getSalesInvoiceFreightDetail()
    {
        return isset($this->SalesInvoiceFreightDetail) ? $this->SalesInvoiceFreightDetail : null;
    }
    /**
     * Set SalesInvoiceFreightDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\SalesInvoiceFreightDetail[] $salesInvoiceFreightDetail
     * @return \AcumaticaConfig\StructType\FreightDetails
     */
    public function setSalesInvoiceFreightDetail(array $salesInvoiceFreightDetail = array())
    {
        foreach ($salesInvoiceFreightDetail as $freightDetailsSalesInvoiceFreightDetailItem) {
            // validation for constraint: itemType
            if (!$freightDetailsSalesInvoiceFreightDetailItem instanceof \AcumaticaConfig\StructType\SalesInvoiceFreightDetail) {
                throw new \InvalidArgumentException(sprintf('The SalesInvoiceFreightDetail property can only contain items of \AcumaticaConfig\StructType\SalesInvoiceFreightDetail, "%s" given', is_object($freightDetailsSalesInvoiceFreightDetailItem) ? get_class($freightDetailsSalesInvoiceFreightDetailItem) : gettype($freightDetailsSalesInvoiceFreightDetailItem)), __LINE__);
            }
        }
        if (is_null($salesInvoiceFreightDetail) || (is_array($salesInvoiceFreightDetail) && empty($salesInvoiceFreightDetail))) {
            unset($this->SalesInvoiceFreightDetail);
        } else {
            $this->SalesInvoiceFreightDetail = $salesInvoiceFreightDetail;
        }
        return $this;
    }
    /**
     * Add item to SalesInvoiceFreightDetail value
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\SalesInvoiceFreightDetail $item
     * @return \AcumaticaConfig\StructType\FreightDetails
     */
    public function addToSalesInvoiceFreightDetail(\AcumaticaConfig\StructType\SalesInvoiceFreightDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AcumaticaConfig\StructType\SalesInvoiceFreightDetail) {
            throw new \InvalidArgumentException(sprintf('The SalesInvoiceFreightDetail property can only contain items of \AcumaticaConfig\StructType\SalesInvoiceFreightDetail, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->SalesInvoiceFreightDetail[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AcumaticaConfig\StructType\FreightDetails
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
