<?php

namespace AcumaticaConfig\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Entity StructType
 * @subpackage Structs
 */
class Entity extends AbstractStructBase
{
    /**
     * The ID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $ID;
    /**
     * The Delete
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Delete;
    /**
     * The ReturnBehavior
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ReturnBehavior;
    /**
     * The RowNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \AcumaticaConfig\StructType\LongValue
     */
    public $RowNumber;
    /**
     * The Note
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Note;
    /**
     * The CustomFields
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \AcumaticaConfig\ArrayType\ArrayOfCustomField
     */
    public $CustomFields;
    /**
     * Constructor method for Entity
     * @uses Entity::setID()
     * @uses Entity::setDelete()
     * @uses Entity::setReturnBehavior()
     * @uses Entity::setRowNumber()
     * @uses Entity::setNote()
     * @uses Entity::setCustomFields()
     * @param string $iD
     * @param bool $delete
     * @param string $returnBehavior
     * @param \AcumaticaConfig\StructType\LongValue $rowNumber
     * @param string $note
     * @param \AcumaticaConfig\ArrayType\ArrayOfCustomField $customFields
     */
    public function __construct($iD = null, $delete = null, $returnBehavior = null, \AcumaticaConfig\StructType\LongValue $rowNumber = null, $note = null, \AcumaticaConfig\ArrayType\ArrayOfCustomField $customFields = null)
    {
        $this
            ->setID($iD)
            ->setDelete($delete)
            ->setReturnBehavior($returnBehavior)
            ->setRowNumber($rowNumber)
            ->setNote($note)
            ->setCustomFields($customFields);
    }
    /**
     * Get ID value
     * @return string
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param string $iD
     * @return \AcumaticaConfig\StructType\Entity
     */
    public function setID($iD = null)
    {
        // validation for constraint: pattern
        if (is_scalar($iD) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}", "%s" given', var_export($iD, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($iD) && !is_string($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get Delete value
     * @return bool
     */
    public function getDelete()
    {
        return $this->Delete;
    }
    /**
     * Set Delete value
     * @param bool $delete
     * @return \AcumaticaConfig\StructType\Entity
     */
    public function setDelete($delete = null)
    {
        // validation for constraint: boolean
        if (!is_null($delete) && !is_bool($delete)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($delete)), __LINE__);
        }
        $this->Delete = $delete;
        return $this;
    }
    /**
     * Get ReturnBehavior value
     * @return string
     */
    public function getReturnBehavior()
    {
        return $this->ReturnBehavior;
    }
    /**
     * Set ReturnBehavior value
     * @uses \AcumaticaConfig\EnumType\ReturnBehavior::valueIsValid()
     * @uses \AcumaticaConfig\EnumType\ReturnBehavior::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $returnBehavior
     * @return \AcumaticaConfig\StructType\Entity
     */
    public function setReturnBehavior($returnBehavior = null)
    {
        // validation for constraint: enumeration
        if (!\AcumaticaConfig\EnumType\ReturnBehavior::valueIsValid($returnBehavior)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $returnBehavior, implode(', ', \AcumaticaConfig\EnumType\ReturnBehavior::getValidValues())), __LINE__);
        }
        $this->ReturnBehavior = $returnBehavior;
        return $this;
    }
    /**
     * Get RowNumber value
     * @return \AcumaticaConfig\StructType\LongValue|null
     */
    public function getRowNumber()
    {
        return $this->RowNumber;
    }
    /**
     * Set RowNumber value
     * @param \AcumaticaConfig\StructType\LongValue $rowNumber
     * @return \AcumaticaConfig\StructType\Entity
     */
    public function setRowNumber(\AcumaticaConfig\StructType\LongValue $rowNumber = null)
    {
        $this->RowNumber = $rowNumber;
        return $this;
    }
    /**
     * Get Note value
     * @return string|null
     */
    public function getNote()
    {
        return $this->Note;
    }
    /**
     * Set Note value
     * @param string $note
     * @return \AcumaticaConfig\StructType\Entity
     */
    public function setNote($note = null)
    {
        // validation for constraint: string
        if (!is_null($note) && !is_string($note)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($note)), __LINE__);
        }
        $this->Note = $note;
        return $this;
    }
    /**
     * Get CustomFields value
     * @return \AcumaticaConfig\ArrayType\ArrayOfCustomField|null
     */
    public function getCustomFields()
    {
        return $this->CustomFields;
    }
    /**
     * Set CustomFields value
     * @param \AcumaticaConfig\ArrayType\ArrayOfCustomField $customFields
     * @return \AcumaticaConfig\StructType\Entity
     */
    public function setCustomFields(\AcumaticaConfig\ArrayType\ArrayOfCustomField $customFields = null)
    {
        $this->CustomFields = $customFields;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AcumaticaConfig\StructType\Entity
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
