<?php

namespace AcumaticaConfig\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EndPointVersion StructType
 * @subpackage Structs
 */
class EndPointVersion extends Entity
{
    /**
     * The EndpointName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $EndpointName;
    /**
     * The EndpointVersion
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $EndpointVersion;
    /**
     * Constructor method for EndPointVersion
     * @uses EndPointVersion::setEndpointName()
     * @uses EndPointVersion::setEndpointVersion()
     * @param \AcumaticaConfig\StructType\StringValue $endpointName
     * @param \AcumaticaConfig\StructType\StringValue $endpointVersion
     */
    public function __construct(\AcumaticaConfig\StructType\StringValue $endpointName = null, \AcumaticaConfig\StructType\StringValue $endpointVersion = null)
    {
        $this
            ->setEndpointName($endpointName)
            ->setEndpointVersion($endpointVersion);
    }
    /**
     * Get EndpointName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getEndpointName()
    {
        return isset($this->EndpointName) ? $this->EndpointName : null;
    }
    /**
     * Set EndpointName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $endpointName
     * @return \AcumaticaConfig\StructType\EndPointVersion
     */
    public function setEndpointName(\AcumaticaConfig\StructType\StringValue $endpointName = null)
    {
        if (is_null($endpointName) || (is_array($endpointName) && empty($endpointName))) {
            unset($this->EndpointName);
        } else {
            $this->EndpointName = $endpointName;
        }
        return $this;
    }
    /**
     * Get EndpointVersion value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getEndpointVersion()
    {
        return isset($this->EndpointVersion) ? $this->EndpointVersion : null;
    }
    /**
     * Set EndpointVersion value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $endpointVersion
     * @return \AcumaticaConfig\StructType\EndPointVersion
     */
    public function setEndpointVersion(\AcumaticaConfig\StructType\StringValue $endpointVersion = null)
    {
        if (is_null($endpointVersion) || (is_array($endpointVersion) && empty($endpointVersion))) {
            unset($this->EndpointVersion);
        } else {
            $this->EndpointVersion = $endpointVersion;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AcumaticaConfig\StructType\EndPointVersion
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
